/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.mysql.MysqlCapability;
import org.apache.doris.mysql.MysqlChannel;
import org.apache.doris.mysql.MysqlCommand;
import org.apache.doris.mysql.MysqlSerializer;
import org.apache.doris.mysql.privilege.PaloRole;
import org.apache.doris.plugin.AuditEvent;
import org.apache.doris.qe.ConnectScheduler;
import org.apache.doris.qe.InsertResult;
import org.apache.doris.qe.QueryDetail;
import org.apache.doris.qe.QueryState;
import org.apache.doris.qe.SessionVariable;
import org.apache.doris.qe.StmtExecutor;
import org.apache.doris.qe.VariableMgr;
import org.apache.doris.resource.Tag;
import org.apache.doris.thrift.TResourceInfo;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.transaction.TransactionEntry;
import org.apache.doris.transaction.TransactionStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectContext {
    private static final Logger LOG = LogManager.getLogger(ConnectContext.class);
    protected static ThreadLocal<ConnectContext> threadLocalInfo = new ThreadLocal();
    protected volatile long stmtId;
    protected volatile long forwardedStmtId;
    protected volatile TUniqueId queryId;
    protected volatile int connectionId;
    protected volatile MysqlChannel mysqlChannel;
    protected volatile QueryState state;
    protected volatile long returnRows = 0L;
    protected volatile MysqlCapability serverCapability;
    protected volatile MysqlCapability capability;
    protected volatile boolean isKilled = false;
    protected volatile String currentDb = "";
    protected volatile long currentDbId = -1L;
    protected volatile TransactionEntry txnEntry = null;
    protected volatile String clusterName = "";
    protected volatile String qualifiedUser;
    protected volatile boolean isTempUser = false;
    protected volatile PaloRole ldapGroupsPrivs = null;
    protected volatile UserIdentity currentUserIdentity;
    protected volatile MysqlSerializer serializer;
    protected volatile SessionVariable sessionVariable;
    protected volatile ConnectScheduler connectScheduler;
    protected volatile StmtExecutor executor;
    protected volatile MysqlCommand command;
    protected volatile long startTime;
    protected volatile ThreadInfo threadInfo;
    protected Catalog catalog;
    protected boolean isSend;
    protected AuditEvent.AuditEventBuilder auditEventBuilder = new AuditEvent.AuditEventBuilder();
    protected String remoteIP;
    protected QueryDetail queryDetail;
    private boolean notEvalNondeterministicFunction = false;
    private Set<Tag> resourceTags = Sets.newHashSet();
    private boolean isResourceTagsSet = false;
    private String sqlHash;
    private String currentConnectedFEIp = "";
    private InsertResult insertResult;

    public void setOrUpdateInsertResult(long txnId, String label, String db, String tbl, TransactionStatus txnStatus, long loadedRows, int filteredRows) {
        if (this.isTxnModel() && this.insertResult != null) {
            this.insertResult.updateResult(txnStatus, loadedRows, filteredRows);
        } else {
            this.insertResult = new InsertResult(txnId, label, db, tbl, txnStatus, loadedRows, filteredRows);
        }
    }

    public InsertResult getInsertResult() {
        return this.insertResult;
    }

    public static ConnectContext get() {
        return threadLocalInfo.get();
    }

    public static void remove() {
        threadLocalInfo.remove();
    }

    public void setIsSend(boolean isSend) {
        this.isSend = isSend;
    }

    public boolean isSend() {
        return this.isSend;
    }

    public void setNotEvalNondeterministicFunction(boolean notEvalNondeterministicFunction) {
        this.notEvalNondeterministicFunction = notEvalNondeterministicFunction;
    }

    public boolean notEvalNondeterministicFunction() {
        return this.notEvalNondeterministicFunction;
    }

    public ConnectContext() {
        this.state = new QueryState();
        this.serverCapability = MysqlCapability.DEFAULT_CAPABILITY;
        this.serializer = MysqlSerializer.newInstance();
        this.sessionVariable = VariableMgr.newSessionVariable();
        this.command = MysqlCommand.COM_SLEEP;
    }

    public ConnectContext(SocketChannel channel) {
        this.state = new QueryState();
        this.serverCapability = MysqlCapability.DEFAULT_CAPABILITY;
        this.mysqlChannel = new MysqlChannel(channel);
        this.serializer = MysqlSerializer.newInstance();
        this.sessionVariable = VariableMgr.newSessionVariable();
        this.command = MysqlCommand.COM_SLEEP;
        if (channel != null) {
            this.remoteIP = this.mysqlChannel.getRemoteIp();
        }
        this.queryDetail = null;
    }

    public boolean isTxnModel() {
        return this.txnEntry != null && this.txnEntry.isTxnModel();
    }

    public boolean isTxnIniting() {
        return this.txnEntry != null && this.txnEntry.isTxnIniting();
    }

    public boolean isTxnBegin() {
        return this.txnEntry != null && this.txnEntry.isTxnBegin();
    }

    public void closeTxn() {
        if (this.isTxnModel()) {
            if (this.isTxnBegin()) {
                try {
                    Catalog.getCurrentGlobalTransactionMgr().abortTransaction(this.currentDbId, this.txnEntry.getTxnConf().getTxnId(), "timeout");
                }
                catch (UserException e) {
                    LOG.error("db: {}, txnId: {}, rollback error.", (Object)this.currentDb, (Object)this.txnEntry.getTxnConf().getTxnId(), (Object)e);
                }
            }
            this.txnEntry = null;
        }
    }

    public long getStmtId() {
        return this.stmtId;
    }

    public void setStmtId(long stmtId) {
        this.stmtId = stmtId;
    }

    public long getForwardedStmtId() {
        return this.forwardedStmtId;
    }

    public void setForwardedStmtId(long forwardedStmtId) {
        this.forwardedStmtId = forwardedStmtId;
    }

    public String getRemoteIP() {
        return this.remoteIP;
    }

    public void setRemoteIP(String remoteIP) {
        this.remoteIP = remoteIP;
    }

    public void setQueryDetail(QueryDetail queryDetail) {
        this.queryDetail = queryDetail;
    }

    public QueryDetail getQueryDetail() {
        return this.queryDetail;
    }

    public AuditEvent.AuditEventBuilder getAuditEventBuilder() {
        return this.auditEventBuilder;
    }

    public void setThreadLocalInfo() {
        threadLocalInfo.set(this);
    }

    public long getCurrentDbId() {
        return this.currentDbId;
    }

    public TransactionEntry getTxnEntry() {
        return this.txnEntry;
    }

    public void setTxnEntry(TransactionEntry txnEntry) {
        this.txnEntry = txnEntry;
    }

    public TResourceInfo toResourceCtx() {
        return new TResourceInfo(this.qualifiedUser, this.sessionVariable.getResourceGroup());
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public String getQualifiedUser() {
        return this.qualifiedUser;
    }

    public void setQualifiedUser(String qualifiedUser) {
        this.qualifiedUser = qualifiedUser;
    }

    public boolean getIsTempUser() {
        return this.isTempUser;
    }

    public void setIsTempUser(boolean isTempUser) {
        this.isTempUser = isTempUser;
    }

    public PaloRole getLdapGroupsPrivs() {
        return this.ldapGroupsPrivs;
    }

    public void setLdapGroupsPrivs(PaloRole ldapGroupsPrivs) {
        this.ldapGroupsPrivs = ldapGroupsPrivs;
    }

    public UserIdentity getUserIdentity() {
        return new UserIdentity(this.qualifiedUser, this.remoteIP);
    }

    public UserIdentity getCurrentUserIdentity() {
        return this.currentUserIdentity;
    }

    public void setCurrentUserIdentity(UserIdentity currentUserIdentity) {
        this.currentUserIdentity = currentUserIdentity;
    }

    public SessionVariable getSessionVariable() {
        return this.sessionVariable;
    }

    public ConnectScheduler getConnectScheduler() {
        return this.connectScheduler;
    }

    public void setConnectScheduler(ConnectScheduler connectScheduler) {
        this.connectScheduler = connectScheduler;
    }

    public MysqlCommand getCommand() {
        return this.command;
    }

    public void setCommand(MysqlCommand command) {
        this.command = command;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime() {
        this.startTime = System.currentTimeMillis();
        this.returnRows = 0L;
    }

    public void updateReturnRows(int returnRows) {
        this.returnRows += (long)returnRows;
    }

    public long getReturnRows() {
        return this.returnRows;
    }

    public void resetReturnRows() {
        this.returnRows = 0L;
    }

    public MysqlSerializer getSerializer() {
        return this.serializer;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
    }

    public MysqlChannel getMysqlChannel() {
        return this.mysqlChannel;
    }

    public QueryState getState() {
        return this.state;
    }

    public void setState(QueryState state) {
        this.state = state;
    }

    public MysqlCapability getCapability() {
        return this.capability;
    }

    public void setCapability(MysqlCapability capability) {
        this.capability = capability;
    }

    public MysqlCapability getServerCapability() {
        return this.serverCapability;
    }

    public String getDatabase() {
        return this.currentDb;
    }

    public void setDatabase(String db) {
        this.currentDb = db;
        this.currentDbId = Catalog.getCurrentCatalog().getDb(db).map(Database::getId).orElse(-1L);
    }

    public void setExecutor(StmtExecutor executor) {
        this.executor = executor;
    }

    public StmtExecutor getExecutor() {
        return this.executor;
    }

    public void cleanup() {
        this.mysqlChannel.close();
        threadLocalInfo.remove();
        this.returnRows = 0L;
    }

    public boolean isKilled() {
        return this.isKilled;
    }

    public void setKilled() {
        this.isKilled = true;
    }

    public void setQueryId(TUniqueId queryId) {
        this.queryId = queryId;
    }

    public TUniqueId queryId() {
        return this.queryId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setCluster(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getSqlHash() {
        return this.sqlHash;
    }

    public void setSqlHash(String sqlHash) {
        this.sqlHash = sqlHash;
    }

    public void kill(boolean killConnection) {
        StmtExecutor executorRef;
        LOG.warn("kill timeout query, {}, kill connection: {}", (Object)this.getMysqlChannel().getRemoteHostPortString(), (Object)killConnection);
        if (killConnection) {
            this.isKilled = true;
            this.getMysqlChannel().close();
        }
        if ((executorRef = this.executor) != null) {
            executorRef.cancel();
        }
    }

    public void checkTimeout(long now) {
        if (this.startTime <= 0L) {
            return;
        }
        long delta = now - this.startTime;
        boolean killFlag = false;
        boolean killConnection = false;
        if (this.command == MysqlCommand.COM_SLEEP) {
            if (delta > (long)(this.sessionVariable.getWaitTimeoutS() * 1000)) {
                LOG.warn("kill wait timeout connection, remote: {}, wait timeout: {}", (Object)this.getMysqlChannel().getRemoteHostPortString(), (Object)this.sessionVariable.getWaitTimeoutS());
                killFlag = true;
                killConnection = true;
            }
        } else if (delta > (long)(this.sessionVariable.getQueryTimeoutS() * 1000)) {
            LOG.warn("kill query timeout, remote: {}, query timeout: {}", (Object)this.getMysqlChannel().getRemoteHostPortString(), (Object)this.sessionVariable.getQueryTimeoutS());
            killFlag = true;
        }
        if (killFlag) {
            this.kill(killConnection);
        }
    }

    public ThreadInfo toThreadInfo() {
        if (this.threadInfo == null) {
            this.threadInfo = new ThreadInfo();
        }
        return this.threadInfo;
    }

    public boolean isResourceTagsSet() {
        return this.isResourceTagsSet;
    }

    public Set<Tag> getResourceTags() {
        return this.resourceTags;
    }

    public void setResourceTags(Set<Tag> resourceTags) {
        this.resourceTags = resourceTags;
        this.isResourceTagsSet = !this.resourceTags.isEmpty();
    }

    public void setCurrentConnectedFEIp(String ip) {
        this.currentConnectedFEIp = ip;
    }

    public String getCurrentConnectedFEIp() {
        return this.currentConnectedFEIp;
    }

    public String getRemoteIp() {
        return this.mysqlChannel == null ? "" : this.mysqlChannel.getRemoteIp();
    }

    public String getQueryIdentifier() {
        return "stmt[" + this.stmtId + ", " + DebugUtil.printId(this.queryId) + "]";
    }

    public class ThreadInfo {
        public List<String> toRow(long nowMs) {
            ArrayList row = Lists.newArrayList();
            row.add("" + ConnectContext.this.connectionId);
            row.add(ClusterNamespace.getNameFromFullName(ConnectContext.this.qualifiedUser));
            row.add(ConnectContext.this.getMysqlChannel().getRemoteHostPortString());
            row.add(ConnectContext.this.clusterName);
            row.add(ClusterNamespace.getNameFromFullName(ConnectContext.this.currentDb));
            row.add(ConnectContext.this.command.toString());
            row.add("" + (nowMs - ConnectContext.this.startTime) / 1000L);
            row.add("");
            row.add("");
            return row;
        }
    }
}

