/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Set;
import org.apache.doris.common.AuditLog;
import org.apache.doris.common.Config;
import org.apache.doris.common.util.DigitalVersion;
import org.apache.doris.plugin.AuditEvent;
import org.apache.doris.plugin.AuditPlugin;
import org.apache.doris.plugin.Plugin;
import org.apache.doris.plugin.PluginInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AuditLogBuilder
extends Plugin
implements AuditPlugin {
    private static final Logger LOG = LogManager.getLogger(AuditLogBuilder.class);
    private PluginInfo pluginInfo;
    private final String[] LOAD_ANNONATION_NAMES = new String[]{"JobId", "Label", "LoadType", "Db", "TableList", "FilePathList", "BrokerUser", "Timestamp", "LoadStartTime", "LoadFinishTime", "ScanRows", "ScanBytes", "FileNumber"};
    private Set<String> loadAnnotationSet;
    private final String[] STREAM_LOAD_ANNONATION_NAMES = new String[]{"Label", "Db", "Table", "User", "ClientIp", "Status", "Message", "Url", "TotalRows", "LoadedRows", "FilteredRows", "UnselectedRows", "LoadBytes", "StartTime", "FinishTime"};
    private Set<String> streamLoadAnnotationSet;

    public AuditLogBuilder() {
        this.pluginInfo = new PluginInfo("__builtin_AuditLogBuilder", PluginInfo.PluginType.AUDIT, "builtin audit logger", DigitalVersion.fromString("0.12.0"), DigitalVersion.fromString("1.8.31"), AuditLogBuilder.class.getName(), null, null);
        this.loadAnnotationSet = Sets.newHashSet((Object[])this.LOAD_ANNONATION_NAMES);
        this.streamLoadAnnotationSet = Sets.newHashSet((Object[])this.STREAM_LOAD_ANNONATION_NAMES);
    }

    public PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    @Override
    public boolean eventFilter(AuditEvent.EventType type) {
        return type == AuditEvent.EventType.AFTER_QUERY || type == AuditEvent.EventType.LOAD_SUCCEED || type == AuditEvent.EventType.STREAM_LOAD_FINISH;
    }

    @Override
    public void exec(AuditEvent event) {
        try {
            switch (event.type) {
                case AFTER_QUERY: {
                    this.auditQueryLog(event);
                    break;
                }
                case LOAD_SUCCEED: {
                    this.auditLoadLog(event);
                    break;
                }
                case STREAM_LOAD_FINISH: {
                    this.auditStreamLoadLog(event);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.debug("failed to process audit event", (Throwable)e);
        }
    }

    private void auditQueryLog(AuditEvent event) throws IllegalAccessException {
        Field[] fields;
        StringBuilder sb = new StringBuilder();
        long queryTime = 0L;
        for (Field f : fields = event.getClass().getFields()) {
            AuditEvent.AuditField af = f.getAnnotation(AuditEvent.AuditField.class);
            if (af == null || af.value().equals("Timestamp")) continue;
            if (af.value().equals("Time")) {
                queryTime = (Long)f.get(event);
            }
            sb.append("|").append(af.value()).append("=").append(String.valueOf(f.get(event)));
        }
        String auditLog = sb.toString();
        AuditLog.getQueryAudit().log(auditLog);
        if (queryTime > Config.qe_slow_log_ms) {
            AuditLog.getSlowAudit().log(auditLog);
        }
    }

    private void auditLoadLog(AuditEvent event) throws IllegalAccessException {
        Field[] fields = event.getClass().getFields();
        HashMap annotationToFieldValueMap = Maps.newHashMap();
        for (Field f : fields) {
            AuditEvent.AuditField af = f.getAnnotation(AuditEvent.AuditField.class);
            if (af == null || !this.loadAnnotationSet.contains(af.value())) continue;
            annotationToFieldValueMap.put(af.value(), String.valueOf(f.get(event)));
        }
        StringBuilder sb = new StringBuilder();
        for (String annotation : this.LOAD_ANNONATION_NAMES) {
            sb.append("|").append(annotation).append("=").append((String)annotationToFieldValueMap.get(annotation));
        }
        String auditLog = sb.toString();
        AuditLog.getLoadAudit().log(auditLog);
    }

    private void auditStreamLoadLog(AuditEvent event) throws IllegalAccessException {
        Field[] fields = event.getClass().getFields();
        HashMap annotationToFieldValueMap = Maps.newHashMap();
        for (Field f : fields) {
            AuditEvent.AuditField af = f.getAnnotation(AuditEvent.AuditField.class);
            if (af == null || !this.streamLoadAnnotationSet.contains(af.value())) continue;
            annotationToFieldValueMap.put(af.value(), String.valueOf(f.get(event)));
        }
        StringBuilder sb = new StringBuilder();
        for (String annotation : this.STREAM_LOAD_ANNONATION_NAMES) {
            sb.append("|").append(annotation).append("=").append((String)annotationToFieldValueMap.get(annotation));
        }
        String auditLog = sb.toString();
        AuditLog.getStreamLoadAudit().log(auditLog);
    }
}

