/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.collect.Queues;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.doris.plugin.AuditEvent;
import org.apache.doris.plugin.AuditPlugin;
import org.apache.doris.plugin.Plugin;
import org.apache.doris.plugin.PluginInfo;
import org.apache.doris.plugin.PluginMgr;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AuditEventProcessor {
    private static final Logger LOG = LogManager.getLogger(AuditEventProcessor.class);
    private static final long UPDATE_PLUGIN_INTERVAL_MS = 60000L;
    private PluginMgr pluginMgr;
    private List<Plugin> auditPlugins;
    private long lastUpdateTime = 0L;
    private BlockingQueue<AuditEvent> eventQueue = Queues.newLinkedBlockingDeque((int)10000);
    private Thread workerThread;
    private volatile boolean isStopped = false;

    public AuditEventProcessor(PluginMgr pluginMgr) {
        this.pluginMgr = pluginMgr;
    }

    public void start() {
        this.workerThread = new Thread((Runnable)new Worker(), "AuditEventProcessor");
        this.workerThread.setDaemon(true);
        this.workerThread.start();
    }

    public void stop() {
        this.isStopped = true;
        if (this.workerThread != null) {
            try {
                this.workerThread.join();
            }
            catch (InterruptedException e) {
                LOG.warn("join worker join failed.", (Throwable)e);
            }
        }
    }

    public void handleAuditEvent(AuditEvent auditEvent) {
        try {
            this.eventQueue.add(auditEvent);
        }
        catch (Exception e) {
            LOG.warn("encounter exception when handle audit event, ignore", (Throwable)e);
        }
    }

    public class Worker
    implements Runnable {
        @Override
        public void run() {
            while (!AuditEventProcessor.this.isStopped) {
                AuditEvent auditEvent;
                block8: {
                    if (AuditEventProcessor.this.auditPlugins == null || System.currentTimeMillis() - AuditEventProcessor.this.lastUpdateTime > 60000L) {
                        AuditEventProcessor.this.auditPlugins = AuditEventProcessor.this.pluginMgr.getActivePluginList(PluginInfo.PluginType.AUDIT);
                        AuditEventProcessor.this.lastUpdateTime = System.currentTimeMillis();
                        LOG.debug("update audit plugins. num: {}", (Object)AuditEventProcessor.this.auditPlugins.size());
                    }
                    try {
                        auditEvent = (AuditEvent)AuditEventProcessor.this.eventQueue.poll(5L, TimeUnit.SECONDS);
                        if (auditEvent == null) {
                        }
                        break block8;
                    }
                    catch (InterruptedException e) {
                        LOG.debug("encounter exception when getting audit event from queue, ignore", (Throwable)e);
                    }
                    continue;
                }
                try {
                    for (Plugin plugin : AuditEventProcessor.this.auditPlugins) {
                        if (!((AuditPlugin)((Object)plugin)).eventFilter(auditEvent.type)) continue;
                        ((AuditPlugin)((Object)plugin)).exec(auditEvent);
                    }
                }
                catch (Exception e) {
                    LOG.debug("encounter exception when processing audit event.", (Throwable)e);
                }
            }
        }
    }
}

