/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import java.util.List;
import org.apache.doris.qe.ResultSet;
import org.apache.doris.qe.ResultSetMetaData;

public abstract class AbstractResultSet
implements ResultSet {
    protected ResultSetMetaData metaData;
    protected List<List<String>> resultRows;
    int rowIdx;

    public AbstractResultSet() {
    }

    public AbstractResultSet(ResultSetMetaData metaData, List<List<String>> resultRows) {
        this.metaData = metaData;
        this.resultRows = resultRows;
        this.rowIdx = -1;
    }

    @Override
    public boolean next() {
        if (this.rowIdx + 1 >= this.resultRows.size()) {
            return false;
        }
        ++this.rowIdx;
        return true;
    }

    @Override
    public List<List<String>> getResultRows() {
        return this.resultRows;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public String getString(int col) {
        return this.resultRows.get(this.rowIdx).get(col);
    }

    @Override
    public byte getByte(int col) {
        return Byte.valueOf(this.getString(col));
    }

    @Override
    public int getInt(int col) {
        return Integer.valueOf(this.getString(col));
    }

    @Override
    public long getLong(int col) {
        return Long.valueOf(this.getString(col));
    }

    @Override
    public short getShort(int col) {
        return Short.valueOf(this.getString(col));
    }
}

