/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.plugin;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.Util;
import org.apache.doris.plugin.PluginException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class PluginZip {
    private static final Logger LOG = LogManager.getLogger(PluginZip.class);
    private static final List<String> DEFAULT_PROTOCOL = ImmutableList.of((Object)"https://", (Object)"http://");
    private static final int HTTP_TIMEOUT_MS = 10000;
    private String source;
    private List<Path> cleanPathList;
    private String expectedChecksum;

    public PluginZip(String source, String expectedMd5sum) {
        this.source = source;
        this.cleanPathList = Lists.newLinkedList();
        this.expectedChecksum = expectedMd5sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path extract(Path targetPath) throws IOException, UserException {
        try {
            Path zipPath = this.downloadZip(targetPath);
            Path path = this.extractZip(zipPath, targetPath);
            return path;
        }
        finally {
            for (Path p : this.cleanPathList) {
                FileUtils.deleteQuietly((File)p.toFile());
            }
        }
    }

    Path downloadZip(Path targetPath) throws IOException, UserException {
        if (Strings.isNullOrEmpty((String)this.source)) {
            throw new PluginException("empty plugin source path: " + this.source);
        }
        boolean isLocal = true;
        for (String p : DEFAULT_PROTOCOL) {
            if (!StringUtils.startsWithIgnoreCase((String)StringUtils.trim((String)this.source), (String)p)) continue;
            isLocal = false;
            break;
        }
        if (!isLocal) {
            return this.downloadRemoteZip(targetPath);
        }
        return FileSystems.getDefault().getPath(this.source, new String[0]);
    }

    Path downloadRemoteZip(Path targetPath) throws IOException, UserException {
        String actualChecksum;
        LOG.info("download plugin zip from: " + this.source);
        Path zip = Files.createTempFile(targetPath, ".plugin_", ".zip", new FileAttribute[0]);
        this.cleanPathList.add(zip);
        try (InputStream in = this.getInputStreamFromUrl(this.source);){
            Files.copy(in, zip, StandardCopyOption.REPLACE_EXISTING);
        }
        if (Strings.isNullOrEmpty((String)this.expectedChecksum)) {
            try {
                in = this.getInputStreamFromUrl(this.source + ".md5");
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    this.expectedChecksum = br.readLine();
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException e) {
                throw new UserException(e.getMessage() + ". you should set md5sum in plugin properties or provide a md5 URI to check plugin file");
            }
        }
        if (!StringUtils.equalsIgnoreCase((String)this.expectedChecksum, (String)(actualChecksum = DigestUtils.md5Hex((byte[])Files.readAllBytes(zip))))) {
            throw new UserException("MD5 check mismatch, expected " + this.expectedChecksum + " but actual " + actualChecksum);
        }
        return zip;
    }

    Path extractZip(Path zip, Path targetPath) throws IOException, UserException {
        if (!Files.exists(zip, new LinkOption[0])) {
            throw new PluginException("Download plugin zip failed. zip file does not exist. source: " + this.source);
        }
        if (Files.isDirectory(zip, new LinkOption[0])) {
            FileUtils.copyDirectory((File)zip.toFile(), (File)targetPath.toFile());
            return targetPath;
        }
        try (ZipInputStream zipInput = new ZipInputStream(Files.newInputStream(zip, new OpenOption[0]));){
            ZipEntry entry;
            byte[] buffer = new byte[8192];
            while ((entry = zipInput.getNextEntry()) != null) {
                Path targetFile = targetPath.resolve(entry.getName());
                if (entry.getName().startsWith("doris/")) {
                    throw new UserException("Not use \"doris\" directory within the plugin zip.");
                }
                if (!targetFile.normalize().startsWith(targetPath)) {
                    throw new UserException("Zip contains entry name '" + entry.getName() + "' resolving outside of plugin directory");
                }
                if (!Files.isSymbolicLink(targetFile.getParent())) {
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                }
                if (!entry.isDirectory()) {
                    try (OutputStream out = Files.newOutputStream(targetFile, new OpenOption[0]);){
                        int len;
                        while ((len = zipInput.read(buffer)) >= 0) {
                            out.write(buffer, 0, len);
                        }
                    }
                }
                zipInput.closeEntry();
            }
        }
        return targetPath;
    }

    InputStream getInputStreamFromUrl(String url) throws IOException {
        return Util.getInputStreamFromUrl(url, null, 10000, 10000);
    }
}

