/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.plugin;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.doris.analysis.InstallPluginStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.plugin.BuiltinPluginLoader;
import org.apache.doris.plugin.DynamicPluginLoader;
import org.apache.doris.plugin.Plugin;
import org.apache.doris.plugin.PluginException;
import org.apache.doris.plugin.PluginInfo;
import org.apache.doris.plugin.PluginLoader;
import org.apache.doris.qe.AuditLogBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PluginMgr
implements Writable {
    private static final Logger LOG = LogManager.getLogger(PluginMgr.class);
    public static final String BUILTIN_PLUGIN_PREFIX = "__builtin_";
    private final Map<String, PluginLoader>[] plugins = new Map[PluginInfo.PluginType.MAX_PLUGIN_TYPE_SIZE];
    private final Set<String> dynamicPluginNames;

    public PluginMgr() {
        for (int i = 0; i < PluginInfo.PluginType.MAX_PLUGIN_TYPE_SIZE; ++i) {
            this.plugins[i] = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        }
        this.dynamicPluginNames = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
    }

    public void init() throws PluginException {
        File file = new File(Config.plugin_dir);
        if (file.exists() && !file.isDirectory()) {
            throw new PluginException("FE plugin dir " + Config.plugin_dir + " is not a directory");
        }
        if (!file.exists() && !file.mkdir()) {
            throw new PluginException("failed to create FE plugin dir " + Config.plugin_dir);
        }
        this.initBuiltinPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDynamicPluginNameExist(String name) {
        Set<String> set = this.dynamicPluginNames;
        synchronized (set) {
            return this.dynamicPluginNames.contains(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDynamicPluginNameIfAbsent(String name) {
        Set<String> set = this.dynamicPluginNames;
        synchronized (set) {
            return this.dynamicPluginNames.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeDynamicPluginName(String name) {
        Set<String> set = this.dynamicPluginNames;
        synchronized (set) {
            return this.dynamicPluginNames.remove(name);
        }
    }

    private void initBuiltinPlugins() {
        AuditLogBuilder auditLogBuilder = new AuditLogBuilder();
        if (!this.registerBuiltinPlugin(auditLogBuilder.getPluginInfo(), auditLogBuilder)) {
            LOG.warn("failed to register audit log builder");
        }
    }

    public PluginInfo installPlugin(InstallPluginStmt stmt) throws IOException, UserException {
        DynamicPluginLoader pluginLoader = new DynamicPluginLoader(Config.plugin_dir, stmt.getPluginPath(), stmt.getMd5sum());
        pluginLoader.setStatus(PluginLoader.PluginStatus.INSTALLING);
        try {
            PluginInfo info = ((PluginLoader)pluginLoader).getPluginInfo();
            if (stmt.getProperties() != null) {
                info.setProperties(stmt.getProperties());
            }
            if (this.checkDynamicPluginNameExist(info.getName())) {
                throw new UserException("plugin " + info.getName() + " has already been installed.");
            }
            ((PluginLoader)pluginLoader).install();
            pluginLoader.setStatus(PluginLoader.PluginStatus.INSTALLED);
            if (!this.addDynamicPluginNameIfAbsent(info.getName())) {
                throw new UserException("plugin " + info.getName() + " has already been installed.");
            }
            this.plugins[info.getTypeId()].put(info.getName(), pluginLoader);
            Catalog.getCurrentCatalog().getEditLog().logInstallPlugin(info);
            LOG.info("install plugin {}", (Object)info.getName());
            return info;
        }
        catch (IOException | UserException e) {
            ((PluginLoader)pluginLoader).uninstall();
            throw e;
        }
    }

    public PluginInfo uninstallPlugin(String name) throws IOException, UserException {
        if (!this.checkDynamicPluginNameExist(name)) {
            throw new DdlException("Plugin " + name + " does not exist");
        }
        for (int i = 0; i < PluginInfo.PluginType.MAX_PLUGIN_TYPE_SIZE; ++i) {
            PluginLoader loader;
            if (!this.plugins[i].containsKey(name) || (loader = this.plugins[i].get(name)) == null) continue;
            if (!loader.isDynamicPlugin()) {
                throw new DdlException("Only support uninstall dynamic plugins");
            }
            loader.pluginUninstallValid();
            loader.setStatus(PluginLoader.PluginStatus.UNINSTALLING);
            loader.uninstall();
            this.plugins[i].remove(name);
            loader.setStatus(PluginLoader.PluginStatus.UNINSTALLED);
            this.removeDynamicPluginName(name);
            return new PluginInfo(name);
        }
        throw new DdlException("Plugin " + name + " does not exist");
    }

    public boolean registerBuiltinPlugin(PluginInfo pluginInfo, Plugin plugin) {
        if (Objects.isNull(pluginInfo) || Objects.isNull(plugin) || Objects.isNull((Object)pluginInfo.getType()) || Strings.isNullOrEmpty((String)pluginInfo.getName())) {
            return false;
        }
        BuiltinPluginLoader loader = new BuiltinPluginLoader(Config.plugin_dir, pluginInfo, plugin);
        PluginLoader checkLoader = this.plugins[pluginInfo.getTypeId()].putIfAbsent(pluginInfo.getName(), loader);
        return checkLoader == null;
    }

    public void replayLoadDynamicPlugin(PluginInfo info) throws IOException, UserException {
        DynamicPluginLoader pluginLoader = new DynamicPluginLoader(Config.plugin_dir, info);
        try {
            PluginLoader checkLoader = this.plugins[info.getTypeId()].putIfAbsent(info.getName(), pluginLoader);
            if (checkLoader != null) {
                throw new UserException("plugin " + info.getName() + " has already been installed.");
            }
            pluginLoader.setStatus(PluginLoader.PluginStatus.INSTALLING);
            pluginLoader.reload();
            pluginLoader.setStatus(PluginLoader.PluginStatus.INSTALLED);
        }
        catch (IOException | UserException e) {
            pluginLoader.setStatus(PluginLoader.PluginStatus.ERROR, e.getMessage());
            throw e;
        }
        finally {
            this.addDynamicPluginNameIfAbsent(info.getName());
        }
    }

    public final Plugin getActivePlugin(String name, PluginInfo.PluginType type) {
        PluginLoader loader = this.plugins[type.ordinal()].get(name);
        if (null != loader && loader.getStatus() == PluginLoader.PluginStatus.INSTALLED) {
            return loader.getPlugin();
        }
        return null;
    }

    public final List<Plugin> getActivePluginList(PluginInfo.PluginType type) {
        Map<String, PluginLoader> m = this.plugins[type.ordinal()];
        ArrayList l = Lists.newArrayListWithCapacity((int)m.size());
        m.values().forEach(d -> {
            if (d.getStatus() == PluginLoader.PluginStatus.INSTALLED) {
                l.add(d.getPlugin());
            }
        });
        return Collections.unmodifiableList(l);
    }

    public final List<PluginInfo> getAllDynamicPluginInfo() {
        ArrayList list = Lists.newArrayList();
        for (Map<String, PluginLoader> map : this.plugins) {
            map.values().forEach(loader -> {
                try {
                    if (loader.isDynamicPlugin()) {
                        list.add(loader.getPluginInfo());
                    }
                }
                catch (Exception e) {
                    LOG.warn("load plugin from {} failed", (Object)loader.source, (Object)e);
                }
            });
        }
        return list;
    }

    public List<List<String>> getPluginShowInfos() {
        ArrayList rows = Lists.newArrayList();
        for (Map<String, PluginLoader> map : this.plugins) {
            for (Map.Entry<String, PluginLoader> entry : map.entrySet()) {
                ArrayList r = Lists.newArrayList();
                PluginLoader loader = entry.getValue();
                PluginInfo pi = null;
                try {
                    pi = loader.getPluginInfo();
                }
                catch (Exception e) {
                    LOG.warn("failed to get plugin info for plugin: {}", (Object)entry.getKey(), (Object)e);
                }
                r.add(entry.getKey());
                r.add(pi != null ? pi.getType().name() : "UNKNOWN");
                r.add(pi != null ? pi.getDescription() : "UNKNOWN");
                r.add(pi != null ? pi.getVersion().toString() : "UNKNOWN");
                r.add(pi != null ? pi.getJavaVersion().toString() : "UNKNOWN");
                r.add(pi != null ? pi.getClassName() : "UNKNOWN");
                r.add(pi != null ? pi.getSoName() : "UNKNOWN");
                if (Strings.isNullOrEmpty((String)loader.source)) {
                    r.add("Builtin");
                } else {
                    r.add(loader.source);
                }
                r.add(loader.getStatus().toString());
                r.add(pi != null ? "{" + new PrintableMap<String, String>(pi.getProperties(), "=", true, false, true).toString() + "}" : "UNKNOWN");
                rows.add(r);
            }
        }
        return rows;
    }

    public void readFields(DataInputStream dis) throws IOException {
        int size = dis.readInt();
        for (int i = 0; i < size; ++i) {
            try {
                PluginInfo pluginInfo = PluginInfo.read(dis);
                this.replayLoadDynamicPlugin(pluginInfo);
                continue;
            }
            catch (Exception e) {
                LOG.warn("load plugin failed.", (Throwable)e);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        List<PluginInfo> list = this.getAllDynamicPluginInfo();
        int size = list.size();
        out.writeInt(size);
        for (PluginInfo pc : list) {
            pc.write(out);
        }
    }
}

