/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.plugin;

import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.doris.common.UserException;
import org.apache.doris.plugin.Plugin;
import org.apache.doris.plugin.PluginContext;
import org.apache.doris.plugin.PluginInfo;

public abstract class PluginLoader {
    protected final Path pluginDir;
    protected String source;
    protected Plugin plugin;
    protected PluginInfo pluginInfo;
    protected PluginContext pluginContext;
    protected PluginStatus status;

    protected PluginLoader(String path, String source) {
        this.pluginDir = FileSystems.getDefault().getPath(path, new String[0]);
        this.source = source;
        this.plugin = null;
        this.pluginInfo = null;
        this.pluginContext = new PluginContext();
    }

    protected PluginLoader(String path, PluginInfo info) {
        this.pluginDir = FileSystems.getDefault().getPath(path, new String[0]);
        this.source = info.getSource();
        this.plugin = null;
        this.pluginInfo = info;
        this.pluginContext = new PluginContext();
    }

    public abstract void install() throws UserException, IOException;

    public abstract void uninstall() throws IOException, UserException;

    public boolean isDynamicPlugin() {
        return false;
    }

    public PluginInfo getPluginInfo() throws IOException, UserException {
        return this.pluginInfo;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void setStatus(PluginStatus status) {
        this.setStatus(status, null);
    }

    public void setStatus(PluginStatus status, String msg) {
        this.status = status;
        this.status.setMsg(msg);
    }

    public PluginStatus getStatus() {
        return this.status;
    }

    public void pluginInstallValid() throws UserException {
    }

    public void pluginUninstallValid() throws UserException {
        if (this.plugin != null && (this.plugin.flags() & 2) > 0) {
            throw new UserException("plugin " + this.pluginInfo + " not allow dynamic uninstall");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginLoader that = (PluginLoader)o;
        return this.pluginInfo.equals(that.pluginInfo);
    }

    public int hashCode() {
        return Objects.hash(this.pluginInfo);
    }

    public static enum PluginStatus {
        INSTALLING,
        INSTALLED,
        UNINSTALLING,
        UNINSTALLED,
        ERROR;

        private String msg;

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String toString() {
            if (Strings.isNullOrEmpty((String)this.msg)) {
                return this.name();
            }
            return this.name() + ": " + this.msg;
        }
    }
}

