/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.plugin;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.DigitalVersion;
import org.apache.doris.persist.gson.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginInfo
implements Writable {
    public static final Logger LOG = LoggerFactory.getLogger(PluginInfo.class);
    private static final String DEFAULT_PLUGIN_PROPERTIES = "plugin.properties";
    @SerializedName(value="name")
    protected String name;
    @SerializedName(value="type")
    protected PluginType type;
    @SerializedName(value="description")
    protected String description;
    @SerializedName(value="version")
    protected DigitalVersion version;
    @SerializedName(value="javaVersion")
    protected DigitalVersion javaVersion;
    @SerializedName(value="className")
    protected String className;
    @SerializedName(value="soName")
    protected String soName;
    @SerializedName(value="source")
    protected String source;
    @SerializedName(value="properties")
    protected Map<String, String> properties = Maps.newHashMap();

    public PluginInfo() {
    }

    public PluginInfo(String name) {
        this.name = name;
    }

    public PluginInfo(String name, PluginType type, String description) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.version = DigitalVersion.CURRENT_PLUGIN_VERSION;
        this.javaVersion = DigitalVersion.JDK_1_8_0;
    }

    public PluginInfo(String name, PluginType type, String description, DigitalVersion version, DigitalVersion javaVersion, String className, String soName, String source) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.version = version;
        this.javaVersion = javaVersion;
        this.className = className;
        this.soName = soName;
        this.source = source;
    }

    public static PluginInfo readFromProperties(Path propertiesPath, String source) throws IOException {
        PluginType type;
        Path descriptor = propertiesPath.resolve(DEFAULT_PLUGIN_PROPERTIES);
        if (!descriptor.toFile().exists()) {
            throw new IOException(descriptor.getFileName() + " does not exist");
        }
        Properties props = new Properties();
        try (InputStream stream = Files.newInputStream(descriptor, new OpenOption[0]);){
            props.load(stream);
        }
        Map propsMap = props.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), props::getProperty));
        String name = propsMap.remove("name");
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("property [name] is missing in [" + descriptor + "]");
        }
        String description = propsMap.remove("description");
        String typeStr = propsMap.remove("type");
        try {
            type = PluginType.valueOf(StringUtils.upperCase((String)typeStr));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("property [type] is missing for plugin [" + typeStr + "]");
        }
        String versionString = propsMap.remove("version");
        if (null == versionString) {
            throw new IllegalArgumentException("property [version] is missing for plugin [" + name + "]");
        }
        DigitalVersion version = DigitalVersion.fromString(versionString);
        String javaVersionString = propsMap.remove("java.version");
        DigitalVersion javaVersion = DigitalVersion.JDK_1_8_0;
        if (null != javaVersionString) {
            javaVersion = DigitalVersion.fromString(javaVersionString);
        }
        String className = propsMap.remove("classname");
        String soName = propsMap.remove("soname");
        if (version.before(DigitalVersion.CURRENT_DORIS_VERSION)) {
            throw new IllegalArgumentException("plugin version is too old. plz recompile and modify property [version]");
        }
        if (!Strings.isNullOrEmpty((String)soName)) {
            throw new IllegalArgumentException("Only support FE plugin");
        }
        if (Strings.isNullOrEmpty((String)className)) {
            throw new IllegalArgumentException("property [className] is missing for plugin [" + name + "]");
        }
        return new PluginInfo(name, type, description, version, javaVersion, className, soName, source);
    }

    public String getName() {
        return this.name;
    }

    public PluginType getType() {
        return this.type;
    }

    public int getTypeId() {
        return this.type.ordinal();
    }

    public String getDescription() {
        return this.description;
    }

    public DigitalVersion getVersion() {
        return this.version;
    }

    public DigitalVersion getJavaVersion() {
        return this.javaVersion;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSoName() {
        return this.soName;
    }

    public String getSource() {
        return this.source;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginInfo that = (PluginInfo)o;
        return Objects.equals(this.name, that.name) && this.type == that.type && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public void write(DataOutput out) throws IOException {
        String s = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)s);
    }

    public static PluginInfo read(DataInput in) throws IOException {
        String s = Text.readString((DataInput)in);
        return (PluginInfo)GsonUtils.GSON.fromJson(s, PluginInfo.class);
    }

    public static enum PluginType {
        AUDIT,
        IMPORT,
        STORAGE;

        public static int MAX_PLUGIN_TYPE_SIZE;

        static {
            MAX_PLUGIN_TYPE_SIZE = PluginType.values().length;
        }
    }
}

