/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.plugin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.UserException;
import org.apache.doris.plugin.Plugin;
import org.apache.doris.plugin.PluginClassLoader;
import org.apache.doris.plugin.PluginException;
import org.apache.doris.plugin.PluginInfo;
import org.apache.doris.plugin.PluginLoader;
import org.apache.doris.plugin.PluginZip;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DynamicPluginLoader
extends PluginLoader {
    private static final Logger LOG = LogManager.getLogger(DynamicPluginLoader.class);
    public static final String MD5SUM_KEY = "md5sum";
    protected Path installPath;
    protected String expectedMd5sum;

    DynamicPluginLoader(String pluginDir, String source, String expectedMd5sum) {
        super(pluginDir, source);
        this.expectedMd5sum = expectedMd5sum;
    }

    DynamicPluginLoader(String pluginPath, PluginInfo info) {
        super(pluginPath, info);
        this.installPath = FileSystems.getDefault().getPath(this.pluginDir.toString(), this.pluginInfo.getName());
        this.expectedMd5sum = this.pluginInfo.getProperties().get(MD5SUM_KEY);
    }

    @Override
    public boolean isDynamicPlugin() {
        return true;
    }

    @Override
    public PluginInfo getPluginInfo() throws IOException, UserException {
        if (this.pluginInfo != null) {
            return this.pluginInfo;
        }
        Path tmpTarget = null;
        try {
            if (this.installPath == null) {
                PluginZip zip = new PluginZip(this.source, this.expectedMd5sum);
                tmpTarget = Files.createTempDirectory(this.pluginDir, ".install_", new FileAttribute[0]);
                this.installPath = zip.extract(tmpTarget);
            }
            this.pluginInfo = PluginInfo.readFromProperties(this.installPath, this.source);
        }
        catch (Exception e) {
            if (tmpTarget != null) {
                FileUtils.deleteQuietly((File)tmpTarget.toFile());
            }
            throw e;
        }
        return this.pluginInfo;
    }

    @Override
    public void install() throws UserException, IOException {
        if (this.hasInstalled()) {
            throw new UserException("Plugin " + this.pluginInfo.getName() + " has already been installed.");
        }
        this.getPluginInfo();
        this.movePlugin();
        this.plugin = this.dynamicLoadPlugin(true);
        this.pluginInstallValid();
        this.pluginContext.setPluginPath(this.installPath.toString());
        try {
            this.plugin.init(this.pluginInfo, this.pluginContext);
        }
        catch (Error e) {
            throw new UserException(e.getMessage());
        }
    }

    private boolean hasInstalled() {
        Path targetPath;
        return this.pluginInfo != null && Files.exists(targetPath = FileSystems.getDefault().getPath(this.pluginDir.toString(), this.pluginInfo.getName()), new LinkOption[0]);
    }

    @Override
    public void uninstall() throws IOException, UserException {
        if (this.plugin != null) {
            this.pluginUninstallValid();
            this.plugin.close();
        }
        if (null != this.installPath && Files.exists(this.installPath, new LinkOption[0]) && Files.isSameFile(this.installPath.getParent(), this.pluginDir)) {
            FileUtils.deleteQuietly((File)this.installPath.toFile());
        }
    }

    public void reload() throws IOException, UserException {
        if (Catalog.isCheckpointThread()) {
            return;
        }
        if (this.hasInstalled()) {
            this.plugin = this.dynamicLoadPlugin(true);
            this.pluginInstallValid();
            this.pluginContext.setPluginPath(this.installPath.toString());
            this.plugin.init(this.pluginInfo, this.pluginContext);
        } else {
            Map<String, String> properties = this.pluginInfo.getProperties();
            this.installPath = null;
            this.pluginInfo = null;
            this.pluginInfo = this.getPluginInfo();
            this.pluginInfo.setProperties(properties);
            this.install();
        }
    }

    Plugin dynamicLoadPlugin(boolean closePreviousPlugin) throws IOException, UserException {
        Class<Plugin> pluginClass;
        if (closePreviousPlugin && this.plugin != null) {
            try {
                this.plugin.close();
            }
            catch (Exception e) {
                LOG.warn("failed to close previous plugin {}, ignore it", (Throwable)e);
            }
            finally {
                this.plugin = null;
            }
        }
        Set<URL> jarList = this.getJarUrl(this.installPath);
        ClassLoader parentLoader = PluginClassLoader.createLoader(this.getClass().getClassLoader(), Collections.EMPTY_LIST);
        URLClassLoader loader = URLClassLoader.newInstance(jarList.toArray(new URL[0]), parentLoader);
        try {
            pluginClass = loader.loadClass(this.pluginInfo.getClassName()).asSubclass(Plugin.class);
        }
        catch (ClassNotFoundException e) {
            throw new UserException("Could not find plugin class [" + this.pluginInfo.getClassName() + "]", e);
        }
        return this.loadPluginClass(pluginClass);
    }

    private Plugin loadPluginClass(Class<? extends Plugin> pluginClass) {
        Constructor<?>[] constructors = pluginClass.getConstructors();
        if (constructors.length == 0) {
            throw new IllegalStateException("no public constructor for [" + pluginClass.getName() + "]");
        }
        if (constructors.length > 1) {
            throw new IllegalStateException("no unique public constructor for [" + pluginClass.getName() + "]");
        }
        Constructor<?> constructor = constructors[0];
        try {
            if (constructor.getParameterCount() == 0) {
                return (Plugin)constructor.newInstance(new Object[0]);
            }
            throw new IllegalStateException("failed to find correct constructor.");
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("failed to load plugin class [" + pluginClass.getName() + "]", e);
        }
    }

    private Set<URL> getJarUrl(Path path) throws IOException {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        try (DirectoryStream<Path> jarStream = Files.newDirectoryStream(path, "*.jar");){
            for (Path jar : jarStream) {
                URL url = jar.toRealPath(new LinkOption[0]).toUri().toURL();
                if (urls.add(url)) continue;
                throw new IllegalStateException("duplicate codebase: " + url);
            }
        }
        return urls;
    }

    public void movePlugin() throws UserException, IOException {
        if (this.installPath == null || !Files.exists(this.installPath, new LinkOption[0])) {
            throw new PluginException("Install plugin " + this.pluginInfo.getName() + " failed, because install path doesn't exist.");
        }
        Path targetPath = FileSystems.getDefault().getPath(this.pluginDir.toString(), this.pluginInfo.getName());
        if (Files.exists(targetPath, new LinkOption[0])) {
            if (!Files.isSameFile(this.installPath, targetPath)) {
                throw new PluginException("Install plugin " + this.pluginInfo.getName() + " failed. because " + this.installPath.toString() + " exists");
            }
        } else {
            Files.move(this.installPath, targetPath, StandardCopyOption.ATOMIC_MOVE);
        }
        this.installPath = targetPath;
    }
}

