/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.plugin;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class AuditEvent {
    public EventType type;
    @AuditField(value="Timestamp")
    public long timestamp = -1L;
    @AuditField(value="Client")
    public String clientIp = "";
    @AuditField(value="User")
    public String user = "";
    @AuditField(value="Db")
    public String db = "";
    @AuditField(value="State")
    public String state = "";
    @AuditField(value="Time")
    public long queryTime = -1L;
    @AuditField(value="ScanBytes")
    public long scanBytes = -1L;
    @AuditField(value="ScanRows")
    public long scanRows = -1L;
    @AuditField(value="ReturnRows")
    public long returnRows = -1L;
    @AuditField(value="StmtId")
    public long stmtId = -1L;
    @AuditField(value="QueryId")
    public String queryId = "";
    @AuditField(value="IsQuery")
    public boolean isQuery = false;
    @AuditField(value="feIp")
    public String feIp = "";
    @AuditField(value="Stmt")
    public String stmt = "";
    @AuditField(value="CpuTimeMS")
    public long cpuTimeMs = -1L;
    @AuditField(value="SqlHash")
    public String sqlHash = "";
    @AuditField(value="peakMemoryBytes")
    public long peakMemoryBytes = -1L;

    public static class AuditEventBuilder {
        private AuditEvent auditEvent = new AuditEvent();

        public void reset() {
            this.auditEvent = new AuditEvent();
        }

        public AuditEventBuilder setEventType(EventType eventType) {
            this.auditEvent.type = eventType;
            return this;
        }

        public AuditEventBuilder setTimestamp(long timestamp) {
            this.auditEvent.timestamp = timestamp;
            return this;
        }

        public AuditEventBuilder setClientIp(String clientIp) {
            this.auditEvent.clientIp = clientIp;
            return this;
        }

        public AuditEventBuilder setUser(String user) {
            this.auditEvent.user = user;
            return this;
        }

        public AuditEventBuilder setDb(String db) {
            this.auditEvent.db = db;
            return this;
        }

        public AuditEventBuilder setState(String state) {
            this.auditEvent.state = state;
            return this;
        }

        public AuditEventBuilder setQueryTime(long queryTime) {
            this.auditEvent.queryTime = queryTime;
            return this;
        }

        public AuditEventBuilder setScanBytes(long scanBytes) {
            this.auditEvent.scanBytes = scanBytes;
            return this;
        }

        public AuditEventBuilder setCpuTimeMs(long cpuTimeMs) {
            this.auditEvent.cpuTimeMs = cpuTimeMs;
            return this;
        }

        public AuditEventBuilder setPeakMemoryBytes(long peakMemoryBytes) {
            this.auditEvent.peakMemoryBytes = peakMemoryBytes;
            return this;
        }

        public AuditEventBuilder setScanRows(long scanRows) {
            this.auditEvent.scanRows = scanRows;
            return this;
        }

        public AuditEventBuilder setReturnRows(long returnRows) {
            this.auditEvent.returnRows = returnRows;
            return this;
        }

        public AuditEventBuilder setStmtId(long stmtId) {
            this.auditEvent.stmtId = stmtId;
            return this;
        }

        public AuditEventBuilder setQueryId(String queryId) {
            this.auditEvent.queryId = queryId;
            return this;
        }

        public AuditEventBuilder setIsQuery(boolean isQuery) {
            this.auditEvent.isQuery = isQuery;
            return this;
        }

        public AuditEventBuilder setFeIp(String feIp) {
            this.auditEvent.feIp = feIp;
            return this;
        }

        public AuditEventBuilder setStmt(String stmt) {
            this.auditEvent.stmt = stmt;
            return this;
        }

        public AuditEventBuilder setSqlHash(String sqlHash) {
            this.auditEvent.sqlHash = sqlHash;
            return this;
        }

        public AuditEvent build() {
            return this.auditEvent;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface AuditField {
        public String value() default "";
    }

    public static enum EventType {
        CONNECTION,
        DISCONNECTION,
        BEFORE_QUERY,
        AFTER_QUERY,
        LOAD_SUCCEED,
        STREAM_LOAD_FINISH;

    }
}

