/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LateralViewRef;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.doris.thrift.TTableFunctionNode;

public class TableFunctionNode
extends PlanNode {
    private List<LateralViewRef> lateralViewRefs;
    private ArrayList<Expr> fnCallExprList;
    private List<TupleId> lateralViewTupleIds;
    private List<SlotId> outputSlotIds = Lists.newArrayList();

    protected TableFunctionNode(PlanNodeId id, PlanNode inputNode, List<LateralViewRef> lateralViewRefs) {
        super(id, "TABLE FUNCTION NODE");
        this.tupleIds.addAll(inputNode.getTupleIds());
        this.tblRefIds.addAll(inputNode.getTupleIds());
        this.lateralViewTupleIds = lateralViewRefs.stream().map(e -> e.getDesc().getId()).collect(Collectors.toList());
        this.tupleIds.addAll(this.lateralViewTupleIds);
        this.tblRefIds.addAll(this.lateralViewTupleIds);
        this.children.add(inputNode);
        this.lateralViewRefs = lateralViewRefs;
    }

    public void projectSlots(Analyzer analyzer, SelectStmt selectStmt) throws AnalysisException {
        if ((selectStmt.hasAggInfo() || selectStmt.getSortInfo() != null || selectStmt.hasAnalyticInfo()) && selectStmt.hasInlineView()) {
            throw new AnalysisException("Please treat the query containing the lateral view as a inline viewand extract your aggregation/sort/window functions to the outer query.For example select sum(a) from (select a from table lateral view xxx) tmp1");
        }
        HashSet outputSlotRef = Sets.newHashSet();
        ArrayList<Expr> baseTblResultExprs = selectStmt.getBaseTblResultExprs();
        for (Expr resultExpr : baseTblResultExprs) {
            resultExpr.getSlotRefsBoundByTupleIds(this.tupleIds, outputSlotRef);
        }
        List<Expr> remainConjuncts = analyzer.getRemainConjuncts(this.tupleIds);
        for (Expr expr : remainConjuncts) {
            expr.getSlotRefsBoundByTupleIds(this.tupleIds, outputSlotRef);
        }
        for (SlotRef slotRef : outputSlotRef) {
            this.outputSlotIds.add(slotRef.getSlotId());
        }
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        super.init(analyzer);
        this.fnCallExprList = new ArrayList(this.lateralViewRefs.stream().map(e -> e.getFnExpr()).collect(Collectors.toList()));
        this.outputSmap = this.getCombinedChildSmap();
        this.fnCallExprList = Expr.substituteList(this.fnCallExprList, this.outputSmap, analyzer, false);
        this.computeStats(analyzer);
    }

    @Override
    protected void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        this.cardinality = ((PlanNode)this.children.get((int)0)).cardinality;
    }

    @Override
    public String getNodeExplainString(String prefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(prefix + "table function: ");
        for (Expr fnExpr : this.fnCallExprList) {
            output.append(fnExpr.toSql() + " ");
        }
        output.append("\n");
        output.append(prefix + "lateral view tuple id: ");
        for (TupleId tupleId : this.lateralViewTupleIds) {
            output.append(tupleId.asInt() + " ");
        }
        output.append("\n");
        if (detailLevel == TExplainLevel.BRIEF) {
            return output.toString();
        }
        output.append(prefix + "output slot id: ");
        for (SlotId slotId : this.outputSlotIds) {
            output.append(slotId.asInt() + " ");
        }
        output.append("\n");
        if (!this.conjuncts.isEmpty()) {
            output.append(prefix).append("PREDICATES: ").append(this.getExplainString(this.conjuncts)).append("\n");
        }
        output.append(prefix).append(String.format("cardinality=%s", this.cardinality)).append("\n");
        return output.toString();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.TABLE_FUNCTION_NODE;
        msg.table_function_node = new TTableFunctionNode();
        msg.table_function_node.setFnCallExprList(Expr.treesToThrift(this.fnCallExprList));
        for (SlotId slotId : this.outputSlotIds) {
            msg.table_function_node.addToOutputSlotIds(slotId.asInt());
        }
    }
}

