/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ImportColumnDesc;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.UserException;
import org.apache.doris.load.Load;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.planner.LoadScanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.task.LoadTaskInfo;
import org.apache.doris.thrift.TBrokerRangeDesc;
import org.apache.doris.thrift.TBrokerScanRange;
import org.apache.doris.thrift.TBrokerScanRangeParams;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TFileFormatType;
import org.apache.doris.thrift.TScanRange;
import org.apache.doris.thrift.TScanRangeLocations;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamLoadScanNode
extends LoadScanNode {
    private static final Logger LOG = LogManager.getLogger(StreamLoadScanNode.class);
    private TUniqueId loadId;
    private Table dstTable;
    private LoadTaskInfo taskInfo;
    private Analyzer analyzer;
    private TupleDescriptor srcTupleDesc;
    private TBrokerScanRange brokerScanRange;
    private final Map<String, SlotDescriptor> slotDescByName = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Expr> exprsByName = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);

    public StreamLoadScanNode(TUniqueId loadId, PlanNodeId id, TupleDescriptor tupleDesc, Table dstTable, LoadTaskInfo taskInfo) {
        super(id, tupleDesc, "StreamLoadScanNode");
        this.loadId = loadId;
        this.dstTable = dstTable;
        this.taskInfo = taskInfo;
        this.numInstances = 1;
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        String sep;
        this.assignConjuncts(analyzer);
        this.analyzer = analyzer;
        this.brokerScanRange = new TBrokerScanRange();
        this.deleteCondition = this.taskInfo.getDeleteCondition();
        this.mergeType = this.taskInfo.getMergeType();
        TBrokerRangeDesc rangeDesc = new TBrokerRangeDesc();
        rangeDesc.file_type = this.taskInfo.getFileType();
        rangeDesc.format_type = this.taskInfo.getFormatType();
        if (rangeDesc.format_type == TFileFormatType.FORMAT_JSON) {
            if (!this.taskInfo.getJsonPaths().isEmpty()) {
                rangeDesc.setJsonpaths(this.taskInfo.getJsonPaths());
            }
            if (!this.taskInfo.getJsonRoot().isEmpty()) {
                rangeDesc.setJsonRoot(this.taskInfo.getJsonRoot());
            }
            rangeDesc.setStripOuterArray(this.taskInfo.isStripOuterArray());
            rangeDesc.setNumAsString(this.taskInfo.isNumAsString());
            rangeDesc.setFuzzyParse(this.taskInfo.isFuzzyParse());
            rangeDesc.setReadJsonByLine(this.taskInfo.isReadJsonByLine());
        }
        rangeDesc.splittable = false;
        switch (this.taskInfo.getFileType()) {
            case FILE_LOCAL: {
                rangeDesc.path = this.taskInfo.getPath();
                break;
            }
            case FILE_STREAM: {
                rangeDesc.path = "Invalid Path";
                rangeDesc.load_id = this.loadId;
                break;
            }
            default: {
                throw new UserException("unsupported file type, type=" + this.taskInfo.getFileType());
            }
        }
        rangeDesc.start_offset = 0L;
        rangeDesc.size = -1L;
        this.brokerScanRange.addToRanges(rangeDesc);
        this.srcTupleDesc = analyzer.getDescTbl().createTupleDescriptor("StreamLoadScanNode");
        TBrokerScanRangeParams params = new TBrokerScanRangeParams();
        LoadTaskInfo.ImportColumnDescs columnExprDescs = this.taskInfo.getColumnExprDescs();
        if (!columnExprDescs.isColumnDescsRewrited) {
            if (this.mergeType == LoadTask.MergeType.MERGE) {
                columnExprDescs.descs.add(ImportColumnDesc.newDeleteSignImportColumnDesc(this.deleteCondition));
            } else if (this.mergeType == LoadTask.MergeType.DELETE) {
                columnExprDescs.descs.add(ImportColumnDesc.newDeleteSignImportColumnDesc(new IntLiteral(1L)));
            }
            if (this.taskInfo.hasSequenceCol()) {
                columnExprDescs.descs.add(new ImportColumnDesc("__DORIS_SEQUENCE_COL__", new SlotRef(null, this.taskInfo.getSequenceCol())));
            }
        }
        Load.initColumns(this.dstTable, columnExprDescs, null, this.exprsByName, analyzer, this.srcTupleDesc, this.slotDescByName, params);
        this.initAndSetPrecedingFilter(this.taskInfo.getPrecedingFilter(), this.srcTupleDesc, analyzer);
        this.initAndSetWhereExpr(this.taskInfo.getWhereExpr(), this.desc, analyzer);
        this.createDefaultSmap(analyzer);
        if (this.taskInfo.getColumnSeparator() != null) {
            sep = this.taskInfo.getColumnSeparator().getSeparator();
            params.setColumnSeparatorStr(sep);
            params.setColumnSeparatorLength(sep.getBytes(Charset.forName("UTF-8")).length);
            params.setColumnSeparator(sep.getBytes(Charset.forName("UTF-8"))[0]);
        } else {
            params.setColumnSeparator((byte)9);
            params.setColumnSeparatorLength(1);
            params.setColumnSeparatorStr("\t");
        }
        if (this.taskInfo.getLineDelimiter() != null) {
            sep = this.taskInfo.getLineDelimiter().getSeparator();
            params.setLineDelimiterStr(sep);
            params.setLineDelimiterLength(sep.getBytes(Charset.forName("UTF-8")).length);
            params.setLineDelimiter(sep.getBytes(Charset.forName("UTF-8"))[0]);
        } else {
            params.setLineDelimiter((byte)10);
            params.setLineDelimiterLength(1);
        }
        params.setDestTupleId(this.desc.getId().asInt());
        this.brokerScanRange.setParams(params);
        this.brokerScanRange.setBrokerAddresses((List)Lists.newArrayList());
        this.computeStats(analyzer);
    }

    @Override
    public void finalize(Analyzer analyzer) throws UserException {
        this.finalizeParams(this.slotDescByName, this.exprsByName, this.brokerScanRange.params, this.srcTupleDesc, this.taskInfo.isStrictMode(), this.taskInfo.getNegative(), analyzer);
    }

    @Override
    public List<TScanRangeLocations> getScanRangeLocations(long maxScanRangeLength) {
        TScanRangeLocations locations = new TScanRangeLocations();
        TScanRange scanRange = new TScanRange();
        scanRange.setBrokerScanRange(this.brokerScanRange);
        locations.setScanRange(scanRange);
        locations.setLocations((List)Lists.newArrayList());
        return Lists.newArrayList((Object[])new TScanRangeLocations[]{locations});
    }

    @Override
    public int getNumInstances() {
        return 1;
    }

    @Override
    public String getNodeExplainString(String prefix, TExplainLevel detailLevel) {
        return "StreamLoadScanNode";
    }
}

