/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DescriptorTable;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.load.LoadErrorHub;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.load.routineload.RoutineLoadJob;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.ListPartitionPruner;
import org.apache.doris.planner.OlapTableSink;
import org.apache.doris.planner.PartitionColumnFilter;
import org.apache.doris.planner.PartitionPruner;
import org.apache.doris.planner.PlanFragment;
import org.apache.doris.planner.PlanFragmentId;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.planner.RangePartitionPruner;
import org.apache.doris.planner.SingleNodePlanner;
import org.apache.doris.planner.StreamLoadScanNode;
import org.apache.doris.task.LoadTaskInfo;
import org.apache.doris.thrift.PaloInternalServiceVersion;
import org.apache.doris.thrift.TExecPlanFragmentParams;
import org.apache.doris.thrift.TLoadErrorHubInfo;
import org.apache.doris.thrift.TPlanFragmentExecParams;
import org.apache.doris.thrift.TQueryGlobals;
import org.apache.doris.thrift.TQueryOptions;
import org.apache.doris.thrift.TQueryType;
import org.apache.doris.thrift.TScanRangeLocations;
import org.apache.doris.thrift.TScanRangeParams;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamLoadPlanner {
    private static final Logger LOG = LogManager.getLogger(StreamLoadPlanner.class);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Database db;
    private OlapTable destTable;
    private LoadTaskInfo taskInfo;
    private Analyzer analyzer;
    private DescriptorTable descTable;
    private StreamLoadScanNode scanNode;
    private TupleDescriptor tupleDesc;

    public StreamLoadPlanner(Database db, OlapTable destTable, LoadTaskInfo taskInfo) {
        this.db = db;
        this.destTable = destTable;
        this.taskInfo = taskInfo;
    }

    private void resetAnalyzer() {
        this.analyzer = new Analyzer(Catalog.getCurrentCatalog(), null);
        this.analyzer.setUDFAllowed(false);
        this.descTable = this.analyzer.getDescTbl();
    }

    public OlapTable getDestTable() {
        return this.destTable;
    }

    public TExecPlanFragmentParams plan(TUniqueId loadId) throws UserException {
        TLoadErrorHubInfo info;
        if (this.destTable.getKeysType() != KeysType.UNIQUE_KEYS && this.taskInfo.getMergeType() != LoadTask.MergeType.APPEND) {
            throw new AnalysisException("load by MERGE or DELETE is only supported in unique tables.");
        }
        if (this.taskInfo.getMergeType() != LoadTask.MergeType.APPEND && !this.destTable.hasDeleteSign()) {
            throw new AnalysisException("load by MERGE or DELETE need to upgrade table to support batch delete.");
        }
        if (this.destTable.hasSequenceCol().booleanValue() && !this.taskInfo.hasSequenceCol()) {
            throw new UserException("Table " + this.destTable.getName() + " has sequence column, need to specify the sequence column");
        }
        if (!this.destTable.hasSequenceCol().booleanValue() && this.taskInfo.hasSequenceCol()) {
            throw new UserException("There is no sequence column in the table " + this.destTable.getName());
        }
        this.resetAnalyzer();
        this.tupleDesc = this.descTable.createTupleDescriptor("DstTableTuple");
        boolean negative = this.taskInfo.getNegative();
        for (Column col : this.destTable.getFullSchema()) {
            SlotDescriptor slotDesc = this.descTable.addSlotDescriptor(this.tupleDesc);
            slotDesc.setIsMaterialized(true);
            slotDesc.setColumn(col);
            slotDesc.setIsNullable(col.isAllowNull());
            if (!negative || col.isKey() || col.getAggregationType() == AggregateType.SUM) continue;
            throw new DdlException("Column is not SUM AggregateType. column:" + col.getName());
        }
        this.scanNode = new StreamLoadScanNode(loadId, new PlanNodeId(0), this.tupleDesc, this.destTable, this.taskInfo);
        this.scanNode.init(this.analyzer);
        this.descTable.computeStatAndMemLayout();
        this.scanNode.finalize(this.analyzer);
        int timeout = this.taskInfo.getTimeout();
        if (this.taskInfo instanceof RoutineLoadJob) {
            timeout *= 2;
        }
        List<Long> partitionIds = this.getAllPartitionIds();
        OlapTableSink olapTableSink = new OlapTableSink(this.destTable, this.tupleDesc, partitionIds);
        olapTableSink.init(loadId, this.taskInfo.getTxnId(), this.db.getId(), this.taskInfo.getTimeout(), this.taskInfo.getSendBatchParallelism(), this.taskInfo.isLoadToSingleTablet());
        olapTableSink.complete();
        PlanFragment fragment = new PlanFragment(new PlanFragmentId(0), this.scanNode, DataPartition.UNPARTITIONED);
        fragment.setSink(olapTableSink);
        fragment.finalize(null);
        TExecPlanFragmentParams params = new TExecPlanFragmentParams();
        params.setProtocolVersion(PaloInternalServiceVersion.V1);
        params.setFragment(fragment.toThrift());
        params.setDescTbl(this.analyzer.getDescTbl().toThrift());
        TPlanFragmentExecParams execParams = new TPlanFragmentExecParams();
        execParams.setQueryId(loadId);
        execParams.setFragmentInstanceId(new TUniqueId(loadId.hi, loadId.lo + 1L));
        execParams.per_exch_num_senders = Maps.newHashMap();
        execParams.destinations = Lists.newArrayList();
        HashMap perNodeScanRange = Maps.newHashMap();
        ArrayList scanRangeParams = Lists.newArrayList();
        for (TScanRangeLocations locations : this.scanNode.getScanRangeLocations(0L)) {
            scanRangeParams.add(new TScanRangeParams(locations.getScanRange()));
        }
        execParams.setSenderId(0);
        execParams.setNumSenders(1);
        perNodeScanRange.put(this.scanNode.getId().asInt(), scanRangeParams);
        execParams.setPerNodeScanRanges((Map)perNodeScanRange);
        params.setParams(execParams);
        TQueryOptions queryOptions = new TQueryOptions();
        queryOptions.setQueryType(TQueryType.LOAD);
        queryOptions.setQueryTimeout(timeout);
        queryOptions.setMemLimit(this.taskInfo.getMemLimit());
        queryOptions.setLoadMemLimit(this.taskInfo.getMemLimit());
        params.setQueryOptions(queryOptions);
        TQueryGlobals queryGlobals = new TQueryGlobals();
        queryGlobals.setNowString(DATE_FORMAT.format(new Date()));
        queryGlobals.setTimestampMs(System.currentTimeMillis());
        queryGlobals.setTimeZone(this.taskInfo.getTimezone());
        queryGlobals.setLoadZeroTolerance(this.taskInfo.getMaxFilterRatio() <= 0.0);
        params.setQueryGlobals(queryGlobals);
        LoadErrorHub.Param param = Catalog.getCurrentCatalog().getLoadInstance().getLoadErrorHubInfo();
        if (param != null && (info = param.toThrift()) != null) {
            params.setLoadErrorHubInfo(info);
        }
        return params;
    }

    private List<Long> getAllPartitionIds() throws DdlException, AnalysisException {
        ArrayList partitionIds = Lists.newArrayList();
        PartitionNames partitionNames = this.taskInfo.getPartitions();
        if (partitionNames != null) {
            for (String partName : partitionNames.getPartitionNames()) {
                Partition part = this.destTable.getPartition(partName, partitionNames.isTemp());
                if (part == null) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_UNKNOWN_PARTITION, partName, this.destTable.getName());
                }
                partitionIds.add(part.getId());
            }
            return partitionIds;
        }
        List<Expr> conjuncts = this.scanNode.getConjuncts();
        if (this.destTable.getPartitionInfo().getType() != PartitionType.UNPARTITIONED && !conjuncts.isEmpty()) {
            PartitionInfo partitionInfo = this.destTable.getPartitionInfo();
            Map<Long, PartitionItem> itemById = partitionInfo.getIdToItem(false);
            HashMap columnFilters = Maps.newHashMap();
            for (Column column : partitionInfo.getPartitionColumns()) {
                PartitionColumnFilter keyFilter;
                SlotDescriptor slotDesc = this.tupleDesc.getColumnSlot(column.getName());
                if (null == slotDesc || null == (keyFilter = SingleNodePlanner.createPartitionFilter(slotDesc, conjuncts))) continue;
                columnFilters.put(column.getName(), keyFilter);
            }
            if (columnFilters.isEmpty()) {
                return null;
            }
            PartitionPruner partitionPruner = null;
            if (this.destTable.getPartitionInfo().getType() == PartitionType.RANGE) {
                partitionPruner = new RangePartitionPruner(itemById, partitionInfo.getPartitionColumns(), columnFilters);
            } else if (this.destTable.getPartitionInfo().getType() == PartitionType.LIST) {
                partitionPruner = new ListPartitionPruner(itemById, partitionInfo.getPartitionColumns(), columnFilters);
            }
            partitionIds.addAll(partitionPruner.prune());
            return partitionIds;
        }
        return null;
    }
}

