/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.SortInfo;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.common.NotImplementedException;
import org.apache.doris.common.UserException;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.doris.thrift.TSortInfo;
import org.apache.doris.thrift.TSortNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SortNode
extends PlanNode {
    private static final Logger LOG = LogManager.getLogger(SortNode.class);
    private final SortInfo info;
    private final boolean useTopN;
    private final boolean isDefaultLimit;
    private long offset;
    private boolean isAnalyticSort;
    List<Expr> resolvedTupleExprs;
    private DataPartition inputPartition;

    public void setIsAnalyticSort(boolean v) {
        this.isAnalyticSort = v;
    }

    public boolean isAnalyticSort() {
        return this.isAnalyticSort;
    }

    public void setInputPartition(DataPartition inputPartition) {
        this.inputPartition = inputPartition;
    }

    public DataPartition getInputPartition() {
        return this.inputPartition;
    }

    public SortNode(PlanNodeId id, PlanNode input, SortInfo info, boolean useTopN, boolean isDefaultLimit, long offset) {
        super(id, useTopN ? "TOP-N" : "SORT");
        this.info = info;
        this.useTopN = useTopN;
        this.isDefaultLimit = isDefaultLimit;
        this.tupleIds.addAll(Lists.newArrayList((Object[])new TupleId[]{info.getSortTupleDescriptor().getId()}));
        this.tblRefIds.addAll(Lists.newArrayList((Object[])new TupleId[]{info.getSortTupleDescriptor().getId()}));
        this.nullableTupleIds.addAll(input.getNullableTupleIds());
        this.children.add(input);
        this.offset = offset;
        Preconditions.checkArgument((info.getOrderingExprs().size() == info.getIsAscOrder().size() ? 1 : 0) != 0);
    }

    public SortNode(PlanNodeId id, SortNode inputSortNode, PlanNode child) {
        super(id, inputSortNode, inputSortNode.useTopN ? "TOP-N" : "SORT");
        this.info = inputSortNode.info;
        this.useTopN = inputSortNode.useTopN;
        this.isDefaultLimit = inputSortNode.isDefaultLimit;
        this.children.add(child);
        this.offset = inputSortNode.offset;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public SortInfo getSortInfo() {
        return this.info;
    }

    @Override
    public void getMaterializedIds(Analyzer analyzer, List<SlotId> ids) {
        super.getMaterializedIds(analyzer, ids);
        Expr.getIds(this.info.getOrderingExprs(), null, ids);
    }

    @Override
    public void setCompactData(boolean on) {
        this.compactData = on;
    }

    @Override
    protected void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        if (!analyzer.safeIsEnableJoinReorderBasedCost()) {
            return;
        }
        this.cardinality = ((PlanNode)this.getChild((int)0)).cardinality;
        this.applyConjunctsSelectivity();
        this.capCardinalityAtLimit();
        if (LOG.isDebugEnabled()) {
            LOG.debug("stats Sort: cardinality=" + this.cardinality);
        }
    }

    @Override
    protected void computeOldCardinality() {
        this.cardinality = ((PlanNode)this.getChild((int)0)).cardinality;
        if (this.hasLimit()) {
            this.cardinality = this.cardinality == -1L ? this.limit : Math.min(this.cardinality, this.limit);
        }
        LOG.debug("stats Sort: cardinality=" + Long.toString(this.cardinality));
    }

    @Override
    public Set<SlotId> computeInputSlotIds(Analyzer analyzer) throws NotImplementedException {
        ArrayList result = Lists.newArrayList();
        Expr.getIds(this.resolvedTupleExprs, null, result);
        return new HashSet<SlotId>(result);
    }

    @Override
    protected String debugString() {
        ArrayList strings = Lists.newArrayList();
        for (Boolean isAsc : this.info.getIsAscOrder()) {
            strings.add(isAsc != false ? "a" : "d");
        }
        return MoreObjects.toStringHelper((Object)this).add("ordering_exprs", (Object)Expr.debugString(this.info.getOrderingExprs())).add("is_asc", (Object)("[" + Joiner.on((String)" ").join((Iterable)strings) + "]")).addValue((Object)super.debugString()).toString();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        TSortNode sortNode;
        msg.node_type = TPlanNodeType.SORT_NODE;
        TSortInfo sortInfo = new TSortInfo(Expr.treesToThrift(this.info.getOrderingExprs()), this.info.getIsAscOrder(), this.info.getNullsFirst());
        Preconditions.checkState((this.tupleIds.size() == 1 ? 1 : 0) != 0, (Object)"Incorrect size for tupleIds in SortNode");
        sortInfo.setSortTupleSlotExprs(Expr.treesToThrift(this.resolvedTupleExprs));
        msg.sort_node = sortNode = new TSortNode(sortInfo, this.useTopN);
        msg.sort_node.setOffset(this.offset);
        msg.sort_node.setOrderingExprs(Expr.treesToThrift(this.info.getOrderingExprs()));
        msg.sort_node.setIsAscOrder(this.info.getIsAscOrder());
        msg.sort_node.setNullsFirst(this.info.getNullsFirst());
        if (this.info.getSortTupleSlotExprs() != null) {
            msg.sort_node.setSortTupleSlotExprs(Expr.treesToThrift(this.info.getSortTupleSlotExprs()));
        }
    }

    @Override
    public String getNodeExplainString(String detailPrefix, TExplainLevel detailLevel) {
        if (detailLevel == TExplainLevel.BRIEF) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        output.append(detailPrefix + "order by: ");
        Iterator<Expr> expr = this.info.getOrderingExprs().iterator();
        Iterator<Boolean> isAsc = this.info.getIsAscOrder().iterator();
        boolean start = true;
        while (expr.hasNext()) {
            if (start) {
                start = false;
            } else {
                output.append(", ");
            }
            output.append(expr.next().toSql() + " ");
            output.append(isAsc.next() != false ? "ASC" : "DESC");
        }
        output.append("\n");
        output.append(detailPrefix + "offset: " + this.offset + "\n");
        return output.toString();
    }

    @Override
    public int getNumInstances() {
        return ((PlanNode)this.children.get(0)).getNumInstances();
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        this.computeStats(analyzer);
        ArrayList<SlotDescriptor> sortTupleSlots = this.info.getSortTupleDescriptor().getSlots();
        List<Expr> slotExprs = this.info.getSortTupleSlotExprs();
        Preconditions.checkState((sortTupleSlots.size() == slotExprs.size() ? 1 : 0) != 0);
        this.resolvedTupleExprs = Lists.newArrayList();
        this.outputSmap = new ExprSubstitutionMap();
        for (int i = 0; i < slotExprs.size(); ++i) {
            if (!((SlotDescriptor)sortTupleSlots.get(i)).isMaterialized()) continue;
            this.resolvedTupleExprs.add(slotExprs.get(i));
            this.outputSmap.put(slotExprs.get(i), new SlotRef((SlotDescriptor)sortTupleSlots.get(i)));
        }
        ExprSubstitutionMap childSmap = this.getCombinedChildSmap();
        this.resolvedTupleExprs = Expr.substituteList(this.resolvedTupleExprs, childSmap, analyzer, false);
        this.outputSmap = ExprSubstitutionMap.compose(childSmap, this.outputSmap, analyzer);
        this.info.substituteOrderingExprs(this.outputSmap, analyzer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sort id " + ((TupleId)this.tupleIds.get(0)).toString() + " smap: " + this.outputSmap.debugString());
            LOG.debug("sort input exprs: " + Expr.debugString(this.resolvedTupleExprs));
        }
    }
}

