/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.analysis.AggregateInfo;
import org.apache.doris.analysis.AnalyticInfo;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.AssertNumRowsElement;
import org.apache.doris.analysis.BaseTableRef;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CaseExpr;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.GroupByClause;
import org.apache.doris.analysis.GroupingInfo;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.InlineViewRef;
import org.apache.doris.analysis.IsNullPredicate;
import org.apache.doris.analysis.JoinOperator;
import org.apache.doris.analysis.LateralViewRef;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.SetOperationStmt;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.analysis.TupleIsNullPredicate;
import org.apache.doris.catalog.AggregateFunction;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.MysqlTable;
import org.apache.doris.catalog.OdbcTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.Pair;
import org.apache.doris.common.Reference;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.planner.AggregationNode;
import org.apache.doris.planner.AnalyticPlanner;
import org.apache.doris.planner.AssertNumRowsNode;
import org.apache.doris.planner.BrokerScanNode;
import org.apache.doris.planner.CrossJoinNode;
import org.apache.doris.planner.EmptySetNode;
import org.apache.doris.planner.EsScanNode;
import org.apache.doris.planner.ExceptNode;
import org.apache.doris.planner.HashJoinNode;
import org.apache.doris.planner.HiveScanNode;
import org.apache.doris.planner.IcebergScanNode;
import org.apache.doris.planner.IntersectNode;
import org.apache.doris.planner.MaterializedViewSelector;
import org.apache.doris.planner.MysqlScanNode;
import org.apache.doris.planner.OdbcScanNode;
import org.apache.doris.planner.OlapScanNode;
import org.apache.doris.planner.PartitionColumnFilter;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlannerContext;
import org.apache.doris.planner.PredicatePushDown;
import org.apache.doris.planner.RepeatNode;
import org.apache.doris.planner.ScanNode;
import org.apache.doris.planner.SchemaScanNode;
import org.apache.doris.planner.SelectNode;
import org.apache.doris.planner.SetOperationNode;
import org.apache.doris.planner.SortNode;
import org.apache.doris.planner.TableFunctionNode;
import org.apache.doris.planner.UnionNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SingleNodePlanner {
    private static final Logger LOG = LogManager.getLogger(SingleNodePlanner.class);
    private final PlannerContext ctx;
    private final ArrayList<ScanNode> scanNodes = Lists.newArrayList();
    private Map<Analyzer, List<ScanNode>> selectStmtToScanNodes = Maps.newHashMap();

    public SingleNodePlanner(PlannerContext ctx) {
        this.ctx = ctx;
    }

    public PlannerContext getPlannerContext() {
        return this.ctx;
    }

    public ArrayList<ScanNode> getScanNodes() {
        return this.scanNodes;
    }

    public PlanNode createSingleNodePlan() throws UserException, AnalysisException {
        QueryStmt queryStmt = this.ctx.getQueryStmt();
        Analyzer analyzer = queryStmt.getAnalyzer();
        if (queryStmt.getBaseTblResultExprs() != null) {
            analyzer.materializeSlots(queryStmt.getBaseTblResultExprs());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("desctbl: " + analyzer.getDescTbl().debugString());
        }
        PlanNode singleNodePlan = this.createQueryPlan(queryStmt, analyzer, this.ctx.getQueryOptions().getDefaultOrderByLimit());
        Preconditions.checkNotNull((Object)singleNodePlan);
        return singleNodePlan;
    }

    private PlanNode createEmptyNode(PlanNode inputPlan, QueryStmt stmt, Analyzer analyzer) {
        ArrayList<TupleId> tupleIds = Lists.newArrayList();
        if (inputPlan != null) {
            tupleIds = inputPlan.tupleIds;
        }
        if (tupleIds.isEmpty()) {
            Preconditions.checkState((boolean)(stmt instanceof SelectStmt), (Object)"Only constant selects should have no materialized tuples");
            SelectStmt selectStmt = (SelectStmt)stmt;
            Preconditions.checkState((boolean)selectStmt.getTableRefs().isEmpty());
            tupleIds.add(this.createResultTupleDescriptor(selectStmt, "empty", analyzer).getId());
        }
        this.unmarkCollectionSlots(stmt);
        EmptySetNode node = new EmptySetNode(this.ctx.getNextNodeId(), tupleIds);
        node.init(analyzer);
        if (stmt instanceof SelectStmt) {
            node.setOutputSmap(((SelectStmt)stmt).getBaseTblSmap());
        }
        return node;
    }

    private void unmarkCollectionSlots(QueryStmt stmt) {
        ArrayList tblRefs = Lists.newArrayList();
        stmt.collectTableRefs(tblRefs);
        for (TableRef ref : tblRefs) {
            if (ref.isRelative()) continue;
        }
    }

    private PlanNode createQueryPlan(QueryStmt stmt, Analyzer analyzer, long defaultOrderByLimit) throws UserException {
        PlanNode root;
        long newDefaultOrderByLimit = defaultOrderByLimit;
        if (newDefaultOrderByLimit == -1L) {
            newDefaultOrderByLimit = 65535L;
        }
        if (stmt instanceof SelectStmt) {
            SelectStmt selectStmt = (SelectStmt)stmt;
            this.pushDownPredicates(analyzer, selectStmt);
            root = this.createSelectPlan(selectStmt, analyzer, newDefaultOrderByLimit);
            if (selectStmt.getAnalyticInfo() != null) {
                AnalyticInfo analyticInfo = selectStmt.getAnalyticInfo();
                AnalyticPlanner analyticPlanner = new AnalyticPlanner(analyticInfo, analyzer, this.ctx);
                ArrayList inputPartitionExprs = Lists.newArrayList();
                AggregateInfo aggInfo = selectStmt.getAggInfo();
                root = analyticPlanner.createSingleNodePlan(root, aggInfo != null ? aggInfo.getGroupingExprs() : null, inputPartitionExprs);
                if (aggInfo != null && !inputPartitionExprs.isEmpty()) {
                    aggInfo.setPartitionExprs(inputPartitionExprs);
                }
            }
        } else {
            Preconditions.checkState((boolean)(stmt instanceof SetOperationStmt));
            root = this.createSetOperationPlan((SetOperationStmt)stmt, analyzer, newDefaultOrderByLimit);
        }
        boolean sortHasMaterializedSlots = false;
        if (stmt.evaluateOrderBy()) {
            for (SlotDescriptor sortSlotDesc : stmt.getSortInfo().getSortTupleDescriptor().getSlots()) {
                if (!sortSlotDesc.isMaterialized()) continue;
                sortHasMaterializedSlots = true;
                break;
            }
        }
        if (stmt.evaluateOrderBy() && sortHasMaterializedSlots) {
            long limit = stmt.getLimit();
            boolean useTopN = true;
            if (limit == -1L && analyzer.getContext().getSessionVariable().enableSpilling) {
                useTopN = false;
            }
            root = new SortNode(this.ctx.getNextNodeId(), root, stmt.getSortInfo(), useTopN, limit == -1L, stmt.getOffset());
            if (useTopN) {
                root.setLimit(limit != -1L ? limit : newDefaultOrderByLimit);
            } else {
                root.setLimit(limit);
            }
            Preconditions.checkState((boolean)root.hasValidStats());
            root.init(analyzer);
            root = this.addUnassignedConjuncts(analyzer, root);
        } else {
            root.setLimit(stmt.getLimit());
            root.computeStats(analyzer);
        }
        if (stmt.getAssertNumRowsElement() != null) {
            root = this.createAssertRowCountNode(root, stmt.getAssertNumRowsElement(), analyzer);
        }
        if (analyzer.hasEmptyResultSet()) {
            HashSet<TupleId> scanTupleIds = new HashSet<TupleId>(root.getAllScanTupleIds());
            this.scanNodes.removeIf(scanNode -> scanTupleIds.contains(scanNode.getTupleIds().get(0)));
            PlanNode node = this.createEmptyNode(root, stmt, analyzer);
            node.setOutputSmap(root.outputSmap);
            return node;
        }
        return root;
    }

    private PlanNode addUnassignedConjuncts(Analyzer analyzer, PlanNode root) throws UserException {
        Preconditions.checkNotNull((Object)root);
        List<Expr> conjuncts = analyzer.getUnassignedConjuncts(root);
        if (conjuncts.isEmpty()) {
            return root;
        }
        SelectNode selectNode = new SelectNode(this.ctx.getNextNodeId(), root, conjuncts);
        selectNode.init(analyzer);
        Preconditions.checkState((boolean)selectNode.hasValidStats());
        return selectNode;
    }

    private PlanNode addUnassignedConjuncts(Analyzer analyzer, List<TupleId> tupleIds, PlanNode root) throws UserException {
        if (root instanceof EmptySetNode) {
            return root;
        }
        Preconditions.checkNotNull((Object)root);
        List<Expr> conjuncts = analyzer.getUnassignedConjuncts(root);
        if (conjuncts.isEmpty()) {
            return root;
        }
        SelectNode selectNode = new SelectNode(this.ctx.getNextNodeId(), root, conjuncts);
        selectNode.init(analyzer);
        Preconditions.checkState((boolean)selectNode.hasValidStats());
        return selectNode;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void turnOffPreAgg(AggregateInfo aggInfo, SelectStmt selectStmt, Analyzer analyzer, PlanNode root) {
        block40: {
            block42: {
                block41: {
                    block39: {
                        turnOffReason = null;
                        if (root instanceof OlapScanNode) break block39;
                        turnOffReason = "left-deep Node is not OlapScanNode";
                        break block40;
                    }
                    if (((OlapScanNode)root).getForceOpenPreAgg()) {
                        ((OlapScanNode)root).setIsPreAggregation(true, "");
                        return;
                    }
                    if (null != aggInfo) break block41;
                    turnOffReason = "No AggregateInfo";
                    break block40;
                }
                aggExprs = aggInfo.getAggregateExprs();
                aggTableValidate = true;
                if (selectStmt.getTableRefs().size() <= 1) break block42;
                for (i = 1; i < selectStmt.getTableRefs().size(); ++i) {
                    joinOperator = selectStmt.getTableRefs().get(i).getJoinOp();
                    if (!joinOperator.isRightOuterJoin() && !joinOperator.isFullOuterJoin()) continue;
                    turnOffReason = selectStmt.getTableRefs().get(i) + " joinOp is full outer join or right outer join.";
                    aggTableValidate = false;
                    break;
                }
                if (!aggTableValidate) break block40;
                block1: for (FunctionCallExpr aggExpr : aggExprs) {
                    olapTableRef = selectStmt.getTableRefs().get(0);
                    if (Expr.isBound(Lists.newArrayList((Object[])new FunctionCallExpr[]{aggExpr}), Lists.newArrayList((Object[])new TupleId[]{olapTableRef.getId()}))) {
                        SingleNodePlanner.LOG.debug("All agg exprs is bound to olapTable: {}" + olapTableRef.getTable().getName());
                        continue;
                    }
                    tupleIds = Lists.newArrayList();
                    slotIds = Lists.newArrayList();
                    aggExpr.getIds(tupleIds, slotIds);
                    var13_17 = tupleIds.iterator();
                    while (var13_17.hasNext()) {
                        tupleId = (TupleId)var13_17.next();
                        if (analyzer.getTupleDesc(tupleId).getRef() == null) {
                            aggTableValidate = false;
                            continue block1;
                        }
                        if (analyzer.getTupleDesc(tupleId).getRef() == olapTableRef) continue;
                        if (analyzer.getTupleDesc(tupleId).getTable() != null && analyzer.getTupleDesc(tupleId).getTable().getType() == Table.TableType.OLAP) {
                            turnOffReason = "agg expr [" + aggExpr.debugString() + "] is not bound [" + selectStmt.getTableRefs().get(0).toSql() + "]";
                            aggTableValidate = false;
                            continue;
                        }
                        SingleNodePlanner.LOG.debug("The table which agg expr [{}] is bound to, is not OLAP table [{}]", (Object)aggExpr.debugString(), (Object)(analyzer.getTupleDesc(tupleId).getTable() == null ? "inline view" : analyzer.getTupleDesc(tupleId).getTable().getName()));
                    }
                }
                if (!aggTableValidate) break block40;
            }
            valueColumnValidate = true;
            allConjuncts = analyzer.getAllConjuncts(selectStmt.getTableRefs().get(0).getId());
            conjunctSlotIds = Lists.newArrayList();
            if (allConjuncts != null) {
                for (Expr conjunct : allConjuncts) {
                    conjunct.getIds(null, conjunctSlotIds);
                }
                for (Object slot : selectStmt.getTableRefs().get(0).getDesc().getSlots()) {
                    if (slot.getColumn().isKey() || !conjunctSlotIds.contains(slot.getId())) continue;
                    turnOffReason = "conjunct on `" + slot.getColumn().getName() + "` which is StorageEngine value column";
                    valueColumnValidate = false;
                    break;
                }
            }
            if (!valueColumnValidate) break block40;
            aggExprValidate = true;
            for (FunctionCallExpr aggExpr : aggExprs) {
                if (aggExpr.getChildren().size() != 1) {
                    turnOffReason = "aggExpr has more than one child";
                    aggExprValidate = false;
                    break;
                }
                returnColumns = Lists.newArrayList();
                conditionColumns = Lists.newArrayList();
                if (aggExpr.getChild(0) instanceof SlotRef) ** GOTO lbl107
                child = (Expr)aggExpr.getChild(0);
                if (!(child instanceof CastExpr) || !(child.getChild(0) instanceof SlotRef)) ** GOTO lbl78
                if (child.getType().isNumericType() && ((Expr)child.getChild(0)).getType().isNumericType()) {
                    returnColumns.add(((SlotRef)child.getChild(0)).getDesc().getColumn());
                } else {
                    turnOffReason = "aggExpr.getChild(0)[" + ((Expr)aggExpr.getChild(0)).toSql() + "] is not Numeric CastExpr";
                    aggExprValidate = false;
                    break;
lbl78:
                    // 1 sources

                    if (aggExpr.getChild(0) instanceof CaseExpr) {
                        caseExpr = (CaseExpr)aggExpr.getChild(0);
                        conditionExprs = caseExpr.getConditionExprs();
                        for (Expr conditionExpr : conditionExprs) {
                            conditionTupleIds = Lists.newArrayList();
                            conditionSlotIds = Lists.newArrayList();
                            conditionExpr.getIds(conditionTupleIds, conditionSlotIds);
                            for (SlotId conditionSlotId : conditionSlotIds) {
                                conditionColumns.add(analyzer.getDescTbl().getSlotDesc(conditionSlotId).getColumn());
                            }
                        }
                        caseReturnExprValidate = true;
                        returnExprs = caseExpr.getReturnExprs();
                        for (Expr returnExpr : returnExprs) {
                            if (returnExpr instanceof SlotRef) {
                                returnColumns.add(((SlotRef)returnExpr).getDesc().getColumn());
                                continue;
                            }
                            turnOffReason = "aggExpr.getChild(0)[" + ((Expr)aggExpr.getChild(0)).toSql() + "] is not SlotExpr";
                            caseReturnExprValidate = false;
                            break;
                        }
                        if (!caseReturnExprValidate) {
                            aggExprValidate = false;
                            break;
                        }
                    } else {
                        turnOffReason = "aggExpr.getChild(0)[" + ((Expr)aggExpr.getChild(0)).debugString() + "] is not SlotRef or CastExpr|CaseExpr";
                        aggExprValidate = false;
                        break;
lbl107:
                        // 1 sources

                        returnColumns.add(((SlotRef)aggExpr.getChild(0)).getDesc().getColumn());
                    }
                }
                conditionColumnValidate = true;
                for (Object col : conditionColumns) {
                    if (col == null || col.isKey()) continue;
                    turnOffReason = "the condition column [" + col.getName() + "] is not key type in aggr expr [" + aggExpr.toSql() + "].";
                    conditionColumnValidate = false;
                    break;
                }
                if (!conditionColumnValidate) {
                    aggExprValidate = false;
                    break;
                }
                returnColumnValidate = true;
                col = returnColumns.iterator();
                while (col.hasNext()) {
                    col = (Column)col.next();
                    if (col == null) continue;
                    if (col.isKey() && !aggExpr.getFnName().getFunction().equalsIgnoreCase("MAX") && !aggExpr.getFnName().getFunction().equalsIgnoreCase("MIN")) {
                        returnColumnValidate = false;
                        turnOffReason = "the type of agg on StorageEngine's Key column should only be MAX or MIN.agg expr: " + aggExpr.toSql();
                        break;
                    }
                    if (aggExpr.getFnName().getFunction().equalsIgnoreCase("SUM")) {
                        if (col.getAggregationType() == AggregateType.SUM) continue;
                        turnOffReason = "Aggregate Operator not match: SUM <--> " + (Object)col.getAggregationType();
                        returnColumnValidate = false;
                        break;
                    }
                    if (aggExpr.getFnName().getFunction().equalsIgnoreCase("MAX")) {
                        if (col.isKey() || col.getAggregationType() == AggregateType.MAX) continue;
                        turnOffReason = "Aggregate Operator not match: MAX <--> " + (Object)col.getAggregationType();
                        returnColumnValidate = false;
                        break;
                    }
                    if (aggExpr.getFnName().getFunction().equalsIgnoreCase("MIN")) {
                        if (col.isKey() || col.getAggregationType() == AggregateType.MIN) continue;
                        turnOffReason = "Aggregate Operator not match: MIN <--> " + (Object)col.getAggregationType();
                        returnColumnValidate = false;
                        break;
                    }
                    if (aggExpr.getFnName().getFunction().equalsIgnoreCase("HLL_UNION_AGG") || aggExpr.getFnName().getFunction().equalsIgnoreCase("HLL_RAW_AGG")) continue;
                    if (aggExpr.getFnName().getFunction().equalsIgnoreCase("NDV")) {
                        if (col.isKey()) continue;
                        turnOffReason = "NDV function with non-key column: " + col.getName();
                        returnColumnValidate = false;
                        break;
                    }
                    if (aggExpr.getFnName().getFunction().equalsIgnoreCase("bitmap_union_int")) {
                        if (col.isKey()) continue;
                        turnOffReason = "BITMAP_UNION_INT function with non-key column: " + col.getName();
                        returnColumnValidate = false;
                        break;
                    }
                    if (aggExpr.getFnName().getFunction().equalsIgnoreCase("bitmap_union") || aggExpr.getFnName().getFunction().equalsIgnoreCase("bitmap_union_count")) {
                        if (col.getAggregationType() == AggregateType.BITMAP_UNION) continue;
                        turnOffReason = "Aggregate Operator not match: BITMAP_UNION <--> " + (Object)col.getAggregationType();
                        returnColumnValidate = false;
                        break;
                    }
                    if (aggExpr.getFnName().getFunction().equalsIgnoreCase("multi_distinct_count")) {
                        if (col.isKey()) continue;
                        turnOffReason = "Multi count or sum distinct with non-key column: " + col.getName();
                        returnColumnValidate = false;
                        break;
                    }
                    turnOffReason = "Invalid Aggregate Operator: " + aggExpr.getFnName().getFunction();
                    returnColumnValidate = false;
                    break;
                }
                if (returnColumnValidate) continue;
                aggExprValidate = false;
                break;
            }
            if (aggExprValidate) {
                groupExprValidate = true;
                groupExprs = aggInfo.getGroupingExprs();
                for (Expr groupExpr : groupExprs) {
                    groupSlotIds = Lists.newArrayList();
                    groupExpr.getIds(null, groupSlotIds);
                    for (SlotDescriptor slot : selectStmt.getTableRefs().get(0).getDesc().getSlots()) {
                        if (slot.getColumn().isKey() || !groupSlotIds.contains(slot.getId())) continue;
                        turnOffReason = "groupExpr contains StorageEngine's Value";
                        groupExprValidate = false;
                        break;
                    }
                    if (groupExprValidate) continue;
                    break;
                }
                if (groupExprValidate) {
                    olapNode = (OlapScanNode)root;
                    if (!olapNode.getCanTurnOnPreAggr()) {
                        turnOffReason = "this olap scan node[" + olapNode.debugString() + "] has already been turned off pre-aggregation.";
                    } else {
                        olapNode.setIsPreAggregation(true, null);
                    }
                }
            }
        }
        if (root instanceof OlapScanNode && turnOffReason != null) {
            ((OlapScanNode)root).setIsPreAggregation(false, turnOffReason);
        }
    }

    private PlanNode createCheapestJoinPlan(Analyzer analyzer, List<Pair<TableRef, PlanNode>> refPlans) throws UserException {
        if (refPlans.size() == 1) {
            return (PlanNode)refPlans.get((int)0).second;
        }
        ArrayList<Pair<TableRef, Long>> candidates = new ArrayList<Pair<TableRef, Long>>();
        for (Pair<TableRef, PlanNode> pair : refPlans) {
            TableRef ref = (TableRef)pair.first;
            JoinOperator joinOp = ref.getJoinOp();
            if (joinOp.isOuterJoin() || joinOp.isSemiJoin() || joinOp.isCrossJoin()) continue;
            PlanNode plan = (PlanNode)pair.second;
            if (plan.getCardinality() == -1L) {
                candidates.add(new Pair<TableRef, Long>(ref, new Long(0L)));
                LOG.debug("The candidate of " + ref.getUniqueAlias() + ": -1. Using 0 instead of -1 to avoid error");
                continue;
            }
            Preconditions.checkState((boolean)ref.isAnalyzed());
            long materializedSize = plan.getCardinality();
            candidates.add(new Pair<TableRef, Long>(ref, new Long(materializedSize)));
            LOG.debug("The candidate of " + ref.getUniqueAlias() + ": " + materializedSize);
        }
        if (candidates.isEmpty()) {
            LOG.warn("Something wrong happens, the code should not be runned");
            return null;
        }
        Collections.sort(candidates, new Comparator<Pair<TableRef, Long>>(){

            @Override
            public int compare(Pair<TableRef, Long> a, Pair<TableRef, Long> b) {
                long diff = (Long)b.second - (Long)a.second;
                return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
            }
        });
        for (Pair<TableRef, PlanNode> pair : candidates) {
            PlanNode result = this.createJoinPlan(analyzer, (TableRef)pair.first, refPlans);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    boolean candidateCardinalityIsSmaller(PlanNode candidate, long candidateInnerNodeCardinality, PlanNode newRoot, long newRootInnerNodeCardinality) {
        if (candidate.getCardinality() < newRoot.getCardinality()) {
            return true;
        }
        return candidate.getCardinality() == newRoot.getCardinality() && candidate instanceof HashJoinNode && ((HashJoinNode)candidate).getJoinOp().isInnerJoin() && newRoot instanceof HashJoinNode && ((HashJoinNode)newRoot).getJoinOp().isInnerJoin() && candidateInnerNodeCardinality < newRootInnerNodeCardinality;
    }

    private PlanNode createJoinPlan(Analyzer analyzer, TableRef leftmostRef, List<Pair<TableRef, PlanNode>> refPlans) throws UserException {
        LOG.debug("Try to create a query plan starting with " + leftmostRef.getUniqueAlias());
        ArrayList<Pair<TableRef, PlanNode>> remainingRefs = new ArrayList<Pair<TableRef, PlanNode>>();
        PlanNode root = null;
        for (Pair<TableRef, PlanNode> entry : refPlans) {
            if (entry.first == leftmostRef) {
                root = (PlanNode)entry.second;
                continue;
            }
            remainingRefs.add(entry);
        }
        Preconditions.checkNotNull(root);
        HashMap<TableRef, HashSet> precedingRefs = new HashMap<TableRef, HashSet>();
        ArrayList<TableRef> tmpTblRefs = new ArrayList<TableRef>();
        for (Pair<TableRef, PlanNode> entry : refPlans) {
            TableRef tblRef = (TableRef)entry.first;
            if (tblRef.getJoinOp().isOuterJoin() || tblRef.getJoinOp().isSemiJoin()) {
                precedingRefs.put(tblRef, Sets.newHashSet(tmpTblRefs));
            }
            tmpTblRefs.add(tblRef);
        }
        HashSet joinedRefs = Sets.newHashSet((Object[])new TableRef[]{leftmostRef});
        long numOps = 0L;
        int successfulSelectionTimes = 0;
        while (!remainingRefs.isEmpty()) {
            PlanNode newRoot = null;
            Pair minEntry = null;
            long newRootRightChildCardinality = 0L;
            for (Pair pair : remainingRefs) {
                TableRef tblRefOfCandidate = (TableRef)pair.first;
                long cardinalityOfCandidate = ((PlanNode)pair.second).getCardinality();
                PlanNode rootPlanNodeOfCandidate = (PlanNode)pair.second;
                JoinOperator joinOp = tblRefOfCandidate.getJoinOp();
                Set requiredRefs = (Set)precedingRefs.get(tblRefOfCandidate);
                if (requiredRefs != null) {
                    Preconditions.checkState((joinOp.isOuterJoin() || joinOp.isSemiJoin() ? 1 : 0) != 0);
                    if (!requiredRefs.equals(joinedRefs)) break;
                }
                analyzer.setAssignedConjuncts(root.getAssignedConjuncts());
                PlanNode candidate = this.createJoinNode(analyzer, root, rootPlanNodeOfCandidate, tblRefOfCandidate);
                if (candidate == null) continue;
                ((PlanNode)candidate.getChildren().get(1)).setCompactData(true);
                if (LOG.isDebugEnabled()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("The " + tblRefOfCandidate.getUniqueAlias() + " is right child of join node.");
                    stringBuilder.append("The join cardinality is " + candidate.getCardinality() + ".");
                    stringBuilder.append("In round " + successfulSelectionTimes);
                    LOG.debug(stringBuilder.toString());
                }
                if (joinOp.isOuterJoin() || joinOp.isSemiJoin()) {
                    newRoot = candidate;
                    minEntry = pair;
                    break;
                }
                if (newRoot != null && (!candidate.getClass().equals(newRoot.getClass()) || !this.candidateCardinalityIsSmaller(candidate, ((PlanNode)pair.second).getCardinality(), newRoot, newRootRightChildCardinality)) && (!(candidate instanceof HashJoinNode) || !(newRoot instanceof CrossJoinNode))) continue;
                newRoot = candidate;
                minEntry = pair;
                newRootRightChildCardinality = cardinalityOfCandidate;
            }
            if (newRoot == null) {
                return null;
            }
            long lhsCardinality = root.getCardinality();
            long rhsCardinality = ((PlanNode)minEntry.second).getCardinality();
            numOps += lhsCardinality + rhsCardinality;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Round " + successfulSelectionTimes + " chose " + ((TableRef)minEntry.first).getUniqueAlias() + " #lhs=" + lhsCardinality + " #rhs=" + rhsCardinality + " #ops=" + numOps);
            }
            remainingRefs.remove(minEntry);
            joinedRefs.add((TableRef)minEntry.first);
            root = newRoot;
            analyzer.setAssignedConjuncts(root.getAssignedConjuncts());
            ++successfulSelectionTimes;
        }
        LOG.debug("The final join sequence is " + joinedRefs.stream().map(TableRef::getUniqueAlias).collect(Collectors.joining(",")));
        return root;
    }

    private PlanNode createSelectPlan(SelectStmt selectStmt, Analyzer analyzer, long defaultOrderByLimit) throws UserException, AnalysisException {
        if (selectStmt.getTableRefs().isEmpty()) {
            return this.createConstantSelectPlan(selectStmt, analyzer);
        }
        selectStmt.materializeRequiredSlots(analyzer);
        ArrayList rowTuples = Lists.newArrayList();
        for (TableRef tblRef : selectStmt.getTableRefs()) {
            rowTuples.addAll(tblRef.getMaterializedTupleIds());
        }
        if (analyzer.hasEmptySpjResultSet() && selectStmt.getAggInfo() != null) {
            EmptySetNode emptySetNode = new EmptySetNode(this.ctx.getNextNodeId(), rowTuples);
            ((PlanNode)emptySetNode).init(analyzer);
            emptySetNode.setOutputSmap(selectStmt.getBaseTblSmap());
            return this.createAggregationPlan(selectStmt, analyzer, emptySetNode);
        }
        PlanNode root = null;
        AggregateInfo aggInfo = selectStmt.getAggInfo();
        if (analyzer.safeIsEnableJoinReorderBasedCost()) {
            LOG.debug("Using new join reorder strategy when enable_join_reorder_based_cost is true");
            ArrayList refPlans = Lists.newArrayList();
            for (TableRef ref : selectStmt.getTableRefs()) {
                OlapScanNode olapNode;
                this.materializeTableResultForCrossJoinOrCountStar(ref, analyzer);
                PlanNode plan = this.createTableRefNode(analyzer, ref, selectStmt);
                this.turnOffPreAgg(aggInfo, selectStmt, analyzer, plan);
                if (plan instanceof OlapScanNode && !(olapNode = (OlapScanNode)plan).isPreAggregation()) {
                    olapNode.setCanTurnOnPreAggr(false);
                }
                Preconditions.checkState((plan != null ? 1 : 0) != 0);
                refPlans.add(new Pair<TableRef, PlanNode>(ref, plan));
            }
            for (Pair entry : refPlans) {
                ((PlanNode)entry.second).setAssignedConjuncts(analyzer.getAssignedConjuncts());
            }
            root = this.createCheapestJoinPlan(analyzer, refPlans);
            Preconditions.checkState((root != null ? 1 : 0) != 0);
        } else {
            OlapScanNode olapNode;
            TableRef tblRef = selectStmt.getTableRefs().get(0);
            this.materializeTableResultForCrossJoinOrCountStar(tblRef, analyzer);
            root = this.createTableRefNode(analyzer, tblRef, selectStmt);
            this.turnOffPreAgg(aggInfo, selectStmt, analyzer, root);
            if (root instanceof OlapScanNode && !(olapNode = (OlapScanNode)root).isPreAggregation()) {
                olapNode.setCanTurnOnPreAggr(false);
            }
            for (int i = 1; i < selectStmt.getTableRefs().size(); ++i) {
                TableRef innerRef = selectStmt.getTableRefs().get(i);
                root = this.createJoinNode(analyzer, root, innerRef, selectStmt);
                ((PlanNode)root.getChildren().get(1)).setCompactData(true);
                root.assignConjuncts(analyzer);
            }
        }
        if (selectStmt.getSortInfo() != null && selectStmt.getLimit() == -1L && defaultOrderByLimit == -1L) {
            throw new AnalysisException("ORDER BY without LIMIT currently not supported");
        }
        if (root != null && !selectStmt.hasOrderByClause()) {
            root = this.addUnassignedConjuncts(analyzer, root);
        }
        if (aggInfo != null) {
            GroupByClause groupByClause = selectStmt.getGroupByClause();
            if (groupByClause != null && groupByClause.isGroupByExtension()) {
                root = this.createRepeatNodePlan(selectStmt, analyzer, root);
            }
            root = this.createAggregationPlan(selectStmt, analyzer, root);
        }
        return root;
    }

    private PlanNode createRepeatNodePlan(SelectStmt selectStmt, Analyzer analyzer, PlanNode root) throws UserException {
        GroupByClause groupByClause = selectStmt.getGroupByClause();
        GroupingInfo groupingInfo = selectStmt.getGroupingInfo();
        Preconditions.checkState((groupByClause != null && groupByClause.isGroupByExtension() && groupingInfo != null ? 1 : 0) != 0);
        root = new RepeatNode(this.ctx.getNextNodeId(), root, groupingInfo, groupByClause);
        root.init(analyzer);
        return root;
    }

    public boolean selectMaterializedView(QueryStmt queryStmt, Analyzer analyzer) throws UserException {
        boolean selectFailed = false;
        if (queryStmt instanceof SelectStmt) {
            SelectStmt selectStmt = (SelectStmt)queryStmt;
            for (TableRef tableRef : selectStmt.getTableRefs()) {
                if (!(tableRef instanceof InlineViewRef)) continue;
                selectFailed |= this.selectMaterializedView(((InlineViewRef)tableRef).getViewStmt(), ((InlineViewRef)tableRef).getAnalyzer());
            }
            List<ScanNode> scanNodeList = this.selectStmtToScanNodes.get(selectStmt.getAnalyzer());
            if (scanNodeList == null) {
                return selectFailed;
            }
            MaterializedViewSelector materializedViewSelector = new MaterializedViewSelector(selectStmt, analyzer);
            for (ScanNode scanNode : scanNodeList) {
                OlapScanNode olapScanNode;
                if (!(scanNode instanceof OlapScanNode) || (olapScanNode = (OlapScanNode)scanNode).getSelectedPartitionIds().size() == 0 && !FeConstants.runningUnitTest) continue;
                olapScanNode.selectBestRollupByRollupSelector(analyzer);
                MaterializedViewSelector.BestIndexInfo bestIndexInfo = materializedViewSelector.selectBestMV(olapScanNode);
                if (bestIndexInfo == null) {
                    selectFailed |= true;
                    TupleId tupleId = olapScanNode.getTupleId();
                    selectStmt.updateDisableTuplesMVRewriter(tupleId);
                    LOG.debug("MV rewriter of tuple [] will be disable", (Object)tupleId);
                    continue;
                }
                olapScanNode.updateScanRangeInfoByNewMVSelector(bestIndexInfo.getBestIndexId(), bestIndexInfo.isPreAggregation(), bestIndexInfo.getReasonOfDisable());
                if (selectStmt.getAggInfo() == null) continue;
                selectStmt.getAggInfo().updateTypeOfAggregateExprs();
            }
        } else {
            Preconditions.checkState((boolean)(queryStmt instanceof SetOperationStmt));
            SetOperationStmt unionStmt = (SetOperationStmt)queryStmt;
            for (SetOperationStmt.SetOperand unionOperand : unionStmt.getOperands()) {
                selectFailed |= this.selectMaterializedView(unionOperand.getQueryStmt(), analyzer);
            }
        }
        return selectFailed;
    }

    private PlanNode createAggregationPlan(SelectStmt selectStmt, Analyzer analyzer, PlanNode root) throws UserException {
        Preconditions.checkState((selectStmt.getAggInfo() != null ? 1 : 0) != 0);
        AggregateInfo aggInfo = selectStmt.getAggInfo();
        AggregationNode newRoot = new AggregationNode(this.ctx.getNextNodeId(), root, aggInfo);
        ((PlanNode)newRoot).init(analyzer);
        Preconditions.checkState((boolean)newRoot.hasValidStats());
        if (aggInfo.isDistinctAgg()) {
            newRoot.unsetNeedsFinalize();
            newRoot.setIntermediateTuple();
            newRoot = new AggregationNode(this.ctx.getNextNodeId(), (PlanNode)newRoot, aggInfo.getSecondPhaseDistinctAggInfo());
            ((PlanNode)newRoot).init(analyzer);
            Preconditions.checkState((boolean)newRoot.hasValidStats());
        }
        newRoot.assignConjuncts(analyzer);
        return newRoot;
    }

    private PlanNode createConstantSelectPlan(SelectStmt selectStmt, Analyzer analyzer) throws UserException {
        Preconditions.checkState((boolean)selectStmt.getTableRefs().isEmpty());
        List resultExprs = selectStmt.getResultExprs();
        TupleDescriptor tupleDesc = this.createResultTupleDescriptor(selectStmt, "union", analyzer);
        UnionNode unionNode = new UnionNode(this.ctx.getNextNodeId(), tupleDesc.getId());
        if (selectStmt.getValueList() != null) {
            for (ArrayList<Expr> row : selectStmt.getValueList().getRows()) {
                unionNode.addConstExprList(row);
            }
        } else {
            unionNode.addConstExprList(Lists.newArrayList((Iterable)resultExprs));
        }
        for (int i = 0; i < ((ArrayList)resultExprs).size(); ++i) {
            SlotRef slotRef = new SlotRef(tupleDesc.getSlots().get(i));
            ((ArrayList)resultExprs).set(i, slotRef);
            selectStmt.getBaseTblResultExprs().set(i, slotRef);
        }
        unionNode.init(analyzer);
        return unionNode;
    }

    private TupleDescriptor createResultTupleDescriptor(SelectStmt selectStmt, String debugName, Analyzer analyzer) {
        TupleDescriptor tupleDesc = analyzer.getDescTbl().createTupleDescriptor(debugName);
        tupleDesc.setIsMaterialized(true);
        List resultExprs = selectStmt.getResultExprs();
        List colLabels = selectStmt.getColLabels();
        for (int i = 0; i < resultExprs.size(); ++i) {
            Expr resultExpr = (Expr)resultExprs.get(i);
            String colLabel = (String)colLabels.get(i);
            SlotDescriptor slotDesc = analyzer.addSlotDescriptor(tupleDesc);
            slotDesc.setLabel(colLabel);
            slotDesc.setSourceExpr(resultExpr);
            slotDesc.setType(resultExpr.getType());
            slotDesc.setIsMaterialized(true);
        }
        tupleDesc.computeStatAndMemLayout();
        return tupleDesc;
    }

    public static PartitionColumnFilter createPartitionFilter(SlotDescriptor desc, List<Expr> conjuncts) {
        PartitionColumnFilter partitionColumnFilter = null;
        for (Expr expr : conjuncts) {
            IsNullPredicate isNullPredicate;
            if (!expr.isBound(desc.getId())) continue;
            if (expr instanceof BinaryPredicate) {
                BinaryPredicate binPredicate = (BinaryPredicate)expr;
                Expr slotBinding = binPredicate.getSlotBinding(desc.getId());
                if (slotBinding == null || !slotBinding.isConstant() || binPredicate.getOp() == BinaryPredicate.Operator.NE || !(slotBinding instanceof LiteralExpr)) continue;
                if (null == partitionColumnFilter) {
                    partitionColumnFilter = new PartitionColumnFilter();
                }
                LiteralExpr literal = (LiteralExpr)slotBinding;
                BinaryPredicate.Operator op = binPredicate.getOp();
                if (!binPredicate.slotIsLeft()) {
                    op = op.commutative();
                }
                switch (op) {
                    case EQ: {
                        partitionColumnFilter.setLowerBound(literal, true);
                        partitionColumnFilter.setUpperBound(literal, true);
                        break;
                    }
                    case LE: {
                        partitionColumnFilter.setUpperBound(literal, true);
                        if (null != partitionColumnFilter.lowerBound) break;
                        partitionColumnFilter.lowerBoundInclusive = true;
                        break;
                    }
                    case LT: {
                        partitionColumnFilter.setUpperBound(literal, false);
                        if (null != partitionColumnFilter.lowerBound) break;
                        partitionColumnFilter.lowerBoundInclusive = true;
                        break;
                    }
                    case GE: {
                        partitionColumnFilter.setLowerBound(literal, true);
                        break;
                    }
                    case GT: {
                        partitionColumnFilter.setLowerBound(literal, false);
                        break;
                    }
                }
                continue;
            }
            if (expr instanceof InPredicate) {
                InPredicate inPredicate = (InPredicate)expr;
                if (!inPredicate.isLiteralChildren() || inPredicate.isNotIn() || !(((Expr)inPredicate.getChild(0)).unwrapExpr(false) instanceof SlotRef)) continue;
                if (null == partitionColumnFilter) {
                    partitionColumnFilter = new PartitionColumnFilter();
                }
                partitionColumnFilter.setInPredicate(inPredicate);
                continue;
            }
            if (!(expr instanceof IsNullPredicate) || !(isNullPredicate = (IsNullPredicate)expr).isSlotRefChildren() || isNullPredicate.isNotNull()) continue;
            partitionColumnFilter = new PartitionColumnFilter();
            NullLiteral nullLiteral = new NullLiteral();
            partitionColumnFilter.setLowerBound(nullLiteral, true);
            partitionColumnFilter.setUpperBound(nullLiteral, true);
            break;
        }
        LOG.debug("partitionColumnFilter: {}", partitionColumnFilter);
        return partitionColumnFilter;
    }

    private PlanNode createInlineViewPlan(Analyzer analyzer, InlineViewRef inlineViewRef) throws UserException, AnalysisException {
        SelectStmt selectStmt;
        this.migrateConjunctsToInlineView(analyzer, inlineViewRef);
        QueryStmt viewStmt = inlineViewRef.getViewStmt();
        if (viewStmt instanceof SelectStmt && (selectStmt = (SelectStmt)viewStmt).getTableRefs().isEmpty()) {
            if (inlineViewRef.getAnalyzer().hasEmptyResultSet()) {
                PlanNode emptySetNode = this.createEmptyNode(null, viewStmt, inlineViewRef.getAnalyzer());
                Preconditions.checkState((!analyzer.isOuterJoined(inlineViewRef.getId()) ? 1 : 0) != 0);
                emptySetNode.setOutputSmap(inlineViewRef.getSmap());
                return emptySetNode;
            }
            Preconditions.checkState((inlineViewRef.getMaterializedTupleIds().size() == 1 ? 1 : 0) != 0);
            analyzer.getTupleDesc(inlineViewRef.getId()).materializeSlots();
            UnionNode unionNode = new UnionNode(this.ctx.getNextNodeId(), inlineViewRef.getMaterializedTupleIds().get(0));
            if (analyzer.hasEmptyResultSet()) {
                return unionNode;
            }
            unionNode.setTblRefIds(Lists.newArrayList((Object[])new TupleId[]{inlineViewRef.getId()}));
            unionNode.addConstExprList(selectStmt.getBaseTblResultExprs());
            unionNode.init(analyzer);
            if (analyzer.isOuterJoined(inlineViewRef.getId()) && !VectorizedUtil.isVectorized()) {
                unionNode.setWithoutTupleIsNullOutputSmap(inlineViewRef.getSmap());
                List<Expr> nullableRhs = TupleIsNullPredicate.wrapExprs(inlineViewRef.getSmap().getRhs(), unionNode.getTupleIds(), analyzer);
                unionNode.setOutputSmap(new ExprSubstitutionMap(inlineViewRef.getSmap().getLhs(), nullableRhs));
            }
            return unionNode;
        }
        PlanNode rootNode = this.createQueryPlan(inlineViewRef.getViewStmt(), inlineViewRef.getAnalyzer(), -1L);
        rootNode.setTblRefIds(Lists.newArrayList((Object[])new TupleId[]{inlineViewRef.getId()}));
        ExprSubstitutionMap outputSmap = ExprSubstitutionMap.compose(inlineViewRef.getSmap(), rootNode.getOutputSmap(), analyzer);
        if (analyzer.isOuterJoined(inlineViewRef.getId()) && !VectorizedUtil.isVectorized()) {
            rootNode.setWithoutTupleIsNullOutputSmap(outputSmap);
            List<Expr> nullableRhs = TupleIsNullPredicate.wrapExprs(outputSmap.getRhs(), rootNode.getTupleIds(), analyzer);
            outputSmap = new ExprSubstitutionMap(outputSmap.getLhs(), nullableRhs);
        }
        rootNode.setOutputSmap(outputSmap);
        if (!this.canMigrateConjuncts(inlineViewRef)) {
            rootNode = this.addUnassignedConjuncts(analyzer, inlineViewRef.getDesc().getId().asList(), rootNode);
        }
        return rootNode;
    }

    public void migrateConjunctsToInlineView(Analyzer analyzer, InlineViewRef inlineViewRef) throws AnalysisException {
        List<Expr> unassignedConjuncts = analyzer.getUnassignedConjuncts(inlineViewRef.getId().asList(), true);
        ArrayList unassignedConstantConjuncts = Lists.newArrayList();
        for (Expr e : unassignedConjuncts) {
            if (!e.isConstant()) continue;
            unassignedConstantConjuncts.add(e);
        }
        unassignedConjuncts.removeAll(unassignedConstantConjuncts);
        this.migrateNonconstantConjuncts(inlineViewRef, unassignedConjuncts, analyzer);
        this.migrateConstantConjuncts(inlineViewRef, unassignedConstantConjuncts);
    }

    private void migrateNonconstantConjuncts(InlineViewRef inlineViewRef, List<Expr> unassignedConjuncts, Analyzer analyzer) throws AnalysisException {
        ArrayList preds = Lists.newArrayList();
        for (Expr e : unassignedConjuncts) {
            if (!analyzer.canEvalPredicate(inlineViewRef.getId().asList(), e)) continue;
            preds.add(e);
        }
        ArrayList pushDownFailedPredicates = Lists.newArrayList();
        List<Expr> viewPredicates = this.getPushDownPredicatesForInlineView(inlineViewRef, preds, analyzer, pushDownFailedPredicates);
        if (viewPredicates.size() <= 0) {
            ArrayList<Expr> substUnassigned = Expr.substituteList(unassignedConjuncts, inlineViewRef.getBaseTblSmap(), analyzer, false);
            analyzer.materializeSlots(substUnassigned);
            return;
        }
        preds.removeAll(pushDownFailedPredicates);
        unassignedConjuncts.remove(preds);
        unassignedConjuncts.addAll(pushDownFailedPredicates);
        com.google.common.base.Predicate<Expr> isIdentityPredicate = new com.google.common.base.Predicate<Expr>(){

            public boolean apply(Expr expr) {
                return Predicate.isEquivalencePredicate(expr) && ((BinaryPredicate)expr).isInferred() && ((Expr)expr.getChild(0)).equals(expr.getChild(1));
            }
        };
        Iterables.removeIf(viewPredicates, (com.google.common.base.Predicate)isIdentityPredicate);
        analyzer.markConjunctsAssigned(preds);
        for (Expr e : viewPredicates) {
            e.setIsOnClauseConjunct(false);
        }
        inlineViewRef.getAnalyzer().registerConjuncts(viewPredicates, inlineViewRef.getAllTupleIds());
        ArrayList<Expr> substUnassigned = Expr.substituteList(unassignedConjuncts, inlineViewRef.getBaseTblSmap(), analyzer, false);
        analyzer.materializeSlots(substUnassigned);
    }

    private void migrateConstantConjuncts(InlineViewRef inlineViewRef, List<Expr> conjuncts) throws AnalysisException {
        if (conjuncts.isEmpty()) {
            return;
        }
        if (!this.canMigrateConjuncts(inlineViewRef)) {
            return;
        }
        List<Expr> newConjuncts = this.cloneExprs(conjuncts);
        QueryStmt stmt = inlineViewRef.getViewStmt();
        Analyzer viewAnalyzer = inlineViewRef.getAnalyzer();
        viewAnalyzer.markConjunctsAssigned(conjuncts);
        if (stmt instanceof SelectStmt) {
            SelectStmt select = (SelectStmt)stmt;
            if (select.getAggInfo() != null) {
                viewAnalyzer.registerConjuncts(newConjuncts, select.getAggInfo().getOutputTupleId().asList());
            } else if (select.getTableRefs().size() > 1) {
                for (int i = select.getTableRefs().size(); i > 1; --i) {
                    TableRef joinInnerChild = select.getTableRefs().get(i - 1);
                    if (!joinInnerChild.getJoinOp().isOuterJoin()) {
                        if (i != 2) continue;
                        viewAnalyzer.registerConjuncts(newConjuncts, joinInnerChild.getDesc().getId().asList());
                        TableRef joinOuterChild = select.getTableRefs().get(0);
                        List<Expr> cloneConjuncts = this.cloneExprs(newConjuncts);
                        viewAnalyzer.registerConjuncts(cloneConjuncts, joinOuterChild.getDesc().getId().asList());
                        continue;
                    }
                    viewAnalyzer.registerOnClauseConjuncts(newConjuncts, joinInnerChild);
                    break;
                }
            } else {
                Preconditions.checkArgument((select.getTableRefs().size() == 1 ? 1 : 0) != 0);
                viewAnalyzer.registerConjuncts(newConjuncts, select.getTableRefs().get(0).getDesc().getId().asList());
            }
        } else {
            Preconditions.checkArgument((boolean)(stmt instanceof SetOperationStmt));
            SetOperationStmt union = (SetOperationStmt)stmt;
            viewAnalyzer.registerConjuncts(newConjuncts, union.getTupleId().asList());
        }
    }

    private List<Expr> cloneExprs(List<Expr> candidates) {
        ArrayList clones = Lists.newArrayList();
        candidates.forEach(expr -> clones.add(expr.clone()));
        return clones;
    }

    private List<Expr> getPushDownPredicatesForInlineView(InlineViewRef inlineViewRef, List<Expr> viewPredicates, Analyzer analyzer, List<Expr> pushDownFailedPredicates) {
        ArrayList pushDownPredicates = Lists.newArrayList();
        if (inlineViewRef.getViewStmt().evaluateOrderBy() || inlineViewRef.getViewStmt().hasLimit() || inlineViewRef.getViewStmt().hasOffset()) {
            return pushDownPredicates;
        }
        ArrayList<Expr> candicatePredicates = Expr.substituteList(viewPredicates, inlineViewRef.getSmap(), analyzer, false);
        if (inlineViewRef.getViewStmt() instanceof SetOperationStmt) {
            SetOperationStmt setOperationStmt = (SetOperationStmt)inlineViewRef.getViewStmt();
            for (int i = 0; i < candicatePredicates.size(); ++i) {
                Expr predicate = (Expr)candicatePredicates.get(i);
                if (predicate.isBound(setOperationStmt.getTupleId())) {
                    pushDownPredicates.add(predicate);
                    continue;
                }
                pushDownFailedPredicates.add(viewPredicates.get(i));
            }
            return pushDownPredicates;
        }
        SelectStmt selectStmt = (SelectStmt)inlineViewRef.getViewStmt();
        if (selectStmt.hasAnalyticInfo()) {
            pushDownPredicates.addAll(this.getWindowsPushDownPredicates(candicatePredicates, viewPredicates, selectStmt.getAnalyticInfo(), pushDownFailedPredicates));
        } else {
            pushDownPredicates.addAll(candicatePredicates);
        }
        return pushDownPredicates;
    }

    private List<Expr> getWindowsPushDownPredicates(List<Expr> predicates, List<Expr> viewPredicates, AnalyticInfo analyticInfo, List<Expr> pushDownFailedPredicates) {
        ArrayList pushDownPredicates = Lists.newArrayList();
        List<Expr> partitionExprs = analyticInfo.getCommonPartitionExprs();
        ArrayList partitionByIds = Lists.newArrayList();
        for (Expr expr : partitionExprs) {
            if (!(expr instanceof SlotRef)) continue;
            SlotRef slotRef = (SlotRef)expr;
            partitionByIds.add(slotRef.getSlotId());
        }
        if (partitionByIds.size() <= 0) {
            return pushDownPredicates;
        }
        for (int i = 0; i < predicates.size(); ++i) {
            Expr predicate = predicates.get(i);
            if (predicate.isBound(partitionByIds)) {
                pushDownPredicates.add(predicate);
                continue;
            }
            pushDownFailedPredicates.add(viewPredicates.get(i));
        }
        return pushDownPredicates;
    }

    private boolean canMigrateConjuncts(InlineViewRef inlineViewRef) {
        return inlineViewRef.getViewStmt().evaluateOrderBy() ? false : !inlineViewRef.getViewStmt().hasLimit() && !inlineViewRef.getViewStmt().hasOffset() && (!(inlineViewRef.getViewStmt() instanceof SelectStmt) || !((SelectStmt)inlineViewRef.getViewStmt()).hasAnalyticInfo());
    }

    private PlanNode createScanNode(Analyzer analyzer, TableRef tblRef, SelectStmt selectStmt) throws UserException {
        ScanNode scanNode = null;
        switch (tblRef.getTable().getType()) {
            case OLAP: {
                OlapScanNode olapNode = new OlapScanNode(this.ctx.getNextNodeId(), tblRef.getDesc(), "OlapScanNode");
                olapNode.setForceOpenPreAgg(tblRef.isForcePreAggOpened());
                scanNode = olapNode;
                break;
            }
            case ODBC: {
                scanNode = new OdbcScanNode(this.ctx.getNextNodeId(), tblRef.getDesc(), (OdbcTable)tblRef.getTable());
                break;
            }
            case MYSQL: {
                scanNode = new MysqlScanNode(this.ctx.getNextNodeId(), tblRef.getDesc(), (MysqlTable)tblRef.getTable());
                break;
            }
            case SCHEMA: {
                scanNode = new SchemaScanNode(this.ctx.getNextNodeId(), tblRef.getDesc());
                break;
            }
            case BROKER: {
                scanNode = new BrokerScanNode(this.ctx.getNextNodeId(), tblRef.getDesc(), "BrokerScanNode", null, -1);
                break;
            }
            case ELASTICSEARCH: {
                scanNode = new EsScanNode(this.ctx.getNextNodeId(), tblRef.getDesc(), "EsScanNode");
                break;
            }
            case HIVE: {
                scanNode = new HiveScanNode(this.ctx.getNextNodeId(), tblRef.getDesc(), "HiveScanNode", null, -1);
                break;
            }
            case ICEBERG: {
                scanNode = new IcebergScanNode(this.ctx.getNextNodeId(), tblRef.getDesc(), "IcebergScanNode", null, -1);
                break;
            }
        }
        if (scanNode instanceof OlapScanNode || scanNode instanceof EsScanNode || scanNode instanceof HiveScanNode) {
            if (analyzer.enableInferPredicate()) {
                PredicatePushDown.visitScanNode(scanNode, tblRef.getJoinOp(), analyzer);
            }
            scanNode.setSortColumn(tblRef.getSortColumn());
        }
        this.scanNodes.add(scanNode);
        List scanNodeList = this.selectStmtToScanNodes.computeIfAbsent(selectStmt.getAnalyzer(), k -> Lists.newArrayList());
        scanNodeList.add(scanNode);
        scanNode.init(analyzer);
        return scanNode;
    }

    private void getHashLookupJoinConjuncts(Analyzer analyzer, PlanNode left, PlanNode right, List<Expr> joinConjuncts, Reference<String> errMsg, JoinOperator op) {
        joinConjuncts.clear();
        ArrayList<TupleId> lhsIds = left.getTblRefIds();
        ArrayList<TupleId> rhsIds = right.getTblRefIds();
        List<Expr> candidates = analyzer.getEqJoinConjuncts(lhsIds, rhsIds);
        if (candidates == null) {
            if (op.isOuterJoin() || op.isSemiAntiJoin()) {
                errMsg.setRef("non-equal " + op.toString() + " is not supported");
                LOG.warn(errMsg);
            }
            LOG.debug("no candidates for join.");
            return;
        }
        for (Expr e : candidates) {
            if (((Expr)e.getChild(0)).isConstant() || ((Expr)e.getChild(1)).isConstant()) {
                LOG.debug("double is constant.");
                continue;
            }
            Expr rhsExpr = null;
            if (((Expr)e.getChild(0)).isBoundByTupleIds(rhsIds)) {
                rhsExpr = (Expr)e.getChild(0);
            } else {
                Preconditions.checkState((boolean)((Expr)e.getChild(1)).isBoundByTupleIds(rhsIds));
                rhsExpr = (Expr)e.getChild(1);
            }
            Expr lhsExpr = null;
            if (((Expr)e.getChild(1)).isBoundByTupleIds(lhsIds)) {
                lhsExpr = (Expr)e.getChild(1);
            } else if (((Expr)e.getChild(0)).isBoundByTupleIds(lhsIds)) {
                lhsExpr = (Expr)e.getChild(0);
            } else {
                LOG.debug("not an equi-join condition between lhsIds and rhsId");
                continue;
            }
            Preconditions.checkState((lhsExpr != rhsExpr ? 1 : 0) != 0);
            Preconditions.checkState((boolean)(e instanceof BinaryPredicate));
            BinaryPredicate newEqJoinPredicate = (BinaryPredicate)e.clone();
            newEqJoinPredicate.setChild(0, lhsExpr);
            newEqJoinPredicate.setChild(1, rhsExpr);
            joinConjuncts.add(newEqJoinPredicate);
        }
    }

    private PlanNode createJoinNodeBase(Analyzer analyzer, PlanNode outer, PlanNode inner, TableRef innerRef) throws UserException {
        this.materializeTableResultForCrossJoinOrCountStar(innerRef, analyzer);
        ArrayList eqJoinConjuncts = Lists.newArrayList();
        Reference<String> errMsg = new Reference<String>();
        this.getHashLookupJoinConjuncts(analyzer, outer, inner, eqJoinConjuncts, errMsg, innerRef.getJoinOp());
        if (eqJoinConjuncts.isEmpty()) {
            if (innerRef.getJoinOp().isOuterJoin() || innerRef.getJoinOp().isSemiAntiJoin()) {
                throw new AnalysisException("non-equal " + innerRef.getJoinOp().toString() + " is not supported");
            }
            CrossJoinNode result = new CrossJoinNode(this.ctx.getNextNodeId(), outer, inner, innerRef);
            result.init(analyzer);
            return result;
        }
        analyzer.markConjunctsAssigned(eqJoinConjuncts);
        List<Object> ojConjuncts = Lists.newArrayList();
        if (innerRef.getJoinOp().isOuterJoin()) {
            ojConjuncts = analyzer.getUnassignedOjConjuncts(innerRef);
            analyzer.markConjunctsAssigned(ojConjuncts);
        } else if (innerRef.getJoinOp().isSemiAntiJoin()) {
            List<TupleId> tupleIds = innerRef.getAllTupleIds();
            ojConjuncts = analyzer.getUnassignedConjuncts(tupleIds, false);
            analyzer.markConjunctsAssigned(ojConjuncts);
        }
        HashJoinNode result = new HashJoinNode(this.ctx.getNextNodeId(), outer, inner, innerRef, eqJoinConjuncts, ojConjuncts);
        result.init(analyzer);
        return result;
    }

    public PlanNode createJoinNode(Analyzer analyzer, PlanNode outer, PlanNode inner, TableRef innerRef) throws UserException {
        return this.createJoinNodeBase(analyzer, outer, inner, innerRef);
    }

    private PlanNode createJoinNode(Analyzer analyzer, PlanNode outer, TableRef innerRef, SelectStmt selectStmt) throws UserException {
        PlanNode inner = this.createTableRefNode(analyzer, innerRef, selectStmt);
        return this.createJoinNodeBase(analyzer, outer, inner, innerRef);
    }

    private PlanNode createTableRefNode(Analyzer analyzer, TableRef tblRef, SelectStmt selectStmt) throws UserException {
        PlanNode scanNode = null;
        if (tblRef instanceof BaseTableRef) {
            scanNode = this.createScanNode(analyzer, tblRef, selectStmt);
        }
        if (tblRef instanceof InlineViewRef) {
            scanNode = this.createInlineViewPlan(analyzer, (InlineViewRef)tblRef);
        }
        if (scanNode == null) {
            throw new UserException("unknown TableRef node");
        }
        ArrayList<LateralViewRef> lateralViewRefs = tblRef.getLateralViewRefs();
        if (lateralViewRefs == null || lateralViewRefs.size() == 0) {
            return scanNode;
        }
        return this.createTableFunctionNode(analyzer, scanNode, lateralViewRefs, selectStmt);
    }

    private PlanNode createTableFunctionNode(Analyzer analyzer, PlanNode inputNode, List<LateralViewRef> lateralViewRefs, SelectStmt selectStmt) throws UserException {
        Preconditions.checkNotNull(lateralViewRefs);
        Preconditions.checkState((lateralViewRefs.size() > 0 ? 1 : 0) != 0);
        TableFunctionNode tableFunctionNode = new TableFunctionNode(this.ctx.getNextNodeId(), inputNode, lateralViewRefs);
        tableFunctionNode.init(analyzer);
        tableFunctionNode.projectSlots(analyzer, selectStmt);
        inputNode = tableFunctionNode;
        return inputNode;
    }

    private SetOperationNode createSetOperationPlan(Analyzer analyzer, SetOperationStmt setOperationStmt, List<SetOperationStmt.SetOperand> setOperands, PlanNode result, long defaultOrderByLimit) throws UserException, AnalysisException {
        SetOperationNode setOpNode;
        Enum operation = null;
        for (SetOperationStmt.SetOperand setOperand : setOperands) {
            if (setOperand.getOperation() == null) continue;
            if (operation == null) {
                operation = setOperand.getOperation();
            }
            Preconditions.checkState((operation == setOperand.getOperation() ? 1 : 0) != 0, (Object)"can not support mixed set operations at here");
        }
        switch (3.$SwitchMap$org$apache$doris$analysis$SetOperationStmt$Operation[operation.ordinal()]) {
            case 1: {
                setOpNode = new UnionNode(this.ctx.getNextNodeId(), setOperationStmt.getTupleId(), setOperationStmt.getSetOpsResultExprs(), false);
                break;
            }
            case 2: {
                setOpNode = new IntersectNode(this.ctx.getNextNodeId(), setOperationStmt.getTupleId(), setOperationStmt.getSetOpsResultExprs(), false);
                break;
            }
            case 3: {
                setOpNode = new ExceptNode(this.ctx.getNextNodeId(), setOperationStmt.getTupleId(), setOperationStmt.getSetOpsResultExprs(), false);
                break;
            }
            default: {
                throw new AnalysisException("not supported set operations: " + operation);
            }
        }
        if (result != null && result instanceof SetOperationNode) {
            Preconditions.checkState((!result.getClass().equals(setOpNode.getClass()) ? 1 : 0) != 0);
            setOpNode.addChild(result, setOperationStmt.getResultExprs());
        } else if (result != null) {
            Preconditions.checkState((boolean)setOperationStmt.hasDistinctOps());
            Preconditions.checkState((boolean)(result instanceof AggregationNode));
            setOpNode.addChild(result, setOperationStmt.getDistinctAggInfo().getGroupingExprs());
        }
        for (SetOperationStmt.SetOperand op : setOperands) {
            SelectStmt selectStmt;
            if (op.getAnalyzer().hasEmptyResultSet()) {
                this.unmarkCollectionSlots(op.getQueryStmt());
                continue;
            }
            QueryStmt queryStmt = op.getQueryStmt();
            if (queryStmt instanceof SelectStmt && (selectStmt = (SelectStmt)queryStmt).getTableRefs().isEmpty() && setOpNode instanceof UnionNode) {
                setOpNode.addConstExprList(selectStmt.getResultExprs());
                continue;
            }
            PlanNode opPlan = this.createQueryPlan(queryStmt, op.getAnalyzer(), defaultOrderByLimit);
            if ((opPlan = this.addUnassignedConjuncts(analyzer, opPlan.getTupleIds(), opPlan)) instanceof EmptySetNode) continue;
            setOpNode.addChild(opPlan, op.getQueryStmt().getResultExprs());
        }
        setOpNode.init(analyzer);
        return setOpNode;
    }

    private PlanNode createSetOperationPlan(SetOperationStmt setOperationStmt, Analyzer analyzer, long defaultOrderByLimit) throws UserException, AnalysisException {
        List<Expr> conjuncts = analyzer.getUnassignedConjuncts(setOperationStmt.getTupleId().asList());
        boolean hasConstantOp = false;
        if (!setOperationStmt.hasAnalyticExprs()) {
            for (SetOperationStmt.SetOperand op : setOperationStmt.getOperands()) {
                SelectStmt selectStmt;
                ArrayList<Expr> opConjuncts = Expr.substituteList(conjuncts, op.getSmap(), analyzer, false);
                boolean selectHasTableRef = true;
                QueryStmt queryStmt = op.getQueryStmt();
                if (queryStmt instanceof SelectStmt && (selectStmt = (SelectStmt)queryStmt).getTableRefs().isEmpty()) {
                    selectHasTableRef = false;
                    boolean bl = hasConstantOp = !selectHasTableRef;
                }
                if (queryStmt instanceof SelectStmt && selectHasTableRef) {
                    SelectStmt select = (SelectStmt)queryStmt;
                    op.getAnalyzer().registerConjuncts(opConjuncts, select.getTableRefIds());
                    continue;
                }
                if (queryStmt instanceof SetOperationStmt) {
                    SetOperationStmt subSetOp = (SetOperationStmt)queryStmt;
                    op.getAnalyzer().registerConjuncts(opConjuncts, subSetOp.getTupleId().asList());
                    continue;
                }
                if (!selectHasTableRef) continue;
                Preconditions.checkArgument((boolean)false);
            }
            if (!hasConstantOp) {
                analyzer.markConjunctsAssigned(conjuncts);
            }
        } else {
            analyzer.materializeSlots(conjuncts);
        }
        setOperationStmt.materializeRequiredSlots(analyzer);
        PlanNode result = null;
        SetOperationStmt.Operation operation = null;
        ArrayList<SetOperationStmt.SetOperand> partialOperands = new ArrayList<SetOperationStmt.SetOperand>();
        for (SetOperationStmt.SetOperand op : setOperationStmt.getOperands()) {
            if (op.getOperation() == null) {
                partialOperands.add(op);
                continue;
            }
            if (operation == null && op.getOperation() != null) {
                operation = op.getOperation();
                partialOperands.add(op);
                continue;
            }
            if (operation != null && op.getOperation() == operation) {
                partialOperands.add(op);
                continue;
            }
            if (operation != null && op.getOperation() != operation) {
                if (partialOperands.size() > 0) {
                    result = operation == SetOperationStmt.Operation.INTERSECT || operation == SetOperationStmt.Operation.EXCEPT ? this.createSetOperationPlan(analyzer, setOperationStmt, partialOperands, result, defaultOrderByLimit) : this.createUnionPartialSetOperationPlan(analyzer, setOperationStmt, partialOperands, result, defaultOrderByLimit);
                    partialOperands.clear();
                }
                operation = op.getOperation();
                partialOperands.add(op);
                continue;
            }
            throw new AnalysisException("invalid set operation statement.");
        }
        if (partialOperands.size() > 0) {
            result = operation == SetOperationStmt.Operation.INTERSECT || operation == SetOperationStmt.Operation.EXCEPT ? this.createSetOperationPlan(analyzer, setOperationStmt, partialOperands, result, defaultOrderByLimit) : this.createUnionPartialSetOperationPlan(analyzer, setOperationStmt, partialOperands, result, defaultOrderByLimit);
        }
        if (setOperationStmt.hasAnalyticExprs() || hasConstantOp) {
            result = this.addUnassignedConjuncts(analyzer, setOperationStmt.getTupleId().asList(), result);
        }
        return result;
    }

    private PlanNode createUnionPartialSetOperationPlan(Analyzer analyzer, SetOperationStmt setOperationStmt, List<SetOperationStmt.SetOperand> setOperands, PlanNode result, long defaultOrderByLimit) throws UserException {
        boolean hasDistinctOps = false;
        boolean hasAllOps = false;
        ArrayList<SetOperationStmt.SetOperand> allOps = new ArrayList<SetOperationStmt.SetOperand>();
        ArrayList<SetOperationStmt.SetOperand> distinctOps = new ArrayList<SetOperationStmt.SetOperand>();
        for (SetOperationStmt.SetOperand op : setOperands) {
            if (op.getQualifier() == SetOperationStmt.Qualifier.DISTINCT) {
                hasDistinctOps = true;
                distinctOps.add(op);
            }
            if (op.getQualifier() != SetOperationStmt.Qualifier.ALL) continue;
            hasAllOps = true;
            allOps.add(op);
        }
        if (hasDistinctOps) {
            result = this.createSetOperationPlan(analyzer, setOperationStmt, distinctOps, result, defaultOrderByLimit);
            result = new AggregationNode(this.ctx.getNextNodeId(), result, setOperationStmt.getDistinctAggInfo());
            result.init(analyzer);
        }
        if (hasAllOps) {
            result = this.createSetOperationPlan(analyzer, setOperationStmt, allOps, result, defaultOrderByLimit);
        }
        return result;
    }

    private PlanNode createAssertRowCountNode(PlanNode input, AssertNumRowsElement assertNumRowsElement, Analyzer analyzer) throws UserException {
        AssertNumRowsNode root = new AssertNumRowsNode(this.ctx.getNextNodeId(), input, assertNumRowsElement);
        root.init(analyzer);
        return root;
    }

    private void materializeTableResultForCrossJoinOrCountStar(TableRef tblRef, Analyzer analyzer) {
        if (tblRef instanceof BaseTableRef) {
            this.materializeSlotForEmptyMaterializedTableRef((BaseTableRef)tblRef, analyzer);
        } else if (tblRef instanceof InlineViewRef) {
            this.materializeInlineViewResultExprForCrossJoinOrCountStar((InlineViewRef)tblRef, analyzer);
        } else {
            Preconditions.checkArgument((boolean)false);
        }
    }

    private void materializeSlotForEmptyMaterializedTableRef(BaseTableRef tblRef, Analyzer analyzer) {
        if (tblRef.getDesc().getMaterializedSlots().isEmpty()) {
            Column minimuColumn = null;
            for (Column col : tblRef.getTable().getBaseSchema()) {
                if (minimuColumn != null && col.getDataType().getSlotSize() >= minimuColumn.getDataType().getSlotSize()) continue;
                minimuColumn = col;
            }
            if (minimuColumn != null) {
                SlotDescriptor slot = tblRef.getDesc().getColumnSlot(minimuColumn.getName());
                if (slot != null) {
                    slot.setIsMaterialized(true);
                } else {
                    slot = analyzer.getDescTbl().addSlotDescriptor(tblRef.getDesc());
                    slot.setColumn(minimuColumn);
                    slot.setIsMaterialized(true);
                    slot.setIsNullable(minimuColumn.isAllowNull());
                }
            }
        }
    }

    private void materializeInlineViewResultExprForCrossJoinOrCountStar(InlineViewRef inlineView, Analyzer analyzer) {
        ArrayList<Expr> baseResultExprs = inlineView.getViewStmt().getBaseTblResultExprs();
        if (baseResultExprs.size() <= 0) {
            return;
        }
        Expr resultExprSelected = null;
        int resultExprSelectedSize = 0;
        for (Expr e : baseResultExprs) {
            ArrayList slotIds = Lists.newArrayList();
            e.getIds(null, slotIds);
            boolean exprIsMaterialized = true;
            int exprSize = 0;
            for (SlotId id : slotIds) {
                SlotDescriptor slot = analyzer.getDescTbl().getSlotDesc(id);
                if (!slot.isMaterialized()) {
                    exprIsMaterialized = false;
                }
                exprSize += slot.getType().getSlotSize();
            }
            if (exprIsMaterialized) {
                return;
            }
            if (resultExprSelected != null && exprSize >= resultExprSelectedSize) continue;
            resultExprSelectedSize = exprSize;
            resultExprSelected = e;
        }
        ArrayList slotIds = Lists.newArrayList();
        ArrayList tupleIds = Lists.newArrayList();
        resultExprSelected.getIds(tupleIds, slotIds);
        for (SlotId id : slotIds) {
            SlotDescriptor slot = analyzer.getDescTbl().getSlotDesc(id);
            slot.setIsMaterialized(true);
        }
        for (TupleId id : tupleIds) {
            TupleDescriptor tuple = analyzer.getDescTbl().getTupleDesc(id);
            tuple.setIsMaterialized(true);
        }
    }

    private void pushDownPredicates(Analyzer analyzer, SelectStmt stmt) throws AnalysisException {
        this.pushDownPredicatesPastSort(analyzer, stmt);
        this.pushDownPredicatesPastWindows(analyzer, stmt);
        this.pushDownPredicatesPastAggregation(analyzer, stmt);
    }

    private void pushDownPredicatesPastSort(Analyzer analyzer, SelectStmt stmt) throws AnalysisException {
        if (stmt.evaluateOrderBy() || stmt.getLimit() >= 0L || stmt.getOffset() > 0L || stmt.getSortInfo() == null) {
            return;
        }
        List<Expr> predicates = this.getBoundPredicates(analyzer, stmt.getSortInfo().getSortTupleDescriptor());
        if (predicates.size() <= 0) {
            return;
        }
        List<Expr> pushDownPredicates = this.getPredicatesReplacedSlotWithSourceExpr(predicates, analyzer);
        if (pushDownPredicates.size() <= 0) {
            return;
        }
        if (this.putPredicatesOnWindows(stmt, analyzer, pushDownPredicates)) {
            return;
        }
        if (this.putPredicatesOnAggregation(stmt, analyzer, pushDownPredicates)) {
            return;
        }
        this.putPredicatesOnTargetTupleIds(stmt.getTableRefIds(), analyzer, predicates);
    }

    private void pushDownPredicatesPastWindows(Analyzer analyzer, SelectStmt stmt) throws AnalysisException {
        AnalyticInfo analyticInfo = stmt.getAnalyticInfo();
        if (analyticInfo == null || analyticInfo.getCommonPartitionExprs().size() == 0) {
            return;
        }
        List<Expr> predicates = this.getBoundPredicates(analyzer, analyticInfo.getOutputTupleDesc());
        if (predicates.size() <= 0) {
            return;
        }
        List<Expr> pushDownPredicates = this.getPredicatesBoundedByGroupbysSourceExpr(predicates, analyzer, stmt);
        if (pushDownPredicates.size() <= 0) {
            return;
        }
        if (this.putPredicatesOnAggregation(stmt, analyzer, pushDownPredicates)) {
            return;
        }
        this.putPredicatesOnTargetTupleIds(stmt.getTableRefIds(), analyzer, predicates);
    }

    private void pushDownPredicatesPastAggregationOnePhase(AggregateInfo aggregateInfo, Analyzer analyzer, SelectStmt stmt, List<TupleId> targetTupleIds) throws AnalysisException {
        if (aggregateInfo == null || aggregateInfo.getGroupingExprs().isEmpty()) {
            return;
        }
        List<Expr> predicates = this.getBoundPredicates(analyzer, aggregateInfo.getOutputTupleDesc());
        if (predicates.isEmpty()) {
            return;
        }
        List<Expr> pushDownPredicates = this.getPredicatesBoundedByGroupbysSourceExpr(predicates, analyzer, stmt);
        if (CollectionUtils.isEmpty(pushDownPredicates)) {
            return;
        }
        this.putPredicatesOnTargetTupleIds(targetTupleIds, analyzer, pushDownPredicates);
    }

    private void pushDownPredicatesPastAggregation(Analyzer analyzer, SelectStmt stmt) throws AnalysisException {
        AggregateInfo firstPhaseAggInfo = stmt.getAggInfo();
        if (firstPhaseAggInfo == null) {
            return;
        }
        AggregateInfo secondPhaseAggInfo = firstPhaseAggInfo.getSecondPhaseDistinctAggInfo();
        ArrayList firstPhaseTupleIds = Lists.newArrayList((Object[])new TupleId[]{firstPhaseAggInfo.getOutputTupleId()});
        this.pushDownPredicatesPastAggregationOnePhase(secondPhaseAggInfo, analyzer, stmt, firstPhaseTupleIds);
        this.pushDownPredicatesPastAggregationOnePhase(firstPhaseAggInfo, analyzer, stmt, stmt.getTableRefIds());
    }

    private List<Expr> getPredicatesBoundedByGroupbysSourceExpr(List<Expr> predicates, Analyzer analyzer, SelectStmt stmt) {
        ArrayList predicatesCanPushDown = Lists.newArrayList();
        for (Expr predicate : predicates) {
            if (predicate.isConstant()) continue;
            ArrayList tupleIds = Lists.newArrayList();
            ArrayList slotIds = Lists.newArrayList();
            predicate.getIds(tupleIds, slotIds);
            boolean isAllSlotReferToGroupBys = true;
            for (SlotId slotId : slotIds) {
                SlotRef slotRef;
                SlotDescriptor slotDescriptor;
                Expr sourceExpr = new SlotRef(analyzer.getDescTbl().getSlotDesc(slotId));
                while (sourceExpr instanceof SlotRef && !(slotDescriptor = (slotRef = sourceExpr).getDesc()).getSourceExprs().isEmpty()) {
                    sourceExpr = slotDescriptor.getSourceExprs().get(0);
                }
                if (stmt.getGroupByClause() == null) continue;
                if (stmt.getGroupByClause().isGroupByExtension() && stmt.getGroupByClause().getGroupingExprs().contains(sourceExpr)) {
                    if (stmt.getGroupByClause().getGroupingType() == GroupByClause.GroupingType.CUBE || stmt.getGroupByClause().getGroupingType() == GroupByClause.GroupingType.ROLLUP) {
                        isAllSlotReferToGroupBys = false;
                    } else {
                        for (List list : stmt.getGroupByClause().getGroupingSetList()) {
                            if (list.contains(sourceExpr)) continue;
                            isAllSlotReferToGroupBys = false;
                            break;
                        }
                    }
                }
                if (!(sourceExpr.getFn() instanceof AggregateFunction)) continue;
                isAllSlotReferToGroupBys = false;
            }
            if (!isAllSlotReferToGroupBys) continue;
            predicatesCanPushDown.add(predicate);
        }
        return this.getPredicatesReplacedSlotWithSourceExpr(predicatesCanPushDown, analyzer);
    }

    private List<Expr> getPredicatesReplacedSlotWithSourceExpr(List<Expr> predicates, Analyzer analyzer) {
        ArrayList predicatesCanPushDown = Lists.newArrayList();
        analyzer.markConjunctsAssigned(predicates);
        for (Expr predicate : predicates) {
            Expr newPredicate = predicate.clone();
            this.replacePredicateSlotRefWithSource(newPredicate, analyzer);
            predicatesCanPushDown.add(newPredicate);
        }
        return predicatesCanPushDown;
    }

    private void replacePredicateSlotRefWithSource(Expr predicate, Analyzer analyzer) {
        this.replacePredicateSlotRefWithSource(null, predicate, -1, analyzer);
    }

    private void replacePredicateSlotRefWithSource(Expr parent, Expr predicate, int childIndex, Analyzer analyzer) {
        if (predicate instanceof SlotRef) {
            SlotRef slotRef = (SlotRef)predicate;
            if (parent != null && childIndex >= 0) {
                Expr newReplacedExpr = slotRef.getDesc().getSourceExprs().get(0).clone();
                parent.setChild(childIndex, newReplacedExpr);
            }
        }
        for (int i = 0; i < predicate.getChildren().size(); ++i) {
            Expr child = (Expr)predicate.getChild(i);
            this.replacePredicateSlotRefWithSource(predicate, child, i, analyzer);
        }
    }

    private boolean putPredicatesOnAggregation(SelectStmt stmt, Analyzer analyzer, List<Expr> predicates) throws AnalysisException {
        AggregateInfo aggregateInfo = stmt.getAggInfo();
        if (aggregateInfo != null) {
            analyzer.registerConjuncts(predicates, aggregateInfo.getOutputTupleId());
            return true;
        }
        return false;
    }

    private boolean putPredicatesOnWindows(SelectStmt stmt, Analyzer analyzer, List<Expr> predicates) throws AnalysisException {
        AnalyticInfo analyticInfo = stmt.getAnalyticInfo();
        if (analyticInfo != null) {
            analyzer.registerConjuncts(predicates, analyticInfo.getOutputTupleId());
            return true;
        }
        return false;
    }

    private void putPredicatesOnTargetTupleIds(List<TupleId> tupleIds, Analyzer analyzer, List<Expr> predicates) throws AnalysisException {
        if (CollectionUtils.isEmpty(tupleIds)) {
            return;
        }
        for (Expr predicate : predicates) {
            Preconditions.checkArgument((boolean)predicate.isBoundByTupleIds(tupleIds), (Object)("Predicate:" + predicate.toSql() + " can't be assigned to some PlanNode."));
            ArrayList predicateTupleIds = Lists.newArrayList();
            predicate.getIds(predicateTupleIds, null);
            analyzer.registerConjunct(predicate, predicateTupleIds);
        }
    }

    private List<Expr> getBoundPredicates(Analyzer analyzer, TupleDescriptor tupleDesc) {
        ArrayList tupleIds = Lists.newArrayList();
        if (tupleDesc != null) {
            tupleIds.add(tupleDesc.getId());
        }
        return analyzer.getUnassignedConjuncts(tupleIds);
    }

    public static BinaryPredicate getNormalizedEqPred(Expr expr, List<TupleId> lhsTids, List<TupleId> rhsTids, Analyzer analyzer) {
        if (!(expr instanceof BinaryPredicate)) {
            return null;
        }
        BinaryPredicate pred = (BinaryPredicate)expr;
        if (!pred.getOp().isEquivalence()) {
            return null;
        }
        if (((Expr)pred.getChild(0)).isConstant() || ((Expr)pred.getChild(1)).isConstant()) {
            return null;
        }
        Expr lhsExpr = Expr.getFirstBoundChild(pred, lhsTids);
        Expr rhsExpr = Expr.getFirstBoundChild(pred, rhsTids);
        if (lhsExpr == null || rhsExpr == null || lhsExpr == rhsExpr) {
            return null;
        }
        BinaryPredicate result = new BinaryPredicate(pred.getOp(), lhsExpr, rhsExpr);
        result.analyzeNoThrow(analyzer);
        return result;
    }
}

