/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.common.CheckedMath;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.planner.ExceptNode;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TExceptNode;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TIntersectNode;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.doris.thrift.TUnionNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SetOperationNode
extends PlanNode {
    private static final Logger LOG = LoggerFactory.getLogger(SetOperationNode.class);
    protected List<Expr> setOpResultExprs_;
    protected List<List<Expr>> resultExprLists_ = Lists.newArrayList();
    protected List<List<Expr>> constExprLists_ = Lists.newArrayList();
    protected List<List<Expr>> materializedResultExprLists_ = Lists.newArrayList();
    protected List<List<Expr>> materializedConstExprLists_ = Lists.newArrayList();
    protected boolean isInSubplan_;
    protected int firstMaterializedChildIdx_;
    protected final TupleId tupleId_;

    protected SetOperationNode(PlanNodeId id, TupleId tupleId, String planNodeName) {
        super(id, tupleId.asList(), planNodeName);
        this.setOpResultExprs_ = Lists.newArrayList();
        this.tupleId_ = tupleId;
        this.isInSubplan_ = false;
    }

    protected SetOperationNode(PlanNodeId id, TupleId tupleId, String planNodeName, List<Expr> setOpResultExprs, boolean isInSubplan) {
        super(id, tupleId.asList(), planNodeName);
        this.setOpResultExprs_ = setOpResultExprs;
        this.tupleId_ = tupleId;
        this.isInSubplan_ = isInSubplan;
    }

    public void addConstExprList(List<Expr> exprs) {
        this.constExprLists_.add(exprs);
    }

    public boolean isConstantUnion() {
        return this.resultExprLists_.isEmpty();
    }

    public void addChild(PlanNode node, List<Expr> resultExprs) {
        super.addChild(node);
        this.resultExprLists_.add(resultExprs);
    }

    public List<List<Expr>> getMaterializedResultExprLists_() {
        return this.materializedResultExprLists_;
    }

    public List<List<Expr>> getMaterializedConstExprLists_() {
        return this.materializedConstExprLists_;
    }

    @Override
    public void finalize(Analyzer analyzer) throws UserException {
        ArrayList newExprList;
        super.finalize(analyzer);
        if (!(this instanceof ExceptNode)) {
            this.computePassthrough(analyzer);
        }
        this.materializedResultExprLists_.clear();
        Preconditions.checkState((this.resultExprLists_.size() == this.children.size() ? 1 : 0) != 0);
        ArrayList<SlotDescriptor> slots = analyzer.getDescTbl().getTupleDesc(this.tupleId_).getSlots();
        for (int i = 0; i < this.resultExprLists_.size(); ++i) {
            List<Expr> exprList = this.resultExprLists_.get(i);
            newExprList = Lists.newArrayList();
            Preconditions.checkState((exprList.size() == slots.size() ? 1 : 0) != 0);
            for (int j = 0; j < exprList.size(); ++j) {
                if (!((SlotDescriptor)slots.get(j)).isMaterialized()) continue;
                newExprList.add(exprList.get(j));
            }
            this.materializedResultExprLists_.add(Expr.substituteList(newExprList, ((PlanNode)this.getChild(i)).getOutputSmap(), analyzer, true));
        }
        Preconditions.checkState((this.materializedResultExprLists_.size() == this.getChildren().size() ? 1 : 0) != 0);
        this.materializedConstExprLists_.clear();
        for (List<Expr> exprList : this.constExprLists_) {
            Preconditions.checkState((exprList.size() == slots.size() ? 1 : 0) != 0);
            newExprList = Lists.newArrayList();
            for (int i = 0; i < exprList.size(); ++i) {
                if (!((SlotDescriptor)slots.get(i)).isMaterialized()) continue;
                newExprList.add(exprList.get(i));
            }
            this.materializedConstExprLists_.add(newExprList);
        }
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        if (!analyzer.safeIsEnableJoinReorderBasedCost()) {
            return;
        }
        this.computeCardinality();
    }

    @Override
    protected void computeOldCardinality() {
        this.computeCardinality();
    }

    private void computeCardinality() {
        this.cardinality = this.constExprLists_.size();
        for (PlanNode child : this.children) {
            if (child.cardinality <= 0L) continue;
            this.cardinality = CheckedMath.checkedAdd(this.cardinality, child.cardinality);
        }
        if (this.numNodes == -1) {
            this.numNodes = 1;
        }
        this.capCardinalityAtLimit();
        if (LOG.isDebugEnabled()) {
            LOG.trace("stats Union: cardinality=" + this.cardinality);
        }
    }

    private boolean isChildPassthrough(Analyzer analyzer, PlanNode childNode, List<Expr> childExprList) {
        ArrayList<TupleId> childTupleIds = childNode.getTupleIds();
        Preconditions.checkState((childTupleIds.size() != 1 || !childNode.getNullableTupleIds().contains(childTupleIds.get(0)) ? 1 : 0) != 0);
        if (this.isInSubplan_) {
            return false;
        }
        if (childTupleIds.size() != 1) {
            return false;
        }
        Preconditions.checkState((!this.setOpResultExprs_.isEmpty() ? 1 : 0) != 0);
        TupleDescriptor setOpTupleDescriptor = analyzer.getDescTbl().getTupleDesc(this.tupleId_);
        TupleDescriptor childTupleDescriptor = analyzer.getDescTbl().getTupleDesc((TupleId)childTupleIds.get(0));
        Preconditions.checkState((setOpTupleDescriptor.getSlots().size() == this.setOpResultExprs_.size() ? 1 : 0) != 0);
        Preconditions.checkState((setOpTupleDescriptor.getSlots().size() == childExprList.size() ? 1 : 0) != 0);
        if (this.setOpResultExprs_.size() != childTupleDescriptor.getSlots().size()) {
            return false;
        }
        if (setOpTupleDescriptor.getByteSize() != childTupleDescriptor.getByteSize()) {
            return false;
        }
        for (int i = 0; i < this.setOpResultExprs_.size(); ++i) {
            if (!setOpTupleDescriptor.getSlots().get(i).isMaterialized()) continue;
            SlotRef setOpSlotRef = this.setOpResultExprs_.get(i).unwrapSlotRef(false);
            SlotRef childSlotRef = childExprList.get(i).unwrapSlotRef(false);
            Preconditions.checkNotNull((Object)setOpSlotRef);
            if (childSlotRef == null) {
                return false;
            }
            if (VectorizedUtil.isVectorized()) {
                if (childSlotRef.getDesc().getSlotOffset() != setOpSlotRef.getDesc().getSlotOffset()) {
                    return false;
                }
                if (childSlotRef.isNullable() != setOpSlotRef.isNullable()) {
                    return false;
                }
                if (childSlotRef.getDesc().getType() == setOpSlotRef.getDesc().getType()) continue;
                return false;
            }
            if (childSlotRef.getDesc().LayoutEquals(setOpSlotRef.getDesc())) continue;
            return false;
        }
        return true;
    }

    void computePassthrough(Analyzer analyzer) {
        int i;
        ArrayList newResultExprLists = Lists.newArrayList();
        ArrayList newChildren = Lists.newArrayList();
        for (i = 0; i < this.children.size(); ++i) {
            if (!this.isChildPassthrough(analyzer, (PlanNode)this.children.get(i), this.resultExprLists_.get(i))) continue;
            newResultExprLists.add(this.resultExprLists_.get(i));
            newChildren.add((PlanNode)this.children.get(i));
        }
        this.firstMaterializedChildIdx_ = newChildren.size();
        for (i = 0; i < this.children.size(); ++i) {
            if (this.isChildPassthrough(analyzer, (PlanNode)this.children.get(i), this.resultExprLists_.get(i))) continue;
            newResultExprLists.add(this.resultExprLists_.get(i));
            newChildren.add((PlanNode)this.children.get(i));
        }
        Preconditions.checkState((this.resultExprLists_.size() == newResultExprLists.size() ? 1 : 0) != 0);
        this.resultExprLists_ = newResultExprLists;
        Preconditions.checkState((this.children.size() == newChildren.size() ? 1 : 0) != 0);
        this.children = newChildren;
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        Preconditions.checkState((boolean)this.conjuncts.isEmpty());
        this.createDefaultSmap(analyzer);
        this.computeTupleStatAndMemLayout(analyzer);
        this.computeStats(analyzer);
    }

    protected void toThrift(TPlanNode msg, TPlanNodeType nodeType) {
        Preconditions.checkState((this.materializedResultExprLists_.size() == this.children.size() ? 1 : 0) != 0);
        ArrayList texprLists = Lists.newArrayList();
        for (List<Expr> exprList : this.materializedResultExprLists_) {
            texprLists.add(Expr.treesToThrift(exprList));
        }
        ArrayList constTexprLists = Lists.newArrayList();
        for (List<Expr> constTexprList : this.materializedConstExprLists_) {
            constTexprLists.add(Expr.treesToThrift(constTexprList));
        }
        Preconditions.checkState((this.firstMaterializedChildIdx_ <= this.children.size() ? 1 : 0) != 0);
        switch (nodeType) {
            case UNION_NODE: {
                msg.union_node = new TUnionNode(this.tupleId_.asInt(), (List)texprLists, (List)constTexprLists, (long)this.firstMaterializedChildIdx_);
                msg.node_type = TPlanNodeType.UNION_NODE;
                break;
            }
            case INTERSECT_NODE: {
                msg.intersect_node = new TIntersectNode(this.tupleId_.asInt(), (List)texprLists, (List)constTexprLists, (long)this.firstMaterializedChildIdx_);
                msg.node_type = TPlanNodeType.INTERSECT_NODE;
                break;
            }
            case EXCEPT_NODE: {
                msg.except_node = new TExceptNode(this.tupleId_.asInt(), (List)texprLists, (List)constTexprLists, (long)this.firstMaterializedChildIdx_);
                msg.node_type = TPlanNodeType.EXCEPT_NODE;
                break;
            }
            default: {
                LOG.error("Node type: " + nodeType.toString() + " is invalid.");
            }
        }
    }

    @Override
    public String getNodeExplainString(String prefix, TExplainLevel detailLevel) {
        if (detailLevel == TExplainLevel.BRIEF) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)this.conjuncts)) {
            output.append(prefix).append("predicates: ").append(this.getExplainString(this.conjuncts)).append("\n");
        }
        if (CollectionUtils.isNotEmpty(this.constExprLists_)) {
            output.append(prefix).append("constant exprs: ").append("\n");
            for (List<Expr> exprs : this.constExprLists_) {
                output.append(prefix).append("    ").append(exprs.stream().map(Expr::toSql).collect(Collectors.joining(" | "))).append("\n");
            }
        }
        if (detailLevel == TExplainLevel.VERBOSE) {
            if (CollectionUtils.isNotEmpty(this.materializedResultExprLists_)) {
                output.append(prefix).append("child exprs: ").append("\n");
                for (List<Expr> exprs : this.materializedResultExprLists_) {
                    output.append(prefix).append("    ").append(exprs.stream().map(Expr::toSql).collect(Collectors.joining(" | "))).append("\n");
                }
            }
            ArrayList passThroughNodeIds = Lists.newArrayList();
            for (int i = 0; i < this.firstMaterializedChildIdx_; ++i) {
                passThroughNodeIds.add(((PlanNode)this.children.get(i)).getId().toString());
            }
            if (!passThroughNodeIds.isEmpty()) {
                String result = prefix + "pass-through-operands: ";
                if (passThroughNodeIds.size() == this.children.size()) {
                    output.append(result + "all\n");
                } else {
                    output.append(result).append(Joiner.on((String)",").join((Iterable)passThroughNodeIds)).append("\n");
                }
            }
        }
        return output.toString();
    }

    @Override
    public int getNumInstances() {
        int numInstances = 0;
        for (PlanNode child : this.children) {
            numInstances += child.getNumInstances();
        }
        numInstances = Math.max(1, numInstances);
        return numInstances;
    }
}

