/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.common.UserException;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SelectNode
extends PlanNode {
    private static final Logger LOG = LogManager.getLogger(SelectNode.class);

    protected SelectNode(PlanNodeId id, PlanNode child) {
        super(id, child.getTupleIds(), "SELECT");
        this.addChild(child);
        this.nullableTupleIds = child.nullableTupleIds;
    }

    protected SelectNode(PlanNodeId id, PlanNode child, List<Expr> conjuncts) {
        super(id, child.getTupleIds(), "SELECT");
        this.addChild(child);
        this.tblRefIds = child.tblRefIds;
        this.nullableTupleIds = child.nullableTupleIds;
        this.conjuncts.addAll(conjuncts);
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.SELECT_NODE;
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        super.init(analyzer);
        analyzer.markConjunctsAssigned(this.conjuncts);
        this.computeStats(analyzer);
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        if (!analyzer.safeIsEnableJoinReorderBasedCost()) {
            return;
        }
        this.cardinality = ((PlanNode)this.getChild((int)0)).cardinality;
        this.applyConjunctsSelectivity();
        this.capCardinalityAtLimit();
        if (LOG.isDebugEnabled()) {
            LOG.debug("stats Select: cardinality={}", (Object)this.cardinality);
        }
    }

    @Override
    protected void computeOldCardinality() {
        long cardinality = ((PlanNode)this.getChild((int)0)).cardinality;
        double selectivity = this.computeOldSelectivity();
        this.cardinality = cardinality < 0L || selectivity < 0.0 ? -1L : Math.round((double)cardinality * selectivity);
        LOG.debug("stats Select: cardinality={}", (Object)this.cardinality);
    }

    @Override
    public String getNodeExplainString(String prefix, TExplainLevel detailLevel) {
        if (detailLevel == TExplainLevel.BRIEF) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        if (!this.conjuncts.isEmpty()) {
            output.append(prefix + "predicates: " + this.getExplainString(this.conjuncts) + "\n");
        }
        return output.toString();
    }

    @Override
    public int getNumInstances() {
        return ((PlanNode)this.children.get(0)).getNumInstances();
    }
}

