/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.MoreObjects;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.SchemaTable;
import org.apache.doris.common.Config;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.Util;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.planner.ScanNode;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.doris.thrift.TScanRangeLocations;
import org.apache.doris.thrift.TSchemaScanNode;
import org.apache.doris.thrift.TUserIdentity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SchemaScanNode
extends ScanNode {
    private static final Logger LOG = LogManager.getLogger(SchemaTable.class);
    private final String tableName;
    private String schemaDb;
    private String schemaTable;
    private String schemaWild;
    private String user;
    private String userIp;
    private String frontendIP;
    private int frontendPort;

    public SchemaScanNode(PlanNodeId id, TupleDescriptor desc) {
        super(id, desc, "SCAN SCHEMA");
        this.tableName = desc.getTable().getName();
    }

    @Override
    protected String debugString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        return helper.addValue((Object)super.debugString()).toString();
    }

    @Override
    public void finalize(Analyzer analyzer) throws UserException {
        this.schemaDb = analyzer.getSchemaDb();
        this.schemaTable = analyzer.getSchemaTable();
        this.schemaWild = analyzer.getSchemaWild();
        this.user = analyzer.getQualifiedUser();
        this.userIp = analyzer.getContext().getRemoteIP();
        this.frontendIP = FrontendOptions.getLocalHostAddress();
        this.frontendPort = Config.rpc_port;
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        ConnectContext ctx;
        msg.node_type = TPlanNodeType.SCHEMA_SCAN_NODE;
        msg.schema_scan_node = new TSchemaScanNode(this.desc.getId().asInt(), this.tableName);
        if (this.schemaDb != null) {
            msg.schema_scan_node.setDb(this.schemaDb);
        } else if (this.tableName.equalsIgnoreCase("GLOBAL_VARIABLES")) {
            msg.schema_scan_node.setDb("GLOBAL");
        } else if (this.tableName.equalsIgnoreCase("SESSION_VARIABLES")) {
            msg.schema_scan_node.setDb("SESSION");
        }
        msg.schema_scan_node.show_hidden_cloumns = Util.showHiddenColumns();
        if (this.schemaTable != null) {
            msg.schema_scan_node.setTable(this.schemaTable);
        }
        if (this.schemaWild != null) {
            msg.schema_scan_node.setWild(this.schemaWild);
        }
        if ((ctx = ConnectContext.get()) != null) {
            msg.schema_scan_node.setThreadId((long)ConnectContext.get().getConnectionId());
        }
        msg.schema_scan_node.setIp(this.frontendIP);
        msg.schema_scan_node.setPort(this.frontendPort);
        TUserIdentity tCurrentUser = ConnectContext.get().getCurrentUserIdentity().toThrift();
        msg.schema_scan_node.setCurrentUserIdent(tCurrentUser);
    }

    @Override
    public List<TScanRangeLocations> getScanRangeLocations(long maxScanRangeLength) {
        return null;
    }

    @Override
    public int getNumInstances() {
        return 1;
    }
}

