/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.IsNullPredicate;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.PredicateUtils;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.common.UserException;
import org.apache.doris.planner.ColumnBound;
import org.apache.doris.planner.ColumnRange;
import org.apache.doris.planner.PartitionColumnFilter;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TScanRangeLocations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jersey.internal.guava.Sets;

public abstract class ScanNode
extends PlanNode {
    private static final Logger LOG = LogManager.getLogger(ScanNode.class);
    protected final TupleDescriptor desc;
    protected Map<String, PartitionColumnFilter> columnFilters = Maps.newHashMap();
    protected Map<String, ColumnRange> columnNameToRange = Maps.newHashMap();
    protected String sortColumn = null;
    protected Analyzer analyzer;

    public ScanNode(PlanNodeId id, TupleDescriptor desc, String planNodeName) {
        super(id, desc.getId().asList(), planNodeName);
        this.desc = desc;
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        super.init(analyzer);
        this.analyzer = analyzer;
        analyzer.materializeSlots(this.conjuncts);
    }

    protected static TNetworkAddress addressToTNetworkAddress(String address) {
        TNetworkAddress result = new TNetworkAddress();
        String[] hostPort = address.split(":");
        result.hostname = hostPort[0];
        result.port = Integer.parseInt(hostPort[1]);
        return result;
    }

    public TupleDescriptor getTupleDesc() {
        return this.desc;
    }

    public void setSortColumn(String column) {
        this.sortColumn = column;
    }

    protected Expr castToSlot(SlotDescriptor slotDesc, Expr expr) throws UserException {
        PrimitiveType srcType;
        PrimitiveType dstType = slotDesc.getType().getPrimitiveType();
        if (dstType != (srcType = expr.getType().getPrimitiveType())) {
            return expr.castTo(slotDesc.getType());
        }
        return expr;
    }

    public abstract List<TScanRangeLocations> getScanRangeLocations(long var1);

    public void computeColumnFilter() {
        for (Column column : this.desc.getTable().getBaseSchema()) {
            ColumnRange columnRange;
            SlotDescriptor slotDesc = this.desc.getColumnSlot(column.getName());
            if (null == slotDesc) continue;
            PartitionColumnFilter keyFilter = this.createPartitionFilter(slotDesc, this.conjuncts);
            if (null != keyFilter) {
                this.columnFilters.put(column.getName(), keyFilter);
            }
            if (!this.analyzer.partitionPruneV2Enabled() || (columnRange = this.createColumnRange(slotDesc, this.conjuncts)) == null) continue;
            this.columnNameToRange.put(column.getName(), columnRange);
        }
    }

    private ColumnRange createColumnRange(SlotDescriptor desc, List<Expr> conjuncts) {
        ColumnRange result = ColumnRange.create();
        for (Expr expr : conjuncts) {
            if (!expr.isBound(desc.getId())) continue;
            if (expr instanceof CompoundPredicate && ((CompoundPredicate)expr).getOp() == CompoundPredicate.Operator.OR) {
                List<Expr> disjunctivePredicates = PredicateUtils.splitDisjunctivePredicates(expr);
                if (disjunctivePredicates.isEmpty()) continue;
                ArrayList disjunctiveRanges = Lists.newArrayList();
                HashSet hasIsNull = Sets.newHashSet();
                boolean allMatch = disjunctivePredicates.stream().allMatch(e -> {
                    ColumnRanges ranges = this.expressionToRanges((Expr)e, desc);
                    switch (ranges.type) {
                        case IS_NULL: {
                            hasIsNull.add(true);
                            return true;
                        }
                        case CONVERT_SUCCESS: {
                            disjunctiveRanges.addAll(ranges.ranges);
                            return true;
                        }
                    }
                    return false;
                });
                if (!allMatch || disjunctiveRanges.isEmpty() && hasIsNull.isEmpty()) continue;
                result.intersect(disjunctiveRanges);
                result.setHasDisjunctiveIsNull(!hasIsNull.isEmpty());
                continue;
            }
            ColumnRanges ranges = this.expressionToRanges(expr, desc);
            switch (ranges.type) {
                case IS_NULL: {
                    result.setHasConjunctiveIsNull(true);
                    break;
                }
                case CONVERT_SUCCESS: {
                    result.intersect(ranges.ranges);
                }
            }
        }
        return result;
    }

    private ColumnRanges expressionToRanges(Expr expr, SlotDescriptor desc) {
        IsNullPredicate isNullPredicate;
        if (expr instanceof IsNullPredicate && (isNullPredicate = (IsNullPredicate)expr).isSlotRefChildren() && !isNullPredicate.isNotNull()) {
            return ColumnRanges.createIsNull();
        }
        ArrayList result = Lists.newArrayList();
        if (expr instanceof BinaryPredicate) {
            BinaryPredicate binPred = (BinaryPredicate)expr;
            Expr slotBinding = binPred.getSlotBinding(desc.getId());
            if (slotBinding == null || !slotBinding.isConstant() || !(slotBinding instanceof LiteralExpr)) {
                return ColumnRanges.createFailure();
            }
            LiteralExpr value = (LiteralExpr)slotBinding;
            switch (binPred.getOp()) {
                case EQ: {
                    ColumnBound bound = ColumnBound.of(value);
                    result.add(Range.closed((Comparable)bound, (Comparable)bound));
                    break;
                }
                case LE: {
                    result.add(Range.atMost((Comparable)ColumnBound.of(value)));
                    break;
                }
                case LT: {
                    result.add(Range.lessThan((Comparable)ColumnBound.of(value)));
                    break;
                }
                case GE: {
                    result.add(Range.atLeast((Comparable)ColumnBound.of(value)));
                    break;
                }
                case GT: {
                    result.add(Range.greaterThan((Comparable)ColumnBound.of(value)));
                    break;
                }
                case NE: {
                    ColumnBound b = ColumnBound.of(value);
                    result.add(Range.greaterThan((Comparable)b));
                    result.add(Range.lessThan((Comparable)b));
                    break;
                }
            }
        } else if (expr instanceof InPredicate) {
            InPredicate inPredicate = (InPredicate)expr;
            if (!inPredicate.isLiteralChildren() || inPredicate.isNotIn()) {
                return ColumnRanges.createFailure();
            }
            if (!(((Expr)inPredicate.getChild(0)).unwrapExpr(false) instanceof SlotRef)) {
                return ColumnRanges.createFailure();
            }
            for (int i = 1; i < inPredicate.getChildren().size(); ++i) {
                ColumnBound bound = ColumnBound.of((LiteralExpr)inPredicate.getChild(i));
                result.add(Range.closed((Comparable)bound, (Comparable)bound));
            }
        }
        if (result.isEmpty()) {
            return ColumnRanges.createFailure();
        }
        return ColumnRanges.create(result);
    }

    private PartitionColumnFilter createPartitionFilter(SlotDescriptor desc, List<Expr> conjuncts) {
        PartitionColumnFilter partitionColumnFilter = null;
        for (Expr expr : conjuncts) {
            IsNullPredicate isNullPredicate;
            if (!expr.isBound(desc.getId())) continue;
            if (expr instanceof BinaryPredicate) {
                Expr slotBinding;
                BinaryPredicate binPredicate = (BinaryPredicate)expr;
                if (binPredicate.getOp() == BinaryPredicate.Operator.NE || (slotBinding = binPredicate.getSlotBinding(desc.getId())) == null || !slotBinding.isConstant() || !(slotBinding instanceof LiteralExpr)) continue;
                if (null == partitionColumnFilter) {
                    partitionColumnFilter = new PartitionColumnFilter();
                }
                LiteralExpr literal = (LiteralExpr)slotBinding;
                BinaryPredicate.Operator op = binPredicate.getOp();
                if (!binPredicate.slotIsLeft()) {
                    op = op.commutative();
                }
                switch (op) {
                    case EQ: {
                        partitionColumnFilter.setLowerBound(literal, true);
                        partitionColumnFilter.setUpperBound(literal, true);
                        break;
                    }
                    case LE: {
                        partitionColumnFilter.setUpperBound(literal, true);
                        partitionColumnFilter.lowerBoundInclusive = true;
                        break;
                    }
                    case LT: {
                        partitionColumnFilter.setUpperBound(literal, false);
                        partitionColumnFilter.lowerBoundInclusive = true;
                        break;
                    }
                    case GE: {
                        partitionColumnFilter.setLowerBound(literal, true);
                        break;
                    }
                    case GT: {
                        partitionColumnFilter.setLowerBound(literal, false);
                        break;
                    }
                }
                continue;
            }
            if (expr instanceof InPredicate) {
                InPredicate inPredicate = (InPredicate)expr;
                if (!inPredicate.isLiteralChildren() || inPredicate.isNotIn() || !(((Expr)inPredicate.getChild(0)).unwrapExpr(false) instanceof SlotRef)) continue;
                if (null == partitionColumnFilter) {
                    partitionColumnFilter = new PartitionColumnFilter();
                }
                partitionColumnFilter.setInPredicate(inPredicate);
                continue;
            }
            if (!(expr instanceof IsNullPredicate) || !(isNullPredicate = (IsNullPredicate)expr).isSlotRefChildren() || isNullPredicate.isNotNull()) continue;
            partitionColumnFilter = new PartitionColumnFilter();
            NullLiteral nullLiteral = new NullLiteral();
            partitionColumnFilter.setLowerBound(nullLiteral, true);
            partitionColumnFilter.setUpperBound(nullLiteral, true);
            break;
        }
        LOG.debug("partitionColumnFilter: {}", partitionColumnFilter);
        return partitionColumnFilter;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tid", this.desc.getId().asInt()).add("tblName", (Object)this.desc.getTable().getName()).add("keyRanges", (Object)"").addValue((Object)super.debugString()).toString();
    }

    private static class ColumnRanges {
        final Type type;
        final List<Range<ColumnBound>> ranges;
        private static final ColumnRanges IS_NULL = new ColumnRanges(Type.IS_NULL, null);
        private static final ColumnRanges CONVERT_FAILURE = new ColumnRanges(Type.CONVERT_FAILURE, null);

        private ColumnRanges(Type type, List<Range<ColumnBound>> ranges) {
            this.type = type;
            this.ranges = ranges;
        }

        public static ColumnRanges createIsNull() {
            return IS_NULL;
        }

        public static ColumnRanges createFailure() {
            return CONVERT_FAILURE;
        }

        public static ColumnRanges create(List<Range<ColumnBound>> ranges) {
            return new ColumnRanges(Type.CONVERT_SUCCESS, ranges);
        }

        static enum Type {
            IS_NULL,
            CONVERT_SUCCESS,
            CONVERT_FAILURE;

        }
    }
}

