/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.analysis.TupleIsNullPredicate;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.IdGenerator;
import org.apache.doris.planner.HashJoinNode;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.planner.RuntimeFilterGenerator;
import org.apache.doris.planner.RuntimeFilterId;
import org.apache.doris.planner.ScanNode;
import org.apache.doris.planner.SingleNodePlanner;
import org.apache.doris.thrift.TRuntimeFilterDesc;
import org.apache.doris.thrift.TRuntimeFilterType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RuntimeFilter {
    private static final Logger LOG = LogManager.getLogger(RuntimeFilter.class);
    private final RuntimeFilterId id;
    private final HashJoinNode builderNode;
    private final Expr srcExpr;
    private final int exprOrder;
    private final Expr origTargetExpr;
    private final List<RuntimeFilterTarget> targets = new ArrayList<RuntimeFilterTarget>();
    private final Map<TupleId, List<SlotId>> targetSlotsByTid;
    private boolean isBroadcastJoin;
    private long ndvEstimate = -1L;
    private long filterSizeBytes = 0L;
    private boolean hasLocalTargets = false;
    private boolean hasRemoteTargets = false;
    private boolean finalized = false;
    private TRuntimeFilterType runtimeFilterType;

    private RuntimeFilter(RuntimeFilterId filterId, HashJoinNode filterSrcNode, Expr srcExpr, int exprOrder, Expr origTargetExpr, Map<TupleId, List<SlotId>> targetSlots, TRuntimeFilterType type, RuntimeFilterGenerator.FilterSizeLimits filterSizeLimits) {
        this.id = filterId;
        this.builderNode = filterSrcNode;
        this.srcExpr = srcExpr;
        this.exprOrder = exprOrder;
        this.origTargetExpr = origTargetExpr;
        this.targetSlotsByTid = targetSlots;
        this.runtimeFilterType = type;
        this.computeNdvEstimate();
        this.calculateFilterSize(filterSizeLimits);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RuntimeFilter)) {
            return false;
        }
        return ((RuntimeFilter)obj).id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void markFinalized() {
        this.finalized = true;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public TRuntimeFilterDesc toThrift() {
        TRuntimeFilterDesc tFilter = new TRuntimeFilterDesc();
        tFilter.setFilterId(this.id.asInt());
        tFilter.setSrcExpr(this.srcExpr.treeToThrift());
        tFilter.setExprOrder(this.exprOrder);
        tFilter.setIsBroadcastJoin(this.isBroadcastJoin);
        tFilter.setHasLocalTargets(this.hasLocalTargets);
        tFilter.setHasRemoteTargets(this.hasRemoteTargets);
        for (RuntimeFilterTarget target : this.targets) {
            tFilter.putToPlanIdToTargetExpr(target.node.getId().asInt(), target.expr.treeToThrift());
        }
        tFilter.setType(this.runtimeFilterType);
        tFilter.setBloomFilterSizeBytes(this.filterSizeBytes);
        return tFilter;
    }

    public List<RuntimeFilterTarget> getTargets() {
        return this.targets;
    }

    public boolean hasTargets() {
        return !this.targets.isEmpty();
    }

    public Expr getSrcExpr() {
        return this.srcExpr;
    }

    public Expr getOrigTargetExpr() {
        return this.origTargetExpr;
    }

    public Map<TupleId, List<SlotId>> getTargetSlots() {
        return this.targetSlotsByTid;
    }

    public RuntimeFilterId getFilterId() {
        return this.id;
    }

    public TRuntimeFilterType getType() {
        return this.runtimeFilterType;
    }

    public void setType(TRuntimeFilterType type) {
        this.runtimeFilterType = type;
    }

    public boolean hasRemoteTargets() {
        return this.hasRemoteTargets;
    }

    public HashJoinNode getBuilderNode() {
        return this.builderNode;
    }

    public static RuntimeFilter create(IdGenerator<RuntimeFilterId> idGen, Analyzer analyzer, Expr joinPredicate, int exprOrder, HashJoinNode filterSrcNode, TRuntimeFilterType type, RuntimeFilterGenerator.FilterSizeLimits filterSizeLimits) {
        Preconditions.checkNotNull(idGen);
        Preconditions.checkNotNull((Object)joinPredicate);
        Preconditions.checkNotNull((Object)filterSrcNode);
        if (!Predicate.isUnNullSafeEquivalencePredicate(joinPredicate)) {
            return null;
        }
        BinaryPredicate normalizedJoinConjunct = SingleNodePlanner.getNormalizedEqPred(joinPredicate, ((PlanNode)filterSrcNode.getChild(0)).getTupleIds(), ((PlanNode)filterSrcNode.getChild(1)).getTupleIds(), analyzer);
        if (normalizedJoinConjunct == null) {
            return null;
        }
        Expr targetExpr = TupleIsNullPredicate.unwrapExpr(((Expr)normalizedJoinConjunct.getChild(0)).clone());
        Expr srcExpr = (Expr)normalizedJoinConjunct.getChild(1);
        if (srcExpr.getType().equals(ScalarType.createHllType()) || srcExpr.getType().equals(ScalarType.createType(PrimitiveType.BITMAP))) {
            return null;
        }
        Map<TupleId, List<SlotId>> targetSlots = RuntimeFilter.getTargetSlots(analyzer, targetExpr);
        Preconditions.checkNotNull(targetSlots);
        if (targetSlots.isEmpty()) {
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Generating runtime filter from predicate " + joinPredicate);
        }
        return new RuntimeFilter(idGen.getNextId(), filterSrcNode, srcExpr, exprOrder, targetExpr, targetSlots, type, filterSizeLimits);
    }

    private static Map<TupleId, List<SlotId>> getTargetSlots(Analyzer analyzer, Expr expr) {
        ArrayList<TupleId> tids = new ArrayList<TupleId>();
        ArrayList<SlotId> sids = new ArrayList<SlotId>();
        expr.getIds(tids, sids);
        if (analyzer.hasOuterJoinedValueTransferTarget(sids) && (expr.isContainsFunction("COALESCE") || expr.isContainsFunction("IFNULL") || expr.isContainsClass("org.apache.doris.analysis.CaseExpr"))) {
            return Collections.emptyMap();
        }
        HashMap<TupleId, List<SlotId>> slotsByTid = new HashMap<TupleId, List<SlotId>>();
        for (SlotId slotId : sids) {
            Map<TupleId, List<SlotId>> currSlotsByTid = RuntimeFilter.getBaseTblEquivSlots(analyzer, slotId);
            if (currSlotsByTid.isEmpty()) {
                return Collections.emptyMap();
            }
            if (slotsByTid.isEmpty()) {
                slotsByTid.putAll(currSlotsByTid);
                continue;
            }
            Iterator iter = slotsByTid.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                List<SlotId> slotIds = currSlotsByTid.get(entry.getKey());
                if (slotIds == null) {
                    iter.remove();
                    continue;
                }
                ((List)entry.getValue()).addAll(slotIds);
            }
            if (!slotsByTid.isEmpty()) continue;
            return Collections.emptyMap();
        }
        return slotsByTid;
    }

    private static Map<TupleId, List<SlotId>> getBaseTblEquivSlots(Analyzer analyzer, SlotId srcSid) {
        HashMap<TupleId, List<SlotId>> slotsByTid = new HashMap<TupleId, List<SlotId>>();
        for (SlotId targetSid : analyzer.getValueTransferTargets(srcSid)) {
            TupleDescriptor tupleDesc = analyzer.getSlotDesc(targetSid).getParent();
            if (tupleDesc.getTable() == null) continue;
            List sids = slotsByTid.computeIfAbsent(tupleDesc.getId(), k -> new ArrayList());
            sids.add(targetSid);
        }
        return slotsByTid;
    }

    public Expr getTargetExpr(PlanNodeId targetPlanNodeId) {
        for (RuntimeFilterTarget target : this.targets) {
            if (target.node.getId() != targetPlanNodeId) continue;
            return target.expr;
        }
        return null;
    }

    public double getSelectivity() {
        if (this.builderNode.getCardinality() == -1L || ((PlanNode)this.builderNode.getChild(0)).getCardinality() == -1L || ((PlanNode)this.builderNode.getChild(0)).getCardinality() == 0L) {
            return -1.0;
        }
        return (double)this.builderNode.getCardinality() / (double)((PlanNode)this.builderNode.getChild(0)).getCardinality();
    }

    public void addTarget(RuntimeFilterTarget target) {
        this.targets.add(target);
    }

    public void setIsBroadcast(boolean isBroadcast) {
        this.isBroadcastJoin = isBroadcast;
    }

    public void computeNdvEstimate() {
        this.ndvEstimate = ((PlanNode)this.builderNode.getChild(1)).getCardinality();
    }

    public void extractTargetsPosition() {
        Preconditions.checkNotNull((Object)this.builderNode.getFragment());
        Preconditions.checkState((boolean)this.hasTargets());
        for (RuntimeFilterTarget target : this.targets) {
            Preconditions.checkNotNull((Object)target.node.getFragment());
            this.hasLocalTargets = this.hasLocalTargets || target.isLocalTarget;
            this.hasRemoteTargets = this.hasRemoteTargets || !target.isLocalTarget;
        }
    }

    private void calculateFilterSize(RuntimeFilterGenerator.FilterSizeLimits filterSizeLimits) {
        if (this.ndvEstimate == -1L) {
            this.filterSizeBytes = filterSizeLimits.defaultVal;
            return;
        }
        double fpp = FeConstants.default_bloom_filter_fpp;
        int logFilterSize = RuntimeFilter.GetMinLogSpaceForBloomFilter(this.ndvEstimate, fpp);
        this.filterSizeBytes = 1L << logFilterSize;
        this.filterSizeBytes = Math.max(this.filterSizeBytes, filterSizeLimits.minVal);
        this.filterSizeBytes = Math.min(this.filterSizeBytes, filterSizeLimits.maxVal);
    }

    public static int GetMinLogSpaceForBloomFilter(long ndv, double fpp) {
        if (0L == ndv) {
            return 0;
        }
        double k = 8.0;
        double m = -k * (double)ndv / Math.log(1.0 - Math.pow(fpp, 1.0 / k));
        return Math.max(0, (int)Math.ceil(Math.log(m / 8.0) / Math.log(2.0)));
    }

    public void assignToPlanNodes() {
        Preconditions.checkState((boolean)this.hasTargets());
        this.builderNode.addRuntimeFilter(this);
        this.builderNode.fragment_.setBuilderRuntimeFilterIds(this.getFilterId());
        for (RuntimeFilterTarget target : this.targets) {
            target.node.addRuntimeFilter(this);
            target.node.fragment_.setTargetRuntimeFilterIds(this.id);
        }
    }

    public void registerToPlan(Analyzer analyzer) {
        this.setIsBroadcast(this.getBuilderNode().getDistributionMode() == HashJoinNode.DistributionMode.BROADCAST);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Runtime filter: " + this.debugString());
        }
        this.assignToPlanNodes();
        analyzer.putAssignedRuntimeFilter(this);
    }

    public String debugString() {
        return "FilterID: " + this.id + " Source: " + this.builderNode.getId() + " SrcExpr: " + this.getSrcExpr().debugString() + " Target(s): " + Joiner.on((String)", ").join(this.targets) + " Selectivity: " + this.getSelectivity();
    }

    public static class RuntimeFilterTarget {
        public ScanNode node;
        public Expr expr;
        public final boolean isBoundByKeyColumns;
        public final boolean isLocalTarget;

        public RuntimeFilterTarget(ScanNode targetNode, Expr targetExpr, boolean isBoundByKeyColumns, boolean isLocalTarget) {
            Preconditions.checkState((boolean)targetExpr.isBoundByTupleIds(targetNode.getTupleIds()));
            this.node = targetNode;
            this.expr = targetExpr;
            this.isBoundByKeyColumns = isBoundByKeyColumns;
            this.isLocalTarget = isLocalTarget;
        }

        public String toString() {
            return "Target Id: " + this.node.getId() + " Target expr: " + this.expr.debugString() + " Is only Bound By Key: " + this.isBoundByKeyColumns + "Is local: " + this.isLocalTarget;
        }
    }
}

