/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RollupSelector {
    private static final Logger LOG = LogManager.getLogger(RollupSelector.class);
    private final TupleDescriptor tupleDesc;
    private final OlapTable table;
    private final Analyzer analyzer;

    public RollupSelector(Analyzer analyzer, TupleDescriptor tupleDesc, OlapTable table) {
        this.analyzer = analyzer;
        this.tupleDesc = tupleDesc;
        this.table = table;
    }

    public long selectBestRollup(Collection<Long> partitionIds, List<Expr> conjuncts, boolean isPreAggregation) throws UserException {
        String v2RollupIndexName;
        Long v2RollupIndexId;
        Preconditions.checkArgument((partitionIds != null ? 1 : 0) != 0, (Object)"Paritition can't be null.");
        ConnectContext connectContext = ConnectContext.get();
        if (connectContext != null && connectContext.getSessionVariable().isUseV2Rollup() && (v2RollupIndexId = this.table.getIndexIdByName(v2RollupIndexName = "__v2_" + this.table.getName())) != null) {
            return v2RollupIndexId;
        }
        List<Long> bestPrefixIndexRollups = this.selectBestPrefixIndexRollup(conjuncts, isPreAggregation);
        return this.selectBestRowCountRollup(bestPrefixIndexRollups, partitionIds);
    }

    private long selectBestRowCountRollup(List<Long> bestPrefixIndexRollups, Collection<Long> partitionIds) {
        long minRowCount = Long.MAX_VALUE;
        long selectedIndexId = 0L;
        for (Long indexId : bestPrefixIndexRollups) {
            long rowCount = 0L;
            for (Long partitionId : partitionIds) {
                rowCount += this.table.getPartition(partitionId).getIndex(indexId).getRowCount();
            }
            LOG.debug("rowCount={} for table={}", (Object)rowCount, (Object)indexId);
            if (rowCount < minRowCount) {
                minRowCount = rowCount;
                selectedIndexId = indexId;
                continue;
            }
            if (rowCount != minRowCount) continue;
            int selectedColumnSize = this.table.getSchemaByIndexId(selectedIndexId).size();
            int currColumnSize = this.table.getSchemaByIndexId(indexId).size();
            if (currColumnSize >= selectedColumnSize) continue;
            selectedIndexId = indexId;
        }
        String tableName = this.table.getName();
        String v2RollupIndexName = "__v2_" + tableName;
        Long v2RollupIndexId = this.table.getIndexIdByName(v2RollupIndexName);
        long baseIndexId = this.table.getBaseIndexId();
        if (v2RollupIndexId != null && v2RollupIndexId == selectedIndexId) {
            selectedIndexId = baseIndexId;
        }
        return selectedIndexId;
    }

    private List<Long> selectBestPrefixIndexRollup(List<Expr> conjuncts, boolean isPreAggregation) throws UserException {
        ArrayList outputColumns = Lists.newArrayList();
        for (SlotDescriptor slot : this.tupleDesc.getMaterializedSlots()) {
            Column col = slot.getColumn();
            outputColumns.add(col.getName());
        }
        List<MaterializedIndex> rollups = this.table.getVisibleIndex();
        LOG.debug("num of rollup(base included): {}, pre aggr: {}", (Object)rollups.size(), (Object)isPreAggregation);
        ArrayList rollupsContainsOutput = Lists.newArrayList();
        List<Column> baseTableColumns = this.table.getKeyColumnsByIndexId(this.table.getBaseIndexId());
        for (MaterializedIndex rollup : rollups) {
            HashSet rollupColumns = Sets.newHashSet();
            this.table.getSchemaByIndexId(rollup.getId(), true).stream().forEach(column -> rollupColumns.add(column.getName()));
            if (rollupColumns.containsAll(outputColumns)) {
                if (isPreAggregation) {
                    LOG.debug("preAggregation is on. add index {} which contains all output columns", (Object)rollup.getId());
                    rollupsContainsOutput.add(rollup);
                    continue;
                }
                if (this.table.getKeyColumnsByIndexId(rollup.getId()).size() != baseTableColumns.size()) continue;
                LOG.debug("preAggregation is off, but index {} have same key columns with base index.", (Object)rollup.getId());
                rollupsContainsOutput.add(rollup);
                continue;
            }
            LOG.debug("exclude index {} because it does not contain all output columns", (Object)rollup.getId());
        }
        Preconditions.checkArgument((rollupsContainsOutput.size() > 0 ? 1 : 0) != 0, (Object)"Can't find candicate rollup contains all output columns.");
        HashSet equivalenceColumns = Sets.newHashSet();
        HashSet unequivalenceColumns = Sets.newHashSet();
        this.collectColumns(conjuncts, equivalenceColumns, unequivalenceColumns);
        ArrayList rollupsMatchingBestPrefixIndex = Lists.newArrayList();
        this.matchPrefixIndex(rollupsContainsOutput, rollupsMatchingBestPrefixIndex, equivalenceColumns, unequivalenceColumns);
        if (rollupsMatchingBestPrefixIndex.isEmpty()) {
            rollupsContainsOutput.stream().forEach(n -> rollupsMatchingBestPrefixIndex.add(n.getId()));
        }
        Collections.sort(rollupsMatchingBestPrefixIndex, new Comparator<Long>(){

            @Override
            public int compare(Long id1, Long id2) {
                return (int)(id1 - id2);
            }
        });
        return rollupsMatchingBestPrefixIndex;
    }

    private void matchPrefixIndex(List<MaterializedIndex> candidateRollups, List<Long> rollupsMatchingBestPrefixIndex, Set<String> equivalenceColumns, Set<String> unequivalenceColumns) {
        if (equivalenceColumns.size() == 0 && unequivalenceColumns.size() == 0) {
            return;
        }
        int maxPrefixMatchCount = 0;
        for (MaterializedIndex index : candidateRollups) {
            int prefixMatchCount = 0;
            for (Column col : this.table.getSchemaByIndexId(index.getId())) {
                if (equivalenceColumns.contains(col.getName())) {
                    ++prefixMatchCount;
                    continue;
                }
                if (!unequivalenceColumns.contains(col.getName())) break;
                ++prefixMatchCount;
                break;
            }
            if (prefixMatchCount == maxPrefixMatchCount) {
                LOG.debug("s3: find a equal prefix match index {}. match count: {}", (Object)index.getId(), (Object)prefixMatchCount);
                rollupsMatchingBestPrefixIndex.add(index.getId());
                continue;
            }
            if (prefixMatchCount <= maxPrefixMatchCount) continue;
            LOG.debug("s3: find a better prefix match index {}. match count: {}", (Object)index.getId(), (Object)prefixMatchCount);
            maxPrefixMatchCount = prefixMatchCount;
            rollupsMatchingBestPrefixIndex.clear();
            rollupsMatchingBestPrefixIndex.add(index.getId());
        }
    }

    private void collectColumns(List<Expr> conjuncts, Set<String> equivalenceColumns, Set<String> unequivalenceColumns) {
        block0: for (Expr expr : conjuncts) {
            if (!this.isPredicateUsedForPrefixIndex(expr, false)) continue;
            for (SlotDescriptor slot : this.tupleDesc.getMaterializedSlots()) {
                if (!expr.isBound(slot.getId())) continue;
                if (!this.isEquivalenceExpr(expr)) {
                    unequivalenceColumns.add(slot.getColumn().getName());
                    continue block0;
                }
                equivalenceColumns.add(slot.getColumn().getName());
                continue block0;
            }
        }
        List<Expr> eqJoinPredicate = this.analyzer.getEqJoinConjuncts(this.tupleDesc.getId());
        for (Expr expr : eqJoinPredicate) {
            if (!this.isPredicateUsedForPrefixIndex(expr, true)) continue;
            block3: for (SlotDescriptor slot : this.tupleDesc.getMaterializedSlots()) {
                for (int i = 0; i < 2; ++i) {
                    if (!((Expr)expr.getChild(i)).isBound(slot.getId())) continue;
                    equivalenceColumns.add(slot.getColumn().getName());
                    continue block3;
                }
            }
        }
    }

    private boolean isEquivalenceExpr(Expr expr) {
        BinaryPredicate predicate;
        if (expr instanceof InPredicate) {
            return true;
        }
        return expr instanceof BinaryPredicate && (predicate = (BinaryPredicate)expr).getOp().isEquivalence();
    }

    private boolean isPredicateUsedForPrefixIndex(Expr expr, boolean isJoinConjunct) {
        if (!(expr instanceof InPredicate) && !(expr instanceof BinaryPredicate)) {
            return false;
        }
        if (expr instanceof InPredicate) {
            return this.isInPredicateUsedForPrefixIndex((InPredicate)expr);
        }
        if (expr instanceof BinaryPredicate) {
            if (isJoinConjunct) {
                return this.isEqualJoinConjunctUsedForPrefixIndex((BinaryPredicate)expr);
            }
            return this.isBinaryPredicateUsedForPrefixIndex((BinaryPredicate)expr);
        }
        return true;
    }

    private boolean isEqualJoinConjunctUsedForPrefixIndex(BinaryPredicate expr) {
        Preconditions.checkArgument((boolean)expr.getOp().isEquivalence());
        if (expr.isAuxExpr()) {
            return false;
        }
        for (Expr child : expr.getChildren()) {
            for (SlotDescriptor slot : this.tupleDesc.getMaterializedSlots()) {
                if (!child.isBound(slot.getId()) || !this.isSlotRefNested(child)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBinaryPredicateUsedForPrefixIndex(BinaryPredicate expr) {
        if (expr.isAuxExpr() || expr.getOp().isUnequivalence()) {
            return false;
        }
        return this.isSlotRefNested((Expr)expr.getChild(0)) && ((Expr)expr.getChild(1)).isConstant() || this.isSlotRefNested((Expr)expr.getChild(1)) && ((Expr)expr.getChild(0)).isConstant();
    }

    private boolean isInPredicateUsedForPrefixIndex(InPredicate expr) {
        if (expr.isNotIn()) {
            return false;
        }
        return this.isSlotRefNested((Expr)expr.getChild(0)) && expr.isLiteralChildren();
    }

    private boolean isSlotRefNested(Expr expr) {
        while (expr instanceof CastExpr) {
            expr = (Expr)expr.getChild(0);
        }
        return expr instanceof SlotRef;
    }
}

