/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.analysis.OutFileClause;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.DataSink;
import org.apache.doris.planner.DataStreamSink;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TDataSink;
import org.apache.doris.thrift.TDataSinkType;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TResultFileSink;
import org.apache.doris.thrift.TResultFileSinkOptions;

public class ResultFileSink
extends DataSink {
    private PlanNodeId exchNodeId;
    private TResultFileSinkOptions fileSinkOptions;
    private String brokerName;
    private StorageBackend.StorageType storageType;
    private DataPartition outputPartition;
    private TupleId outputTupleId;

    public ResultFileSink(PlanNodeId exchNodeId, OutFileClause outFileClause) {
        this.exchNodeId = exchNodeId;
        this.fileSinkOptions = outFileClause.toSinkOptions();
        this.brokerName = outFileClause.getBrokerDesc() == null ? null : outFileClause.getBrokerDesc().getName();
        this.storageType = outFileClause.getBrokerDesc() == null ? StorageBackend.StorageType.LOCAL : outFileClause.getBrokerDesc().getStorageType();
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public StorageBackend.StorageType getStorageType() {
        return this.storageType;
    }

    public void setBrokerAddr(String ip, int port) {
        Preconditions.checkNotNull((Object)this.fileSinkOptions);
        this.fileSinkOptions.setBrokerAddresses((List)Lists.newArrayList((Object[])new TNetworkAddress[]{new TNetworkAddress(ip, port)}));
    }

    public void resetByDataStreamSink(DataStreamSink dataStreamSink) {
        this.exchNodeId = dataStreamSink.getExchNodeId();
        this.outputPartition = dataStreamSink.getOutputPartition();
    }

    public void setOutputTupleId(TupleId tupleId) {
        this.outputTupleId = tupleId;
    }

    @Override
    public String getExplainString(String prefix, TExplainLevel explainLevel) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(prefix);
        strBuilder.append("RESULT FILE SINK\n");
        strBuilder.append("  FILE PATH: " + this.fileSinkOptions.getFilePath() + "\n");
        strBuilder.append("  STORAGE TYPE: " + this.storageType.name() + "\n");
        switch (this.storageType) {
            case BROKER: {
                strBuilder.append("  broker name: " + this.brokerName + "\n");
                break;
            }
        }
        return strBuilder.toString();
    }

    @Override
    protected TDataSink toThrift() {
        TDataSink result = new TDataSink(TDataSinkType.RESULT_FILE_SINK);
        TResultFileSink tResultFileSink = new TResultFileSink();
        tResultFileSink.setFileOptions(this.fileSinkOptions);
        tResultFileSink.setStorageBackendType(this.storageType.toThrift());
        tResultFileSink.setDestNodeId(this.exchNodeId.asInt());
        if (this.outputTupleId != null) {
            tResultFileSink.setOutputTupleId(this.outputTupleId.asInt());
        }
        result.setResultFileSink(tResultFileSink);
        return result;
    }

    @Override
    public PlanNodeId getExchNodeId() {
        return this.exchNodeId;
    }

    @Override
    public DataPartition getOutputPartition() {
        return this.outputPartition;
    }
}

