/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.GroupByClause;
import org.apache.doris.analysis.GroupingFunctionCallExpr;
import org.apache.doris.analysis.GroupingInfo;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.analysis.VirtualSlotRef;
import org.apache.doris.common.UserException;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.doris.thrift.TRepeatNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RepeatNode
extends PlanNode {
    private static final Logger LOG = LogManager.getLogger(RepeatNode.class);
    private List<Set<Integer>> repeatSlotIdList;
    private Set<Integer> allSlotId;
    private TupleDescriptor outputTupleDesc;
    private List<List<Long>> groupingList;
    private GroupingInfo groupingInfo;
    private PlanNode input;
    private GroupByClause groupByClause;

    protected RepeatNode(PlanNodeId id, PlanNode input, GroupingInfo groupingInfo, GroupByClause groupByClause) {
        super(id, input.getTupleIds(), "REPEAT_NODE");
        this.children.add(input);
        this.groupingInfo = groupingInfo;
        this.input = input;
        this.groupByClause = groupByClause;
    }

    protected RepeatNode(PlanNodeId id, PlanNode input, List<Set<SlotId>> repeatSlotIdList, TupleDescriptor outputTupleDesc, List<List<Long>> groupingList) {
        super(id, input.getTupleIds(), "REPEAT_NODE");
        this.children.add(input);
        this.repeatSlotIdList = RepeatNode.buildIdSetList(repeatSlotIdList);
        this.groupingList = groupingList;
        this.outputTupleDesc = outputTupleDesc;
        this.tupleIds.add(outputTupleDesc.getId());
    }

    private static List<Set<Integer>> buildIdSetList(List<Set<SlotId>> repeatSlotIdList) {
        ArrayList<Set<Integer>> slotIdList = new ArrayList<Set<Integer>>();
        for (Set<SlotId> slotSet : repeatSlotIdList) {
            HashSet<Integer> intSet = new HashSet<Integer>();
            for (SlotId slotId : slotSet) {
                intSet.add(slotId.asInt());
            }
            slotIdList.add(intSet);
        }
        return slotIdList;
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        this.avgRowSize = 0.0f;
        this.numNodes = 1;
        this.cardinality = 0L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("stats Sort: cardinality=" + this.cardinality);
        }
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        Preconditions.checkState((boolean)this.conjuncts.isEmpty());
        this.groupByClause.substituteGroupingExprs(this.groupingInfo.getGroupingSlots(), this.input.getOutputSmap(), analyzer);
        for (Expr expr : this.groupByClause.getGroupingExprs()) {
            if (!(expr instanceof SlotRef) && !(expr instanceof GroupingFunctionCallExpr)) continue;
        }
        HashSet<SlotDescriptor> slotDescSet = new HashSet<SlotDescriptor>();
        for (TupleId tupleId : this.input.getTupleIds()) {
            TupleDescriptor tupleDescriptor = analyzer.getDescTbl().getTupleDesc(tupleId);
            slotDescSet.addAll(tupleDescriptor.getSlots());
        }
        this.outputTupleDesc = this.groupingInfo.getVirtualTuple();
        for (Expr slot : this.groupByClause.getGroupingExprs()) {
            if (!(slot instanceof SlotRef) || slot instanceof VirtualSlotRef) continue;
            ((SlotRef)slot).getDesc().setIsNullable(true);
        }
        this.outputTupleDesc.computeStatAndMemLayout();
        ArrayList<Set<SlotId>> arrayList = new ArrayList<Set<SlotId>>();
        ArrayList<Expr> exprList = this.groupByClause.getGroupingExprs();
        Preconditions.checkState((exprList.size() >= 2 ? 1 : 0) != 0);
        this.allSlotId = new HashSet<Integer>();
        for (BitSet bitSet : Collections.unmodifiableList(this.groupingInfo.getGroupingIdList())) {
            HashSet<SlotId> slotIdSet = new HashSet<SlotId>();
            block4: for (SlotDescriptor slotDesc : slotDescSet) {
                SlotId slotId = slotDesc.getId();
                if (slotId == null) continue;
                block5: for (int i = 0; i < exprList.size(); ++i) {
                    if (exprList.get(i) instanceof SlotRef) {
                        SlotRef slotRef = (SlotRef)exprList.get(i);
                        if (!bitSet.get(i) || slotRef.getSlotId() != slotId) continue;
                        slotIdSet.add(slotId);
                        continue block4;
                    }
                    if (!(exprList.get(i) instanceof FunctionCallExpr)) continue;
                    List<SlotRef> slotRefs = this.getSlotRefChildren((Expr)exprList.get(i));
                    for (SlotRef slotRef : slotRefs) {
                        if (!bitSet.get(i) || slotRef.getSlotId() != slotId) continue;
                        slotIdSet.add(slotId);
                        continue block5;
                    }
                }
            }
            arrayList.add(slotIdSet);
        }
        this.repeatSlotIdList = RepeatNode.buildIdSetList(arrayList);
        for (Set set : this.repeatSlotIdList) {
            this.allSlotId.addAll(set);
        }
        this.groupingList = this.groupingInfo.genGroupingList(this.groupByClause.getGroupingExprs());
        this.tupleIds.add(this.outputTupleDesc.getId());
        for (TupleId tupleId : this.tupleIds) {
            analyzer.getTupleDesc(tupleId).setIsMaterialized(true);
        }
        this.computeTupleStatAndMemLayout(analyzer);
        this.computeStats(analyzer);
        this.createDefaultSmap(analyzer);
    }

    private List<SlotRef> getSlotRefChildren(Expr root) {
        ArrayList<SlotRef> result = new ArrayList<SlotRef>();
        for (Expr child : root.getChildren()) {
            if (child instanceof SlotRef) {
                result.add((SlotRef)child);
                continue;
            }
            result.addAll(this.getSlotRefChildren(child));
        }
        return result;
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.REPEAT_NODE;
        msg.repeat_node = new TRepeatNode(this.outputTupleDesc.getId().asInt(), this.repeatSlotIdList, this.groupingList.get(0), this.groupingList, this.allSlotId);
    }

    @Override
    protected String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("Repeat", this.repeatSlotIdList.size()).addValue((Object)super.debugString()).toString();
    }

    @Override
    public String getNodeExplainString(String detailPrefix, TExplainLevel detailLevel) {
        if (detailLevel == TExplainLevel.BRIEF) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        output.append(detailPrefix + "repeat: repeat ");
        output.append(this.repeatSlotIdList.size() - 1);
        output.append(" lines ");
        output.append(this.repeatSlotIdList);
        output.append("\n");
        if (CollectionUtils.isNotEmpty(this.outputTupleDesc.getSlots())) {
            output.append(detailPrefix + "generate: ");
            output.append(this.outputTupleDesc.getSlots().stream().map(slot -> "`" + slot.getColumn().getName() + "`").collect(Collectors.joining(", ")) + "\n");
        }
        return output.toString();
    }

    @Override
    public int getNumInstances() {
        return ((PlanNode)this.children.get(0)).getNumInstances();
    }
}

