/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeRangeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.planner.ColumnBound;
import org.apache.doris.planner.ColumnRange;
import org.apache.doris.planner.PartitionPrunerV2Base;

public class RangePartitionPrunerV2
extends PartitionPrunerV2Base {
    public RangePartitionPrunerV2(Map<Long, PartitionItem> idToPartitionItem, List<Column> partitionColumns, Map<String, ColumnRange> columnNameToRange) {
        super(idToPartitionItem, partitionColumns, columnNameToRange);
    }

    @Override
    RangeMap<ColumnBound, PartitionPrunerV2Base.UniqueId> getCandidateRangeMap() {
        TreeRangeMap candidate = TreeRangeMap.create();
        this.idToPartitionItem.forEach((arg_0, arg_1) -> this.lambda$getCandidateRangeMap$0((RangeMap)candidate, arg_0, arg_1));
        return candidate;
    }

    @Override
    Collection<Long> pruneMultipleColumnPartition(Map<Column, PartitionPrunerV2Base.FinalFilters> columnToFilters) throws AnalysisException {
        PartitionKey minKey = new PartitionKey();
        PartitionKey maxKey = new PartitionKey();
        TreeRangeMap rangeMap = TreeRangeMap.create();
        this.idToPartitionItem.forEach((arg_0, arg_1) -> RangePartitionPrunerV2.lambda$pruneMultipleColumnPartition$1((RangeMap)rangeMap, arg_0, arg_1));
        return this.doPruneMulti(columnToFilters, (RangeMap<PartitionKey, Long>)rangeMap, 0, minKey, maxKey);
    }

    @Override
    PartitionPrunerV2Base.FinalFilters getFinalFilters(ColumnRange columnRange, Column column) throws AnalysisException {
        if (!columnRange.hasFilter()) {
            return PartitionPrunerV2Base.FinalFilters.noFilters();
        }
        Optional<RangeSet<ColumnBound>> rangeSetOpt = columnRange.getRangeSet();
        if (columnRange.hasConjunctiveIsNull()) {
            if (!rangeSetOpt.isPresent()) {
                return PartitionPrunerV2Base.FinalFilters.create(Sets.newHashSet((Object[])new Range[]{this.getMinInfinityRange(column)}));
            }
            return PartitionPrunerV2Base.FinalFilters.constantFalseFilters();
        }
        if (columnRange.hasDisjunctiveIsNull()) {
            if (rangeSetOpt.isPresent() && !rangeSetOpt.get().isEmpty()) {
                RangeSet<ColumnBound> rangeSet = rangeSetOpt.get();
                rangeSet.add(this.getMinInfinityRange(column));
                return PartitionPrunerV2Base.FinalFilters.create(rangeSet.asRanges());
            }
            return PartitionPrunerV2Base.FinalFilters.create(Sets.newHashSet((Object[])new Range[]{this.getMinInfinityRange(column)}));
        }
        if (rangeSetOpt.isPresent()) {
            RangeSet<ColumnBound> rangeSet = rangeSetOpt.get();
            if (rangeSet.isEmpty()) {
                return PartitionPrunerV2Base.FinalFilters.constantFalseFilters();
            }
            return PartitionPrunerV2Base.FinalFilters.create(rangeSet.asRanges());
        }
        return PartitionPrunerV2Base.FinalFilters.noFilters();
    }

    private Range<ColumnBound> getMinInfinityRange(Column column) throws AnalysisException {
        ColumnBound value = ColumnBound.of(LiteralExpr.createInfinity(Type.fromPrimitiveType(column.getDataType()), false));
        return Range.closed((Comparable)value, (Comparable)value);
    }

    private Collection<Long> doPruneMulti(Map<Column, PartitionPrunerV2Base.FinalFilters> columnToFilters, RangeMap<PartitionKey, Long> rangeMap, int columnIdx, PartitionKey minKey, PartitionKey maxKey) throws AnalysisException {
        if (columnIdx == this.partitionColumns.size()) {
            try {
                return Lists.newArrayList(rangeMap.subRangeMap(Range.closed((Comparable)minKey, (Comparable)maxKey)).asMapOfRanges().values());
            }
            catch (IllegalArgumentException e) {
                return Lists.newArrayList();
            }
        }
        Column column = (Column)this.partitionColumns.get(columnIdx);
        PartitionPrunerV2Base.FinalFilters finalFilters = columnToFilters.get(column);
        switch (finalFilters.type) {
            case HAVE_FILTERS: {
                Set<Range<ColumnBound>> filters = finalFilters.filters;
                HashSet result = Sets.newHashSet();
                for (Range<ColumnBound> filter : filters) {
                    if (filter.hasLowerBound() && filter.lowerBoundType() == BoundType.CLOSED && filter.hasUpperBound() && filter.upperBoundType() == BoundType.CLOSED && filter.lowerEndpoint() == filter.upperEndpoint()) {
                        minKey.pushColumn(((ColumnBound)filter.lowerEndpoint()).getValue(), column.getDataType());
                        maxKey.pushColumn(((ColumnBound)filter.upperEndpoint()).getValue(), column.getDataType());
                        result.addAll(this.doPruneMulti(columnToFilters, rangeMap, columnIdx + 1, minKey, maxKey));
                        minKey.popColumn();
                        maxKey.popColumn();
                        continue;
                    }
                    int lastColumnId = this.partitionColumns.size() - 1;
                    int pushMinCount = 0;
                    int pushMaxCount = 0;
                    if (filter.hasLowerBound()) {
                        minKey.pushColumn(((ColumnBound)filter.lowerEndpoint()).getValue(), column.getDataType());
                        ++pushMinCount;
                        if (filter.lowerBoundType() == BoundType.CLOSED && columnIdx != lastColumnId) {
                            this.pushInfinity(minKey, columnIdx + 1, false);
                            ++pushMinCount;
                        }
                    } else {
                        this.pushInfinity(minKey, columnIdx, false);
                        ++pushMinCount;
                    }
                    if (filter.hasUpperBound()) {
                        maxKey.pushColumn(((ColumnBound)filter.upperEndpoint()).getValue(), column.getDataType());
                        ++pushMaxCount;
                        if (filter.upperBoundType() == BoundType.CLOSED && columnIdx != lastColumnId) {
                            this.pushInfinity(maxKey, columnIdx + 1, true);
                            ++pushMaxCount;
                        }
                    } else {
                        this.pushInfinity(maxKey, columnIdx, true);
                        ++pushMaxCount;
                    }
                    try {
                        BoundType lowerType = filter.hasLowerBound() && filter.lowerBoundType() == BoundType.CLOSED ? BoundType.CLOSED : BoundType.OPEN;
                        BoundType upperType = filter.hasUpperBound() && filter.upperBoundType() == BoundType.CLOSED ? BoundType.CLOSED : BoundType.OPEN;
                        result.addAll(rangeMap.subRangeMap(Range.range((Comparable)minKey, (BoundType)lowerType, (Comparable)maxKey, (BoundType)upperType)).asMapOfRanges().values());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    while (pushMinCount > 0) {
                        minKey.popColumn();
                        --pushMinCount;
                    }
                    while (pushMaxCount > 0) {
                        maxKey.popColumn();
                        --pushMaxCount;
                    }
                }
                return result;
            }
            case CONSTANT_FALSE_FILTERS: {
                return Collections.emptyList();
            }
        }
        return this.noFiltersResult(minKey, maxKey, columnIdx, rangeMap);
    }

    private void pushInfinity(PartitionKey key, int columnIdx, boolean isMax) throws AnalysisException {
        Column column = (Column)this.partitionColumns.get(columnIdx);
        key.pushColumn(LiteralExpr.createInfinity(Type.fromPrimitiveType(column.getDataType()), isMax), column.getDataType());
    }

    private Collection<Long> noFiltersResult(PartitionKey minKey, PartitionKey maxKey, int columnIdx, RangeMap<PartitionKey, Long> rangeMap) throws AnalysisException {
        ArrayList result;
        this.pushInfinity(minKey, columnIdx, false);
        this.pushInfinity(maxKey, columnIdx, true);
        try {
            result = Lists.newArrayList(rangeMap.subRangeMap(Range.closed((Comparable)minKey, (Comparable)maxKey)).asMapOfRanges().values());
        }
        catch (IllegalArgumentException e) {
            result = Lists.newArrayList();
        }
        minKey.popColumn();
        maxKey.popColumn();
        return result;
    }

    private static /* synthetic */ void lambda$pruneMultipleColumnPartition$1(RangeMap rangeMap, Long id, PartitionItem item) {
        rangeMap.put((Range)item.getItems(), (Object)id);
    }

    private /* synthetic */ void lambda$getCandidateRangeMap$0(RangeMap candidate, Long id, PartitionItem item) {
        Range range = (Range)item.getItems();
        candidate.put(this.mapPartitionKeyRange((Range<PartitionKey>)range, 0), (Object)new RangePartitionUniqueId(id));
    }

    private static class RangePartitionUniqueId
    implements PartitionPrunerV2Base.UniqueId {
        private final long partitionId;

        public RangePartitionUniqueId(long partitionId) {
            this.partitionId = partitionId;
        }

        @Override
        public long getPartitionId() {
            return this.partitionId;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partitionId", this.partitionId).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RangePartitionUniqueId that = (RangePartitionUniqueId)o;
            return this.partitionId == that.partitionId;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.partitionId});
        }
    }
}

