/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeRangeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.planner.PartitionColumnFilter;
import org.apache.doris.planner.PartitionPruner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RangePartitionPruner
implements PartitionPruner {
    private static final Logger LOG = LogManager.getLogger(RangePartitionPruner.class);
    private Map<Long, PartitionItem> partitionRangeMap;
    private List<Column> partitionColumns;
    private Map<String, PartitionColumnFilter> partitionColumnFilters;

    public RangePartitionPruner(Map<Long, PartitionItem> rangeMap, List<Column> columns, Map<String, PartitionColumnFilter> filters) {
        this.partitionRangeMap = rangeMap;
        this.partitionColumns = columns;
        this.partitionColumnFilters = filters;
    }

    private Collection<Long> prune(RangeMap<PartitionKey, Long> rangeMap, int columnIdx, PartitionKey minKey, PartitionKey maxKey, int complex) throws AnalysisException {
        LOG.debug("column idx {}, column filters {}", (Object)columnIdx, this.partitionColumnFilters);
        if (columnIdx == this.partitionColumns.size()) {
            try {
                return Lists.newArrayList(rangeMap.subRangeMap(Range.closed((Comparable)minKey, (Comparable)maxKey)).asMapOfRanges().values());
            }
            catch (IllegalArgumentException e) {
                return Lists.newArrayList();
            }
        }
        Column keyColumn = this.partitionColumns.get(columnIdx);
        PartitionColumnFilter filter = this.partitionColumnFilters.get(keyColumn.getName());
        if (null == filter) {
            minKey.pushColumn(LiteralExpr.createInfinity(Type.fromPrimitiveType(keyColumn.getDataType()), false), keyColumn.getDataType());
            maxKey.pushColumn(LiteralExpr.createInfinity(Type.fromPrimitiveType(keyColumn.getDataType()), true), keyColumn.getDataType());
            ArrayList result = null;
            try {
                result = Lists.newArrayList(rangeMap.subRangeMap(Range.closed((Comparable)minKey, (Comparable)maxKey)).asMapOfRanges().values());
            }
            catch (IllegalArgumentException e) {
                result = Lists.newArrayList();
            }
            minKey.popColumn();
            maxKey.popColumn();
            return result;
        }
        InPredicate inPredicate = filter.getInPredicate();
        if (null == inPredicate || inPredicate.getChildren().size() * complex > 100) {
            Column column;
            if (filter.lowerBoundInclusive && filter.upperBoundInclusive && filter.lowerBound != null && filter.upperBound != null && 0 == filter.lowerBound.compareLiteral(filter.upperBound)) {
                if (filter.lowerBound instanceof NullLiteral && filter.upperBound instanceof NullLiteral) {
                    LiteralExpr minKeyValue = LiteralExpr.createInfinity(Type.fromPrimitiveType(keyColumn.getDataType()), false);
                    minKey.pushColumn(minKeyValue, keyColumn.getDataType());
                    maxKey.pushColumn(minKeyValue, keyColumn.getDataType());
                } else {
                    minKey.pushColumn(filter.lowerBound, keyColumn.getDataType());
                    maxKey.pushColumn(filter.upperBound, keyColumn.getDataType());
                }
                Collection<Long> result = this.prune(rangeMap, columnIdx + 1, minKey, maxKey, complex);
                minKey.popColumn();
                maxKey.popColumn();
                return result;
            }
            BoundType lowerType = filter.lowerBoundInclusive ? BoundType.CLOSED : BoundType.OPEN;
            BoundType upperType = filter.upperBoundInclusive ? BoundType.CLOSED : BoundType.OPEN;
            int pushMinCount = 0;
            int pushMaxCount = 0;
            int lastColumnId = this.partitionColumns.size() - 1;
            if (filter.lowerBound != null) {
                minKey.pushColumn(filter.lowerBound, keyColumn.getDataType());
                ++pushMinCount;
                if (filter.lowerBoundInclusive && columnIdx != lastColumnId) {
                    column = this.partitionColumns.get(columnIdx + 1);
                    Type type = Type.fromPrimitiveType(column.getDataType());
                    minKey.pushColumn(LiteralExpr.createInfinity(type, false), column.getDataType());
                    ++pushMinCount;
                }
            } else {
                Type type = Type.fromPrimitiveType(keyColumn.getDataType());
                minKey.pushColumn(LiteralExpr.createInfinity(type, false), keyColumn.getDataType());
                ++pushMinCount;
            }
            if (filter.upperBound != null) {
                maxKey.pushColumn(filter.upperBound, keyColumn.getDataType());
                ++pushMaxCount;
                if (filter.upperBoundInclusive && columnIdx != lastColumnId) {
                    column = this.partitionColumns.get(columnIdx + 1);
                    maxKey.pushColumn(LiteralExpr.createInfinity(Type.fromPrimitiveType(column.getDataType()), true), column.getDataType());
                    ++pushMaxCount;
                }
            } else {
                maxKey.pushColumn(LiteralExpr.createInfinity(Type.fromPrimitiveType(keyColumn.getDataType()), true), keyColumn.getDataType());
                ++pushMaxCount;
            }
            ArrayList result = null;
            try {
                result = Lists.newArrayList(rangeMap.subRangeMap(Range.range((Comparable)minKey, (BoundType)lowerType, (Comparable)maxKey, (BoundType)upperType)).asMapOfRanges().values());
            }
            catch (IllegalArgumentException e) {
                result = Lists.newArrayList();
            }
            while (pushMinCount > 0) {
                minKey.popColumn();
                --pushMinCount;
            }
            while (pushMaxCount > 0) {
                maxKey.popColumn();
                --pushMaxCount;
            }
            return result;
        }
        HashSet resultSet = Sets.newHashSet();
        int childrenNum = inPredicate.getChildren().size();
        int newComplex = inPredicate.getChildren().size() * complex;
        for (int i = 1; i < childrenNum; ++i) {
            LiteralExpr expr = (LiteralExpr)inPredicate.getChild(i);
            minKey.pushColumn(expr, keyColumn.getDataType());
            maxKey.pushColumn(expr, keyColumn.getDataType());
            Collection<Long> subList = this.prune(rangeMap, columnIdx + 1, minKey, maxKey, newComplex);
            for (long partId : subList) {
                resultSet.add(partId);
            }
            minKey.popColumn();
            maxKey.popColumn();
        }
        return resultSet;
    }

    @Override
    public Collection<Long> prune() throws AnalysisException {
        PartitionKey minKey = new PartitionKey();
        PartitionKey maxKey = new PartitionKey();
        TreeRangeMap rangeMap = TreeRangeMap.create();
        for (Map.Entry<Long, PartitionItem> entry : this.partitionRangeMap.entrySet()) {
            rangeMap.put((Range)entry.getValue().getItems(), (Object)entry.getKey());
        }
        return this.prune((RangeMap<PartitionKey, Long>)rangeMap, 0, minKey, maxKey, 1);
    }
}

