/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.common.NotImplementedException;
import org.apache.doris.planner.PlanNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProjectPlanner {
    private static final Logger LOG = LogManager.getLogger(PlanNode.class);
    private Analyzer analyzer;

    public ProjectPlanner(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void projectSingleNodePlan(List<Expr> resultExprs, PlanNode root) {
        Set<SlotId> resultSlotIds = this.getSlotIds(resultExprs, root);
        this.projectPlanNode(resultSlotIds, root);
    }

    public void projectPlanNode(Set<SlotId> outputSlotIds, PlanNode planNode) {
        try {
            planNode.initOutputSlotIds(outputSlotIds, this.analyzer);
            planNode.projectOutputTuple();
        }
        catch (NotImplementedException e) {
            LOG.debug((Object)e);
        }
        if (planNode.getChildren().size() == 0) {
            return;
        }
        Set<SlotId> inputSlotIds = null;
        try {
            inputSlotIds = planNode.computeInputSlotIds(this.analyzer);
        }
        catch (NotImplementedException e) {
            LOG.debug((Object)e);
        }
        for (PlanNode child : planNode.getChildren()) {
            this.projectPlanNode(inputSlotIds, child);
        }
    }

    private Set<SlotId> getSlotIds(List<Expr> resultExprs, PlanNode root) {
        ArrayList<Expr> resExprs = Expr.substituteList(resultExprs, root.getOutputSmap(), this.analyzer, false);
        HashSet result = Sets.newHashSet();
        for (Expr expr : resExprs) {
            ArrayList slotIdList = Lists.newArrayList();
            expr.getIds(null, slotIdList);
            result.addAll(slotIdList);
        }
        return result;
    }
}

