/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.util.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.JoinOperator;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.common.Pair;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.ScanNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PredicatePushDown {
    private static final Logger LOG = LogManager.getLogger(PredicatePushDown.class);

    public static PlanNode visitScanNode(ScanNode scanNode, JoinOperator joinOp, Analyzer analyzer) {
        switch (joinOp) {
            case INNER_JOIN: 
            case LEFT_OUTER_JOIN: {
                PredicatePushDown.predicateFromLeftSidePropagatesToRightSide(scanNode, analyzer);
                break;
            }
        }
        return scanNode;
    }

    private static void predicateFromLeftSidePropagatesToRightSide(ScanNode scanNode, Analyzer analyzer) {
        ArrayList<TupleId> tupleIdList = scanNode.getTupleIds();
        if (tupleIdList.size() != 1) {
            LOG.info("The predicate pushdown is not reflected because the scan node involves more then one tuple:{}", (Object)Strings.listToString(tupleIdList));
            return;
        }
        TupleId rightSideTuple = (TupleId)tupleIdList.get(0);
        List<Expr> unassignedRightSideConjuncts = analyzer.getUnassignedConjuncts(scanNode);
        List<Expr> eqJoinPredicates = analyzer.getEqJoinConjuncts(rightSideTuple);
        if (eqJoinPredicates != null) {
            List<Expr> allConjuncts = analyzer.getConjuncts(analyzer.getAllTupleIds());
            allConjuncts.removeAll(unassignedRightSideConjuncts);
            for (Expr conjunct : allConjuncts) {
                if (!Predicate.canPushDownPredicate(conjunct)) continue;
                for (Expr eqJoinPredicate : eqJoinPredicates) {
                    Expr pushDownConjunct;
                    SlotRef otherSlot = ((Expr)conjunct.getChild(0)).unwrapSlotRef();
                    if (((Expr)eqJoinPredicate.getChild(0)).unwrapSlotRef() == null || ((Expr)eqJoinPredicate.getChild(1)).unwrapSlotRef() == null) continue;
                    SlotRef leftSlot = ((Expr)eqJoinPredicate.getChild(0)).unwrapSlotRef();
                    SlotRef rightSlot = ((Expr)eqJoinPredicate.getChild(1)).unwrapSlotRef();
                    if (!leftSlot.getDesc().getType().matchesType(rightSlot.getDesc().getType())) continue;
                    if (otherSlot.isBound(leftSlot.getSlotId()) && rightSlot.isBound(rightSideTuple)) {
                        pushDownConjunct = PredicatePushDown.rewritePredicate(analyzer, conjunct, rightSlot);
                        LOG.debug("pushDownConjunct: {}", (Object)pushDownConjunct);
                        if (analyzer.getGlobalInDeDuplication().contains(pushDownConjunct) || analyzer.getGlobalSlotToLiteralDeDuplication().contains(new Pair<Expr, Expr>((Expr)pushDownConjunct.getChild(0), (Expr)pushDownConjunct.getChild(1)))) continue;
                        scanNode.addConjunct(pushDownConjunct);
                        continue;
                    }
                    if (!otherSlot.isBound(rightSlot.getSlotId()) || !leftSlot.isBound(rightSideTuple)) continue;
                    pushDownConjunct = PredicatePushDown.rewritePredicate(analyzer, conjunct, leftSlot);
                    LOG.debug("pushDownConjunct: {}", (Object)pushDownConjunct);
                    if (analyzer.getGlobalInDeDuplication().contains(pushDownConjunct) || analyzer.getGlobalSlotToLiteralDeDuplication().contains(new Pair<Expr, Expr>((Expr)pushDownConjunct.getChild(0), (Expr)pushDownConjunct.getChild(1)))) continue;
                    scanNode.addConjunct(pushDownConjunct);
                }
            }
        }
    }

    private static Expr rewritePredicate(Analyzer analyzer, Expr oldPredicate, Expr leftChild) {
        if (oldPredicate instanceof BinaryPredicate) {
            BinaryPredicate oldBP = (BinaryPredicate)oldPredicate;
            BinaryPredicate bp = new BinaryPredicate(oldBP.getOp(), leftChild, (Expr)oldBP.getChild(1));
            bp.analyzeNoThrow(analyzer);
            return bp;
        }
        if (oldPredicate instanceof InPredicate) {
            InPredicate oldIP = (InPredicate)oldPredicate;
            InPredicate ip = new InPredicate(leftChild, oldIP.getListChildren(), oldIP.isNotIn());
            ip.analyzeNoThrow(analyzer);
            return ip;
        }
        return oldPredicate;
    }
}

