/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.InsertStmt;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.StatementBase;
import org.apache.doris.common.IdGenerator;
import org.apache.doris.planner.PlanFragmentId;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TQueryOptions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlannerContext {
    private static final Logger LOG = LogManager.getLogger(PlannerContext.class);
    public static final double HASH_TBL_SPACE_OVERHEAD = 1.1;
    private final IdGenerator<PlanNodeId> nodeIdGenerator_ = PlanNodeId.createGenerator();
    private final IdGenerator<PlanFragmentId> fragmentIdGenerator_ = PlanFragmentId.createGenerator();
    private final Analyzer analyzer_;
    private final TQueryOptions queryOptions_;
    private final QueryStmt queryStmt_;
    private final StatementBase statement_;

    public PlannerContext(Analyzer analyzer, QueryStmt queryStmt, TQueryOptions queryOptions, StatementBase statement) {
        this.analyzer_ = analyzer;
        this.queryStmt_ = queryStmt;
        this.queryOptions_ = queryOptions;
        this.statement_ = statement;
    }

    public QueryStmt getQueryStmt() {
        return this.queryStmt_;
    }

    public TQueryOptions getQueryOptions() {
        return this.queryOptions_;
    }

    public Analyzer getRootAnalyzer() {
        return this.analyzer_;
    }

    public boolean isSingleNodeExec() {
        return this.getQueryOptions().num_nodes == 1;
    }

    public PlanNodeId getNextNodeId() {
        return this.nodeIdGenerator_.getNextId();
    }

    public PlanFragmentId getNextFragmentId() {
        return this.fragmentIdGenerator_.getNextId();
    }

    public boolean isInsert() {
        return this.statement_ instanceof InsertStmt;
    }
}

