/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ExplainOptions;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InsertStmt;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.StatementBase;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.UserException;
import org.apache.doris.common.profile.PlanTreeBuilder;
import org.apache.doris.common.profile.PlanTreePrinter;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.DataStreamSink;
import org.apache.doris.planner.DistributedPlanner;
import org.apache.doris.planner.ExchangeNode;
import org.apache.doris.planner.PlanFragment;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlannerContext;
import org.apache.doris.planner.ResultFileSink;
import org.apache.doris.planner.ResultSink;
import org.apache.doris.planner.RuntimeFilterGenerator;
import org.apache.doris.planner.ScanNode;
import org.apache.doris.planner.SelectNode;
import org.apache.doris.planner.SingleNodePlanner;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.rewrite.mvrewrite.MVSelectFailedException;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TQueryOptions;
import org.apache.doris.thrift.TRuntimeFilterMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Planner {
    private static final Logger LOG = LogManager.getLogger(Planner.class);
    private boolean isBlockQuery = false;
    protected ArrayList<PlanFragment> fragments = Lists.newArrayList();
    private PlannerContext plannerContext;
    private SingleNodePlanner singleNodePlanner;
    private DistributedPlanner distributedPlanner;

    public boolean isBlockQuery() {
        return this.isBlockQuery;
    }

    public List<PlanFragment> getFragments() {
        return this.fragments;
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    public List<ScanNode> getScanNodes() {
        if (this.singleNodePlanner == null) {
            return Lists.newArrayList();
        }
        return this.singleNodePlanner.getScanNodes();
    }

    public void plan(StatementBase queryStmt, Analyzer analyzer, TQueryOptions queryOptions) throws UserException {
        this.createPlanFragments(queryStmt, analyzer, queryOptions);
    }

    private void setResultExprScale(Analyzer analyzer, ArrayList<Expr> outputExprs) {
        for (TupleDescriptor tupleDesc : analyzer.getDescTbl().getTupleDescs()) {
            for (SlotDescriptor slotDesc : tupleDesc.getSlots()) {
                for (Expr expr : outputExprs) {
                    int outputScale;
                    ArrayList slotList = Lists.newArrayList();
                    expr.getIds(null, slotList);
                    if (PrimitiveType.DECIMALV2 != expr.getType().getPrimitiveType() || PrimitiveType.DECIMALV2 != slotDesc.getType().getPrimitiveType() || !slotList.contains(slotDesc.getId()) || null == slotDesc.getColumn() || (outputScale = slotDesc.getColumn().getScale()) < 0 || outputScale <= expr.getOutputScale()) continue;
                    expr.setOutputScale(outputScale);
                }
            }
        }
    }

    public String getExplainString(List<PlanFragment> fragments, ExplainOptions explainOptions) {
        Preconditions.checkNotNull((Object)explainOptions);
        if (explainOptions.isGraph()) {
            PlanTreeBuilder builder = new PlanTreeBuilder(fragments);
            try {
                builder.build();
            }
            catch (UserException e) {
                LOG.warn("Failed to build explain plan tree", (Throwable)e);
                return e.getMessage();
            }
            return PlanTreePrinter.printPlanExplanation(builder.getTreeRoot());
        }
        TExplainLevel explainLevel = explainOptions.isVerbose() ? TExplainLevel.VERBOSE : TExplainLevel.NORMAL;
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < fragments.size(); ++i) {
            PlanFragment fragment = fragments.get(i);
            if (i > 0) {
                str.append("\n");
            }
            str.append("PLAN FRAGMENT " + i + "\n");
            str.append(fragment.getExplainString(explainLevel));
        }
        if (explainLevel == TExplainLevel.VERBOSE) {
            str.append(this.plannerContext.getRootAnalyzer().getDescTbl().getExplainString());
        }
        return str.toString();
    }

    public void createPlanFragments(StatementBase statement, Analyzer analyzer, TQueryOptions queryOptions) throws UserException {
        QueryStmt queryStmt = statement instanceof InsertStmt ? ((InsertStmt)statement).getQueryStmt() : (QueryStmt)statement;
        this.plannerContext = new PlannerContext(analyzer, queryStmt, queryOptions, statement);
        this.singleNodePlanner = new SingleNodePlanner(this.plannerContext);
        PlanNode singleNodePlan = this.singleNodePlanner.createSingleNodePlan();
        if (VectorizedUtil.isVectorized()) {
            singleNodePlan.convertToVectoriezd();
        }
        if (statement instanceof InsertStmt) {
            InsertStmt insertStmt = (InsertStmt)statement;
            insertStmt.prepareExpressions();
        }
        this.setResultExprScale(analyzer, (ArrayList<Expr>)queryStmt.getResultExprs());
        boolean selectFailed = this.singleNodePlanner.selectMaterializedView(queryStmt, analyzer);
        if (selectFailed) {
            throw new MVSelectFailedException("Failed to select materialize view");
        }
        analyzer.getDescTbl().computeMemLayout();
        singleNodePlan.finalize(analyzer);
        if (queryOptions.num_nodes == 1) {
            singleNodePlan = this.addUnassignedConjuncts(analyzer, singleNodePlan);
            this.fragments.add(new PlanFragment(this.plannerContext.getNextFragmentId(), singleNodePlan, DataPartition.UNPARTITIONED));
        } else {
            this.distributedPlanner = new DistributedPlanner(this.plannerContext);
            this.fragments = this.distributedPlanner.createPlanFragments(singleNodePlan);
        }
        PlanFragment rootFragment = this.fragments.get(this.fragments.size() - 1);
        QueryStatisticsTransferOptimizer queryStatisticTransferOptimizer = new QueryStatisticsTransferOptimizer(rootFragment);
        queryStatisticTransferOptimizer.optimizeQueryStatisticsTransfer();
        if (!ConnectContext.get().getSessionVariable().getRuntimeFilterMode().toUpperCase().equals(TRuntimeFilterMode.OFF.name())) {
            RuntimeFilterGenerator.generateRuntimeFilters(analyzer, rootFragment.getPlanRoot());
        }
        if (statement instanceof InsertStmt && !analyzer.getContext().isTxnModel()) {
            InsertStmt insertStmt = (InsertStmt)statement;
            rootFragment = this.distributedPlanner.createInsertFragment(rootFragment, insertStmt, this.fragments);
            rootFragment.setSink(insertStmt.getDataSink());
            insertStmt.complete();
            List exprs = ((InsertStmt)statement).getResultExprs();
            ArrayList<Expr> resExprs = Expr.substituteList(exprs, rootFragment.getPlanRoot().getOutputSmap(), analyzer, true);
            rootFragment.setOutputExprs(resExprs);
        } else {
            ArrayList<Expr> resExprs = Expr.substituteList(queryStmt.getResultExprs(), rootFragment.getPlanRoot().getOutputSmap(), analyzer, false);
            rootFragment.setOutputExprs(resExprs);
        }
        LOG.debug("finalize plan fragments");
        for (PlanFragment fragment : this.fragments) {
            fragment.finalize(queryStmt);
        }
        Collections.reverse(this.fragments);
        this.pushDownResultFileSink(analyzer);
        if (queryStmt instanceof SelectStmt) {
            SelectStmt selectStmt = (SelectStmt)queryStmt;
            if (queryStmt.getSortInfo() != null || selectStmt.getAggInfo() != null) {
                this.isBlockQuery = true;
                LOG.debug("this is block query");
            } else {
                this.isBlockQuery = false;
                LOG.debug("this isn't block query");
            }
        }
    }

    private PlanNode addUnassignedConjuncts(Analyzer analyzer, PlanNode root) throws UserException {
        Preconditions.checkNotNull((Object)root);
        List<Expr> conjuncts = analyzer.getUnassignedConjuncts(root);
        if (conjuncts.isEmpty()) {
            return root;
        }
        SelectNode selectNode = new SelectNode(this.plannerContext.getNextNodeId(), root, conjuncts);
        selectNode.init(analyzer);
        Preconditions.checkState((boolean)selectNode.hasValidStats());
        return selectNode;
    }

    private void pushDownResultFileSink(Analyzer analyzer) {
        if (this.fragments.size() < 1) {
            return;
        }
        if (!(this.fragments.get(0).getSink() instanceof ResultFileSink)) {
            return;
        }
        if (!ConnectContext.get().getSessionVariable().isEnableParallelOutfile()) {
            return;
        }
        if (!(this.fragments.get(0).getPlanRoot() instanceof ExchangeNode)) {
            return;
        }
        PlanFragment topPlanFragment = this.fragments.get(0);
        ExchangeNode topPlanNode = (ExchangeNode)topPlanFragment.getPlanRoot();
        if (topPlanNode.isMergingExchange()) {
            return;
        }
        PlanFragment secondPlanFragment = this.fragments.get(1);
        ResultFileSink resultFileSink = (ResultFileSink)topPlanFragment.getSink();
        if (resultFileSink.getStorageType() == StorageBackend.StorageType.BROKER) {
            return;
        }
        if (secondPlanFragment.getOutputExprs() != null) {
            return;
        }
        TupleDescriptor fileStatusDesc = this.constructFileStatusTupleDesc(analyzer);
        resultFileSink.resetByDataStreamSink((DataStreamSink)secondPlanFragment.getSink());
        resultFileSink.setOutputTupleId(fileStatusDesc.getId());
        secondPlanFragment.setOutputExprs(topPlanFragment.getOutputExprs());
        secondPlanFragment.resetSink(resultFileSink);
        ResultSink resultSink = new ResultSink(topPlanNode.getId());
        topPlanFragment.resetSink(resultSink);
        topPlanFragment.resetOutputExprs(fileStatusDesc);
        topPlanFragment.getPlanRoot().resetTupleIds(Lists.newArrayList((Object[])new TupleId[]{fileStatusDesc.getId()}));
    }

    private TupleDescriptor constructFileStatusTupleDesc(Analyzer analyzer) {
        TupleDescriptor resultFileStatusTupleDesc = analyzer.getDescTbl().createTupleDescriptor("result_file_status");
        resultFileStatusTupleDesc.setIsMaterialized(true);
        SlotDescriptor fileNumber = analyzer.getDescTbl().addSlotDescriptor(resultFileStatusTupleDesc);
        fileNumber.setLabel("FileNumber");
        fileNumber.setType(ScalarType.createType(PrimitiveType.INT));
        fileNumber.setIsMaterialized(true);
        fileNumber.setIsNullable(false);
        SlotDescriptor totalRows = analyzer.getDescTbl().addSlotDescriptor(resultFileStatusTupleDesc);
        totalRows.setLabel("TotalRows");
        totalRows.setType(ScalarType.createType(PrimitiveType.BIGINT));
        totalRows.setIsMaterialized(true);
        totalRows.setIsNullable(false);
        SlotDescriptor fileSize = analyzer.getDescTbl().addSlotDescriptor(resultFileStatusTupleDesc);
        fileSize.setLabel("FileSize");
        fileSize.setType(ScalarType.createType(PrimitiveType.BIGINT));
        fileSize.setIsMaterialized(true);
        fileSize.setIsNullable(false);
        SlotDescriptor url = analyzer.getDescTbl().addSlotDescriptor(resultFileStatusTupleDesc);
        url.setLabel("URL");
        url.setType(ScalarType.createType(PrimitiveType.VARCHAR));
        url.setIsMaterialized(true);
        url.setIsNullable(false);
        resultFileStatusTupleDesc.computeStatAndMemLayout();
        return resultFileStatusTupleDesc;
    }

    private static class QueryStatisticsTransferOptimizer {
        private final PlanFragment root;

        public QueryStatisticsTransferOptimizer(PlanFragment root) {
            Preconditions.checkNotNull((Object)root);
            this.root = root;
        }

        public void optimizeQueryStatisticsTransfer() {
            this.optimizeQueryStatisticsTransfer(this.root, null);
        }

        private void optimizeQueryStatisticsTransfer(PlanFragment fragment, PlanFragment parent) {
            if (parent != null && this.hasLimit(parent.getPlanRoot(), fragment.getPlanRoot())) {
                fragment.setTransferQueryStatisticsWithEveryBatch(true);
            }
            for (PlanFragment child : fragment.getChildren()) {
                this.optimizeQueryStatisticsTransfer(child, fragment);
            }
        }

        private boolean hasLimit(PlanNode ancestor, PlanNode successor) {
            ArrayList exchangeNodes = Lists.newArrayList();
            this.collectExchangeNode(ancestor, exchangeNodes);
            for (PlanNode leaf : exchangeNodes) {
                if (leaf.getChild(0) != successor || !leaf.hasLimit()) continue;
                return true;
            }
            return false;
        }

        private void collectExchangeNode(PlanNode planNode, List<PlanNode> exchangeNodes) {
            if (planNode instanceof ExchangeNode) {
                exchangeNodes.add(planNode);
            }
            for (PlanNode child : planNode.getChildren()) {
                if (child instanceof ExchangeNode) {
                    exchangeNodes.add(child);
                    continue;
                }
                this.collectExchangeNode(child, exchangeNodes);
            }
        }
    }
}

