/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprId;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.NotImplementedException;
import org.apache.doris.common.TreeNode;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.planner.ExchangeNode;
import org.apache.doris.planner.HashJoinNode;
import org.apache.doris.planner.PlanFragment;
import org.apache.doris.planner.PlanFragmentId;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.planner.RuntimeFilter;
import org.apache.doris.planner.ScanNode;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TFunctionBinaryType;
import org.apache.doris.thrift.TPlan;
import org.apache.doris.thrift.TPlanNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PlanNode
extends TreeNode<PlanNode> {
    private static final Logger LOG = LogManager.getLogger(PlanNode.class);
    protected String planNodeName;
    protected PlanNodeId id;
    protected PlanFragmentId fragmentId;
    protected long limit;
    protected ArrayList<TupleId> tupleIds;
    protected ArrayList<TupleId> tblRefIds;
    protected Set<TupleId> nullableTupleIds = Sets.newHashSet();
    protected List<Expr> conjuncts = Lists.newArrayList();
    protected Expr vconjunct = null;
    protected List<Expr> preFilterConjuncts = Lists.newArrayList();
    protected PlanFragment fragment_;
    protected long cardinality;
    protected int numNodes;
    protected float avgRowSize;
    protected boolean compactData;
    protected int numInstances;
    protected List<RuntimeFilter> runtimeFilters = new ArrayList<RuntimeFilter>();
    private boolean cardinalityIsDone = false;
    protected List<SlotId> outputSlotIds;
    protected ExprSubstitutionMap outputSmap;
    protected Set<ExprId> assignedConjuncts;
    protected ExprSubstitutionMap withoutTupleIsNullOutputSmap;

    protected PlanNode(PlanNodeId id, ArrayList<TupleId> tupleIds, String planNodeName) {
        this.id = id;
        this.limit = -1L;
        this.tupleIds = Lists.newArrayList(tupleIds);
        this.tblRefIds = Lists.newArrayList(tupleIds);
        this.cardinality = -1L;
        this.planNodeName = VectorizedUtil.isVectorized() ? "V" + planNodeName : planNodeName;
        this.numInstances = 1;
    }

    protected PlanNode(PlanNodeId id, String planNodeName) {
        this.id = id;
        this.limit = -1L;
        this.tupleIds = Lists.newArrayList();
        this.tblRefIds = Lists.newArrayList();
        this.cardinality = -1L;
        this.planNodeName = VectorizedUtil.isVectorized() ? "V" + planNodeName : planNodeName;
        this.numInstances = 1;
    }

    protected PlanNode(PlanNodeId id, PlanNode node, String planNodeName) {
        this.id = id;
        this.limit = node.limit;
        this.tupleIds = Lists.newArrayList(node.tupleIds);
        this.tblRefIds = Lists.newArrayList(node.tblRefIds);
        this.nullableTupleIds = Sets.newHashSet(node.nullableTupleIds);
        this.conjuncts = Expr.cloneList(node.conjuncts, null);
        this.cardinality = -1L;
        this.compactData = node.compactData;
        this.planNodeName = VectorizedUtil.isVectorized() ? "V" + planNodeName : planNodeName;
        this.numInstances = 1;
    }

    public String getPlanNodeName() {
        return this.planNodeName;
    }

    public void computeTupleIds() {
        Preconditions.checkState((this.children.isEmpty() || !this.tupleIds.isEmpty() ? 1 : 0) != 0);
    }

    protected void clearTupleIds() {
        this.tblRefIds.clear();
        this.tupleIds.clear();
        this.nullableTupleIds.clear();
    }

    protected void setPlanNodeName(String s) {
        this.planNodeName = s;
    }

    public PlanNodeId getId() {
        return this.id;
    }

    public void setId(PlanNodeId id) {
        Preconditions.checkState((this.id == null ? 1 : 0) != 0);
        this.id = id;
    }

    public PlanFragmentId getFragmentId() {
        return this.fragment_.getFragmentId();
    }

    public void setFragmentId(PlanFragmentId id) {
        this.fragmentId = id;
    }

    public void setFragment(PlanFragment fragment) {
        this.fragment_ = fragment;
    }

    public PlanFragment getFragment() {
        return this.fragment_;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        if (this.limit == -1L || limit != -1L && this.limit > limit) {
            this.limit = limit;
        }
    }

    public boolean hasLimit() {
        return this.limit > -1L;
    }

    public long getCardinality() {
        return this.cardinality;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public float getAvgRowSize() {
        return this.avgRowSize;
    }

    public void setCompactData(boolean on) {
        this.compactData = on;
        for (PlanNode child : this.getChildren()) {
            child.setCompactData(on);
        }
    }

    public void unsetLimit() {
        this.limit = -1L;
    }

    protected List<TupleId> getAllScanTupleIds() {
        ArrayList tupleIds = Lists.newArrayList();
        ArrayList scanNodes = Lists.newArrayList();
        this.collectAll(Predicates.instanceOf(ScanNode.class), scanNodes);
        for (ScanNode node : scanNodes) {
            tupleIds.addAll(node.getTupleIds());
        }
        return tupleIds;
    }

    public void resetTupleIds(ArrayList<TupleId> tupleIds) {
        this.tupleIds = tupleIds;
    }

    public ArrayList<TupleId> getTupleIds() {
        Preconditions.checkState((this.tupleIds != null ? 1 : 0) != 0);
        return this.tupleIds;
    }

    public ArrayList<TupleId> getTblRefIds() {
        return this.tblRefIds;
    }

    public void setTblRefIds(ArrayList<TupleId> ids) {
        this.tblRefIds = ids;
    }

    public ArrayList<TupleId> getOutputTblRefIds() {
        return this.tblRefIds;
    }

    public ArrayList<TupleId> getOutputTupleIds() {
        return this.tupleIds;
    }

    public Set<TupleId> getNullableTupleIds() {
        Preconditions.checkState((this.nullableTupleIds != null ? 1 : 0) != 0);
        return this.nullableTupleIds;
    }

    public List<Expr> getConjuncts() {
        return this.conjuncts;
    }

    void initCompoundPredicate(Expr expr) {
        if (expr instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)expr;
            compoundPredicate.setType(Type.BOOLEAN);
            ArrayList<Type> args = new ArrayList<Type>();
            args.add(Type.BOOLEAN);
            args.add(Type.BOOLEAN);
            Function function = new Function(new FunctionName("", compoundPredicate.getOp().toString()), args, Type.BOOLEAN, false);
            function.setBinaryType(TFunctionBinaryType.BUILTIN);
            expr.setFn(function);
        }
        for (Expr child : expr.getChildren()) {
            this.initCompoundPredicate(child);
        }
    }

    Expr convertConjunctsToAndCompoundPredicate(List<Expr> conjuncts) {
        ArrayList targetConjuncts = Lists.newArrayList(conjuncts);
        while (targetConjuncts.size() > 1) {
            ArrayList newTargetConjuncts = Lists.newArrayList();
            for (int i = 0; i < targetConjuncts.size(); i += 2) {
                Expr expr = i + 1 < targetConjuncts.size() ? new CompoundPredicate(CompoundPredicate.Operator.AND, (Expr)targetConjuncts.get(i), (Expr)targetConjuncts.get(i + 1)) : (Expr)targetConjuncts.get(i);
                newTargetConjuncts.add(expr);
            }
            targetConjuncts = newTargetConjuncts;
        }
        Preconditions.checkArgument((targetConjuncts.size() == 1 ? 1 : 0) != 0);
        return (Expr)targetConjuncts.get(0);
    }

    public void addConjuncts(List<Expr> conjuncts) {
        if (conjuncts == null) {
            return;
        }
        for (Expr conjunct : conjuncts) {
            this.addConjunct(conjunct);
        }
    }

    public void addConjunct(Expr conjunct) {
        if (this.conjuncts == null) {
            this.conjuncts = Lists.newArrayList();
        }
        if (!this.conjuncts.contains(conjunct)) {
            this.conjuncts.add(conjunct);
        }
    }

    public void setAssignedConjuncts(Set<ExprId> conjuncts) {
        this.assignedConjuncts = conjuncts;
    }

    public Set<ExprId> getAssignedConjuncts() {
        return this.assignedConjuncts;
    }

    public void transferConjuncts(PlanNode recipient) {
        recipient.vconjunct = this.vconjunct;
        this.vconjunct = null;
        recipient.conjuncts.addAll(this.conjuncts);
        this.conjuncts.clear();
    }

    public void addPreFilterConjuncts(List<Expr> conjuncts) {
        if (conjuncts == null) {
            return;
        }
        this.preFilterConjuncts.addAll(conjuncts);
    }

    protected void computeTupleStatAndMemLayout(Analyzer analyzer) {
        for (TupleId id : this.tupleIds) {
            analyzer.getDescTbl().getTupleDesc(id).computeStatAndMemLayout();
        }
    }

    public String getExplainString() {
        return this.getExplainString("", "", TExplainLevel.VERBOSE);
    }

    protected final String getExplainString(String rootPrefix, String prefix, TExplainLevel detailLevel) {
        StringBuilder expBuilder = new StringBuilder();
        String detailPrefix = prefix;
        boolean traverseChildren = this.children != null && this.children.size() > 0 && !(this instanceof ExchangeNode);
        detailPrefix = traverseChildren ? detailPrefix + "|  " : detailPrefix + "   ";
        expBuilder.append(rootPrefix + this.id.asInt() + ":" + this.planNodeName + "\n");
        expBuilder.append(this.getNodeExplainString(detailPrefix, detailLevel));
        if (this.limit != -1L) {
            expBuilder.append(detailPrefix + "limit: " + this.limit + "\n");
        }
        if (detailLevel.equals((Object)TExplainLevel.VERBOSE)) {
            expBuilder.append(detailPrefix + "tuple ids: ");
            for (TupleId tupleId : this.tupleIds) {
                String nullIndicator = this.nullableTupleIds.contains(tupleId) ? "N" : "";
                expBuilder.append(tupleId.asInt() + nullIndicator + " ");
            }
            expBuilder.append("\n");
        }
        if (traverseChildren) {
            expBuilder.append(detailPrefix + "\n");
            String childHeadlinePrefix = prefix + "|----";
            String childDetailPrefix = prefix + "|    ";
            for (int i = 1; i < this.children.size(); ++i) {
                expBuilder.append(((PlanNode)this.children.get(i)).getExplainString(childHeadlinePrefix, childDetailPrefix, detailLevel));
                expBuilder.append(childDetailPrefix + "\n");
            }
            expBuilder.append(((PlanNode)this.children.get(0)).getExplainString(prefix, prefix, detailLevel));
        }
        return expBuilder.toString();
    }

    public String getNodeExplainString(String prefix, TExplainLevel detailLevel) {
        return "";
    }

    public TPlan treeToThrift() {
        TPlan result = new TPlan();
        this.treeToThriftHelper(result);
        return result;
    }

    private void treeToThriftHelper(TPlan container) {
        TPlanNode msg = new TPlanNode();
        msg.node_id = this.id.asInt();
        msg.num_children = this.children.size();
        msg.limit = this.limit;
        for (TupleId tid : this.tupleIds) {
            msg.addToRowTuples(tid.asInt());
            msg.addToNullableTuples(this.nullableTupleIds.contains(tid));
        }
        for (Expr e : this.conjuncts) {
            msg.addToConjuncts(e.treeToThrift());
        }
        for (RuntimeFilter filter : this.runtimeFilters) {
            msg.addToRuntimeFilters(filter.toThrift());
        }
        if (this.vconjunct != null) {
            msg.vconjunct = this.vconjunct.treeToThrift();
        }
        msg.compact_data = this.compactData;
        if (this.outputSlotIds != null) {
            for (SlotId slotId : this.outputSlotIds) {
                msg.addToOutputSlotIds(slotId.asInt());
            }
        }
        this.toThrift(msg);
        container.addToNodes(msg);
        if (this instanceof ExchangeNode) {
            msg.num_children = 0;
            return;
        }
        msg.num_children = this.children.size();
        for (PlanNode child : this.children) {
            child.treeToThriftHelper(container);
        }
    }

    public void finalize(Analyzer analyzer) throws UserException {
        for (PlanNode child : this.children) {
            child.finalize(analyzer);
        }
        this.computeNumNodes();
        if (!analyzer.safeIsEnableJoinReorderBasedCost()) {
            this.computeOldCardinality();
        }
    }

    protected void computeNumNodes() {
        if (!this.children.isEmpty()) {
            this.numNodes = ((PlanNode)this.getChild((int)0)).numNodes;
        }
    }

    protected void computeStats(Analyzer analyzer) {
        this.avgRowSize = 0.0f;
        for (TupleId tid : this.tupleIds) {
            TupleDescriptor desc = analyzer.getTupleDesc(tid);
            this.avgRowSize += desc.getAvgSerializedSize();
        }
    }

    protected void computeOldCardinality() {
    }

    protected void capCardinalityAtLimit() {
        if (this.hasLimit()) {
            this.cardinality = this.cardinality == -1L ? this.limit : Math.min(this.cardinality, this.limit);
        }
    }

    public ExprSubstitutionMap getOutputSmap() {
        return this.outputSmap;
    }

    public void setOutputSmap(ExprSubstitutionMap smap) {
        this.outputSmap = smap;
    }

    public void setWithoutTupleIsNullOutputSmap(ExprSubstitutionMap smap) {
        this.withoutTupleIsNullOutputSmap = smap;
    }

    public ExprSubstitutionMap getWithoutTupleIsNullOutputSmap() {
        return this.withoutTupleIsNullOutputSmap == null ? this.outputSmap : this.withoutTupleIsNullOutputSmap;
    }

    public void init(Analyzer analyzer) throws UserException {
        this.assignConjuncts(analyzer);
        this.createDefaultSmap(analyzer);
    }

    protected void assignConjuncts(Analyzer analyzer) {
        List<Expr> unassigned = analyzer.getUnassignedConjuncts(this);
        for (Expr unassignedConjunct : unassigned) {
            this.addConjunct(unassignedConjunct);
        }
        analyzer.markConjunctsAssigned(unassigned);
    }

    protected ExprSubstitutionMap getCombinedChildSmap() {
        if (this.getChildren().size() == 0) {
            return new ExprSubstitutionMap();
        }
        if (this.getChildren().size() == 1) {
            return ((PlanNode)this.getChild(0)).getOutputSmap();
        }
        ExprSubstitutionMap result = ExprSubstitutionMap.combine(((PlanNode)this.getChild(0)).getOutputSmap(), ((PlanNode)this.getChild(1)).getOutputSmap());
        for (int i = 2; i < this.getChildren().size(); ++i) {
            result = ExprSubstitutionMap.combine(result, ((PlanNode)this.getChild(i)).getOutputSmap());
        }
        return result;
    }

    protected ExprSubstitutionMap getCombinedChildWithoutTupleIsNullSmap() {
        if (this.getChildren().size() == 0) {
            return new ExprSubstitutionMap();
        }
        if (this.getChildren().size() == 1) {
            return ((PlanNode)this.getChild(0)).getWithoutTupleIsNullOutputSmap();
        }
        ExprSubstitutionMap result = ExprSubstitutionMap.combine(((PlanNode)this.getChild(0)).getWithoutTupleIsNullOutputSmap(), ((PlanNode)this.getChild(1)).getWithoutTupleIsNullOutputSmap());
        for (int i = 2; i < this.getChildren().size(); ++i) {
            result = ExprSubstitutionMap.combine(result, ((PlanNode)this.getChild(i)).getWithoutTupleIsNullOutputSmap());
        }
        return result;
    }

    protected void createDefaultSmap(Analyzer analyzer) throws UserException {
        ExprSubstitutionMap combinedChildSmap = this.getCombinedChildSmap();
        this.outputSmap = ExprSubstitutionMap.compose(this.outputSmap, combinedChildSmap, analyzer);
        this.conjuncts = Expr.substituteList(this.conjuncts, this.outputSmap, analyzer, false);
    }

    public void getMaterializedIds(Analyzer analyzer, List<SlotId> ids) {
        for (PlanNode childNode : this.children) {
            childNode.getMaterializedIds(analyzer, ids);
        }
        Expr.getIds(this.getConjuncts(), null, ids);
    }

    protected abstract void toThrift(TPlanNode var1);

    protected String debugString() {
        StringBuilder output = new StringBuilder();
        output.append("preds=" + Expr.debugString(this.conjuncts));
        output.append(" limit=" + Long.toString(this.limit));
        return output.toString();
    }

    protected String getExplainString(List<? extends Expr> exprs) {
        if (exprs == null) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < exprs.size(); ++i) {
            if (i > 0) {
                output.append(", ");
            }
            output.append(exprs.get(i).toSql());
        }
        return output.toString();
    }

    protected boolean hasValidStats() {
        return !(this.numNodes != -1 && this.numNodes < 0 || this.cardinality != -1L && this.cardinality < 0L);
    }

    public int getNumInstances() {
        return this.numInstances;
    }

    public void setNumInstances(int numInstances) {
        this.numInstances = numInstances;
    }

    public void appendTrace(StringBuilder sb) {
        sb.append(this.planNodeName);
        if (!this.children.isEmpty()) {
            sb.append("(");
            int idx = 0;
            for (PlanNode child : this.children) {
                if (idx++ != 0) {
                    sb.append(",");
                }
                child.appendTrace(sb);
            }
            sb.append(")");
        }
    }

    protected static double computeCombinedSelectivity(List<Expr> conjuncts) {
        ArrayList<Double> selectivities = new ArrayList<Double>();
        for (Expr e : conjuncts) {
            if (!e.hasSelectivity()) continue;
            selectivities.add(e.getSelectivity());
        }
        if (selectivities.size() != conjuncts.size()) {
            selectivities.add(0.1);
        }
        Collections.sort(selectivities);
        double result = 1.0;
        for (int i = 0; i < selectivities.size(); ++i) {
            result *= Math.pow((Double)selectivities.get(i), 1.0 / (double)(i + 1));
        }
        return Math.max(0.0, Math.min(1.0, result));
    }

    protected double computeSelectivity() {
        for (Expr expr : this.conjuncts) {
            expr.setSelectivity();
        }
        return PlanNode.computeCombinedSelectivity(this.conjuncts);
    }

    protected double computeOldSelectivity() {
        double prod = 1.0;
        for (Expr e : this.conjuncts) {
            if (e.getSelectivity() < 0.0) {
                return -1.0;
            }
            prod *= e.getSelectivity();
        }
        return prod;
    }

    protected void applyConjunctsSelectivity() {
        if (this.cardinality == -1L) {
            return;
        }
        this.applySelectivity();
    }

    private void applySelectivity() {
        double selectivity = this.computeSelectivity();
        Preconditions.checkState((this.cardinality >= 0L ? 1 : 0) != 0);
        long preConjunctCardinality = this.cardinality;
        this.cardinality = Math.round((double)this.cardinality * selectivity);
        if (this.cardinality == 0L && preConjunctCardinality > 0L) {
            this.cardinality = 1L;
        }
    }

    public String getPlanTreeExplainStr() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.getId().asInt()).append(": ").append(this.getPlanNodeName()).append("]");
        sb.append("\n[Fragment: ").append(this.getFragmentId().asInt()).append("]");
        sb.append("\n").append(this.getNodeExplainString("", TExplainLevel.BRIEF));
        return sb.toString();
    }

    public ScanNode getScanNodeInOneFragmentBySlotRef(SlotRef slotRef) {
        block5: {
            block3: {
                block4: {
                    TupleId tupleId = slotRef.getDesc().getParent().getId();
                    if (this instanceof ScanNode && this.tupleIds.contains(tupleId)) {
                        return (ScanNode)this;
                    }
                    if (!(this instanceof HashJoinNode)) break block3;
                    HashJoinNode hashJoinNode = (HashJoinNode)this;
                    SlotRef inputSlotRef = hashJoinNode.getMappedInputSlotRef(slotRef);
                    if (inputSlotRef == null) break block4;
                    for (PlanNode planNode : this.children) {
                        ScanNode scanNode = planNode.getScanNodeInOneFragmentBySlotRef(inputSlotRef);
                        if (scanNode == null) continue;
                        return scanNode;
                    }
                    break block5;
                }
                return null;
            }
            if (this instanceof ExchangeNode) break block5;
            for (PlanNode planNode : this.children) {
                ScanNode scanNode = planNode.getScanNodeInOneFragmentBySlotRef(slotRef);
                if (scanNode == null) continue;
                return scanNode;
            }
        }
        return null;
    }

    protected void addRuntimeFilter(RuntimeFilter filter) {
        this.runtimeFilters.add(filter);
    }

    protected Collection<RuntimeFilter> getRuntimeFilters() {
        return this.runtimeFilters;
    }

    public void clearRuntimeFilters() {
        this.runtimeFilters.clear();
    }

    protected String getRuntimeFilterExplainString(boolean isBuildNode) {
        if (this.runtimeFilters.isEmpty()) {
            return "";
        }
        ArrayList<String> filtersStr = new ArrayList<String>();
        for (RuntimeFilter filter : this.runtimeFilters) {
            StringBuilder filterStr = new StringBuilder();
            filterStr.append(filter.getFilterId());
            filterStr.append("[");
            filterStr.append(filter.getType().toString().toLowerCase());
            filterStr.append("]");
            if (isBuildNode) {
                filterStr.append(" <- ");
                filterStr.append(filter.getSrcExpr().toSql());
            } else {
                filterStr.append(" -> ");
                filterStr.append(filter.getTargetExpr(this.getId()).toSql());
            }
            filtersStr.add(filterStr.toString());
        }
        return Joiner.on((String)", ").join(filtersStr) + "\n";
    }

    public void convertToVectoriezd() {
        if (!this.conjuncts.isEmpty()) {
            this.vconjunct = this.convertConjunctsToAndCompoundPredicate(this.conjuncts);
            this.initCompoundPredicate(this.vconjunct);
        }
        for (PlanNode child : this.children) {
            child.convertToVectoriezd();
        }
    }

    public void initOutputSlotIds(Set<SlotId> requiredSlotIdSet, Analyzer analyzer) throws NotImplementedException {
        throw new NotImplementedException("The `initOutputSlotIds` hasn't been implemented in " + this.planNodeName);
    }

    public void projectOutputTuple() throws NotImplementedException {
        throw new NotImplementedException("The `projectOutputTuple` hasn't been implemented in " + this.planNodeName + ". But it does not affect the project optimizer");
    }

    public Set<SlotId> computeInputSlotIds(Analyzer analyzer) throws NotImplementedException {
        throw new NotImplementedException("The `computeInputSlotIds` hasn't been implemented in " + this.planNodeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.getId().asInt()).append(": ").append(this.getPlanNodeName()).append("]");
        sb.append("\nFragment: ").append(this.getFragmentId().asInt()).append("]");
        sb.append("\n").append(this.getNodeExplainString("", TExplainLevel.BRIEF));
        return sb.toString();
    }
}

