/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.common.TreeNode;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.DataSink;
import org.apache.doris.planner.DataStreamSink;
import org.apache.doris.planner.ExchangeNode;
import org.apache.doris.planner.PlanFragmentId;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.ResultFileSink;
import org.apache.doris.planner.ResultSink;
import org.apache.doris.planner.RuntimeFilterId;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TPartitionType;
import org.apache.doris.thrift.TPlanFragment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlanFragment
extends TreeNode<PlanFragment> {
    private static final Logger LOG = LogManager.getLogger(PlanFragment.class);
    private PlanFragmentId fragmentId;
    private PlanNode planRoot;
    private ExchangeNode destNode;
    private ArrayList<Expr> outputExprs;
    private DataSink sink;
    private DataPartition dataPartition;
    private DataPartition dataPartitionForThrift;
    private DataPartition outputPartition;
    private boolean transferQueryStatisticsWithEveryBatch;
    private int parallelExecNum = 1;
    private Set<RuntimeFilterId> builderRuntimeFilterIds;
    private Set<RuntimeFilterId> targetRuntimeFilterIds;
    private boolean hasColocatePlanNode = false;

    public PlanFragment(PlanFragmentId id, PlanNode root, DataPartition partition) {
        this.fragmentId = id;
        this.planRoot = root;
        this.dataPartition = partition;
        this.outputPartition = DataPartition.UNPARTITIONED;
        this.transferQueryStatisticsWithEveryBatch = false;
        this.builderRuntimeFilterIds = new HashSet<RuntimeFilterId>();
        this.targetRuntimeFilterIds = new HashSet<RuntimeFilterId>();
        this.setParallelExecNumIfExists();
        this.setFragmentInPlanTree(this.planRoot);
    }

    public PlanFragment(PlanFragmentId id, PlanNode root, DataPartition partition, DataPartition partitionForThrift) {
        this(id, root, partition);
        this.dataPartitionForThrift = partitionForThrift;
    }

    public void setFragmentInPlanTree(PlanNode node) {
        if (node == null) {
            return;
        }
        node.setFragment(this);
        if (node instanceof ExchangeNode) {
            return;
        }
        for (PlanNode child : node.getChildren()) {
            this.setFragmentInPlanTree(child);
        }
    }

    public void setParallelExecNumIfExists() {
        if (ConnectContext.get() != null) {
            this.parallelExecNum = ConnectContext.get().getSessionVariable().getParallelExecInstanceNum();
        }
    }

    public void setParallelExecNum(int parallelExecNum) {
        this.parallelExecNum = parallelExecNum;
    }

    public void setOutputExprs(List<Expr> outputExprs) {
        this.outputExprs = Expr.cloneList(outputExprs, null);
    }

    public void resetOutputExprs(TupleDescriptor tupleDescriptor) {
        this.outputExprs = Lists.newArrayList();
        for (SlotDescriptor slotDescriptor : tupleDescriptor.getSlots()) {
            SlotRef slotRef = new SlotRef(slotDescriptor);
            this.outputExprs.add(slotRef);
        }
    }

    public ArrayList<Expr> getOutputExprs() {
        return this.outputExprs;
    }

    public void setBuilderRuntimeFilterIds(RuntimeFilterId rid) {
        this.builderRuntimeFilterIds.add(rid);
    }

    public void setTargetRuntimeFilterIds(RuntimeFilterId rid) {
        this.targetRuntimeFilterIds.add(rid);
    }

    public void setHasColocatePlanNode(boolean hasColocatePlanNode) {
        this.hasColocatePlanNode = hasColocatePlanNode;
    }

    public boolean hasColocatePlanNode() {
        return this.hasColocatePlanNode;
    }

    public void finalize(QueryStmt queryStmt) {
        if (this.sink != null) {
            return;
        }
        if (this.destNode != null) {
            Preconditions.checkState((this.sink == null ? 1 : 0) != 0);
            DataStreamSink streamSink = new DataStreamSink(this.destNode.getId());
            streamSink.setPartition(this.outputPartition);
            streamSink.setFragment(this);
            this.sink = streamSink;
        } else {
            if (this.planRoot == null) {
                return;
            }
            Preconditions.checkState((this.sink == null ? 1 : 0) != 0);
            this.sink = queryStmt != null && queryStmt.hasOutFileClause() ? new ResultFileSink(this.planRoot.getId(), queryStmt.getOutFileClause()) : new ResultSink(this.planRoot.getId());
        }
    }

    public int getNumNodes() {
        return this.dataPartition == DataPartition.UNPARTITIONED ? 1 : this.planRoot.getNumNodes();
    }

    public int getParallelExecNum() {
        return this.parallelExecNum;
    }

    public TPlanFragment toThrift() {
        TPlanFragment result = new TPlanFragment();
        if (this.planRoot != null) {
            result.setPlan(this.planRoot.treeToThrift());
        }
        if (this.outputExprs != null) {
            result.setOutputExprs(Expr.treesToThrift(this.outputExprs));
        }
        if (this.sink != null) {
            result.setOutputSink(this.sink.toThrift());
        }
        if (this.dataPartitionForThrift == null) {
            result.setPartition(this.dataPartition.toThrift());
        } else {
            result.setPartition(this.dataPartitionForThrift.toThrift());
        }
        result.setMinReservationBytes(0L);
        result.setInitialReservationTotalClaims(0L);
        return result;
    }

    public String getExplainString(TExplainLevel explainLevel) {
        StringBuilder str = new StringBuilder();
        Preconditions.checkState((this.dataPartition != null ? 1 : 0) != 0);
        if (CollectionUtils.isNotEmpty(this.outputExprs)) {
            str.append("  OUTPUT EXPRS:");
            str.append(this.outputExprs.stream().map(Expr::toSql).collect(Collectors.joining(" | ")));
        }
        str.append("\n");
        str.append("  PARTITION: " + this.dataPartition.getExplainString(explainLevel) + "\n");
        if (this.sink != null) {
            str.append(this.sink.getExplainString("  ", explainLevel) + "\n");
        }
        if (this.planRoot != null) {
            str.append(this.planRoot.getExplainString("  ", "  ", explainLevel));
        }
        return str.toString();
    }

    public boolean isPartitioned() {
        return this.dataPartition.getType() != TPartitionType.UNPARTITIONED;
    }

    public void updateDataPartition(DataPartition dataPartition) {
        if (this.dataPartition == DataPartition.UNPARTITIONED) {
            return;
        }
        this.dataPartition = dataPartition;
    }

    public PlanFragmentId getId() {
        return this.fragmentId;
    }

    public PlanFragment getDestFragment() {
        if (this.destNode == null) {
            return null;
        }
        return this.destNode.getFragment();
    }

    public void setDestination(ExchangeNode destNode) {
        this.destNode = destNode;
        PlanFragment dest = this.getDestFragment();
        Preconditions.checkNotNull((Object)dest);
        dest.addChild(this);
    }

    public DataPartition getDataPartition() {
        return this.dataPartition;
    }

    public DataPartition getOutputPartition() {
        return this.outputPartition;
    }

    public void setOutputPartition(DataPartition outputPartition) {
        this.outputPartition = outputPartition;
    }

    public PlanNode getPlanRoot() {
        return this.planRoot;
    }

    public void setPlanRoot(PlanNode root) {
        this.planRoot = root;
        this.setFragmentInPlanTree(this.planRoot);
    }

    public void addPlanRoot(PlanNode newRoot) {
        Preconditions.checkState((newRoot.getChildren().size() == 1 ? 1 : 0) != 0);
        newRoot.setChild(0, this.planRoot);
        this.planRoot = newRoot;
        this.planRoot.setFragment(this);
    }

    public DataSink getSink() {
        return this.sink;
    }

    public void setSink(DataSink sink) {
        Preconditions.checkState((this.sink == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)sink);
        sink.setFragment(this);
        this.sink = sink;
    }

    public void resetSink(DataSink sink) {
        sink.setFragment(this);
        this.sink = sink;
    }

    public PlanFragmentId getFragmentId() {
        return this.fragmentId;
    }

    public Set<RuntimeFilterId> getBuilderRuntimeFilterIds() {
        return this.builderRuntimeFilterIds;
    }

    public Set<RuntimeFilterId> getTargetRuntimeFilterIds() {
        return this.targetRuntimeFilterIds;
    }

    public void clearRuntimeFilters() {
        this.builderRuntimeFilterIds.clear();
        this.targetRuntimeFilterIds.clear();
    }

    public void setTransferQueryStatisticsWithEveryBatch(boolean value) {
        this.transferQueryStatisticsWithEveryBatch = value;
    }

    public boolean isTransferQueryStatisticsWithEveryBatch() {
        return this.transferQueryStatisticsWithEveryBatch;
    }
}

