/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.planner.ColumnBound;
import org.apache.doris.planner.ColumnRange;
import org.apache.doris.planner.PartitionPruner;

public abstract class PartitionPrunerV2Base
implements PartitionPruner {
    protected final Map<Long, PartitionItem> idToPartitionItem;
    protected final List<Column> partitionColumns;
    protected final Map<String, ColumnRange> columnNameToRange;

    public PartitionPrunerV2Base(Map<Long, PartitionItem> idToPartitionItem, List<Column> partitionColumns, Map<String, ColumnRange> columnNameToRange) {
        this.idToPartitionItem = idToPartitionItem;
        this.partitionColumns = partitionColumns;
        this.columnNameToRange = columnNameToRange;
    }

    @Override
    public Collection<Long> prune() throws AnalysisException {
        HashMap columnToFilters = Maps.newHashMap();
        for (Column column : this.partitionColumns) {
            ColumnRange columnRange = this.columnNameToRange.get(column.getName());
            if (columnRange == null) {
                columnToFilters.put(column, FinalFilters.noFilters());
                continue;
            }
            columnToFilters.put(column, this.getFinalFilters(columnRange, column));
        }
        if (this.partitionColumns.size() == 1) {
            return this.pruneSingleColumnPartition(columnToFilters);
        }
        if (this.partitionColumns.size() > 1) {
            return this.pruneMultipleColumnPartition(columnToFilters);
        }
        return Lists.newArrayList();
    }

    abstract RangeMap<ColumnBound, UniqueId> getCandidateRangeMap();

    abstract FinalFilters getFinalFilters(ColumnRange var1, Column var2) throws AnalysisException;

    abstract Collection<Long> pruneMultipleColumnPartition(Map<Column, FinalFilters> var1) throws AnalysisException;

    private Collection<Long> pruneSingleColumnPartition(Map<Column, FinalFilters> columnToFilters) {
        FinalFilters finalFilters = columnToFilters.get(this.partitionColumns.get(0));
        switch (finalFilters.type) {
            case CONSTANT_FALSE_FILTERS: {
                return Collections.emptyList();
            }
            case HAVE_FILTERS: {
                RangeMap<ColumnBound, UniqueId> candidate = this.getCandidateRangeMap();
                return finalFilters.filters.stream().map(filter -> {
                    RangeMap filtered = candidate.subRangeMap(filter);
                    return filtered.asMapOfRanges().values().stream().map(UniqueId::getPartitionId).collect(Collectors.toSet());
                }).flatMap(Collection::stream).collect(Collectors.toSet());
            }
        }
        return this.idToPartitionItem.keySet();
    }

    protected Range<ColumnBound> mapPartitionKeyRange(Range<PartitionKey> fromRange, int columnIdx) {
        return this.mapRange(fromRange, partitionKey -> ColumnBound.of(partitionKey.getKeys().get(columnIdx)));
    }

    protected <TO extends Comparable, FROM extends Comparable> Range<TO> mapRange(Range<FROM> range, Function<FROM, TO> mapper) {
        Comparable upper;
        Comparable lower = range.hasLowerBound() ? (Comparable)mapper.apply(range.lowerEndpoint()) : null;
        Comparable comparable = upper = range.hasUpperBound() ? (Comparable)mapper.apply(range.upperEndpoint()) : null;
        if (range.hasUpperBound()) {
            if (range.hasLowerBound()) {
                return Range.range((Comparable)lower, (BoundType)range.lowerBoundType(), (Comparable)upper, (BoundType)range.upperBoundType());
            }
            if (range.upperBoundType() == BoundType.OPEN) {
                return Range.lessThan((Comparable)upper);
            }
            return Range.atMost((Comparable)upper);
        }
        if (range.hasLowerBound()) {
            if (range.lowerBoundType() == BoundType.OPEN) {
                return Range.greaterThan((Comparable)lower);
            }
            return Range.atLeast((Comparable)lower);
        }
        return Range.all();
    }

    protected static class FinalFilters {
        final Type type;
        final Set<Range<ColumnBound>> filters;
        private static final FinalFilters NO_FILTERS = new FinalFilters(Type.NO_FILTERS, null);
        private static final FinalFilters CONSTANT_FALSE_FILTERS = new FinalFilters(Type.CONSTANT_FALSE_FILTERS, null);

        private FinalFilters(Type type, Set<Range<ColumnBound>> filters) {
            this.type = type;
            this.filters = filters;
        }

        public static FinalFilters noFilters() {
            return NO_FILTERS;
        }

        public static FinalFilters constantFalseFilters() {
            return CONSTANT_FALSE_FILTERS;
        }

        public static FinalFilters create(Set<Range<ColumnBound>> filters) {
            return new FinalFilters(Type.HAVE_FILTERS, filters);
        }

        static enum Type {
            NO_FILTERS,
            HAVE_FILTERS,
            CONSTANT_FALSE_FILTERS;

        }
    }

    protected static interface UniqueId {
        public long getPartitionId();
    }
}

