/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.List;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.PartitionValue;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.common.AnalysisException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartitionColumnFilter {
    private static final Logger LOG = LogManager.getLogger(PartitionColumnFilter.class);
    public LiteralExpr lowerBound;
    public boolean lowerBoundInclusive;
    public LiteralExpr upperBound;
    public boolean upperBoundInclusive;
    private InPredicate inPredicate;

    public InPredicate getInPredicate() {
        return this.inPredicate;
    }

    public void setInPredicate(InPredicate inPredicate) {
        this.inPredicate = inPredicate;
    }

    public void setLowerBound(LiteralExpr newLowerBound, boolean newLowerBoundInclusive) {
        if (null == this.lowerBound) {
            this.lowerBound = newLowerBound;
            this.lowerBoundInclusive = newLowerBoundInclusive;
        } else {
            int ret = this.lowerBound.compareLiteral(newLowerBound);
            if (ret < 0) {
                this.lowerBound = newLowerBound;
                this.lowerBoundInclusive = newLowerBoundInclusive;
            } else if (ret == 0 && !newLowerBoundInclusive) {
                this.lowerBoundInclusive = newLowerBoundInclusive;
            }
        }
    }

    public void setUpperBound(LiteralExpr newUpperBound, boolean newUpperBoundInclusive) {
        if (null == this.upperBound) {
            this.upperBound = newUpperBound;
            this.upperBoundInclusive = newUpperBoundInclusive;
        } else {
            int ret = this.upperBound.compareLiteral(newUpperBound);
            if (ret >= 0) {
                if (ret == 0) {
                    if (!newUpperBoundInclusive) {
                        this.upperBoundInclusive = newUpperBoundInclusive;
                    }
                } else {
                    this.upperBound = newUpperBound;
                    this.upperBoundInclusive = newUpperBoundInclusive;
                }
            }
        }
    }

    public Range<PartitionKey> getRange(List<Column> columns) {
        BoundType upperType;
        LOG.info("range is " + this.toString());
        BoundType lowerType = this.lowerBoundInclusive ? BoundType.CLOSED : BoundType.OPEN;
        BoundType boundType = upperType = this.upperBoundInclusive ? BoundType.CLOSED : BoundType.OPEN;
        if (null != this.lowerBound && null != this.upperBound) {
            PartitionKey lowerKey = null;
            PartitionKey upperKey = null;
            try {
                lowerKey = PartitionKey.createPartitionKey(Lists.newArrayList((Object[])new PartitionValue[]{new PartitionValue(this.lowerBound.getStringValue())}), columns);
                upperKey = PartitionKey.createPartitionKey(Lists.newArrayList((Object[])new PartitionValue[]{new PartitionValue(this.upperBound.getStringValue())}), columns);
            }
            catch (AnalysisException e) {
                LOG.warn(e.getMessage());
                return null;
            }
            return Range.range((Comparable)lowerKey, (BoundType)lowerType, (Comparable)upperKey, (BoundType)upperType);
        }
        return null;
    }

    public String toString() {
        String str = "";
        str = null == this.lowerBound ? str + "lowerBound is UNSET" : str + "lowerBound is " + this.lowerBound.getStringValue() + " and lowerBoundInclusive is " + this.lowerBoundInclusive;
        str = null == this.upperBound ? str + "\nupperBound is UNSET" : str + "\nupperBound is " + this.upperBound.getStringValue() + " and upperBoundInclusive is " + this.upperBoundInclusive;
        str = null == this.inPredicate ? str + "\ninPredicate is UNSET" : str + "\ninPredicate is " + this.inPredicate;
        return str;
    }
}

