/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.HashDistributionInfo;
import org.apache.doris.catalog.ListPartitionItem;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.MaterializedIndexMeta;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.RandomDistributionInfo;
import org.apache.doris.catalog.RangePartitionItem;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.InternalErrorCode;
import org.apache.doris.common.Status;
import org.apache.doris.common.UserException;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.DataSink;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;
import org.apache.doris.thrift.TDataSink;
import org.apache.doris.thrift.TDataSinkType;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TNodeInfo;
import org.apache.doris.thrift.TOlapTableIndexSchema;
import org.apache.doris.thrift.TOlapTableIndexTablets;
import org.apache.doris.thrift.TOlapTableLocationParam;
import org.apache.doris.thrift.TOlapTablePartition;
import org.apache.doris.thrift.TOlapTablePartitionParam;
import org.apache.doris.thrift.TOlapTableSchemaParam;
import org.apache.doris.thrift.TOlapTableSink;
import org.apache.doris.thrift.TPaloNodesInfo;
import org.apache.doris.thrift.TTabletLocation;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OlapTableSink
extends DataSink {
    private static final Logger LOG = LogManager.getLogger(OlapTableSink.class);
    private OlapTable dstTable;
    private TupleDescriptor tupleDescriptor;
    private List<Long> partitionIds;
    private TDataSink tDataSink;

    public OlapTableSink(OlapTable dstTable, TupleDescriptor tupleDescriptor, List<Long> partitionIds) {
        this.dstTable = dstTable;
        this.tupleDescriptor = tupleDescriptor;
        this.partitionIds = partitionIds;
    }

    public void init(TUniqueId loadId, long txnId, long dbId, long loadChannelTimeoutS, int sendBatchParallelism, boolean loadToSingleTablet) throws AnalysisException {
        TOlapTableSink tSink = new TOlapTableSink();
        tSink.setLoadId(loadId);
        tSink.setTxnId(txnId);
        tSink.setDbId(dbId);
        tSink.setLoadChannelTimeoutS(loadChannelTimeoutS);
        tSink.setSendBatchParallelism(sendBatchParallelism);
        if (loadToSingleTablet && !(this.dstTable.getDefaultDistributionInfo() instanceof RandomDistributionInfo)) {
            throw new AnalysisException("if load_to_single_tablet set to true, the olap table must be with random distribution");
        }
        tSink.setLoadToSingleTablet(loadToSingleTablet);
        this.tDataSink = new TDataSink(TDataSinkType.OLAP_TABLE_SINK);
        this.tDataSink.setOlapTableSink(tSink);
        if (this.partitionIds == null) {
            this.partitionIds = this.dstTable.getPartitionIds();
            if (this.partitionIds.isEmpty()) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_EMPTY_PARTITION_IN_TABLE, this.dstTable.getName());
            }
        }
        for (Long partitionId : this.partitionIds) {
            Partition part = this.dstTable.getPartition(partitionId);
            if (part != null) continue;
            ErrorReport.reportAnalysisException(ErrorCode.ERR_UNKNOWN_PARTITION, partitionId, this.dstTable.getName());
        }
    }

    public void updateLoadId(TUniqueId newLoadId) {
        this.tDataSink.getOlapTableSink().setLoadId(newLoadId);
    }

    public void complete() throws UserException {
        TOlapTableSink tSink = this.tDataSink.getOlapTableSink();
        tSink.setTableId(this.dstTable.getId());
        tSink.setTupleId(this.tupleDescriptor.getId().asInt());
        int numReplicas = 1;
        Iterator<Partition> iterator = this.dstTable.getPartitions().iterator();
        if (iterator.hasNext()) {
            Partition partition = iterator.next();
            numReplicas = this.dstTable.getPartitionInfo().getReplicaAllocation(partition.getId()).getTotalReplicaNum();
        }
        tSink.setNumReplicas(numReplicas);
        tSink.setNeedGenRollup(this.dstTable.shouldLoadToNewRollup());
        tSink.setSchema(this.createSchema(tSink.getDbId(), this.dstTable));
        tSink.setPartition(this.createPartition(tSink.getDbId(), this.dstTable));
        tSink.setLocation(this.createLocation(this.dstTable));
        tSink.setNodesInfo(this.createPaloNodesInfo());
    }

    @Override
    public String getExplainString(String prefix, TExplainLevel explainLevel) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(prefix + "OLAP TABLE SINK\n");
        if (explainLevel == TExplainLevel.BRIEF) {
            return strBuilder.toString();
        }
        strBuilder.append(prefix + "  TUPLE ID: " + this.tupleDescriptor.getId() + "\n");
        strBuilder.append(prefix + "  " + DataPartition.RANDOM.getExplainString(explainLevel));
        return strBuilder.toString();
    }

    @Override
    public PlanNodeId getExchNodeId() {
        return null;
    }

    @Override
    public DataPartition getOutputPartition() {
        return DataPartition.RANDOM;
    }

    @Override
    protected TDataSink toThrift() {
        return this.tDataSink;
    }

    private TOlapTableSchemaParam createSchema(long dbId, OlapTable table) {
        TOlapTableSchemaParam schemaParam = new TOlapTableSchemaParam();
        schemaParam.setDbId(dbId);
        schemaParam.setTableId(table.getId());
        schemaParam.setVersion(0L);
        schemaParam.tuple_desc = this.tupleDescriptor.toThrift();
        for (SlotDescriptor slotDescriptor : this.tupleDescriptor.getSlots()) {
            schemaParam.addToSlotDescs(slotDescriptor.toThrift());
        }
        for (Map.Entry entry : table.getIndexIdToMeta().entrySet()) {
            MaterializedIndexMeta indexMeta = (MaterializedIndexMeta)entry.getValue();
            ArrayList columns = Lists.newArrayList();
            columns.addAll(indexMeta.getSchema().stream().map(Column::getName).collect(Collectors.toList()));
            TOlapTableIndexSchema indexSchema = new TOlapTableIndexSchema(((Long)entry.getKey()).longValue(), (List)columns, indexMeta.getSchemaHash());
            schemaParam.addToIndexes(indexSchema);
        }
        return schemaParam;
    }

    private List<String> getDistColumns(DistributionInfo distInfo) throws UserException {
        ArrayList distColumns = Lists.newArrayList();
        switch (distInfo.getType()) {
            case HASH: {
                HashDistributionInfo hashDistributionInfo = (HashDistributionInfo)distInfo;
                for (Column column : hashDistributionInfo.getDistributionColumns()) {
                    distColumns.add(column.getName());
                }
                break;
            }
            case RANDOM: {
                break;
            }
            default: {
                throw new UserException("unsupported distributed type, type=" + (Object)((Object)distInfo.getType()));
            }
        }
        return distColumns;
    }

    private TOlapTablePartitionParam createPartition(long dbId, OlapTable table) throws UserException {
        TOlapTablePartitionParam partitionParam = new TOlapTablePartitionParam();
        partitionParam.setDbId(dbId);
        partitionParam.setTableId(table.getId());
        partitionParam.setVersion(0L);
        PartitionType partType = table.getPartitionInfo().getType();
        switch (partType) {
            case LIST: 
            case RANGE: {
                PartitionInfo partitionInfo = table.getPartitionInfo();
                for (Column partCol : partitionInfo.getPartitionColumns()) {
                    partitionParam.addToPartitionColumns(partCol.getName());
                }
                int partColNum = partitionInfo.getPartitionColumns().size();
                DistributionInfo selectedDistInfo = null;
                for (Long partitionId : this.partitionIds) {
                    Partition partition = table.getPartition(partitionId);
                    TOlapTablePartition tPartition = new TOlapTablePartition();
                    tPartition.setId(partition.getId());
                    this.setPartitionKeys(tPartition, partitionInfo.getItem(partition.getId()), partColNum);
                    for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                        tPartition.addToIndexes(new TOlapTableIndexTablets(index.getId(), (List)Lists.newArrayList((Iterable)index.getTablets().stream().map(Tablet::getId).collect(Collectors.toList()))));
                        tPartition.setNumBuckets(index.getTablets().size());
                    }
                    partitionParam.addToPartitions(tPartition);
                    DistributionInfo distInfo = partition.getDistributionInfo();
                    if (selectedDistInfo == null) {
                        partitionParam.setDistributedColumns(this.getDistColumns(distInfo));
                        selectedDistInfo = distInfo;
                        continue;
                    }
                    if (selectedDistInfo.getType() == distInfo.getType()) continue;
                    throw new UserException("different distribute types in two different partitions, type1=" + (Object)((Object)selectedDistInfo.getType()) + ", type2=" + (Object)((Object)distInfo.getType()));
                }
                break;
            }
            case UNPARTITIONED: {
                Preconditions.checkArgument((table.getPartitions().size() == 1 ? 1 : 0) != 0, (Object)("Number of table partitions is not 1 for unpartitioned table, partitionNum=" + table.getPartitions().size()));
                Partition partition = table.getPartitions().iterator().next();
                TOlapTablePartition tPartition = new TOlapTablePartition();
                tPartition.setId(partition.getId());
                for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                    tPartition.addToIndexes(new TOlapTableIndexTablets(index.getId(), (List)Lists.newArrayList((Iterable)index.getTablets().stream().map(Tablet::getId).collect(Collectors.toList()))));
                    tPartition.setNumBuckets(index.getTablets().size());
                }
                partitionParam.addToPartitions(tPartition);
                partitionParam.setDistributedColumns(this.getDistColumns(partition.getDistributionInfo()));
                break;
            }
            default: {
                throw new UserException("unsupported partition for OlapTable, partition=" + (Object)((Object)partType));
            }
        }
        return partitionParam;
    }

    private void setPartitionKeys(TOlapTablePartition tPartition, PartitionItem partitionItem, int partColNum) {
        block7: {
            block6: {
                int i;
                if (!(partitionItem instanceof RangePartitionItem)) break block6;
                Range range = (Range)partitionItem.getItems();
                if (range.hasLowerBound() && !((PartitionKey)range.lowerEndpoint()).isMinValue()) {
                    for (i = 0; i < partColNum; ++i) {
                        tPartition.addToStartKeys((TExprNode)((PartitionKey)range.lowerEndpoint()).getKeys().get(i).treeToThrift().getNodes().get(0));
                    }
                }
                if (!range.hasUpperBound() || ((PartitionKey)range.upperEndpoint()).isMaxValue()) break block7;
                for (i = 0; i < partColNum; ++i) {
                    tPartition.addToEndKeys((TExprNode)((PartitionKey)range.upperEndpoint()).getKeys().get(i).treeToThrift().getNodes().get(0));
                }
                break block7;
            }
            if (partitionItem instanceof ListPartitionItem) {
                List partitionKeys = (List)partitionItem.getItems();
                for (PartitionKey partitionKey : partitionKeys) {
                    ArrayList<TExprNode> tExprNodes = new ArrayList<TExprNode>();
                    for (int i = 0; i < partColNum; ++i) {
                        tExprNodes.add((TExprNode)partitionKey.getKeys().get(i).treeToThrift().getNodes().get(0));
                    }
                    tPartition.addToInKeys(tExprNodes);
                }
            }
        }
    }

    private TOlapTableLocationParam createLocation(OlapTable table) throws UserException {
        TOlapTableLocationParam locationParam = new TOlapTableLocationParam();
        HashMultimap allBePathsMap = HashMultimap.create();
        for (Long partitionId : this.partitionIds) {
            Partition partition = table.getPartition(partitionId);
            int quorum = table.getPartitionInfo().getReplicaAllocation(partition.getId()).getTotalReplicaNum() / 2 + 1;
            for (MaterializedIndex index : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                for (Tablet tablet : index.getTablets()) {
                    Multimap<Long, Long> bePathsMap = tablet.getNormalReplicaBackendPathMap();
                    if (bePathsMap.keySet().size() < quorum) {
                        throw new UserException(InternalErrorCode.REPLICA_FEW_ERR, "tablet " + tablet.getId() + " has few replicas: " + bePathsMap.keySet().size() + ", alive backends: [" + StringUtils.join((Collection)bePathsMap.keySet(), (String)",") + "]");
                    }
                    locationParam.addToTablets(new TTabletLocation(tablet.getId(), (List)Lists.newArrayList((Iterable)bePathsMap.keySet())));
                    allBePathsMap.putAll(bePathsMap);
                }
            }
        }
        Status st = Catalog.getCurrentSystemInfo().checkExceedDiskCapacityLimit((Multimap<Long, Long>)allBePathsMap, true);
        if (!st.ok()) {
            throw new DdlException(st.getErrorMsg());
        }
        return locationParam;
    }

    private TPaloNodesInfo createPaloNodesInfo() {
        TPaloNodesInfo nodesInfo = new TPaloNodesInfo();
        SystemInfoService systemInfoService = Catalog.getCurrentSystemInfo();
        for (Long id : systemInfoService.getBackendIds(false)) {
            Backend backend = systemInfoService.getBackend(id);
            nodesInfo.addToNodes(new TNodeInfo(backend.getId(), 0L, backend.getHost(), backend.getBrpcPort()));
        }
        return nodesInfo;
    }
}

