/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BaseTableRef;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.ColocateTableIndex;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.HashDistributionInfo;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.MaterializedIndexMeta;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.Util;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.HashDistributionPruner;
import org.apache.doris.planner.ListPartitionPruner;
import org.apache.doris.planner.ListPartitionPrunerV2;
import org.apache.doris.planner.PartitionPruner;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.planner.RangePartitionPruner;
import org.apache.doris.planner.RangePartitionPrunerV2;
import org.apache.doris.planner.RollupSelector;
import org.apache.doris.planner.ScanNode;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.SessionVariable;
import org.apache.doris.system.Backend;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TOlapScanNode;
import org.apache.doris.thrift.TPaloScanRange;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.doris.thrift.TPrimitiveType;
import org.apache.doris.thrift.TScanRange;
import org.apache.doris.thrift.TScanRangeLocation;
import org.apache.doris.thrift.TScanRangeLocations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OlapScanNode
extends ScanNode {
    private static final Logger LOG = LogManager.getLogger(OlapScanNode.class);
    private static final int COMPRESSION_RATIO = 5;
    private List<TScanRangeLocations> result = new ArrayList<TScanRangeLocations>();
    private boolean isPreAggregation = false;
    private String reasonOfPreAggregation = null;
    private boolean canTurnOnPreAggr = true;
    private boolean forceOpenPreAgg = false;
    private OlapTable olapTable = null;
    private long selectedTabletsNum = 0L;
    private long totalTabletsNum = 0L;
    private long selectedIndexId = -1L;
    private int selectedPartitionNum = 0;
    private Collection<Long> selectedPartitionIds = Lists.newArrayList();
    private long totalBytes = 0L;
    private ArrayList<Long> scanTabletIds = Lists.newArrayList();
    private HashSet<Long> scanBackendIds = new HashSet();
    private Map<Long, Integer> tabletId2BucketSeq = Maps.newHashMap();
    public ArrayListMultimap<Integer, TScanRangeLocations> bucketSeq2locations = ArrayListMultimap.create();

    public OlapScanNode(PlanNodeId id, TupleDescriptor desc, String planNodeName) {
        super(id, desc, planNodeName);
        this.olapTable = (OlapTable)desc.getTable();
    }

    public void setIsPreAggregation(boolean isPreAggregation, String reason) {
        this.isPreAggregation = isPreAggregation;
        this.reasonOfPreAggregation = reason;
    }

    public boolean isPreAggregation() {
        return this.isPreAggregation;
    }

    public boolean getCanTurnOnPreAggr() {
        return this.canTurnOnPreAggr;
    }

    public void setCanTurnOnPreAggr(boolean canChangePreAggr) {
        this.canTurnOnPreAggr = canChangePreAggr;
    }

    public void closePreAggregation(String reason) {
        this.setIsPreAggregation(false, reason);
        this.setCanTurnOnPreAggr(false);
    }

    public long getTotalTabletsNum() {
        return this.totalTabletsNum;
    }

    public boolean getForceOpenPreAgg() {
        return this.forceOpenPreAgg;
    }

    public void setForceOpenPreAgg(boolean forceOpenPreAgg) {
        this.forceOpenPreAgg = forceOpenPreAgg;
    }

    public Integer getSelectedPartitionNum() {
        return this.selectedPartitionNum;
    }

    public Long getSelectedTabletsNum() {
        return this.selectedTabletsNum;
    }

    public Collection<Long> getSelectedPartitionIds() {
        return this.selectedPartitionIds;
    }

    public void setSelectedPartitionIds(Collection<Long> selectedPartitionIds) {
        this.selectedPartitionIds = selectedPartitionIds;
    }

    public void useBaseIndexId() {
        this.selectedIndexId = this.olapTable.getBaseIndexId();
    }

    public void updateScanRangeInfoByNewMVSelector(long selectedIndexId, boolean isPreAggregation, String reasonOfDisable) throws UserException {
        boolean update;
        String situation;
        if (selectedIndexId == this.selectedIndexId && isPreAggregation == this.isPreAggregation) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("The new selected index id ").append(selectedIndexId).append(", pre aggregation tag ").append(isPreAggregation).append(", reason ").append(reasonOfDisable == null ? "null" : reasonOfDisable).append(". The old selected index id ").append(this.selectedIndexId).append(" pre aggregation tag ").append(this.isPreAggregation).append(" reason ").append(this.reasonOfPreAggregation == null ? "null" : this.reasonOfPreAggregation);
        String scanRangeInfo = stringBuilder.toString();
        if (this.olapTable.getKeysType() == KeysType.DUP_KEYS) {
            situation = "The key type of table is duplicate.";
            update = true;
        } else if (ConnectContext.get() == null) {
            situation = "Connection context is null";
            update = true;
        } else {
            SessionVariable sessionVariable = ConnectContext.get().getSessionVariable();
            if (sessionVariable.getTestMaterializedView()) {
                throw new AnalysisException("The old scan range info is different from the new one when test_materialized_view is true. " + scanRangeInfo);
            }
            situation = "The key type of table is aggregated.";
            update = false;
        }
        if (update) {
            this.selectedIndexId = selectedIndexId;
            this.setIsPreAggregation(isPreAggregation, reasonOfDisable);
            this.updateColumnType();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using the new scan range info instead of the old one. {}, {}", (Object)situation, (Object)scanRangeInfo);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Using the old scan range info instead of the new one. {}, {}", (Object)situation, (Object)scanRangeInfo);
        }
    }

    private void updateColumnType() {
        if (this.selectedIndexId == this.olapTable.getBaseIndexId()) {
            return;
        }
        MaterializedIndexMeta meta = this.olapTable.getIndexMetaByIndexId(this.selectedIndexId);
        for (SlotDescriptor slotDescriptor : this.desc.getSlots()) {
            if (!slotDescriptor.isMaterialized()) continue;
            Column baseColumn = slotDescriptor.getColumn();
            Preconditions.checkNotNull((Object)baseColumn);
            Column mvColumn = meta.getColumnByName(baseColumn.getName());
            Preconditions.checkNotNull((Object)mvColumn);
            if (mvColumn.getType() == baseColumn.getType()) continue;
            slotDescriptor.setColumn(mvColumn);
        }
    }

    public OlapTable getOlapTable() {
        return this.olapTable;
    }

    @Override
    protected String debugString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        helper.addValue((Object)super.debugString());
        helper.addValue((Object)("olapTable=" + this.olapTable.getName()));
        return helper.toString();
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        super.init(analyzer);
        this.filterDeletedRows(analyzer);
        this.computeColumnFilter();
        this.computePartitionInfo();
        this.computeTupleState(analyzer);
        if (analyzer.safeIsEnableJoinReorderBasedCost()) {
            this.computeInaccurateCardinality();
        }
    }

    @Override
    public void finalize(Analyzer analyzer) throws UserException {
        LOG.debug("OlapScanNode get scan range locations. Tuple: {}", (Object)this.desc);
        if (analyzer.safeIsEnableJoinReorderBasedCost()) {
            this.cardinality = 0L;
        }
        try {
            this.getScanRangeLocations();
        }
        catch (AnalysisException e) {
            throw new UserException(e.getMessage());
        }
        this.computeStats(analyzer);
        this.computeNumNodes();
    }

    public void computeTupleState(Analyzer analyzer) {
        for (TupleId id : this.tupleIds) {
            analyzer.getDescTbl().getTupleDesc(id).computeStat();
        }
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        if (this.cardinality > 0L) {
            this.avgRowSize = (float)this.totalBytes / (float)this.cardinality * 5.0f;
            this.capCardinalityAtLimit();
        }
        this.cardinality = this.cardinality == -1L ? 0L : this.cardinality;
    }

    @Override
    protected void computeNumNodes() {
        if (this.cardinality > 0L) {
            this.numNodes = this.scanBackendIds.size();
        }
        this.numNodes = this.numNodes <= 0 ? 1 : this.numNodes;
    }

    private void computeInaccurateCardinality() {
        this.cardinality = 0L;
        for (long selectedPartitionId : this.selectedPartitionIds) {
            Partition partition = this.olapTable.getPartition(selectedPartitionId);
            MaterializedIndex baseIndex = partition.getBaseIndex();
            this.cardinality += baseIndex.getRowCount();
        }
        this.applyConjunctsSelectivity();
        this.capCardinalityAtLimit();
    }

    private Collection<Long> partitionPrune(PartitionInfo partitionInfo, PartitionNames partitionNames) throws AnalysisException {
        Map<Object, Object> keyItemMap;
        PartitionPruner partitionPruner = null;
        if (partitionNames != null) {
            keyItemMap = Maps.newHashMap();
            for (String partName : partitionNames.getPartitionNames()) {
                Partition partition = this.olapTable.getPartition(partName, partitionNames.isTemp());
                if (partition == null) {
                    ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_SUCH_PARTITION, partName);
                }
                keyItemMap.put(partition.getId(), partitionInfo.getItem(partition.getId()));
            }
        } else {
            keyItemMap = partitionInfo.getIdToItem(false);
        }
        if (partitionInfo.getType() == PartitionType.RANGE) {
            partitionPruner = this.analyzer.partitionPruneV2Enabled() ? new RangePartitionPrunerV2((Map<Long, PartitionItem>)keyItemMap, partitionInfo.getPartitionColumns(), this.columnNameToRange) : new RangePartitionPruner((Map<Long, PartitionItem>)keyItemMap, partitionInfo.getPartitionColumns(), this.columnFilters);
        } else if (partitionInfo.getType() == PartitionType.LIST) {
            partitionPruner = this.analyzer.partitionPruneV2Enabled() ? new ListPartitionPrunerV2((Map<Long, PartitionItem>)keyItemMap, partitionInfo.getPartitionColumns(), this.columnNameToRange) : new ListPartitionPruner((Map<Long, PartitionItem>)keyItemMap, partitionInfo.getPartitionColumns(), this.columnFilters);
        }
        return partitionPruner.prune();
    }

    private Collection<Long> distributionPrune(MaterializedIndex table, DistributionInfo distributionInfo) throws AnalysisException {
        HashDistributionPruner distributionPruner = null;
        switch (distributionInfo.getType()) {
            case HASH: {
                HashDistributionInfo info = (HashDistributionInfo)distributionInfo;
                distributionPruner = new HashDistributionPruner(table.getTabletIdsInOrder(), info.getDistributionColumns(), this.columnFilters, info.getBucketNum());
                return distributionPruner.prune();
            }
            case RANDOM: {
                return null;
            }
        }
        return null;
    }

    private void addScanRangeLocations(Partition partition, MaterializedIndex index, List<Tablet> tablets) throws UserException {
        int schemaHash = this.olapTable.getSchemaHashByIndexId(index.getId());
        String schemaHashStr = String.valueOf(schemaHash);
        long visibleVersion = partition.getVisibleVersion();
        String visibleVersionStr = String.valueOf(visibleVersion);
        Set<Object> allowedTags = Sets.newHashSet();
        boolean needCheckTags = false;
        if (ConnectContext.get() != null) {
            allowedTags = ConnectContext.get().getResourceTags();
            needCheckTags = ConnectContext.get().isResourceTagsSet();
        }
        for (Tablet tablet : tablets) {
            long tabletId = tablet.getId();
            TScanRangeLocations scanRangeLocations = new TScanRangeLocations();
            TPaloScanRange paloRange = new TPaloScanRange();
            paloRange.setDbName("");
            paloRange.setSchemaHash(schemaHashStr);
            paloRange.setVersion(visibleVersionStr);
            paloRange.setVersionHash("");
            paloRange.setTabletId(tabletId);
            List<Replica> replicas = tablet.getQueryableReplicas(visibleVersion, schemaHash);
            if (replicas.isEmpty()) {
                LOG.error("no queryable replica found in tablet {}. visible version {}", (Object)tabletId, (Object)visibleVersion);
                if (LOG.isDebugEnabled()) {
                    for (Replica replica : tablet.getReplicas()) {
                        LOG.debug("tablet {}, replica: {}", (Object)tabletId, (Object)replica.toString());
                    }
                }
                throw new UserException("Failed to get scan range, no queryable replica found in tablet: " + tabletId);
            }
            Collections.shuffle(replicas);
            boolean tabletIsNull = true;
            boolean collectedStat = false;
            ArrayList errs = Lists.newArrayList();
            for (Replica replica : replicas) {
                Backend backend = Catalog.getCurrentSystemInfo().getBackend(replica.getBackendId());
                if (backend == null || !backend.isAlive()) {
                    LOG.debug("backend {} not exists or is not alive for replica {}", (Object)replica.getBackendId(), (Object)replica.getId());
                    errs.add(replica.getId() + "'s backend " + replica.getBackendId() + " does not exist or not alive");
                    continue;
                }
                if (needCheckTags && !allowedTags.isEmpty() && !allowedTags.contains(backend.getTag())) {
                    String err = String.format("Replica on backend %d with tag %s, which is not in user's resource tags: %s", backend.getId(), backend.getTag(), allowedTags);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(err);
                    }
                    errs.add(err);
                    continue;
                }
                String ip = backend.getHost();
                int port = backend.getBePort();
                TScanRangeLocation scanRangeLocation = new TScanRangeLocation(new TNetworkAddress(ip, port));
                scanRangeLocation.setBackendId(replica.getBackendId());
                scanRangeLocations.addToLocations(scanRangeLocation);
                paloRange.addToHosts(new TNetworkAddress(ip, port));
                tabletIsNull = false;
                if (!collectedStat && replica.getRowCount() != -1L) {
                    this.cardinality += replica.getRowCount();
                    this.totalBytes += replica.getDataSize();
                    collectedStat = true;
                }
                this.scanBackendIds.add(backend.getId());
            }
            if (tabletIsNull) {
                throw new UserException(tabletId + " have no queryable replicas. err: " + Joiner.on((String)", ").join((Iterable)errs));
            }
            TScanRange scanRange = new TScanRange();
            scanRange.setPaloScanRange(paloRange);
            scanRangeLocations.setScanRange(scanRange);
            this.bucketSeq2locations.put((Object)this.tabletId2BucketSeq.get(tabletId), (Object)scanRangeLocations);
            this.result.add(scanRangeLocations);
        }
        if (tablets.size() == 0) {
            this.desc.setCardinality(0L);
        } else {
            this.desc.setCardinality(this.cardinality);
        }
    }

    private void computePartitionInfo() throws AnalysisException {
        long start = System.currentTimeMillis();
        PartitionNames partitionNames = ((BaseTableRef)this.desc.getRef()).getPartitionNames();
        PartitionInfo partitionInfo = this.olapTable.getPartitionInfo();
        this.selectedPartitionIds = partitionInfo.getType() == PartitionType.RANGE || partitionInfo.getType() == PartitionType.LIST ? this.partitionPrune(partitionInfo, partitionNames) : null;
        if (this.selectedPartitionIds == null) {
            this.selectedPartitionIds = Lists.newArrayList();
            for (Partition partition : this.olapTable.getPartitions()) {
                if (!partition.hasData()) continue;
                this.selectedPartitionIds.add(partition.getId());
            }
        } else {
            this.selectedPartitionIds = this.selectedPartitionIds.stream().filter(id -> this.olapTable.getPartition((long)id).hasData()).collect(Collectors.toList());
        }
        this.selectedPartitionNum = this.selectedPartitionIds.size();
        Iterator<Object> iterator = this.selectedPartitionIds.iterator();
        while (iterator.hasNext()) {
            long id2 = (Long)iterator.next();
            Partition partition = this.olapTable.getPartition(id2);
            if (partition.getState() != Partition.PartitionState.RESTORE) continue;
            ErrorReport.reportAnalysisException(ErrorCode.ERR_BAD_PARTITION_STATE, partition.getName(), "RESTORING");
        }
        LOG.debug("partition prune cost: {} ms, partitions: {}", (Object)(System.currentTimeMillis() - start), this.selectedPartitionIds);
    }

    public void selectBestRollupByRollupSelector(Analyzer analyzer) throws UserException {
        long start = System.currentTimeMillis();
        if (this.olapTable.getKeysType() == KeysType.DUP_KEYS) {
            this.selectedIndexId = this.olapTable.getBaseIndexId();
            LOG.debug("The best index will be selected later in mv selector");
            return;
        }
        RollupSelector rollupSelector = new RollupSelector(analyzer, this.desc, this.olapTable);
        this.selectedIndexId = rollupSelector.selectBestRollup(this.selectedPartitionIds, this.conjuncts, this.isPreAggregation);
        LOG.debug("select best roll up cost: {} ms, best index id: {}", (Object)(System.currentTimeMillis() - start), (Object)this.selectedIndexId);
    }

    private void getScanRangeLocations() throws UserException {
        if (this.selectedPartitionIds.size() == 0) {
            this.desc.setCardinality(0L);
            return;
        }
        Preconditions.checkState((this.selectedIndexId != -1L ? 1 : 0) != 0);
        long start = System.currentTimeMillis();
        this.computeTabletInfo();
        LOG.debug("distribution prune cost: {} ms", (Object)(System.currentTimeMillis() - start));
    }

    private void computeTabletInfo() throws UserException {
        Preconditions.checkState((this.scanBackendIds.size() == 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.scanTabletIds.size() == 0 ? 1 : 0) != 0);
        for (Long partitionId : this.selectedPartitionIds) {
            Partition partition = this.olapTable.getPartition(partitionId);
            MaterializedIndex selectedTable = partition.getIndex(this.selectedIndexId);
            ArrayList tablets = Lists.newArrayList();
            Collection<Long> tabletIds = this.distributionPrune(selectedTable, partition.getDistributionInfo());
            LOG.debug("distribution prune tablets: {}", tabletIds);
            List<Long> allTabletIds = selectedTable.getTabletIdsInOrder();
            if (tabletIds != null) {
                for (Long id : tabletIds) {
                    tablets.add(selectedTable.getTablet(id));
                }
                this.scanTabletIds.addAll(tabletIds);
            } else {
                tablets.addAll(selectedTable.getTablets());
                this.scanTabletIds.addAll(allTabletIds);
            }
            for (int i = 0; i < allTabletIds.size(); ++i) {
                this.tabletId2BucketSeq.put(allTabletIds.get(i), i);
            }
            this.totalTabletsNum += (long)selectedTable.getTablets().size();
            this.selectedTabletsNum += (long)tablets.size();
            this.addScanRangeLocations(partition, selectedTable, tablets);
        }
    }

    @Override
    public List<TScanRangeLocations> getScanRangeLocations(long maxScanRangeLength) {
        return this.result;
    }

    @Override
    public String getNodeExplainString(String prefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        String indexName = this.olapTable.getIndexNameById(this.selectedIndexId);
        output.append(prefix).append("TABLE: ").append(this.olapTable.getName()).append("(").append(indexName).append(")");
        if (detailLevel == TExplainLevel.BRIEF) {
            return output.toString();
        }
        if (this.isPreAggregation) {
            output.append(", PREAGGREGATION: ON");
        } else {
            output.append(", PREAGGREGATION: OFF. Reason: ").append(this.reasonOfPreAggregation);
        }
        output.append("\n");
        if (null != this.sortColumn) {
            output.append(prefix).append("SORT COLUMN: ").append(this.sortColumn).append("\n");
        }
        if (!this.conjuncts.isEmpty()) {
            output.append(prefix).append("PREDICATES: ").append(this.getExplainString(this.conjuncts)).append("\n");
        }
        if (!this.runtimeFilters.isEmpty()) {
            output.append(prefix).append("runtime filters: ");
            output.append(this.getRuntimeFilterExplainString(false));
        }
        output.append(prefix).append(String.format("partitions=%s/%s, tablets=%s/%s", this.selectedPartitionNum, this.olapTable.getPartitions().size(), this.selectedTabletsNum, this.totalTabletsNum));
        if (this.scanTabletIds.size() > 3) {
            List<Long> firstTenTabletIds = this.scanTabletIds.subList(0, 3);
            output.append(String.format(", tabletList=%s ...", Joiner.on((String)",").join(firstTenTabletIds)));
        } else {
            output.append(String.format(", tabletList=%s", Joiner.on((String)",").join(this.scanTabletIds)));
        }
        output.append("\n");
        output.append(prefix).append(String.format("cardinality=%s", this.cardinality)).append(String.format(", avgRowSize=%s", Float.valueOf(this.avgRowSize))).append(String.format(", numNodes=%s", this.numNodes));
        output.append("\n");
        return output.toString();
    }

    @Override
    public int getNumInstances() {
        return this.result.size();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        ArrayList<String> keyColumnNames = new ArrayList<String>();
        ArrayList<TPrimitiveType> keyColumnTypes = new ArrayList<TPrimitiveType>();
        if (this.selectedIndexId != -1L) {
            for (Column col : this.olapTable.getSchemaByIndexId(this.selectedIndexId)) {
                if (!col.isKey()) break;
                keyColumnNames.add(col.getName());
                keyColumnTypes.add(col.getDataType().toThrift());
            }
        }
        msg.node_type = TPlanNodeType.OLAP_SCAN_NODE;
        msg.olap_scan_node = new TOlapScanNode(this.desc.getId().asInt(), keyColumnNames, keyColumnTypes, this.isPreAggregation);
        if (null != this.sortColumn) {
            msg.olap_scan_node.setSortColumn(this.sortColumn);
        }
        msg.olap_scan_node.setKeyType(this.olapTable.getKeysType().toThrift());
    }

    public static OlapScanNode createOlapScanNodeByLocation(PlanNodeId id, TupleDescriptor desc, String planNodeName, List<TScanRangeLocations> locationsList) {
        OlapScanNode olapScanNode = new OlapScanNode(id, desc, planNodeName);
        olapScanNode.numInstances = 1;
        olapScanNode.selectedIndexId = olapScanNode.olapTable.getBaseIndexId();
        olapScanNode.selectedPartitionNum = 1;
        olapScanNode.selectedTabletsNum = 1L;
        olapScanNode.totalTabletsNum = 1L;
        olapScanNode.setIsPreAggregation(false, "Export job");
        olapScanNode.result.addAll(locationsList);
        return olapScanNode;
    }

    public void collectColumns(Analyzer analyzer, Set<String> equivalenceColumns, Set<String> unequivalenceColumns) {
        block0: for (Expr expr : this.conjuncts) {
            if (!this.isPredicateUsedForPrefixIndex(expr, false)) continue;
            for (SlotDescriptor slot : this.desc.getMaterializedSlots()) {
                if (!expr.isBound(slot.getId())) continue;
                if (!this.isEquivalenceExpr(expr)) {
                    unequivalenceColumns.add(slot.getColumn().getName());
                    continue block0;
                }
                equivalenceColumns.add(slot.getColumn().getName());
                continue block0;
            }
        }
        List<Expr> eqJoinPredicate = analyzer.getEqJoinConjuncts(this.desc.getId());
        for (Expr expr : eqJoinPredicate) {
            if (!this.isPredicateUsedForPrefixIndex(expr, true)) continue;
            block3: for (SlotDescriptor slot : this.desc.getMaterializedSlots()) {
                Preconditions.checkState((expr.getChildren().size() == 2 ? 1 : 0) != 0);
                for (Expr child : expr.getChildren()) {
                    if (!child.isBound(slot.getId())) continue;
                    equivalenceColumns.add(slot.getColumn().getName());
                    continue block3;
                }
            }
        }
    }

    public TupleId getTupleId() {
        Preconditions.checkNotNull((Object)this.desc);
        return this.desc.getId();
    }

    private boolean isEquivalenceExpr(Expr expr) {
        BinaryPredicate predicate;
        if (expr instanceof InPredicate) {
            return true;
        }
        return expr instanceof BinaryPredicate && (predicate = (BinaryPredicate)expr).getOp().isEquivalence();
    }

    private boolean isPredicateUsedForPrefixIndex(Expr expr, boolean isJoinConjunct) {
        if (!(expr instanceof InPredicate) && !(expr instanceof BinaryPredicate)) {
            return false;
        }
        if (expr instanceof InPredicate) {
            return this.isInPredicateUsedForPrefixIndex((InPredicate)expr);
        }
        if (expr instanceof BinaryPredicate) {
            if (isJoinConjunct) {
                return this.isEqualJoinConjunctUsedForPrefixIndex((BinaryPredicate)expr);
            }
            return this.isBinaryPredicateUsedForPrefixIndex((BinaryPredicate)expr);
        }
        return true;
    }

    private boolean isEqualJoinConjunctUsedForPrefixIndex(BinaryPredicate expr) {
        Preconditions.checkArgument((boolean)expr.getOp().isEquivalence());
        if (expr.isAuxExpr()) {
            return false;
        }
        for (Expr child : expr.getChildren()) {
            for (SlotDescriptor slot : this.desc.getMaterializedSlots()) {
                if (!child.isBound(slot.getId()) || !this.isSlotRefNested(child)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBinaryPredicateUsedForPrefixIndex(BinaryPredicate expr) {
        if (expr.isAuxExpr() || expr.getOp().isUnequivalence()) {
            return false;
        }
        return this.isSlotRefNested((Expr)expr.getChild(0)) && ((Expr)expr.getChild(1)).isConstant() || this.isSlotRefNested((Expr)expr.getChild(1)) && ((Expr)expr.getChild(0)).isConstant();
    }

    private boolean isInPredicateUsedForPrefixIndex(InPredicate expr) {
        if (expr.isNotIn()) {
            return false;
        }
        return this.isSlotRefNested((Expr)expr.getChild(0)) && expr.isLiteralChildren();
    }

    private boolean isSlotRefNested(Expr expr) {
        while (expr instanceof CastExpr) {
            expr = (Expr)expr.getChild(0);
        }
        return expr instanceof SlotRef;
    }

    private void filterDeletedRows(Analyzer analyzer) throws AnalysisException {
        if (!Util.showHiddenColumns() && this.olapTable.hasDeleteSign()) {
            SlotRef deleteSignSlot = new SlotRef(this.desc.getAliasAsName(), "__DORIS_DELETE_SIGN__");
            deleteSignSlot.analyze(analyzer);
            deleteSignSlot.getDesc().setIsMaterialized(true);
            deleteSignSlot.getDesc().setIsNullable(analyzer.isOuterMaterializedJoined(this.desc.getId()));
            BinaryPredicate conjunct = new BinaryPredicate(BinaryPredicate.Operator.EQ, deleteSignSlot, new IntLiteral(0L));
            conjunct.analyze(analyzer);
            this.conjuncts.add(conjunct);
        }
    }

    public DataPartition constructInputPartitionByDistributionInfo() throws UserException {
        ColocateTableIndex colocateTableIndex = Catalog.getCurrentColocateIndex();
        if (colocateTableIndex.isColocateTable(this.olapTable.getId()) && !colocateTableIndex.isGroupUnstable(colocateTableIndex.getGroup(this.olapTable.getId())) || this.olapTable.getPartitionInfo().getType() == PartitionType.UNPARTITIONED || this.olapTable.getPartitions().size() == 1) {
            DistributionInfo distributionInfo = this.olapTable.getDefaultDistributionInfo();
            if (!(distributionInfo instanceof HashDistributionInfo)) {
                return DataPartition.RANDOM;
            }
            List<Column> distributeColumns = ((HashDistributionInfo)distributionInfo).getDistributionColumns();
            ArrayList dataDistributeExprs = Lists.newArrayList();
            for (Column column : distributeColumns) {
                SlotRef slotRef = new SlotRef(this.desc.getRef().getName(), column.getName());
                dataDistributeExprs.add(slotRef);
            }
            return DataPartition.hashPartitioned(dataDistributeExprs);
        }
        return DataPartition.RANDOM;
    }
}

