/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import org.apache.doris.catalog.OdbcTable;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.DataSink;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.thrift.TDataSink;
import org.apache.doris.thrift.TDataSinkType;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TOdbcTableSink;
import org.apache.doris.thrift.TOdbcTableType;

public class OdbcTableSink
extends DataSink {
    private final TOdbcTableType odbcType;
    private final String tblName;
    private final String originTblName;
    private final String connectString;
    private final boolean useTransaction;

    public OdbcTableSink(OdbcTable odbcTable) {
        this.connectString = odbcTable.getConnectString();
        this.originTblName = odbcTable.getName();
        this.odbcType = odbcTable.getOdbcTableType();
        this.tblName = OdbcTable.databaseProperName(this.odbcType, odbcTable.getOdbcTableName());
        this.useTransaction = ConnectContext.get().getSessionVariable().isEnableOdbcTransaction();
    }

    @Override
    public String getExplainString(String prefix, TExplainLevel explainLevel) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(prefix + "ODBC TABLE SINK:\n");
        strBuilder.append(prefix + "TABLENAME IN DORIS: ").append(this.originTblName).append("\n");
        strBuilder.append(prefix + "TABLE TYPE: ").append(this.odbcType.toString()).append("\n");
        strBuilder.append(prefix + "TABLENAME OF EXTERNAL TABLE: ").append(this.tblName).append("\n");
        strBuilder.append(prefix + "EnableTransaction: ").append(this.useTransaction ? "true" : "false").append("\n");
        return strBuilder.toString();
    }

    @Override
    protected TDataSink toThrift() {
        TDataSink tDataSink = new TDataSink(TDataSinkType.ODBC_TABLE_SINK);
        TOdbcTableSink odbcTableSink = new TOdbcTableSink();
        odbcTableSink.setConnectString(this.connectString);
        odbcTableSink.setTable(this.tblName);
        odbcTableSink.setUseTransaction(this.useTransaction);
        tDataSink.setOdbcTableSink(odbcTableSink);
        return tDataSink;
    }

    @Override
    public PlanNodeId getExchNodeId() {
        return null;
    }

    @Override
    public DataPartition getOutputPartition() {
        return null;
    }
}

