/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.OdbcTable;
import org.apache.doris.common.UserException;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.planner.ScanNode;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TOdbcScanNode;
import org.apache.doris.thrift.TOdbcTableType;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.doris.thrift.TScanRangeLocations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OdbcScanNode
extends ScanNode {
    private static final Logger LOG = LogManager.getLogger(OdbcScanNode.class);
    private final List<String> columns = new ArrayList<String>();
    private final List<String> filters = new ArrayList<String>();
    private String tblName;
    private String connectString;
    private TOdbcTableType odbcType;

    private static boolean shouldPushDownConjunct(TOdbcTableType tableType, Expr expr) {
        if (!tableType.equals((Object)TOdbcTableType.MYSQL)) {
            ArrayList fnExprList = Lists.newArrayList();
            expr.collect(FunctionCallExpr.class, fnExprList);
            if (!fnExprList.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public OdbcScanNode(PlanNodeId id, TupleDescriptor desc, OdbcTable tbl) {
        super(id, desc, "SCAN ODBC");
        this.connectString = tbl.getConnectString();
        this.odbcType = tbl.getOdbcTableType();
        this.tblName = OdbcTable.databaseProperName(this.odbcType, tbl.getOdbcTableName());
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        super.init(analyzer);
        this.computeStats(analyzer);
    }

    @Override
    protected String debugString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        return helper.addValue((Object)super.debugString()).toString();
    }

    @Override
    public void finalize(Analyzer analyzer) throws UserException {
        this.createOdbcColumns(analyzer);
        this.createOdbcFilters(analyzer);
    }

    @Override
    public String getNodeExplainString(String prefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(prefix).append("TABLE: ").append(this.tblName).append("\n");
        output.append(prefix).append("TABLE TYPE: ").append(this.odbcType.toString()).append("\n");
        if (detailLevel == TExplainLevel.BRIEF) {
            return output.toString();
        }
        output.append(prefix).append("QUERY: ").append(this.getOdbcQueryStr()).append("\n");
        return output.toString();
    }

    private boolean shouldPushDownLimit() {
        return this.limit != -1L && this.conjuncts.isEmpty();
    }

    private String getOdbcQueryStr() {
        StringBuilder sql = new StringBuilder("SELECT ");
        if (this.shouldPushDownLimit() && this.odbcType == TOdbcTableType.ORACLE) {
            this.filters.add("ROWNUM <= " + this.limit);
        }
        if (this.shouldPushDownLimit() && this.odbcType == TOdbcTableType.SQLSERVER) {
            sql.append("TOP " + this.limit + " ");
        }
        sql.append(Joiner.on((String)", ").join(this.columns));
        sql.append(" FROM ").append(this.tblName);
        if (!this.filters.isEmpty()) {
            sql.append(" WHERE (");
            sql.append(Joiner.on((String)") AND (").join(this.filters));
            sql.append(")");
        }
        if (this.shouldPushDownLimit() && (this.odbcType == TOdbcTableType.MYSQL || this.odbcType == TOdbcTableType.POSTGRESQL || this.odbcType == TOdbcTableType.MONGODB)) {
            sql.append(" LIMIT " + this.limit);
        }
        return sql.toString();
    }

    private void createOdbcColumns(Analyzer analyzer) {
        for (SlotDescriptor slot : this.desc.getSlots()) {
            if (!slot.isMaterialized()) continue;
            Column col = slot.getColumn();
            this.columns.add(OdbcTable.databaseProperName(this.odbcType, col.getName()));
        }
        if (0 == this.columns.size()) {
            this.columns.add("*");
        }
    }

    private void createOdbcFilters(Analyzer analyzer) {
        if (this.conjuncts.isEmpty()) {
            return;
        }
        ArrayList slotRefs = Lists.newArrayList();
        Expr.collectList(this.conjuncts, SlotRef.class, slotRefs);
        ExprSubstitutionMap sMap = new ExprSubstitutionMap();
        for (SlotRef slotRef : slotRefs) {
            SlotRef tmpRef = (SlotRef)slotRef.clone();
            tmpRef.setTblName(null);
            tmpRef.setLabel(OdbcTable.databaseProperName(this.odbcType, tmpRef.getColumnName()));
            sMap.put(slotRef, tmpRef);
        }
        ArrayList<Expr> odbcConjuncts = Expr.cloneList(this.conjuncts, sMap);
        for (Expr p : odbcConjuncts) {
            if (!OdbcScanNode.shouldPushDownConjunct(this.odbcType, p)) continue;
            String filter = p.toMySql();
            this.filters.add(filter);
            this.conjuncts.remove(p);
        }
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.ODBC_SCAN_NODE;
        TOdbcScanNode odbcScanNode = new TOdbcScanNode();
        odbcScanNode.setTupleId(this.desc.getId().asInt());
        odbcScanNode.setTableName(this.tblName);
        odbcScanNode.setConnectString(this.connectString);
        odbcScanNode.setQueryString(this.getOdbcQueryStr());
        msg.odbc_scan_node = odbcScanNode;
    }

    @Override
    public List<TScanRangeLocations> getScanRangeLocations(long maxScanRangeLength) {
        return null;
    }

    @Override
    public int getNumInstances() {
        return 1;
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        this.numNodes = this.numNodes <= 0 ? 1 : this.numNodes;
        this.cardinality = this.cardinality == -1L ? 1L : this.cardinality;
    }
}

