/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import org.apache.doris.catalog.MysqlTable;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.DataSink;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TDataSink;
import org.apache.doris.thrift.TDataSinkType;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TMysqlTableSink;

public class MysqlTableSink
extends DataSink {
    private final String host;
    private final int port;
    private final String user;
    private final String passwd;
    private final String db;
    private final String tbl;

    public MysqlTableSink(MysqlTable mysqlTable) {
        this.host = mysqlTable.getHost();
        this.port = Integer.valueOf(mysqlTable.getPort());
        this.user = mysqlTable.getUserName();
        this.passwd = mysqlTable.getPasswd();
        this.db = mysqlTable.getMysqlDatabaseName();
        this.tbl = mysqlTable.getMysqlTableName();
    }

    @Override
    public String getExplainString(String prefix, TExplainLevel explainLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append("MYSQL TABLE SINK\n");
        sb.append("host: ").append(this.host).append("\n");
        return sb.toString();
    }

    @Override
    protected TDataSink toThrift() {
        TDataSink tDataSink = new TDataSink(TDataSinkType.MYSQL_TABLE_SINK);
        tDataSink.setMysqlTableSink(new TMysqlTableSink(this.host, this.port, this.user, this.passwd, this.db, this.tbl));
        return tDataSink;
    }

    @Override
    public PlanNodeId getExchNodeId() {
        return null;
    }

    @Override
    public DataPartition getOutputPartition() {
        return null;
    }
}

