/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.MysqlTable;
import org.apache.doris.common.UserException;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.planner.ScanNode;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TMySQLScanNode;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.doris.thrift.TScanRangeLocations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MysqlScanNode
extends ScanNode {
    private static final Logger LOG = LogManager.getLogger(MysqlScanNode.class);
    private final List<String> columns = new ArrayList<String>();
    private final List<String> filters = new ArrayList<String>();
    private String tblName;

    public MysqlScanNode(PlanNodeId id, TupleDescriptor desc, MysqlTable tbl) {
        super(id, desc, "SCAN MYSQL");
        this.tblName = "`" + tbl.getMysqlTableName() + "`";
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        super.init(analyzer);
        this.computeStats(analyzer);
    }

    @Override
    protected String debugString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        return helper.addValue((Object)super.debugString()).toString();
    }

    @Override
    public void finalize(Analyzer analyzer) throws UserException {
        this.createMySQLColumns(analyzer);
        this.createMySQLFilters(analyzer);
    }

    @Override
    public String getNodeExplainString(String prefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(prefix).append("TABLE: ").append(this.tblName).append("\n");
        if (detailLevel == TExplainLevel.BRIEF) {
            return output.toString();
        }
        output.append(prefix).append("Query: ").append(this.getMysqlQueryStr()).append("\n");
        return output.toString();
    }

    private String getMysqlQueryStr() {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(Joiner.on((String)", ").join(this.columns));
        sql.append(" FROM ").append(this.tblName);
        if (!this.filters.isEmpty()) {
            sql.append(" WHERE (");
            sql.append(Joiner.on((String)") AND (").join(this.filters));
            sql.append(")");
        }
        if (this.limit != -1L) {
            sql.append(" LIMIT " + this.limit);
        }
        return sql.toString();
    }

    private void createMySQLColumns(Analyzer analyzer) {
        for (SlotDescriptor slot : this.desc.getSlots()) {
            if (!slot.isMaterialized()) continue;
            Column col = slot.getColumn();
            this.columns.add("`" + col.getName() + "`");
        }
        if (0 == this.columns.size()) {
            this.columns.add("*");
        }
    }

    private void createMySQLFilters(Analyzer analyzer) {
        if (this.conjuncts.isEmpty()) {
            return;
        }
        ArrayList slotRefs = Lists.newArrayList();
        Expr.collectList(this.conjuncts, SlotRef.class, slotRefs);
        ExprSubstitutionMap sMap = new ExprSubstitutionMap();
        for (SlotRef slotRef : slotRefs) {
            SlotRef tmpRef = (SlotRef)slotRef.clone();
            tmpRef.setTblName(null);
            sMap.put(slotRef, tmpRef);
        }
        ArrayList<Expr> mysqlConjuncts = Expr.cloneList(this.conjuncts, sMap);
        for (Expr p : mysqlConjuncts) {
            this.filters.add(p.toMySql());
        }
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.MYSQL_SCAN_NODE;
        msg.mysql_scan_node = new TMySQLScanNode(this.desc.getId().asInt(), this.tblName, this.columns, this.filters);
    }

    @Override
    public List<TScanRangeLocations> getScanRangeLocations(long maxScanRangeLength) {
        return null;
    }

    @Override
    public int getNumInstances() {
        return 1;
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        this.numNodes = this.numNodes <= 0 ? 1 : this.numNodes;
        this.cardinality = this.cardinality == -1L ? 1L : this.cardinality;
    }
}

