/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.common.UserException;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TMergeNode;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MergeNode
extends PlanNode {
    private static final Logger LOG = LogManager.getLogger(MergeNode.class);
    protected List<List<Expr>> resultExprLists = Lists.newArrayList();
    protected List<List<Expr>> constExprLists = Lists.newArrayList();
    protected final List<TupleDescriptor> tupleDescs = Lists.newArrayList();
    protected final TupleId tupleId;

    protected MergeNode(PlanNodeId id, MergeNode node) {
        super(id, node, "MERGE");
        this.tupleId = node.tupleId;
    }

    public void addConstExprList(List<Expr> exprs) {
        this.constExprLists.add(exprs);
    }

    public void addChild(PlanNode node, List<Expr> resultExprs) {
        this.addChild(node);
        this.resultExprLists.add(resultExprs);
        if (resultExprs != null) {
            Preconditions.checkState((this.tupleIds.size() == 1 ? 1 : 0) != 0);
        }
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        this.assignConjuncts(analyzer);
        this.computeStats(analyzer);
        Preconditions.checkState((this.resultExprLists.size() == this.getChildren().size() ? 1 : 0) != 0);
        ArrayList<SlotDescriptor> slots = analyzer.getDescTbl().getTupleDesc(this.tupleId).getSlots();
        ArrayList newResultExprLists = Lists.newArrayList();
        Preconditions.checkState((this.resultExprLists.size() == this.getChildren().size() ? 1 : 0) != 0);
        ArrayList newConstExprLists = Lists.newArrayList();
        for (List<Expr> exprList : this.constExprLists) {
            ArrayList newExprList = Lists.newArrayList();
            for (int i = 0; i < exprList.size(); ++i) {
                if (!((SlotDescriptor)slots.get(i)).isMaterialized()) continue;
                newExprList.add(exprList.get(i));
            }
            newConstExprLists.add(newExprList);
        }
        this.constExprLists = newConstExprLists;
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        if (!analyzer.safeIsEnableJoinReorderBasedCost()) {
            return;
        }
        this.cardinality = this.constExprLists.size();
        for (PlanNode child : this.children) {
            if (child.cardinality <= 0L) continue;
            this.cardinality += child.cardinality;
        }
        this.applyConjunctsSelectivity();
        this.capCardinalityAtLimit();
        if (LOG.isDebugEnabled()) {
            LOG.debug("stats Merge: cardinality={}", (Object)Long.toString(this.cardinality));
        }
    }

    @Override
    protected void computeOldCardinality() {
        this.cardinality = this.constExprLists.size();
        for (PlanNode child : this.children) {
            if (child.cardinality <= 0L) continue;
            this.cardinality += child.cardinality;
        }
        LOG.debug("stats Merge: cardinality={}", (Object)Long.toString(this.cardinality));
    }

    public List<List<Expr>> getResultExprLists() {
        return this.resultExprLists;
    }

    public List<List<Expr>> getConstExprLists() {
        return this.constExprLists;
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        ArrayList texprLists = Lists.newArrayList();
        ArrayList constTexprLists = Lists.newArrayList();
        for (List<Expr> exprList : this.resultExprLists) {
            if (exprList == null) continue;
            texprLists.add(Expr.treesToThrift(exprList));
        }
        for (List<Expr> constTexprList : this.constExprLists) {
            constTexprLists.add(Expr.treesToThrift(constTexprList));
        }
        msg.merge_node = new TMergeNode(this.tupleId.asInt(), (List)texprLists, (List)constTexprLists);
        msg.node_type = TPlanNodeType.MERGE_NODE;
    }

    @Override
    public String getNodeExplainString(String prefix, TExplainLevel detailLevel) {
        if (detailLevel == TExplainLevel.BRIEF) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        if (!this.conjuncts.isEmpty()) {
            output.append(prefix + "predicates: " + this.getExplainString(this.conjuncts) + "\n");
        }
        if (this.constExprLists.size() > 0) {
            output.append(prefix + "merging " + this.constExprLists.size() + " SELECT CONSTANT\n");
        }
        return output.toString();
    }

    @Override
    public void getMaterializedIds(Analyzer analyzer, List<SlotId> ids) {
        super.getMaterializedIds(analyzer, ids);
        for (List<Expr> resultExprs : this.resultExprLists) {
            Expr.getIds(resultExprs, null, ids);
        }
        for (TupleId tupleId : this.tupleIds) {
            TupleDescriptor tupleDesc = analyzer.getTupleDesc(tupleId);
            for (SlotDescriptor slotDesc : tupleDesc.getSlots()) {
                ids.add(slotDesc.getId());
            }
        }
    }

    @Override
    public int getNumInstances() {
        return 1;
    }
}

