/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.planner.ColumnBound;
import org.apache.doris.planner.ColumnRange;
import org.apache.doris.planner.PartitionPrunerV2Base;

public class ListPartitionPrunerV2
extends PartitionPrunerV2Base {
    private final Map<PartitionPrunerV2Base.UniqueId, Range<PartitionKey>> uidToPartitionRange = Maps.newHashMap();

    public ListPartitionPrunerV2(Map<Long, PartitionItem> idToPartitionItem, List<Column> partitionColumns, Map<String, ColumnRange> columnNameToRange) {
        super(idToPartitionItem, partitionColumns, columnNameToRange);
        if (partitionColumns.size() > 1) {
            idToPartitionItem.forEach((id, item) -> {
                List keys = (List)item.getItems();
                List ranges = keys.stream().map(key -> Range.closed((Comparable)key, (Comparable)key)).collect(Collectors.toList());
                for (int i = 0; i < ranges.size(); ++i) {
                    this.uidToPartitionRange.put(new ListPartitionUniqueId((long)id, i), (Range<PartitionKey>)((Range)ranges.get(i)));
                }
            });
        }
    }

    @Override
    RangeMap<ColumnBound, PartitionPrunerV2Base.UniqueId> getCandidateRangeMap() {
        TreeRangeMap candidate = TreeRangeMap.create();
        this.idToPartitionItem.forEach((arg_0, arg_1) -> this.lambda$getCandidateRangeMap$3((RangeMap)candidate, arg_0, arg_1));
        return candidate;
    }

    @Override
    PartitionPrunerV2Base.FinalFilters getFinalFilters(ColumnRange columnRange, Column column) throws AnalysisException {
        if (!columnRange.hasFilter()) {
            return PartitionPrunerV2Base.FinalFilters.noFilters();
        }
        Optional<RangeSet<ColumnBound>> rangeSetOpt = columnRange.getRangeSet();
        if (columnRange.hasConjunctiveIsNull() || !rangeSetOpt.isPresent()) {
            return PartitionPrunerV2Base.FinalFilters.constantFalseFilters();
        }
        RangeSet<ColumnBound> rangeSet = rangeSetOpt.get();
        if (rangeSet.isEmpty()) {
            return PartitionPrunerV2Base.FinalFilters.constantFalseFilters();
        }
        return PartitionPrunerV2Base.FinalFilters.create(rangeSet.asRanges());
    }

    @Override
    Collection<Long> pruneMultipleColumnPartition(Map<Column, PartitionPrunerV2Base.FinalFilters> columnToFilters) throws AnalysisException {
        HashMap rangeToId = Maps.newHashMap();
        this.uidToPartitionRange.forEach((uid, range) -> rangeToId.put(range, uid));
        return this.doPruneMultiple(columnToFilters, rangeToId, 0);
    }

    private Collection<Long> doPruneMultiple(Map<Column, PartitionPrunerV2Base.FinalFilters> columnToFilters, Map<Range<PartitionKey>, PartitionPrunerV2Base.UniqueId> partitionRangeToUid, int columnIdx) {
        if (columnIdx == this.partitionColumns.size()) {
            return partitionRangeToUid.values().stream().map(PartitionPrunerV2Base.UniqueId::getPartitionId).collect(Collectors.toSet());
        }
        PartitionPrunerV2Base.FinalFilters finalFilters = columnToFilters.get(this.partitionColumns.get(columnIdx));
        switch (finalFilters.type) {
            case CONSTANT_FALSE_FILTERS: {
                return Collections.emptyList();
            }
            case HAVE_FILTERS: {
                Map grouped = partitionRangeToUid.entrySet().stream().collect(Collectors.groupingBy(entry -> this.mapPartitionKeyRange((Range<PartitionKey>)((Range)entry.getKey()), columnIdx), Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
                TreeRangeMap candidateRangeMap = TreeRangeMap.create();
                grouped.forEach((arg_0, arg_1) -> ((TreeRangeMap)candidateRangeMap).put(arg_0, arg_1));
                return finalFilters.filters.stream().map(filter -> {
                    RangeMap filtered = candidateRangeMap.subRangeMap(filter);
                    Map<Range<PartitionKey>, PartitionPrunerV2Base.UniqueId> filteredPartitionRange = filtered.asMapOfRanges().values().stream().flatMap(Collection::stream).collect(Collectors.toMap(this.uidToPartitionRange::get, Function.identity()));
                    return this.doPruneMultiple(columnToFilters, filteredPartitionRange, columnIdx + 1);
                }).flatMap(Collection::stream).collect(Collectors.toSet());
            }
        }
        return this.doPruneMultiple(columnToFilters, partitionRangeToUid, columnIdx + 1);
    }

    private /* synthetic */ void lambda$getCandidateRangeMap$3(RangeMap candidate, Long id, PartitionItem item) {
        List keys = (List)item.getItems();
        List ranges = keys.stream().map(key -> Range.closed((Comparable)key, (Comparable)key)).collect(Collectors.toList());
        for (int i = 0; i < ranges.size(); ++i) {
            candidate.put(this.mapPartitionKeyRange((Range<PartitionKey>)((Range)ranges.get(i)), 0), (Object)new ListPartitionUniqueId(id, i));
        }
    }

    private static class ListPartitionUniqueId
    implements PartitionPrunerV2Base.UniqueId {
        private final long partitionId;
        private final int partitionKeyIndex;

        public ListPartitionUniqueId(long partitionId, int partitionKeyIndex) {
            this.partitionId = partitionId;
            this.partitionKeyIndex = partitionKeyIndex;
        }

        @Override
        public long getPartitionId() {
            return this.partitionId;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partitionId", this.partitionId).add("partitionKeyIndex", this.partitionKeyIndex).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListPartitionUniqueId that = (ListPartitionUniqueId)o;
            return this.partitionId == that.partitionId && this.partitionKeyIndex == that.partitionKeyIndex;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.partitionId, this.partitionKeyIndex});
        }
    }
}

