/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.planner.PartitionColumnFilter;
import org.apache.doris.planner.PartitionPruner;

public class ListPartitionPruner
implements PartitionPruner {
    private Map<Long, PartitionItem> partitionListMap;
    private List<Column> partitionColumns;
    private Map<String, PartitionColumnFilter> partitionColumnFilters;

    public ListPartitionPruner(Map<Long, PartitionItem> listMap, List<Column> columns, Map<String, PartitionColumnFilter> filters) {
        this.partitionListMap = listMap;
        this.partitionColumns = columns;
        this.partitionColumnFilters = filters;
    }

    private Collection<Long> pruneListMap(Map<Long, PartitionItem> listMap, Range<PartitionKey> range, int columnId) {
        HashSet resultSet = Sets.newHashSet();
        for (Map.Entry<Long, PartitionItem> entry : listMap.entrySet()) {
            List partitionKeys = (List)entry.getValue().getItems();
            for (PartitionKey partitionKey : partitionKeys) {
                LiteralExpr expr = partitionKey.getKeys().get(columnId);
                if (!this.contain(range, expr, columnId)) continue;
                resultSet.add(entry.getKey());
            }
        }
        return resultSet;
    }

    private boolean contain(Range<PartitionKey> range, LiteralExpr literalExpr, int columnId) {
        LiteralExpr lowerExpr = ((PartitionKey)range.lowerEndpoint()).getKeys().get(columnId);
        LiteralExpr upperExpr = ((PartitionKey)range.upperEndpoint()).getKeys().get(columnId);
        BoundType lType = range.lowerBoundType();
        BoundType uType = range.upperBoundType();
        int ret1 = PartitionKey.compareLiteralExpr(literalExpr, lowerExpr);
        int ret2 = PartitionKey.compareLiteralExpr(literalExpr, upperExpr);
        return lType == BoundType.CLOSED && uType == BoundType.CLOSED ? ret1 >= 0 && ret2 <= 0 : (lType == BoundType.CLOSED && uType == BoundType.OPEN ? ret1 >= 0 && ret2 < 0 : (lType == BoundType.OPEN && uType == BoundType.CLOSED ? ret1 > 0 && ret2 <= 0 : lType == BoundType.OPEN && uType == BoundType.OPEN && ret1 > 0 && ret2 < 0));
    }

    private LiteralExpr getMinLiteral(int columnId) {
        LiteralExpr minLiteral = null;
        for (Map.Entry<Long, PartitionItem> entry : this.partitionListMap.entrySet()) {
            List partitionKeys = (List)entry.getValue().getItems();
            for (PartitionKey partitionKey : partitionKeys) {
                minLiteral = this.getMinExpr(partitionKey.getKeys().get(columnId), minLiteral);
            }
        }
        return minLiteral;
    }

    private LiteralExpr getMinExpr(LiteralExpr expr, LiteralExpr minLiteral) {
        if (minLiteral == null) {
            minLiteral = expr;
            return minLiteral;
        }
        if (expr.compareLiteral(minLiteral) < 0) {
            minLiteral = expr;
        }
        return minLiteral;
    }

    private Collection<Long> prune(Map<Long, PartitionItem> listMap, int columnId, PartitionKey minKey, PartitionKey maxKey, int complex) throws AnalysisException {
        if (listMap.size() == 0) {
            return Lists.newArrayList();
        }
        if (columnId == this.partitionColumns.size()) {
            try {
                return this.pruneListMap(listMap, (Range<PartitionKey>)Range.closed((Comparable)minKey, (Comparable)maxKey), columnId - 1);
            }
            catch (IllegalArgumentException e) {
                return Lists.newArrayList();
            }
        }
        Column keyColumn = this.partitionColumns.get(columnId);
        PartitionColumnFilter filter = this.partitionColumnFilters.get(keyColumn.getName());
        if (null == filter) {
            minKey.pushColumn(this.getMinLiteral(columnId), keyColumn.getDataType());
            maxKey.pushColumn(LiteralExpr.createInfinity(Type.fromPrimitiveType(keyColumn.getDataType()), true), keyColumn.getDataType());
            Collection<Object> result = null;
            try {
                result = this.prune(listMap, columnId + 1, minKey, maxKey, complex);
            }
            catch (IllegalArgumentException e) {
                result = Lists.newArrayList();
            }
            minKey.popColumn();
            maxKey.popColumn();
            return result;
        }
        InPredicate inPredicate = filter.getInPredicate();
        if (null == inPredicate || inPredicate.getChildren().size() * complex > 100) {
            if (filter.lowerBoundInclusive && filter.upperBoundInclusive && filter.lowerBound != null && filter.upperBound != null && 0 == filter.lowerBound.compareLiteral(filter.upperBound)) {
                minKey.pushColumn(filter.lowerBound, keyColumn.getDataType());
                maxKey.pushColumn(filter.upperBound, keyColumn.getDataType());
                Collection<Long> result = this.pruneListMap(listMap, (Range<PartitionKey>)Range.closed((Comparable)minKey, (Comparable)maxKey), columnId);
                if (this.partitionColumns.size() > 1) {
                    result.retainAll(this.prune(listMap, columnId + 1, minKey, maxKey, complex));
                }
                minKey.popColumn();
                maxKey.popColumn();
                return result;
            }
            BoundType lowerType = filter.lowerBoundInclusive ? BoundType.CLOSED : BoundType.OPEN;
            BoundType upperType = filter.upperBoundInclusive ? BoundType.CLOSED : BoundType.OPEN;
            boolean isPushMin = false;
            boolean isPushMax = false;
            int lastColumnId = this.partitionColumns.size() - 1;
            if (filter.lowerBound != null) {
                minKey.pushColumn(filter.lowerBound, keyColumn.getDataType());
            } else {
                minKey.pushColumn(this.getMinLiteral(columnId), keyColumn.getDataType());
                isPushMin = true;
            }
            if (filter.upperBound != null) {
                maxKey.pushColumn(filter.upperBound, keyColumn.getDataType());
            } else {
                maxKey.pushColumn(LiteralExpr.createInfinity(Type.fromPrimitiveType(keyColumn.getDataType()), true), keyColumn.getDataType());
                isPushMax = true;
            }
            Collection<Object> result = null;
            try {
                result = this.pruneListMap(listMap, (Range<PartitionKey>)Range.range((Comparable)minKey, (BoundType)lowerType, (Comparable)maxKey, (BoundType)upperType), columnId);
                if (this.partitionColumns.size() > 1) {
                    result.retainAll(this.prune(listMap, columnId + 1, minKey, maxKey, complex));
                }
                return result;
            }
            catch (IllegalArgumentException e) {
                result = Lists.newArrayList();
                if (isPushMin) {
                    minKey.popColumn();
                }
                if (isPushMax) {
                    maxKey.popColumn();
                }
                return result;
            }
        }
        HashSet resultSet = Sets.newHashSet();
        int childrenNum = inPredicate.getChildren().size();
        complex = inPredicate.getChildren().size() * complex;
        for (int i = 1; i < childrenNum; ++i) {
            LiteralExpr expr = (LiteralExpr)inPredicate.getChild(i);
            minKey.pushColumn(expr, keyColumn.getDataType());
            maxKey.pushColumn(expr, keyColumn.getDataType());
            Collection<Long> result = this.pruneListMap(listMap, (Range<PartitionKey>)Range.closed((Comparable)minKey, (Comparable)maxKey), columnId);
            if (this.partitionColumns.size() > 1) {
                result.retainAll(this.prune(listMap, columnId + 1, minKey, maxKey, complex));
            }
            resultSet.addAll(result);
            minKey.popColumn();
            maxKey.popColumn();
        }
        return resultSet;
    }

    @Override
    public Collection<Long> prune() throws AnalysisException {
        PartitionKey minKey = new PartitionKey();
        PartitionKey maxKey = new PartitionKey();
        return this.prune(this.partitionListMap, 0, minKey, maxKey, 1);
    }
}

