/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import org.apache.doris.planner.PlanFragment;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JoinCostEvaluation {
    private static final Logger LOG = LogManager.getLogger(JoinCostEvaluation.class);
    private final long rhsTreeCardinality;
    private final float rhsTreeAvgRowSize;
    private final int rhsTreeTupleIdNum;
    private final long lhsTreeCardinality;
    private final float lhsTreeAvgRowSize;
    private final int lhsTreeNumNodes;
    private long broadcastCost = 0L;
    private long partitionCost = 0L;

    JoinCostEvaluation(PlanNode node, PlanFragment rightChildFragment, PlanFragment leftChildFragment) {
        PlanNode rhsTree = rightChildFragment.getPlanRoot();
        this.rhsTreeCardinality = rhsTree.getCardinality();
        this.rhsTreeAvgRowSize = rhsTree.getAvgRowSize();
        this.rhsTreeTupleIdNum = rhsTree.getTupleIds().size();
        PlanNode lhsTree = leftChildFragment.getPlanRoot();
        this.lhsTreeCardinality = lhsTree.getCardinality();
        this.lhsTreeAvgRowSize = lhsTree.getAvgRowSize();
        this.lhsTreeNumNodes = leftChildFragment.getNumNodes();
        String nodeOverview = this.setNodeOverview(node, rightChildFragment, leftChildFragment);
        this.broadcastCost(nodeOverview);
        this.shuffleCost(nodeOverview);
    }

    private String setNodeOverview(PlanNode node, PlanFragment rightChildFragment, PlanFragment leftChildFragment) {
        return "root node id=" + node.getId().toString() + ": " + node.planNodeName + " right fragment id=" + rightChildFragment.getFragmentId().toString() + " left fragment id=" + leftChildFragment.getFragmentId().toString();
    }

    private void broadcastCost(String nodeOverview) {
        if (this.rhsTreeCardinality != -1L && this.lhsTreeNumNodes != -1) {
            this.broadcastCost = Math.round((double)this.rhsTreeCardinality * (double)this.rhsTreeAvgRowSize) * (long)this.lhsTreeNumNodes;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(nodeOverview);
            LOG.debug("broadcast: cost=" + Long.toString(this.broadcastCost));
            LOG.debug("rhs card=" + Long.toString(this.rhsTreeCardinality) + " rhs row_size=" + Float.toString(this.rhsTreeAvgRowSize) + " lhs nodes=" + Integer.toString(this.lhsTreeNumNodes));
        }
    }

    private void shuffleCost(String nodeOverview) {
        if (this.lhsTreeCardinality != -1L && this.rhsTreeCardinality != -1L) {
            this.partitionCost = Math.round((double)this.lhsTreeCardinality * (double)this.lhsTreeAvgRowSize + (double)this.rhsTreeCardinality * (double)this.rhsTreeAvgRowSize);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(nodeOverview);
            LOG.debug("partition: cost=" + Long.toString(this.partitionCost));
            LOG.debug("lhs card=" + Long.toString(this.lhsTreeCardinality) + " row_size=" + Float.toString(this.lhsTreeAvgRowSize));
            LOG.debug("rhs card=" + Long.toString(this.rhsTreeCardinality) + " row_size=" + Float.toString(this.rhsTreeAvgRowSize));
        }
    }

    public boolean isBroadcastCostSmaller() {
        String joinMethod = ConnectContext.get().getSessionVariable().getPreferJoinMethod();
        if (joinMethod.equalsIgnoreCase("broadcast")) {
            return this.broadcastCost <= this.partitionCost;
        }
        return this.broadcastCost < this.partitionCost;
    }

    public long constructHashTableSpace() {
        double bucketPointerSpace = (double)this.rhsTreeCardinality / 0.75 * 8.0;
        double nodeArrayLen = Math.pow(1.5, (int)(Math.log((double)this.rhsTreeCardinality / 4096.0) / Math.log(1.5) + 1.0)) * 4096.0;
        double nodeOverheadSpace = nodeArrayLen * 16.0;
        double nodeTuplePointerSpace = nodeArrayLen * (double)this.rhsTreeTupleIdNum * 8.0;
        return Math.round((bucketPointerSpace + (double)this.rhsTreeCardinality * (double)this.rhsTreeAvgRowSize + nodeOverheadSpace + nodeTuplePointerSpace) * 1.1);
    }
}

