/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.IcebergTable;
import org.apache.doris.common.UserException;
import org.apache.doris.external.iceberg.util.IcebergUtils;
import org.apache.doris.load.BrokerFileGroup;
import org.apache.doris.planner.BrokerScanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TBrokerFileStatus;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.iceberg.expressions.Expression;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IcebergScanNode
extends BrokerScanNode {
    private static final Logger LOG = LogManager.getLogger(IcebergScanNode.class);
    private IcebergTable icebergTable;
    private final List<Expression> icebergPredicates = new ArrayList<Expression>();

    public IcebergScanNode(PlanNodeId id, TupleDescriptor desc, String planNodeName, List<List<TBrokerFileStatus>> fileStatusesList, int filesAdded) {
        super(id, desc, planNodeName, fileStatusesList, filesAdded);
        this.icebergTable = (IcebergTable)desc.getTable();
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        super.init(analyzer);
    }

    @Override
    protected void initFileGroup() throws UserException {
        this.fileGroups = Lists.newArrayList((Object[])new BrokerFileGroup[]{new BrokerFileGroup(this.icebergTable)});
        this.brokerDesc = new BrokerDesc("IcebergTableDesc", this.icebergTable.getStorageType(), this.icebergTable.getIcebergProperties());
        this.targetTable = this.icebergTable;
    }

    @Override
    public String getHostUri() throws UserException {
        return this.icebergTable.getHostUri();
    }

    @Override
    protected void getFileStatus() throws UserException {
        List<TBrokerFileStatus> fileStatuses;
        ListIterator it = this.conjuncts.listIterator();
        while (it.hasNext()) {
            Expression expression = IcebergUtils.convertToIcebergExpr((Expr)it.next());
            if (expression == null) continue;
            this.icebergPredicates.add(expression);
        }
        try {
            fileStatuses = this.icebergTable.getIcebergDataFiles(this.icebergPredicates);
        }
        catch (Exception e) {
            LOG.warn("errors while load iceberg table {} data files.", (Object)this.icebergTable.getName(), (Object)e);
            throw new UserException("errors while load Iceberg table [" + this.icebergTable.getName() + "] data files.");
        }
        this.fileStatusesList.add(fileStatuses);
        this.filesAdded += fileStatuses.size();
        for (TBrokerFileStatus fstatus : fileStatuses) {
            LOG.debug("Add file status is {}", (Object)fstatus);
        }
    }

    @Override
    public String getNodeExplainString(String prefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        if (!this.isLoad()) {
            output.append(prefix).append("TABLE: ").append(this.icebergTable.getName()).append("\n");
            output.append(prefix).append("PATH: ").append(this.icebergTable.getIcebergProperties().get("iceberg.hive.metastore.uris")).append("\n");
        }
        return output.toString();
    }
}

