/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ImportColumnDesc;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.HiveMetaStoreClientHelper;
import org.apache.doris.catalog.HiveTable;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.UserException;
import org.apache.doris.load.BrokerFileGroup;
import org.apache.doris.planner.BrokerScanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TBrokerFileStatus;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HiveScanNode
extends BrokerScanNode {
    private static final Logger LOG = LogManager.getLogger(HiveScanNode.class);
    private static final String HIVE_DEFAULT_COLUMN_SEPARATOR = "\u0001";
    private static final String HIVE_DEFAULT_LINE_DELIMITER = "\n";
    private HiveTable hiveTable;
    private List<ExprNodeDesc> hivePredicates = new ArrayList<ExprNodeDesc>();
    private ExprNodeGenericFuncDesc hivePartitionPredicate;
    private List<ImportColumnDesc> parsedColumnExprList = new ArrayList<ImportColumnDesc>();
    private String hdfsUri;
    private Table remoteHiveTable;
    private String columnSeparator;
    private String lineDelimiter;
    private String fileFormat;
    private String path;
    private List<String> partitionKeys = new ArrayList<String>();
    private StorageBackend.StorageType storageType;

    @Override
    public String getHostUri() {
        return this.hdfsUri;
    }

    public List<ImportColumnDesc> getParsedColumnExprList() {
        return this.parsedColumnExprList;
    }

    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getPartitionKeys() {
        return this.partitionKeys;
    }

    public HiveScanNode(PlanNodeId id, TupleDescriptor destTupleDesc, String planNodeName, List<List<TBrokerFileStatus>> fileStatusesList, int filesAdded) {
        super(id, destTupleDesc, planNodeName, fileStatusesList, filesAdded);
        this.hiveTable = (HiveTable)destTupleDesc.getTable();
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        super.init(analyzer);
    }

    @Override
    protected void initFileGroup() throws UserException {
        this.initHiveTblProperties();
        this.analyzeColumnFromPath();
        HiveTable hiveTable = (HiveTable)this.desc.getTable();
        this.fileGroups = Lists.newArrayList((Object[])new BrokerFileGroup[]{new BrokerFileGroup(hiveTable, this.getColumnSeparator(), this.getLineDelimiter(), this.getPath(), this.getFileFormat(), this.getPartitionKeys(), this.getParsedColumnExprList())});
        this.brokerDesc = new BrokerDesc("HiveTableDesc", this.storageType, hiveTable.getHiveProperties());
        this.targetTable = hiveTable;
    }

    private void setStorageType(String location) throws UserException {
        String[] strings = StringUtils.split((String)location, (String)"/");
        String storagePrefix = strings[0].split(":")[0];
        if (storagePrefix.equalsIgnoreCase("s3")) {
            this.storageType = StorageBackend.StorageType.S3;
        } else if (storagePrefix.equalsIgnoreCase("hdfs")) {
            this.storageType = StorageBackend.StorageType.HDFS;
        } else {
            throw new UserException("Not supported storage type: " + storagePrefix);
        }
    }

    private void initHiveTblProperties() throws UserException {
        this.remoteHiveTable = HiveMetaStoreClientHelper.getTable(this.hiveTable);
        this.fileFormat = HiveMetaStoreClientHelper.HiveFileFormat.getFormat(this.remoteHiveTable.getSd().getInputFormat());
        this.setStorageType(this.remoteHiveTable.getSd().getLocation());
        Map serDeInfoParams = this.remoteHiveTable.getSd().getSerdeInfo().getParameters();
        this.columnSeparator = Strings.isNullOrEmpty((String)((String)serDeInfoParams.get("field.delim"))) ? HIVE_DEFAULT_COLUMN_SEPARATOR : (String)serDeInfoParams.get("field.delim");
        this.lineDelimiter = Strings.isNullOrEmpty((String)((String)serDeInfoParams.get("line.delim"))) ? HIVE_DEFAULT_LINE_DELIMITER : (String)serDeInfoParams.get("line.delim");
        this.path = this.remoteHiveTable.getSd().getLocation();
        for (FieldSchema fieldSchema : this.remoteHiveTable.getPartitionKeys()) {
            this.partitionKeys.add(fieldSchema.getName());
        }
    }

    private void extractHivePartitionPredicate() throws DdlException {
        ListIterator it = this.conjuncts.listIterator();
        while (it.hasNext()) {
            ExprNodeGenericFuncDesc hiveExpr = HiveMetaStoreClientHelper.convertToHivePartitionExpr((Expr)it.next(), this.partitionKeys, this.hiveTable.getName());
            if (hiveExpr == null) continue;
            this.hivePredicates.add((ExprNodeDesc)hiveExpr);
        }
        int count = this.hivePredicates.size();
        if (count >= 2) {
            this.hivePartitionPredicate = HiveMetaStoreClientHelper.getCompoundExpr(this.hivePredicates, "and");
        } else if (count == 1) {
            this.hivePartitionPredicate = (ExprNodeGenericFuncDesc)this.hivePredicates.get(0);
        } else {
            HiveMetaStoreClientHelper.ExprBuilder exprBuilder = new HiveMetaStoreClientHelper.ExprBuilder(this.hiveTable.getName());
            this.hivePartitionPredicate = exprBuilder.val((TypeInfo)TypeInfoFactory.intTypeInfo, 1).val((TypeInfo)TypeInfoFactory.intTypeInfo, 1).pred("=", 2).build();
        }
    }

    @Override
    protected void getFileStatus() throws UserException {
        if (this.partitionKeys.size() > 0) {
            this.extractHivePartitionPredicate();
        }
        ArrayList<TBrokerFileStatus> fileStatuses = new ArrayList<TBrokerFileStatus>();
        this.hdfsUri = HiveMetaStoreClientHelper.getHiveDataFiles(this.hiveTable, this.hivePartitionPredicate, fileStatuses, this.remoteHiveTable, this.storageType);
        this.fileStatusesList.add(fileStatuses);
        this.filesAdded += fileStatuses.size();
        for (TBrokerFileStatus fstatus : fileStatuses) {
            LOG.info("Add file status is {}", (Object)fstatus);
        }
    }

    @Override
    public String getNodeExplainString(String prefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        if (!this.isLoad()) {
            output.append(prefix).append("TABLE: ").append(this.hiveTable.getName()).append(HIVE_DEFAULT_LINE_DELIMITER);
            output.append(prefix).append("PATH: ").append(this.hiveTable.getHiveProperties().get("hive.metastore.uris")).append(HIVE_DEFAULT_LINE_DELIMITER);
        }
        return output.toString();
    }

    private void analyzeColumnFromPath() {
        for (String colName : this.partitionKeys) {
            ImportColumnDesc importColumnDesc = new ImportColumnDesc(colName, null);
            this.parsedColumnExprList.add(importColumnDesc);
        }
    }
}

