/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.JoinOperator;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.analysis.TupleIsNullPredicate;
import org.apache.doris.catalog.ColumnStats;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.CheckedMath;
import org.apache.doris.common.NotImplementedException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TEqJoinCondition;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.THashJoinNode;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HashJoinNode
extends PlanNode {
    private static final Logger LOG = LogManager.getLogger(HashJoinNode.class);
    private final TableRef innerRef;
    private final JoinOperator joinOp;
    private List<BinaryPredicate> eqJoinConjuncts = Lists.newArrayList();
    private List<Expr> otherJoinConjuncts;
    private Expr votherJoinConjunct = null;
    private DistributionMode distrMode;
    private boolean isColocate = false;
    private String colocateReason = "";
    private boolean isBucketShuffle = false;
    private List<SlotId> hashOutputSlotIds;
    private TupleDescriptor vOutputTupleDesc;
    private ExprSubstitutionMap vSrcToOutputSMap;

    public HashJoinNode(PlanNodeId id, PlanNode outer, PlanNode inner, TableRef innerRef, List<Expr> eqJoinConjuncts, List<Expr> otherJoinConjuncts) {
        super(id, "HASH JOIN");
        Preconditions.checkArgument((eqJoinConjuncts != null && !eqJoinConjuncts.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((otherJoinConjuncts != null ? 1 : 0) != 0);
        this.tblRefIds.addAll(outer.getTblRefIds());
        this.tblRefIds.addAll(inner.getTblRefIds());
        this.innerRef = innerRef;
        this.joinOp = innerRef.getJoinOp();
        if (VectorizedUtil.isVectorized()) {
            if (this.joinOp.equals((Object)JoinOperator.LEFT_ANTI_JOIN) || this.joinOp.equals((Object)JoinOperator.LEFT_SEMI_JOIN) || this.joinOp.equals((Object)JoinOperator.NULL_AWARE_LEFT_ANTI_JOIN)) {
                this.tupleIds.addAll(outer.getTupleIds());
            } else if (this.joinOp.equals((Object)JoinOperator.RIGHT_ANTI_JOIN) || this.joinOp.equals((Object)JoinOperator.RIGHT_SEMI_JOIN)) {
                this.tupleIds.addAll(inner.getTupleIds());
            } else {
                this.tupleIds.addAll(outer.getTupleIds());
                this.tupleIds.addAll(inner.getTupleIds());
            }
        } else {
            this.tupleIds.addAll(outer.getTupleIds());
            this.tupleIds.addAll(inner.getTupleIds());
        }
        for (Expr eqJoinPredicate : eqJoinConjuncts) {
            Preconditions.checkArgument((boolean)(eqJoinPredicate instanceof BinaryPredicate));
            BinaryPredicate eqJoin = (BinaryPredicate)eqJoinPredicate;
            if (eqJoin.getOp().equals((Object)BinaryPredicate.Operator.EQ_FOR_NULL)) {
                Preconditions.checkArgument((eqJoin.getChildren().size() == 2 ? 1 : 0) != 0);
                if (!((Expr)eqJoin.getChild(0)).isNullable() || !((Expr)eqJoin.getChild(1)).isNullable()) {
                    eqJoin.setOp(BinaryPredicate.Operator.EQ);
                }
            }
            this.eqJoinConjuncts.add(eqJoin);
        }
        this.distrMode = DistributionMode.NONE;
        this.otherJoinConjuncts = otherJoinConjuncts;
        this.children.add(outer);
        this.children.add(inner);
        this.nullableTupleIds.addAll(inner.getNullableTupleIds());
        this.nullableTupleIds.addAll(outer.getNullableTupleIds());
        if (this.joinOp.equals((Object)JoinOperator.FULL_OUTER_JOIN)) {
            this.nullableTupleIds.addAll(outer.getTupleIds());
            this.nullableTupleIds.addAll(inner.getTupleIds());
        } else if (this.joinOp.equals((Object)JoinOperator.LEFT_OUTER_JOIN)) {
            this.nullableTupleIds.addAll(inner.getTupleIds());
        } else if (this.joinOp.equals((Object)JoinOperator.RIGHT_OUTER_JOIN)) {
            this.nullableTupleIds.addAll(outer.getTupleIds());
        }
    }

    public List<BinaryPredicate> getEqJoinConjuncts() {
        return this.eqJoinConjuncts;
    }

    public JoinOperator getJoinOp() {
        return this.joinOp;
    }

    public TableRef getInnerRef() {
        return this.innerRef;
    }

    public DistributionMode getDistributionMode() {
        return this.distrMode;
    }

    public void setDistributionMode(DistributionMode distrMode) {
        this.distrMode = distrMode;
    }

    public boolean isColocate() {
        return this.isColocate;
    }

    public boolean isBucketShuffle() {
        return this.distrMode.equals((Object)DistributionMode.BUCKET_SHUFFLE);
    }

    public void setColocate(boolean colocate, String reason) {
        this.isColocate = colocate;
        this.colocateReason = reason;
    }

    private void initHashOutputSlotIds(List<SlotId> slotIdList, Analyzer analyzer) {
        HashSet hashOutputSlotIdSet = Sets.newHashSet();
        if (this.vSrcToOutputSMap != null) {
            for (SlotId slotId : slotIdList) {
                SlotRef slotRef = new SlotRef(analyzer.getDescTbl().getSlotDesc(slotId));
                Expr srcExpr = this.vSrcToOutputSMap.mappingForRhsExpr(slotRef);
                if (srcExpr == null) {
                    hashOutputSlotIdSet.add(slotId);
                    continue;
                }
                ArrayList srcSlotRefList = Lists.newArrayList();
                srcExpr.collect(SlotRef.class, srcSlotRefList);
                hashOutputSlotIdSet.addAll(srcSlotRefList.stream().map(e -> e.getSlotId()).collect(Collectors.toList()));
            }
        }
        ArrayList otherAndConjunctSlotIds = Lists.newArrayList();
        Expr.getIds(this.otherJoinConjuncts, null, otherAndConjunctSlotIds);
        Expr.getIds(this.conjuncts, null, otherAndConjunctSlotIds);
        hashOutputSlotIdSet.addAll(otherAndConjunctSlotIds);
        this.hashOutputSlotIds = new ArrayList<SlotId>(hashOutputSlotIdSet);
    }

    @Override
    public void initOutputSlotIds(Set<SlotId> requiredSlotIdSet, Analyzer analyzer) {
        this.outputSlotIds = Lists.newArrayList();
        ArrayList outputTupleDescList = Lists.newArrayList();
        if (this.vOutputTupleDesc != null) {
            outputTupleDescList.add(this.vOutputTupleDesc);
        } else {
            for (TupleId tupleId : this.tupleIds) {
                outputTupleDescList.add(analyzer.getTupleDesc(tupleId));
            }
        }
        for (TupleDescriptor tupleDescriptor : outputTupleDescList) {
            for (SlotDescriptor slotDescriptor : tupleDescriptor.getSlots()) {
                if (!slotDescriptor.isMaterialized() || requiredSlotIdSet != null && !requiredSlotIdSet.contains(slotDescriptor.getId())) continue;
                this.outputSlotIds.add(slotDescriptor.getId());
            }
        }
        this.initHashOutputSlotIds(this.outputSlotIds, analyzer);
    }

    @Override
    public void projectOutputTuple() throws NotImplementedException {
        if (this.vOutputTupleDesc == null) {
            return;
        }
        if (this.vOutputTupleDesc.getSlots().size() == this.outputSlotIds.size()) {
            return;
        }
        Iterator<SlotDescriptor> iterator = this.vOutputTupleDesc.getSlots().iterator();
        while (iterator.hasNext()) {
            SlotDescriptor slotDescriptor = iterator.next();
            boolean keep = false;
            for (SlotId outputSlotId : this.outputSlotIds) {
                if (!slotDescriptor.getId().equals(outputSlotId)) continue;
                keep = true;
                break;
            }
            if (keep) continue;
            iterator.remove();
            SlotRef slotRef = new SlotRef(slotDescriptor);
            this.vSrcToOutputSMap.removeByRhsExpr(slotRef);
        }
        this.vOutputTupleDesc.computeStatAndMemLayout();
    }

    @Override
    public Set<SlotId> computeInputSlotIds(Analyzer analyzer) throws NotImplementedException {
        HashSet result = Sets.newHashSet();
        Preconditions.checkState((this.outputSlotIds != null ? 1 : 0) != 0);
        if (this.vSrcToOutputSMap != null) {
            for (SlotId slotId : this.outputSlotIds) {
                SlotRef slotRef = new SlotRef(analyzer.getDescTbl().getSlotDesc(slotId));
                Expr srcExpr = this.vSrcToOutputSMap.mappingForRhsExpr(slotRef);
                if (srcExpr == null) {
                    result.add(slotId);
                    continue;
                }
                ArrayList srcSlotRefList = Lists.newArrayList();
                srcExpr.collect(SlotRef.class, srcSlotRefList);
                result.addAll(srcSlotRefList.stream().map(e -> e.getSlotId()).collect(Collectors.toList()));
            }
        }
        ArrayList eqConjunctSlotIds = Lists.newArrayList();
        Expr.getIds(this.eqJoinConjuncts, null, eqConjunctSlotIds);
        result.addAll(eqConjunctSlotIds);
        ArrayList otherConjunctSlotIds = Lists.newArrayList();
        Expr.getIds(this.otherJoinConjuncts, null, otherConjunctSlotIds);
        result.addAll(otherConjunctSlotIds);
        ArrayList conjunctSlotIds = Lists.newArrayList();
        Expr.getIds(this.conjuncts, null, conjunctSlotIds);
        result.addAll(conjunctSlotIds);
        return result;
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        super.init(analyzer);
        this.assignedConjuncts = analyzer.getAssignedConjuncts();
        this.replaceOutputSmapForOuterJoin();
        this.computeStats(analyzer);
        ExprSubstitutionMap combinedChildSmap = this.getCombinedChildWithoutTupleIsNullSmap();
        ArrayList<Expr> newEqJoinConjuncts = Expr.substituteList(this.eqJoinConjuncts, combinedChildSmap, analyzer, false);
        this.eqJoinConjuncts = newEqJoinConjuncts.stream().map(entity -> (BinaryPredicate)entity).collect(Collectors.toList());
        this.assignedConjuncts = analyzer.getAssignedConjuncts();
        this.otherJoinConjuncts = Expr.substituteList(this.otherJoinConjuncts, combinedChildSmap, analyzer, false);
        if (VectorizedUtil.isVectorized()) {
            this.computeOutputTuple(analyzer);
        }
    }

    private void computeOutputTuple(Analyzer analyzer) throws UserException {
        SlotDescriptor outputSlotDesc;
        this.vOutputTupleDesc = analyzer.getDescTbl().createTupleDescriptor();
        boolean copyLeft = false;
        boolean copyRight = false;
        boolean leftNullable = false;
        boolean rightNullable = false;
        switch (this.joinOp) {
            case INNER_JOIN: 
            case CROSS_JOIN: {
                copyLeft = true;
                copyRight = true;
                break;
            }
            case LEFT_OUTER_JOIN: {
                copyLeft = true;
                copyRight = true;
                rightNullable = true;
                break;
            }
            case RIGHT_OUTER_JOIN: {
                copyLeft = true;
                copyRight = true;
                leftNullable = true;
                break;
            }
            case FULL_OUTER_JOIN: {
                copyLeft = true;
                copyRight = true;
                leftNullable = true;
                rightNullable = true;
                break;
            }
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: 
            case NULL_AWARE_LEFT_ANTI_JOIN: {
                copyLeft = true;
                break;
            }
            case RIGHT_ANTI_JOIN: 
            case RIGHT_SEMI_JOIN: {
                copyRight = true;
                break;
            }
        }
        ExprSubstitutionMap srcTblRefToOutputTupleSmap = new ExprSubstitutionMap();
        int leftNullableNumber = 0;
        int rightNullableNumber = 0;
        if (copyLeft) {
            for (TupleDescriptor leftTupleDesc : analyzer.getDescTbl().getTupleDesc(((PlanNode)this.getChild(0)).getOutputTblRefIds())) {
                for (SlotDescriptor leftSlotDesc : leftTupleDesc.getSlots()) {
                    if (!this.isMaterailizedByChild(leftSlotDesc, ((PlanNode)this.getChild(0)).getOutputSmap())) continue;
                    outputSlotDesc = analyzer.getDescTbl().copySlotDescriptor(this.vOutputTupleDesc, leftSlotDesc);
                    if (leftNullable) {
                        outputSlotDesc.setIsNullable(true);
                        ++leftNullableNumber;
                    }
                    srcTblRefToOutputTupleSmap.put(new SlotRef(leftSlotDesc), new SlotRef(outputSlotDesc));
                }
            }
        }
        if (copyRight) {
            for (TupleDescriptor rightTupleDesc : analyzer.getDescTbl().getTupleDesc(((PlanNode)this.getChild(1)).getOutputTblRefIds())) {
                for (SlotDescriptor rightSlotDesc : rightTupleDesc.getSlots()) {
                    if (!this.isMaterailizedByChild(rightSlotDesc, ((PlanNode)this.getChild(1)).getOutputSmap())) continue;
                    outputSlotDesc = analyzer.getDescTbl().copySlotDescriptor(this.vOutputTupleDesc, rightSlotDesc);
                    if (rightNullable) {
                        outputSlotDesc.setIsNullable(true);
                        ++rightNullableNumber;
                    }
                    srcTblRefToOutputTupleSmap.put(new SlotRef(rightSlotDesc), new SlotRef(outputSlotDesc));
                }
            }
        }
        this.vSrcToOutputSMap = ExprSubstitutionMap.subtraction(this.outputSmap, srcTblRefToOutputTupleSmap, analyzer);
        for (int i = 0; i < this.vSrcToOutputSMap.size(); ++i) {
            Preconditions.checkState((boolean)(this.vSrcToOutputSMap.getRhs().get(i) instanceof SlotRef));
            SlotRef rSlotRef = (SlotRef)this.vSrcToOutputSMap.getRhs().get(i);
            if (this.vSrcToOutputSMap.getLhs().get(i) instanceof SlotRef) {
                SlotRef lSlotRef = (SlotRef)this.vSrcToOutputSMap.getLhs().get(i);
                rSlotRef.getDesc().setIsMaterialized(lSlotRef.getDesc().isMaterialized());
                continue;
            }
            rSlotRef.getDesc().setIsMaterialized(true);
        }
        this.vOutputTupleDesc.computeStatAndMemLayout();
        Preconditions.checkState((srcTblRefToOutputTupleSmap.getLhs().size() == this.vSrcToOutputSMap.getLhs().size() ? 1 : 0) != 0);
        if (leftNullable && ((PlanNode)this.getChild((int)0)).tblRefIds.size() == 1 && analyzer.isInlineView(((PlanNode)this.getChild((int)0)).tblRefIds.get(0))) {
            List<Expr> tupleIsNullLhs = TupleIsNullPredicate.wrapExprs(this.vSrcToOutputSMap.getLhs().subList(0, leftNullableNumber), ((PlanNode)this.getChild(0)).getTupleIds(), analyzer);
            tupleIsNullLhs.addAll(this.vSrcToOutputSMap.getLhs().subList(leftNullableNumber, this.vSrcToOutputSMap.getLhs().size()));
            this.vSrcToOutputSMap.updateLhsExprs(tupleIsNullLhs);
        }
        if (rightNullable && ((PlanNode)this.getChild((int)1)).tblRefIds.size() == 1 && analyzer.isInlineView(((PlanNode)this.getChild((int)1)).tblRefIds.get(0)) && rightNullableNumber != 0) {
            int rightBeginIndex = this.vSrcToOutputSMap.size() - rightNullableNumber;
            List<Expr> tupleIsNullLhs = TupleIsNullPredicate.wrapExprs(this.vSrcToOutputSMap.getLhs().subList(rightBeginIndex, this.vSrcToOutputSMap.size()), ((PlanNode)this.getChild(1)).getTupleIds(), analyzer);
            ArrayList newLhsList = Lists.newArrayList();
            if (rightBeginIndex > 0) {
                newLhsList.addAll(this.vSrcToOutputSMap.getLhs().subList(0, rightBeginIndex));
            }
            newLhsList.addAll(tupleIsNullLhs);
            this.vSrcToOutputSMap.updateLhsExprs(newLhsList);
        }
        this.outputSmap = ExprSubstitutionMap.composeAndReplace(this.outputSmap, srcTblRefToOutputTupleSmap, analyzer);
    }

    private void replaceOutputSmapForOuterJoin() {
        if (this.joinOp.isOuterJoin() && !VectorizedUtil.isVectorized()) {
            ArrayList<Expr> lhs = new ArrayList<Expr>();
            ArrayList<Expr> rhs = new ArrayList<Expr>();
            for (int i = 0; i < this.outputSmap.size(); ++i) {
                Expr expr = this.outputSmap.getLhs().get(i);
                boolean isInNullableTuple = false;
                for (TupleId tupleId : this.nullableTupleIds) {
                    if (!expr.isBound(tupleId)) continue;
                    isInNullableTuple = true;
                    break;
                }
                if (isInNullableTuple) continue;
                lhs.add(this.outputSmap.getLhs().get(i));
                rhs.add(this.outputSmap.getRhs().get(i));
            }
            this.outputSmap = new ExprSubstitutionMap(lhs, rhs);
        }
    }

    private long getJoinCardinality() {
        Preconditions.checkState((this.joinOp.isInnerJoin() || this.joinOp.isOuterJoin() ? 1 : 0) != 0);
        long lhsCard = ((PlanNode)this.getChild((int)0)).cardinality;
        long rhsCard = ((PlanNode)this.getChild((int)1)).cardinality;
        if (lhsCard == -1L || rhsCard == -1L) {
            return lhsCard;
        }
        ArrayList<EqJoinConjunctScanSlots> eqJoinConjunctSlots = new ArrayList<EqJoinConjunctScanSlots>();
        for (Expr expr : this.eqJoinConjuncts) {
            EqJoinConjunctScanSlots slots = EqJoinConjunctScanSlots.create(expr);
            if (slots == null) continue;
            eqJoinConjunctSlots.add(slots);
        }
        if (eqJoinConjunctSlots.isEmpty()) {
            return lhsCard;
        }
        return this.getGenericJoinCardinality(eqJoinConjunctSlots, lhsCard, rhsCard);
    }

    private long getGenericJoinCardinality(List<EqJoinConjunctScanSlots> eqJoinConjunctSlots, long lhsCard, long rhsCard) {
        Preconditions.checkState((this.joinOp.isInnerJoin() || this.joinOp.isOuterJoin() ? 1 : 0) != 0);
        Preconditions.checkState((!eqJoinConjunctSlots.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((lhsCard >= 0L && rhsCard >= 0L ? 1 : 0) != 0);
        long result = -1L;
        for (EqJoinConjunctScanSlots slots : eqJoinConjunctSlots) {
            double lhsAdjNdv = slots.lhsNdv();
            if (slots.lhsNumRows() > (double)lhsCard) {
                lhsAdjNdv *= (double)lhsCard / slots.lhsNumRows();
            }
            double rhsAdjNdv = slots.rhsNdv();
            if (slots.rhsNumRows() > (double)rhsCard) {
                rhsAdjNdv *= (double)rhsCard / slots.rhsNumRows();
            }
            long joinCard = CheckedMath.checkedMultiply(Math.round((double)lhsCard / Math.max(1.0, Math.max(lhsAdjNdv, rhsAdjNdv))), rhsCard);
            if (result == -1L) {
                result = joinCard;
                continue;
            }
            result = Math.min(result, joinCard);
        }
        Preconditions.checkState((result >= 0L ? 1 : 0) != 0);
        return result;
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        if (!analyzer.safeIsEnableJoinReorderBasedCost()) {
            return;
        }
        if (this.joinOp.isSemiAntiJoin()) {
            this.cardinality = this.getSemiJoinCardinality();
        } else if (this.joinOp.isInnerJoin() || this.joinOp.isOuterJoin()) {
            this.cardinality = this.getJoinCardinality();
        } else {
            Preconditions.checkState((boolean)false, (Object)"joinOp is not supported");
        }
        this.capCardinalityAtLimit();
        if (LOG.isDebugEnabled()) {
            LOG.debug("stats HashJoin:" + this.id + ", cardinality: " + this.cardinality);
        }
    }

    @Override
    protected void computeOldCardinality() {
        long maxNumDistinct = 0L;
        for (BinaryPredicate eqJoinPredicate : this.eqJoinConjuncts) {
            ColumnStats stats;
            SlotDescriptor slotDesc;
            SlotRef rhsSlotRef;
            Expr lhsJoinExpr = (Expr)eqJoinPredicate.getChild(0);
            Expr rhsJoinExpr = (Expr)eqJoinPredicate.getChild(1);
            if (lhsJoinExpr.unwrapSlotRef() == null || (rhsSlotRef = rhsJoinExpr.unwrapSlotRef()) == null || (slotDesc = rhsSlotRef.getDesc()) == null || !(stats = slotDesc.getStats()).hasNumDistinctValues()) continue;
            long numDistinct = stats.getNumDistinctValues();
            maxNumDistinct = Math.max(maxNumDistinct, numDistinct);
            LOG.debug("min slotref: {}, #distinct: {}", (Object)rhsSlotRef.toSql(), (Object)numDistinct);
        }
        if (maxNumDistinct == 0L) {
            this.cardinality = ((PlanNode)this.getChild((int)0)).cardinality;
        } else {
            this.cardinality = Math.round((double)((PlanNode)this.getChild((int)0)).cardinality * (double)((PlanNode)this.getChild((int)1)).cardinality / (double)maxNumDistinct);
            LOG.debug("lhs card: {}, rhs card: {}", (Object)((PlanNode)this.getChild((int)0)).cardinality, (Object)((PlanNode)this.getChild((int)1)).cardinality);
        }
        LOG.debug("stats HashJoin: cardinality {}", (Object)this.cardinality);
    }

    private long getNdv(Expr expr) {
        SlotRef slotRef = expr.unwrapSlotRef(false);
        if (slotRef == null) {
            return -1L;
        }
        SlotDescriptor slotDesc = slotRef.getDesc();
        if (slotDesc == null) {
            return -1L;
        }
        ColumnStats stats = slotDesc.getStats();
        if (!stats.hasNumDistinctValues()) {
            return -1L;
        }
        return stats.getNumDistinctValues();
    }

    private long getSemiJoinCardinality() {
        long cardinality;
        Preconditions.checkState((boolean)this.joinOp.isSemiJoin());
        if (this.joinOp == JoinOperator.RIGHT_SEMI_JOIN || this.joinOp == JoinOperator.RIGHT_ANTI_JOIN) {
            if (((PlanNode)this.getChild((int)1)).cardinality == -1L) {
                return -1L;
            }
            cardinality = ((PlanNode)this.getChild((int)1)).cardinality;
        } else {
            if (((PlanNode)this.getChild((int)0)).cardinality == -1L) {
                return -1L;
            }
            cardinality = ((PlanNode)this.getChild((int)0)).cardinality;
        }
        double minSelectivity = 1.0;
        for (Expr expr : this.eqJoinConjuncts) {
            long lhsNdv = this.getNdv((Expr)expr.getChild(0));
            lhsNdv = Math.min(lhsNdv, ((PlanNode)this.getChild((int)0)).cardinality);
            long rhsNdv = this.getNdv((Expr)expr.getChild(1));
            rhsNdv = Math.min(rhsNdv, ((PlanNode)this.getChild((int)1)).cardinality);
            if (lhsNdv == -1L || rhsNdv == -1L) continue;
            double selectivity = 1.0;
            switch (this.joinOp) {
                case LEFT_SEMI_JOIN: {
                    selectivity = (double)Math.min(lhsNdv, rhsNdv) / (double)lhsNdv;
                    break;
                }
                case RIGHT_SEMI_JOIN: {
                    selectivity = (double)Math.min(lhsNdv, rhsNdv) / (double)rhsNdv;
                    break;
                }
                case LEFT_ANTI_JOIN: 
                case NULL_AWARE_LEFT_ANTI_JOIN: {
                    selectivity = (double)(lhsNdv > rhsNdv ? lhsNdv - rhsNdv : lhsNdv) / (double)lhsNdv;
                    break;
                }
                case RIGHT_ANTI_JOIN: {
                    selectivity = (double)(rhsNdv > lhsNdv ? rhsNdv - lhsNdv : rhsNdv) / (double)rhsNdv;
                    break;
                }
                default: {
                    Preconditions.checkState((boolean)false);
                }
            }
            minSelectivity = Math.min(minSelectivity, selectivity);
        }
        Preconditions.checkState((cardinality != -1L ? 1 : 0) != 0);
        return Math.round((double)cardinality * minSelectivity);
    }

    @Override
    protected String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("eqJoinConjuncts", (Object)this.eqJoinConjunctsDebugString()).addValue((Object)super.debugString()).toString();
    }

    private String eqJoinConjunctsDebugString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        for (BinaryPredicate expr : this.eqJoinConjuncts) {
            helper.add("lhs", expr.getChild(0)).add("rhs", expr.getChild(1));
        }
        return helper.toString();
    }

    @Override
    public void getMaterializedIds(Analyzer analyzer, List<SlotId> ids) {
        super.getMaterializedIds(analyzer, ids);
        for (Expr expr : this.eqJoinConjuncts) {
            expr.getIds(null, ids);
        }
        for (Expr expr : this.otherJoinConjuncts) {
            expr.getIds(null, ids);
        }
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.HASH_JOIN_NODE;
        msg.hash_join_node = new THashJoinNode();
        msg.hash_join_node.join_op = this.joinOp.toThrift();
        for (BinaryPredicate eqJoinPredicate : this.eqJoinConjuncts) {
            TEqJoinCondition eqJoinCondition = new TEqJoinCondition(((Expr)eqJoinPredicate.getChild(0)).treeToThrift(), ((Expr)eqJoinPredicate.getChild(1)).treeToThrift());
            eqJoinCondition.setOpcode(eqJoinPredicate.getOp().getOpcode());
            msg.hash_join_node.addToEqJoinConjuncts(eqJoinCondition);
        }
        for (Expr e : this.otherJoinConjuncts) {
            msg.hash_join_node.addToOtherJoinConjuncts(e.treeToThrift());
        }
        if (this.votherJoinConjunct != null) {
            msg.hash_join_node.setVotherJoinConjunct(this.votherJoinConjunct.treeToThrift());
        }
        if (this.hashOutputSlotIds != null) {
            for (SlotId slotId : this.hashOutputSlotIds) {
                msg.hash_join_node.addToHashOutputSlotIds(slotId.asInt());
            }
        }
        if (this.vSrcToOutputSMap != null) {
            for (int i = 0; i < this.vSrcToOutputSMap.size(); ++i) {
                msg.hash_join_node.addToSrcExprList(this.vSrcToOutputSMap.getLhs().get(i).treeToThrift());
            }
        }
        if (this.vOutputTupleDesc != null) {
            msg.hash_join_node.setVoutputTupleId(this.vOutputTupleDesc.getId().asInt());
        }
    }

    @Override
    public String getNodeExplainString(String detailPrefix, TExplainLevel detailLevel) {
        String distrModeStr = "";
        distrModeStr = this.isColocate ? "COLOCATE[" + this.colocateReason + "]" : this.distrMode.toString();
        StringBuilder output = new StringBuilder().append(detailPrefix).append("join op: ").append(this.joinOp.toString()).append("(").append(distrModeStr).append(")").append("[").append(this.colocateReason).append("]\n");
        if (detailLevel == TExplainLevel.BRIEF) {
            return output.toString();
        }
        for (BinaryPredicate eqJoinPredicate : this.eqJoinConjuncts) {
            output.append(detailPrefix).append("equal join conjunct: ").append(eqJoinPredicate.toSql()).append("\n");
        }
        if (!this.otherJoinConjuncts.isEmpty()) {
            output.append(detailPrefix).append("other join predicates: ").append(this.getExplainString(this.otherJoinConjuncts)).append("\n");
        }
        if (!this.conjuncts.isEmpty()) {
            output.append(detailPrefix).append("other predicates: ").append(this.getExplainString(this.conjuncts)).append("\n");
        }
        if (!this.runtimeFilters.isEmpty()) {
            output.append(detailPrefix).append("runtime filters: ");
            output.append(this.getRuntimeFilterExplainString(true));
        }
        output.append(detailPrefix).append(String.format("cardinality=%s", this.cardinality)).append("\n");
        if (this.vOutputTupleDesc != null) {
            output.append(detailPrefix).append("vec output tuple id: ").append(this.vOutputTupleDesc.getId());
        }
        if (this.outputSlotIds != null) {
            output.append(detailPrefix).append("output slot ids: ");
            for (SlotId slotId : this.outputSlotIds) {
                output.append(slotId).append(" ");
            }
            output.append("\n");
        }
        if (this.hashOutputSlotIds != null) {
            output.append(detailPrefix).append("hash output slot ids: ");
            for (SlotId slotId : this.hashOutputSlotIds) {
                output.append(slotId).append(" ");
            }
            output.append("\n");
        }
        return output.toString();
    }

    @Override
    public int getNumInstances() {
        return Math.max(((PlanNode)this.children.get(0)).getNumInstances(), ((PlanNode)this.children.get(1)).getNumInstances());
    }

    public boolean isShuffleJoin() {
        return this.distrMode == DistributionMode.PARTITIONED;
    }

    @Override
    public void convertToVectoriezd() {
        if (!this.otherJoinConjuncts.isEmpty()) {
            this.votherJoinConjunct = this.convertConjunctsToAndCompoundPredicate(this.otherJoinConjuncts);
            this.initCompoundPredicate(this.votherJoinConjunct);
        }
        super.convertToVectoriezd();
    }

    @Override
    public ArrayList<TupleId> getTupleIds() {
        Preconditions.checkState((this.tupleIds != null ? 1 : 0) != 0);
        if (this.vOutputTupleDesc != null) {
            return Lists.newArrayList((Object[])new TupleId[]{this.vOutputTupleDesc.getId()});
        }
        return this.tupleIds;
    }

    @Override
    public ArrayList<TupleId> getOutputTblRefIds() {
        if (this.vOutputTupleDesc != null) {
            return Lists.newArrayList((Object[])new TupleId[]{this.vOutputTupleDesc.getId()});
        }
        switch (this.joinOp) {
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: 
            case NULL_AWARE_LEFT_ANTI_JOIN: {
                return ((PlanNode)this.getChild(0)).getOutputTblRefIds();
            }
            case RIGHT_ANTI_JOIN: 
            case RIGHT_SEMI_JOIN: {
                return ((PlanNode)this.getChild(1)).getOutputTblRefIds();
            }
        }
        return this.getTblRefIds();
    }

    @Override
    public ArrayList<TupleId> getOutputTupleIds() {
        if (this.vOutputTupleDesc != null) {
            return Lists.newArrayList((Object[])new TupleId[]{this.vOutputTupleDesc.getId()});
        }
        switch (this.joinOp) {
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: 
            case NULL_AWARE_LEFT_ANTI_JOIN: {
                return ((PlanNode)this.getChild(0)).getOutputTupleIds();
            }
            case RIGHT_ANTI_JOIN: 
            case RIGHT_SEMI_JOIN: {
                return ((PlanNode)this.getChild(1)).getOutputTupleIds();
            }
        }
        return this.tupleIds;
    }

    private boolean isMaterailizedByChild(SlotDescriptor slotDesc, ExprSubstitutionMap smap) {
        if (slotDesc.isMaterialized()) {
            return true;
        }
        Expr child = smap.get(new SlotRef(slotDesc));
        if (child == null) {
            return false;
        }
        ArrayList slotRefList = Lists.newArrayList();
        child.collect(SlotRef.class, slotRefList);
        for (SlotRef slotRef : slotRefList) {
            if (slotRef.getDesc() == null || slotRef.getDesc().isMaterialized()) continue;
            return false;
        }
        return true;
    }

    SlotRef getMappedInputSlotRef(SlotRef slotRef) {
        if (this.vSrcToOutputSMap != null) {
            Expr mappedExpr = this.vSrcToOutputSMap.mappingForRhsExpr(slotRef);
            if (mappedExpr != null && mappedExpr instanceof SlotRef) {
                return (SlotRef)mappedExpr;
            }
            return null;
        }
        return slotRef;
    }

    public static enum DistributionMode {
        NONE("NONE"),
        BROADCAST("BROADCAST"),
        PARTITIONED("PARTITIONED"),
        BUCKET_SHUFFLE("BUCKET_SHUFFLE");

        private final String description;

        private DistributionMode(String descr) {
            this.description = descr;
        }

        public String toString() {
            return this.description;
        }
    }

    public static final class EqJoinConjunctScanSlots {
        private final Expr eqJoinConjunct;
        private final SlotDescriptor lhs;
        private final SlotDescriptor rhs;

        private EqJoinConjunctScanSlots(Expr eqJoinConjunct, SlotDescriptor lhs, SlotDescriptor rhs) {
            this.eqJoinConjunct = eqJoinConjunct;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public double lhsNdv() {
            return Math.min((double)this.lhs.getStats().getNumDistinctValues(), this.lhsNumRows());
        }

        public double rhsNdv() {
            return Math.min((double)this.rhs.getStats().getNumDistinctValues(), this.rhsNumRows());
        }

        public double lhsNumRows() {
            Table table = this.lhs.getParent().getTable();
            Preconditions.checkState((boolean)(table instanceof OlapTable));
            return ((OlapTable)table).getRowCount();
        }

        public double rhsNumRows() {
            Table table = this.rhs.getParent().getTable();
            Preconditions.checkState((boolean)(table instanceof OlapTable));
            return ((OlapTable)table).getRowCount();
        }

        public TupleId lhsTid() {
            return this.lhs.getParent().getId();
        }

        public TupleId rhsTid() {
            return this.rhs.getParent().getId();
        }

        public static EqJoinConjunctScanSlots create(Expr eqJoinConjunct) {
            if (!Expr.IS_EQ_BINARY_PREDICATE.apply((Object)eqJoinConjunct)) {
                return null;
            }
            SlotDescriptor lhsScanSlot = ((Expr)eqJoinConjunct.getChild(0)).findSrcScanSlot();
            if (lhsScanSlot == null || !EqJoinConjunctScanSlots.hasNumRowsAndNdvStats(lhsScanSlot)) {
                return null;
            }
            SlotDescriptor rhsScanSlot = ((Expr)eqJoinConjunct.getChild(1)).findSrcScanSlot();
            if (rhsScanSlot == null || !EqJoinConjunctScanSlots.hasNumRowsAndNdvStats(rhsScanSlot)) {
                return null;
            }
            return new EqJoinConjunctScanSlots(eqJoinConjunct, lhsScanSlot, rhsScanSlot);
        }

        private static boolean hasNumRowsAndNdvStats(SlotDescriptor slotDesc) {
            if (slotDesc.getColumn() == null) {
                return false;
            }
            return slotDesc.getStats().hasNumDistinctValues();
        }

        public static Map<Pair<TupleId, TupleId>, List<EqJoinConjunctScanSlots>> groupByJoinedTupleIds(List<EqJoinConjunctScanSlots> eqJoinConjunctSlots) {
            LinkedHashMap<Pair<TupleId, TupleId>, List<EqJoinConjunctScanSlots>> scanSlotsByJoinedTids = new LinkedHashMap<Pair<TupleId, TupleId>, List<EqJoinConjunctScanSlots>>();
            for (EqJoinConjunctScanSlots slots : eqJoinConjunctSlots) {
                Pair<TupleId, TupleId> tids = Pair.create(slots.lhsTid(), slots.rhsTid());
                ArrayList<EqJoinConjunctScanSlots> scanSlots = (ArrayList<EqJoinConjunctScanSlots>)scanSlotsByJoinedTids.get(tids);
                if (scanSlots == null) {
                    scanSlots = new ArrayList<EqJoinConjunctScanSlots>();
                    scanSlotsByJoinedTids.put(tids, scanSlots);
                }
                scanSlots.add(slots);
            }
            return scanSlotsByJoinedTids;
        }

        public String toString() {
            return this.eqJoinConjunct.toSql();
        }
    }
}

