/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.common.Config;
import org.apache.doris.planner.DistributionPruner;
import org.apache.doris.planner.PartitionColumnFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HashDistributionPruner
implements DistributionPruner {
    private static final Logger LOG = LogManager.getLogger(HashDistributionPruner.class);
    private List<Long> bucketsList;
    private List<Column> distributionColumns;
    private Map<String, PartitionColumnFilter> distributionColumnFilters;
    private int hashMod;

    HashDistributionPruner(List<Long> bucketsList, List<Column> columns, Map<String, PartitionColumnFilter> filters, int hashMod) {
        this.bucketsList = bucketsList;
        this.distributionColumns = columns;
        this.distributionColumnFilters = filters;
        this.hashMod = hashMod;
    }

    public Collection<Long> prune(int columnId, PartitionKey hashKey, int complex) {
        if (columnId == this.distributionColumns.size()) {
            long hashValue = hashKey.getHashValue();
            return Lists.newArrayList((Object[])new Long[]{this.bucketsList.get((int)((hashValue & 0xFFFFFFFFFFFFFFFFL) % (long)this.hashMod))});
        }
        Column keyColumn = this.distributionColumns.get(columnId);
        PartitionColumnFilter filter = this.distributionColumnFilters.get(keyColumn.getName());
        if (null == filter) {
            return Lists.newArrayList(this.bucketsList);
        }
        InPredicate inPredicate = filter.getInPredicate();
        if (null == inPredicate || inPredicate.getInElementNum() * complex > Config.max_distribution_pruner_recursion_depth) {
            if (filter.lowerBoundInclusive && filter.upperBoundInclusive && filter.lowerBound != null && filter.upperBound != null && 0 == filter.lowerBound.compareLiteral(filter.upperBound)) {
                hashKey.pushColumn(filter.lowerBound, keyColumn.getDataType());
                Collection<Long> result = this.prune(columnId + 1, hashKey, complex);
                hashKey.popColumn();
                return result;
            }
            return Lists.newArrayList(this.bucketsList);
        }
        if (!(inPredicate.getChild(0) instanceof SlotRef)) {
            return Lists.newArrayList(this.bucketsList);
        }
        HashSet resultSet = Sets.newHashSet();
        int inElementNum = inPredicate.getInElementNum();
        int newComplex = inElementNum * complex;
        int childrenNum = inPredicate.getChildren().size();
        for (int i = 1; i < childrenNum; ++i) {
            LiteralExpr expr = (LiteralExpr)inPredicate.getChild(i);
            hashKey.pushColumn(expr, keyColumn.getDataType());
            Collection<Long> subList = this.prune(columnId + 1, hashKey, newComplex);
            resultSet.addAll(subList);
            hashKey.popColumn();
            if (resultSet.size() >= this.bucketsList.size()) break;
        }
        return resultSet;
    }

    @Override
    public Collection<Long> prune() {
        PartitionKey hashKey = new PartitionKey();
        return this.prune(0, hashKey, 1);
    }
}

