/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.DataSink;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TDataSink;
import org.apache.doris.thrift.TDataSinkType;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TExportSink;
import org.apache.doris.thrift.TFileType;
import org.apache.doris.thrift.TNetworkAddress;

public class ExportSink
extends DataSink {
    private final String exportPath;
    private final String columnSeparator;
    private final String lineDelimiter;
    private BrokerDesc brokerDesc;

    public ExportSink(String exportPath, String columnSeparator, String lineDelimiter, BrokerDesc brokerDesc) {
        this.exportPath = exportPath;
        this.columnSeparator = columnSeparator;
        this.lineDelimiter = lineDelimiter;
        this.brokerDesc = brokerDesc;
    }

    @Override
    public String getExplainString(String prefix, TExplainLevel explainLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix + "EXPORT SINK\n");
        if (explainLevel == TExplainLevel.BRIEF) {
            return sb.toString();
        }
        sb.append(prefix + "  path=" + this.exportPath + "\n");
        sb.append(prefix + "  columnSeparator=" + StringEscapeUtils.escapeJava((String)this.columnSeparator) + "\n");
        sb.append(prefix + "  lineDelimiter=" + StringEscapeUtils.escapeJava((String)this.lineDelimiter) + "\n");
        sb.append(prefix + "  broker_name=" + this.brokerDesc.getName() + " property(" + new PrintableMap<String, String>(this.brokerDesc.getProperties(), "=", true, false) + ")");
        sb.append("\n");
        return sb.toString();
    }

    @Override
    protected TDataSink toThrift() {
        FsBroker broker;
        TDataSink result = new TDataSink(TDataSinkType.EXPORT_SINK);
        TExportSink tExportSink = new TExportSink(this.brokerDesc.getFileType(), this.exportPath, this.columnSeparator, this.lineDelimiter);
        if (this.brokerDesc.getFileType() == TFileType.FILE_BROKER && (broker = Catalog.getCurrentCatalog().getBrokerMgr().getAnyBroker(this.brokerDesc.getName())) != null) {
            tExportSink.addToBrokerAddresses(new TNetworkAddress(broker.ip, broker.port));
        }
        tExportSink.setProperties(this.brokerDesc.getProperties());
        result.setExportSink(tExportSink);
        return result;
    }

    @Override
    public PlanNodeId getExchNodeId() {
        return null;
    }

    @Override
    public DataPartition getOutputPartition() {
        return DataPartition.RANDOM;
    }
}

