/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.SortInfo;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TExchangeNode;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.doris.thrift.TSortInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExchangeNode
extends PlanNode {
    private static final Logger LOG = LogManager.getLogger(ExchangeNode.class);
    public static final String EXCHANGE_NODE = "EXCHANGE";
    public static final String MERGING_EXCHANGE_NODE = "MERGING-EXCHANGE";
    private SortInfo mergeInfo;
    private long offset = 0L;

    public ExchangeNode(PlanNodeId id, PlanNode inputNode, boolean copyConjuncts) {
        super(id, inputNode, EXCHANGE_NODE);
        this.children.add(inputNode);
        if (!copyConjuncts) {
            this.conjuncts = Lists.newArrayList();
        }
        if (inputNode.getFragment().isPartitioned()) {
            this.limit = inputNode.limit;
        }
        this.computeTupleIds();
    }

    public boolean isMergingExchange() {
        return this.mergeInfo != null;
    }

    @Override
    public final void computeTupleIds() {
        this.clearTupleIds();
        this.tupleIds.addAll(((PlanNode)this.getChild(0)).getTupleIds());
        this.tblRefIds.addAll(((PlanNode)this.getChild(0)).getTblRefIds());
        this.nullableTupleIds.addAll(((PlanNode)this.getChild(0)).getNullableTupleIds());
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        super.init(analyzer);
        Preconditions.checkState((boolean)this.conjuncts.isEmpty());
        if (!analyzer.safeIsEnableJoinReorderBasedCost()) {
            return;
        }
        this.computeStats(analyzer);
    }

    @Override
    protected void computeStats(Analyzer analyzer) {
        Preconditions.checkState((this.children.size() == 1 ? 1 : 0) != 0);
        this.cardinality = ((PlanNode)this.children.get((int)0)).cardinality;
        this.capCardinalityAtLimit();
        if (LOG.isDebugEnabled()) {
            LOG.debug("stats Exchange:" + this.id + ", cardinality: " + this.cardinality);
        }
    }

    public void setMergeInfo(SortInfo info, long offset) {
        this.mergeInfo = info;
        this.offset = offset;
        this.planNodeName = VectorizedUtil.isVectorized() ? "VMERGING-EXCHANGE" : MERGING_EXCHANGE_NODE;
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.EXCHANGE_NODE;
        msg.exchange_node = new TExchangeNode();
        for (TupleId tid : this.tupleIds) {
            msg.exchange_node.addToInputRowTuples(tid.asInt());
        }
        if (this.mergeInfo != null) {
            TSortInfo sortInfo = new TSortInfo(Expr.treesToThrift(this.mergeInfo.getOrderingExprs()), this.mergeInfo.getIsAscOrder(), this.mergeInfo.getNullsFirst());
            msg.exchange_node.setSortInfo(sortInfo);
            msg.exchange_node.setOffset(this.offset);
        }
    }

    @Override
    protected String debugString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        helper.addValue((Object)super.debugString());
        helper.add("offset", this.offset);
        return helper.toString();
    }

    @Override
    public int getNumInstances() {
        return this.numInstances;
    }
}

