/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.EsTable;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.external.elasticsearch.EsShardPartitions;
import org.apache.doris.external.elasticsearch.EsShardRouting;
import org.apache.doris.external.elasticsearch.EsTablePartitions;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.planner.RangePartitionPruner;
import org.apache.doris.planner.ScanNode;
import org.apache.doris.system.Backend;
import org.apache.doris.thrift.TEsScanNode;
import org.apache.doris.thrift.TEsScanRange;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.doris.thrift.TScanRange;
import org.apache.doris.thrift.TScanRangeLocation;
import org.apache.doris.thrift.TScanRangeLocations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EsScanNode
extends ScanNode {
    private static final Logger LOG = LogManager.getLogger(EsScanNode.class);
    private final Random random = new Random(System.currentTimeMillis());
    private Multimap<String, Backend> backendMap;
    private List<Backend> backendList;
    private EsTablePartitions esTablePartitions;
    private List<TScanRangeLocations> shardScanRanges = Lists.newArrayList();
    private EsTable table;
    boolean isFinalized = false;

    public EsScanNode(PlanNodeId id, TupleDescriptor desc, String planNodeName) {
        super(id, desc, planNodeName);
        this.table = (EsTable)desc.getTable();
        this.esTablePartitions = this.table.getEsTablePartitions();
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        super.init(analyzer);
        this.computeColumnFilter();
        this.assignBackends();
        this.computeStats(analyzer);
    }

    @Override
    public int getNumInstances() {
        return this.shardScanRanges.size();
    }

    @Override
    public List<TScanRangeLocations> getScanRangeLocations(long maxScanRangeLength) {
        return this.shardScanRanges;
    }

    @Override
    public void finalize(Analyzer analyzer) throws UserException {
        if (this.isFinalized) {
            return;
        }
        try {
            this.shardScanRanges = this.getShardLocations();
        }
        catch (AnalysisException e) {
            throw new UserException(e.getMessage());
        }
        this.isFinalized = true;
    }

    private int useDocValueScan(TupleDescriptor desc, Map<String, String> docValueContext) {
        ArrayList<SlotDescriptor> slotDescriptors = desc.getSlots();
        ArrayList<String> selectedFields = new ArrayList<String>(slotDescriptors.size());
        for (SlotDescriptor slotDescriptor : slotDescriptors) {
            selectedFields.add(slotDescriptor.getColumn().getName());
        }
        if (selectedFields.size() > this.table.maxDocValueFields()) {
            return 0;
        }
        Set<String> docValueFields = docValueContext.keySet();
        boolean useDocValue = true;
        for (String selectedField : selectedFields) {
            if (docValueFields.contains(selectedField)) continue;
            useDocValue = false;
            break;
        }
        return useDocValue ? 1 : 0;
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = "http".equals(this.table.getTransport()) ? TPlanNodeType.ES_HTTP_SCAN_NODE : TPlanNodeType.ES_SCAN_NODE;
        HashMap properties = Maps.newHashMap();
        properties.put("user", this.table.getUserName());
        properties.put("password", this.table.getPasswd());
        properties.put("http_ssl_enabled", String.valueOf(this.table.isHttpSslEnabled()));
        TEsScanNode esScanNode = new TEsScanNode(this.desc.getId().asInt());
        esScanNode.setProperties((Map)properties);
        if (this.table.isDocValueScanEnable()) {
            esScanNode.setDocvalueContext(this.table.docValueContext());
            properties.put("doc_values_mode", String.valueOf(this.useDocValueScan(this.desc, this.table.docValueContext())));
        }
        if (this.table.isKeywordSniffEnable() && this.table.fieldsContext().size() > 0) {
            esScanNode.setFieldsContext(this.table.fieldsContext());
        }
        msg.es_scan_node = esScanNode;
    }

    private void assignBackends() throws UserException {
        this.backendMap = HashMultimap.create();
        this.backendList = Lists.newArrayList();
        for (Backend be : Catalog.getCurrentSystemInfo().getIdToBackend().values()) {
            if (!be.isAlive()) continue;
            this.backendMap.put((Object)be.getHost(), (Object)be);
            this.backendList.add(be);
        }
        if (this.backendMap.isEmpty()) {
            throw new UserException("No Alive backends");
        }
    }

    private List<TScanRangeLocations> getShardLocations() throws UserException {
        if (this.esTablePartitions == null) {
            if (this.table.getLastMetaDataSyncException() != null) {
                throw new UserException("fetch es table [" + this.table.getName() + "] metadata failure: " + this.table.getLastMetaDataSyncException().getLocalizedMessage());
            }
            throw new UserException("EsTable metadata has not been synced, Try it later");
        }
        Collection<Long> partitionIds = this.partitionPrune(this.esTablePartitions.getPartitionInfo());
        ArrayList selectedIndex = Lists.newArrayList();
        ArrayList unPartitionedIndices = Lists.newArrayList();
        ArrayList partitionedIndices = Lists.newArrayList();
        for (EsShardPartitions esShardPartitions : this.esTablePartitions.getUnPartitionedIndexStates().values()) {
            selectedIndex.add(esShardPartitions);
            unPartitionedIndices.add(esShardPartitions.getIndexName());
        }
        if (partitionIds != null) {
            for (Long partitionId : partitionIds) {
                EsShardPartitions indexState = this.esTablePartitions.getEsShardPartitions(partitionId);
                selectedIndex.add(indexState);
                partitionedIndices.add(indexState.getIndexName());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("partition prune finished, unpartitioned index [{}], partitioned index [{}]", (Object)String.join((CharSequence)",", unPartitionedIndices), (Object)String.join((CharSequence)",", partitionedIndices));
        }
        int size = this.backendList.size();
        int beIndex = this.random.nextInt(size);
        ArrayList result = Lists.newArrayList();
        for (EsShardPartitions indexState : selectedIndex) {
            for (List<EsShardRouting> shardRouting : indexState.getShardRoutings().values()) {
                HashSet colocatedBes = Sets.newHashSet();
                int numBe = Math.min(3, size);
                ArrayList<TNetworkAddress> shardAllocations = new ArrayList<TNetworkAddress>();
                for (EsShardRouting item : shardRouting) {
                    shardAllocations.add("http".equals(this.table.getTransport()) ? item.getHttpAddress() : item.getAddress());
                }
                Collections.shuffle(shardAllocations, this.random);
                for (TNetworkAddress address : shardAllocations) {
                    colocatedBes.addAll(this.backendMap.get((Object)address.getHostname()));
                }
                boolean usingRandomBackend = colocatedBes.size() == 0;
                ArrayList candidateBeList = Lists.newArrayList();
                if (usingRandomBackend) {
                    for (int i = 0; i < numBe; ++i) {
                        candidateBeList.add(this.backendList.get(beIndex++ % size));
                    }
                } else {
                    candidateBeList.addAll(colocatedBes);
                    Collections.shuffle(candidateBeList);
                }
                TScanRangeLocations locations = new TScanRangeLocations();
                for (int i = 0; i < numBe && i < candidateBeList.size(); ++i) {
                    TScanRangeLocation location = new TScanRangeLocation();
                    Backend be = (Backend)candidateBeList.get(i);
                    location.setBackendId(be.getId());
                    location.setServer(new TNetworkAddress(be.getHost(), be.getBePort()));
                    locations.addToLocations(location);
                }
                TEsScanRange esScanRange = new TEsScanRange();
                esScanRange.setEsHosts(shardAllocations);
                esScanRange.setIndex(shardRouting.get(0).getIndexName());
                if (this.table.getType() != null) {
                    esScanRange.setType(this.table.getMappingType());
                }
                esScanRange.setShardId(shardRouting.get(0).getShardId());
                TScanRange scanRange = new TScanRange();
                scanRange.setEsScanRange(esScanRange);
                locations.setScanRange(scanRange);
                result.add(locations);
            }
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder scratchBuilder = new StringBuilder();
            for (TScanRangeLocations scanRangeLocations : result) {
                scratchBuilder.append(scanRangeLocations.toString());
                scratchBuilder.append(" ");
            }
            LOG.debug("ES table {}  scan ranges {}", (Object)this.table.getName(), (Object)scratchBuilder.toString());
        }
        return result;
    }

    private Collection<Long> partitionPrune(PartitionInfo partitionInfo) throws AnalysisException {
        if (partitionInfo == null) {
            return null;
        }
        RangePartitionPruner partitionPruner = null;
        switch (partitionInfo.getType()) {
            case RANGE: {
                RangePartitionInfo rangePartitionInfo = (RangePartitionInfo)partitionInfo;
                Map<Long, PartitionItem> keyRangeById = rangePartitionInfo.getIdToItem(false);
                partitionPruner = new RangePartitionPruner(keyRangeById, rangePartitionInfo.getPartitionColumns(), this.columnFilters);
                return partitionPruner.prune();
            }
            case UNPARTITIONED: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getNodeExplainString(String prefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        output.append(prefix).append("TABLE: ").append(this.table.getName()).append("\n");
        if (detailLevel == TExplainLevel.BRIEF) {
            return output.toString();
        }
        if (null != this.sortColumn) {
            output.append(prefix).append("SORT COLUMN: ").append(this.sortColumn).append("\n");
        }
        if (!this.conjuncts.isEmpty()) {
            output.append(prefix).append("PREDICATES: ").append(this.getExplainString(this.conjuncts)).append("\n");
            output.append(prefix).append("LOCAL_PREDICATES: ").append(" ").append("\n");
            output.append(prefix).append("REMOTE_PREDICATES: ").append(" ").append("\n");
            output.append(prefix).append("ES_QUERY_DSL: ").append(" ").append("\n");
        } else {
            output.append(prefix).append("ES_QUERY_DSL: ").append("{\"match_all\": {}}").append("\n");
        }
        String indexName = this.table.getIndexName();
        String typeName = this.table.getMappingType();
        output.append(prefix).append(String.format("ES index/type: %s/%s", indexName, typeName)).append("\n");
        return output.toString();
    }
}

